/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.internal.storage;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.persistence.internal.storage.RepositoryPreferences;
import org.eclipse.gyrex.persistence.storage.registry.IRepositoryDefinition;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class RepositoryDefinition
extends PlatformObject
implements IRepositoryDefinition {
    private static final String KEY_TAGS = "tags";
    private static final String KEY_TYPE = "type";
    private final IEclipsePreferences storage;
    private final String repositoryId;
    private volatile RepositoryPreferences repositoryPreferences;

    RepositoryDefinition(String repositoryId, IEclipsePreferences storage) {
        this.repositoryId = repositoryId;
        this.storage = storage;
    }

    @Override
    public void addTag(String tag) {
        if (StringUtils.isBlank((String)tag)) {
            return;
        }
        HashSet<String> tags = new HashSet<String>(this.getTags());
        if (tags.contains(tag)) {
            return;
        }
        tags.add(tag);
        this.setTags(tags);
    }

    private void checkExist() {
        try {
            if (!this.storage.nodeExists("")) {
                throw new IllegalStateException(NLS.bind((String)"Repository definition for repository ''{0}'' does not exist!", (Object)this.repositoryId));
            }
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(NLS.bind((String)"Error accessing preferences store for repository ''{0}'': {1}", (Object)this.repositoryId, (Object)e.getMessage()), e);
        }
    }

    @Override
    public String getProviderId() {
        this.checkExist();
        return this.storage.get(KEY_TYPE, null);
    }

    @Override
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public IRepositoryPreferences getRepositoryPreferences() {
        if (this.repositoryPreferences != null) {
            return this.repositoryPreferences;
        }
        this.repositoryPreferences = new RepositoryPreferences((IEclipsePreferences)this.storage.node("data"));
        return this.repositoryPreferences;
    }

    @Override
    public Collection<String> getTags() {
        this.checkExist();
        return Collections.unmodifiableCollection(Arrays.asList(StringUtils.split((String)this.storage.get(KEY_TAGS, ""))));
    }

    @Override
    public void removeTag(String tag) {
        if (StringUtils.isBlank((String)tag)) {
            return;
        }
        HashSet<String> tags = new HashSet<String>(this.getTags());
        if (!tags.contains(tag)) {
            return;
        }
        tags.remove(tag);
        this.setTags(tags);
    }

    void setProviderId(String providerId) {
        try {
            this.checkExist();
            if (this.storage.get(KEY_TYPE, null) != null) {
                throw new IllegalStateException(NLS.bind((String)"Repository type for repository ''{0}'' already set!", (Object)this.repositoryId));
            }
            this.storage.put(KEY_TYPE, providerId);
            this.storage.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(NLS.bind((String)"Error creating repository definition ''{0}'': {1}", (Object)this.repositoryId, (Object)e.getMessage()), e);
        }
    }

    private void setTags(Collection<String> tags) {
        try {
            if (!tags.isEmpty()) {
                this.storage.put(KEY_TAGS, StringUtils.join(tags, (char)' '));
            } else {
                this.storage.remove(KEY_TAGS);
            }
            this.storage.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(NLS.bind((String)"Error adding tags to repository definition ''{0}'': {1}", (Object)this.repositoryId, (Object)e.getMessage()), e);
        }
    }
}

