/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.internal.storage;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.persistence.internal.PersistenceActivator;
import org.eclipse.gyrex.persistence.internal.storage.RepositoryDefinition;
import org.eclipse.gyrex.persistence.internal.storage.RepositoryDefinitionsStore;
import org.eclipse.gyrex.persistence.storage.Repository;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;
import org.eclipse.gyrex.persistence.storage.registry.IRepositoryDefinition;
import org.eclipse.gyrex.persistence.storage.registry.IRepositoryRegistry;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryRegistry
implements IRepositoryRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryRegistry.class);
    private final AtomicReference<RepositoryDefinitionsStore> repositoryDefinitionsStoreRef = new AtomicReference();
    private final ConcurrentMap<String, Lock> locksByRepositoryId = new ConcurrentHashMap<String, Lock>(4);
    private final ConcurrentMap<String, Repository> repositoryCache = new ConcurrentHashMap<String, Repository>(4);
    private final AtomicBoolean closed = new AtomicBoolean(false);

    private static void errorCreatingRepository(RepositoryDefinition repositoryDef, String detail) {
        throw new IllegalStateException(MessageFormat.format("Invalid repository definition ''{0}'': {1}", repositoryDef.getRepositoryId(), detail));
    }

    /*
     * Unable to fully structure code
     */
    public void close() {
        if (this.closed.compareAndSet(false, true)) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            repoIds = this.repositoryCache.keySet();
            for (String repoId : repoIds) {
                this.close(repoId);
            }
lbl7:
            // 2 sources

            ** while (!this.repositoryCache.isEmpty())
        }
lbl8:
        // 1 sources

    }

    public void close(String repositoryId) {
        Repository repository;
        if (!this.repositoryCache.containsKey(repositoryId)) {
            return;
        }
        Lock lock = (Lock)this.locksByRepositoryId.get(repositoryId);
        if (lock != null) {
            lock.lock();
        }
        try {
            repository = (Repository)this.repositoryCache.remove(repositoryId);
            this.locksByRepositoryId.remove(repositoryId);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        if (repository != null) {
            try {
                repository.close();
            }
            catch (Exception e) {
                LOG.error("Error closing repository {}. {}", new Object[]{repositoryId, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
        }
    }

    private Repository createRepository(RepositoryDefinition repositoryDef) throws IllegalStateException {
        String repositoryProviderId = repositoryDef.getProviderId();
        if (repositoryProviderId == null) {
            RepositoryRegistry.errorCreatingRepository(repositoryDef, "invalid type");
        }
        RepositoryProvider repositoryType = PersistenceActivator.getInstance().getRepositoryProviderRegistry().getRepositoryProvider(repositoryProviderId);
        IRepositoryPreferences repositoryPreferences = repositoryDef.getRepositoryPreferences();
        Repository repository = repositoryType.createRepositoryInstance(repositoryDef.getRepositoryId(), repositoryPreferences);
        if (repository == null) {
            RepositoryRegistry.errorCreatingRepository(repositoryDef, MessageFormat.format("repository type ''{0}'' returned no repository instance", repositoryProviderId));
        }
        return repository;
    }

    @Override
    public IRepositoryDefinition createRepository(String repositoryId, String repositoryProviderId) throws IllegalArgumentException {
        if (!IdHelper.isValidId((String)repositoryId)) {
            throw new IllegalArgumentException("repository id is not valid");
        }
        if (StringUtils.isBlank((String)repositoryProviderId)) {
            throw new IllegalArgumentException("repository id must not be null");
        }
        return this.getStore().create(repositoryId, repositoryProviderId);
    }

    private Lock getOrCreateRepositoryLock(String repositoryId) {
        ReentrantLock newLock;
        Lock lock = (Lock)this.locksByRepositoryId.get(repositoryId);
        if (lock == null && (lock = this.locksByRepositoryId.putIfAbsent(repositoryId, newLock = new ReentrantLock())) == null) {
            lock = newLock;
        }
        return lock;
    }

    public Repository getRepository(String repositoryId) throws IllegalStateException {
        if (repositoryId == null) {
            throw new IllegalArgumentException("repository id must not be null");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("closed");
        }
        Repository repository = (Repository)this.repositoryCache.get(repositoryId);
        if (repository != null) {
            return repository;
        }
        RepositoryDefinition repositoryDef = this.getStore().findById(repositoryId);
        if (repositoryDef == null) {
            throw new IllegalStateException(MessageFormat.format("The repository with id \"{0}\" could not be found!", repositoryId));
        }
        Lock repositoryCreationLock = this.getOrCreateRepositoryLock(repositoryId);
        repositoryCreationLock.lock();
        try {
            repository = (Repository)this.repositoryCache.get(repositoryId);
            if (repository != null) {
                Repository repository2 = repository;
                return repository2;
            }
            repository = this.createRepository(repositoryDef);
            this.repositoryCache.put(repositoryId, repository);
            Repository repository3 = repository;
            return repository3;
        }
        finally {
            repositoryCreationLock.unlock();
        }
    }

    @Override
    public IRepositoryDefinition getRepositoryDefinition(String repositoryId) {
        if (repositoryId == null) {
            throw new IllegalArgumentException("repository id must not be null");
        }
        return this.getStore().findById(repositoryId);
    }

    @Override
    public Collection<String> getRepositoryIds() {
        return Collections.unmodifiableCollection(this.getStore().findRepositoryIds());
    }

    RepositoryDefinitionsStore getStore() {
        RepositoryDefinitionsStore store = this.repositoryDefinitionsStoreRef.get();
        if (store != null) {
            return store;
        }
        this.repositoryDefinitionsStoreRef.compareAndSet(null, new RepositoryDefinitionsStore());
        return this.repositoryDefinitionsStoreRef.get();
    }

    @Override
    public void removeRepository(String repositoryId) throws IllegalArgumentException {
        this.getStore().remove(repositoryId);
    }
}

