/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.provider;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.di.IRuntimeContextInjector;

public abstract class RuntimeContextObjectProvider {
    public static final String SERVICE_NAME = RuntimeContextObjectProvider.class.getName();
    private volatile Map<Class<?>, Class<?>> objectTypesToImplementationTypesMap;
    private volatile Class<?>[] objectTypes;

    protected final void configureObjectTypes(Map<Class<?>, Class<?>> objectTypesConfiguration) throws IllegalStateException {
        if (this.objectTypesToImplementationTypesMap != null) {
            throw new IllegalStateException("already configured");
        }
        if (objectTypesConfiguration != null) {
            this.objectTypesToImplementationTypesMap = Collections.unmodifiableMap(objectTypesConfiguration);
            Set<Class<?>> keySet = this.objectTypesToImplementationTypesMap.keySet();
            this.objectTypes = keySet.toArray(new Class[keySet.size()]);
        } else {
            this.objectTypesToImplementationTypesMap = Collections.emptyMap();
            this.objectTypes = new Class[0];
        }
    }

    public <T> T getObject(Class<T> type, IRuntimeContext context) throws IllegalStateException {
        if (this.objectTypesToImplementationTypesMap == null) {
            throw new IllegalStateException("not configured");
        }
        Class<?> implementationType = this.objectTypesToImplementationTypesMap.get(type);
        if (implementationType != null) {
            return this.makeObject(context, implementationType);
        }
        return null;
    }

    public Class<?>[] getObjectTypes() throws IllegalStateException {
        Class<?>[] types = this.objectTypes;
        if (types == null) {
            throw new IllegalStateException("not configured");
        }
        return types;
    }

    private <T> T makeObject(IRuntimeContext context, Class<?> implementationType) {
        return (T)context.getInjector().make(implementationType);
    }

    public String toString() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("RuntimeContextObjectProvider [getClass()=").append(this.getClass()).append(", getObjectTypes()=").append(Arrays.toString(this.getObjectTypes())).append("]");
            return builder.toString();
        }
        catch (IllegalStateException e) {
            StringBuilder builder = new StringBuilder();
            builder.append("RuntimeContextObjectProvider [getClass()=").append(this.getClass()).append(", ").append(e.getMessage()).append("]");
            return builder.toString();
        }
    }

    public <T> void ungetObject(T object, IRuntimeContext context) {
        IRuntimeContextInjector injectionFactory = context.get(IRuntimeContextInjector.class);
        if (injectionFactory != null) {
            injectionFactory.uninject(object);
        }
    }
}

