/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.app;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.application.ApplicationException;
import org.eclipse.gyrex.http.jetty.internal.JettyDebug;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationHandler;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ScopedHandler;
import org.eclipse.jetty.util.log.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDelegateHandler
extends ScopedHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationDelegateHandler.class);
    private final ApplicationHandler applicationHandler;

    public ApplicationDelegateHandler(ApplicationHandler applicationHandler) {
        this.applicationHandler = applicationHandler;
    }

    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.nextHandle(target, baseRequest, request, response);
    }

    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            Application application = this.applicationHandler.getApplication();
            if (JettyDebug.handlers) {
                LOG.debug("routing request to application {}", (Object)application);
            }
            application.handleRequest(request, response);
        }
        catch (IOException e) {
            if (Platform.inDebugMode()) {
                Log.warn((String)"Caught IOException while processing request '{}': {}", (Object)new Object[]{request, e.getMessage(), e});
            }
            throw e;
        }
        catch (ApplicationException e) {
            if (e.getStatus() == 503) {
                if (Platform.inDebugMode()) {
                    Log.warn((String)"Caught ApplicationException while processing request '{}': {}", (Object)new Object[]{request, e.getMessage(), e});
                    throw new UnavailableException(e.getMessage(), 5);
                }
                throw new UnavailableException(e.getMessage(), 30);
            }
            if (Platform.inDebugMode()) {
                Log.warn((String)"Caught ApplicationException while processing request '{}': {}", (Object)new Object[]{request, e.getMessage(), e});
                response.sendError(e.getStatus(), e.getMessage());
            } else {
                response.sendError(e.getStatus());
            }
        }
        catch (IllegalStateException e) {
            if (Platform.inDebugMode()) {
                Log.warn((String)"Caught IllegalStateException while processing request '{}': {}", (Object)new Object[]{request, e.getMessage(), e});
                throw new UnavailableException(e.getMessage(), 5);
            }
            throw new UnavailableException(e.getMessage(), 30);
        }
        catch (RuntimeException e) {
            if (Platform.inDebugMode()) {
                Log.warn((String)"Caught RuntimeException while processing request '{}': {}", (Object)new Object[]{request, e.getMessage(), e});
            }
            throw e;
        }
        baseRequest.setHandled(true);
    }

    public boolean handleApplicationRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Request baseRequest = Request.getRequest((HttpServletRequest)request);
        if (baseRequest == null) {
            throw new IllegalStateException("Please ensure that this method is called within the request thread!");
        }
        try {
            String target = baseRequest.getPathInfo();
            if (JettyDebug.handlers) {
                LOG.debug("got request back from application {}, continue processing with Jetty handler chain (using target '{}')", (Object)this.applicationHandler.getApplication(), (Object)target);
            }
            if (target == null || !target.startsWith("/")) {
                throw new ApplicationException(String.format("Unable to handle request. It seems the specified request is invalid (path info '%s'). At least an absolute path info is necessary in order to determine the request target within the registered application servlets and resources.", StringUtils.trimToEmpty((String)target)));
            }
            this.nextScope(target, baseRequest, (HttpServletRequest)baseRequest, response);
        }
        catch (ServletException e) {
            throw new ApplicationException((Throwable)e);
        }
        return baseRequest.isHandled();
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append(((Object)((Object)this)).getClass().getSimpleName());
        string.append("[");
        try {
            string.append(this.applicationHandler.getApplication().getId());
        }
        catch (Exception e) {
            string.append(e.toString());
        }
        string.append("]");
        return string.toString();
    }
}

