/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.p2.internal;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gyrex.admin.ui.internal.databinding.TrueWhenListSelectionNotEmptyConverter;
import org.eclipse.gyrex.admin.ui.internal.forms.FormLayoutDataFactory;
import org.eclipse.gyrex.admin.ui.internal.forms.ViewerWithButtonsSectionPart;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.p2.internal.AddPackageDialog;
import org.eclipse.gyrex.admin.ui.p2.internal.P2UiLabelProvider;
import org.eclipse.gyrex.admin.ui.p2.internal.SoftwareLandingPage;
import org.eclipse.gyrex.p2.internal.P2Activator;
import org.eclipse.gyrex.p2.internal.packages.IPackageManager;
import org.eclipse.gyrex.p2.internal.packages.PackageDefinition;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public class PackagesSection
extends ViewerWithButtonsSectionPart {
    private Button addButton;
    private Button removeButton;
    private Button provisionButton;
    private Button revokeButton;
    private ListViewer packagesList;
    private final DataBindingContext bindingContext;
    private IObservableValue selectedPackageValue;

    public PackagesSection(Composite parent, SoftwareLandingPage page) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.bindingContext = page.getBindingContext();
        Section section = this.getSection();
        section.setText("Software Packages");
        section.setDescription("Define the installable packages.");
        this.createContent(section);
    }

    void addButtonPressed() {
        AddPackageDialog dialog = new AddPackageDialog(SwtUtil.getShell((Widget)this.addButton), this.getPackageManager());
        if (dialog.open() == 0) {
            this.markStale();
        }
    }

    protected void createButtons(Composite buttonsPanel) {
        this.addButton = this.createButton(buttonsPanel, "Add...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagesSection.this.addButtonPressed();
            }
        });
        this.removeButton = this.createButton(buttonsPanel, "Remove...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagesSection.this.removeButtonPressed();
            }
        });
        Label separator = this.getToolkit().createLabel(buttonsPanel, "");
        FormLayoutDataFactory.applyDefaults((Label)separator, (int)1);
        this.provisionButton = this.createButton(buttonsPanel, "Provision", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagesSection.this.provisionButtonPressed();
            }
        });
        this.revokeButton = this.createButton(buttonsPanel, "Revoke", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagesSection.this.revokeButtonPressed();
            }
        });
    }

    protected void createViewer(Composite parent) {
        this.packagesList = new ListViewer(parent, this.getToolkit().getBorderStyle() | 4 | 0x100 | 0x200);
        List list = this.packagesList.getList();
        this.getToolkit().adapt((Control)list, true, true);
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.packagesList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.packagesList.setLabelProvider((IBaseLabelProvider)new P2UiLabelProvider());
        this.selectedPackageValue = ViewersObservables.observeSingleSelection((Viewer)this.packagesList);
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    IPackageManager getPackageManager() {
        return P2Activator.getInstance().getPackageManager();
    }

    private PackageDefinition getSelectedPackage() {
        return (PackageDefinition)(this.selectedPackageValue != null ? this.selectedPackageValue.getValue() : null);
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter((IConverter)new TrueWhenListSelectionNotEmptyConverter());
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.removeButton), (IObservableValue)SWTObservables.observeSelection((Control)this.packagesList.getControl()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.provisionButton), (IObservableValue)SWTObservables.observeSelection((Control)this.packagesList.getControl()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.revokeButton), (IObservableValue)SWTObservables.observeSelection((Control)this.packagesList.getControl()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
    }

    void provisionButtonPressed() {
        PackageDefinition pkg = this.getSelectedPackage();
        if (pkg == null) {
            return;
        }
        this.getPackageManager().markedForInstall(pkg);
        this.markStale();
    }

    public void refresh() {
        this.packagesList.setInput((Object)this.getPackageManager().getPackages());
        super.refresh();
    }

    void removeButtonPressed() {
        PackageDefinition pkg = this.getSelectedPackage();
        if (pkg == null) {
            return;
        }
        if (!MessageDialog.openQuestion((Shell)SwtUtil.getShell((Widget)this.getSection()), (String)"Remove Package", (String)"Do you really want to delete the package?")) {
            return;
        }
        this.getPackageManager().removePackage(pkg.getId());
        this.markStale();
    }

    void revokeButtonPressed() {
        PackageDefinition pkg = this.getSelectedPackage();
        if (pkg == null) {
            return;
        }
        this.getPackageManager().markedForUninstall(pkg);
        this.markStale();
    }
}

