/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.common.console;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public abstract class BaseCommandProvider
implements CommandProvider {
    private final Map<String, Class<? extends Command>> commands = new TreeMap<String, Class<? extends Command>>();
    protected boolean printStackTraces = false;

    protected final void execute(CommandInterpreter ci) {
        block12: {
            Command cmd;
            String command = ci.nextArgument();
            if (StringUtils.isBlank((String)command)) {
                ci.println((Object)"ERROR: Missing command name!");
                ci.println((Object)this.getHelp());
                return;
            }
            if (this.isHelpOption(command)) {
                ci.println((Object)this.getHelp());
                return;
            }
            Class<? extends Command> cmdClass = this.commands.get(command);
            if (cmdClass == null) {
                ci.println((Object)"ERROR: Command not found!");
                ci.println((Object)this.getHelp());
                return;
            }
            try {
                cmd = cmdClass.newInstance();
            }
            catch (Exception e) {
                ci.println((Object)("ERROR: " + ExceptionUtils.getRootCauseMessage((Throwable)e)));
                return;
            }
            boolean printHelp = false;
            ArrayList<String> args = new ArrayList<String>();
            String arg = ci.nextArgument();
            while (arg != null) {
                if (this.isHelpOption(arg)) {
                    printHelp = true;
                    break;
                }
                args.add(arg);
                arg = ci.nextArgument();
            }
            CmdLineParser parser = new CmdLineParser((Object)cmd);
            if (printHelp) {
                this.printCommandHelp(ci, command, parser);
                return;
            }
            try {
                parser.parseArgument(args.toArray(new String[args.size()]));
            }
            catch (CmdLineException e) {
                ci.println((Object)("ERROR: " + e.getMessage()));
                this.printCommandHelp(ci, command, parser);
                return;
            }
            try {
                cmd.execute(ci);
            }
            catch (Exception e) {
                ci.println((Object)("ERROR: " + ExceptionUtils.getRootCauseMessage((Throwable)e)));
                if (!this.printStackTraces) break block12;
                ci.printStackTrace((Throwable)e);
            }
        }
    }

    protected abstract String getCommandName();

    public String getHelp() {
        StrBuilder help = new StrBuilder(512);
        help.append("---").append(this.getClass().getSimpleName()).appendln("---");
        help.append("\t").append(this.getCommandName()).appendln(" <cmd> [args]");
        for (String name : this.commands.keySet()) {
            try {
                Command command = this.commands.get(name).newInstance();
                help.append("\t\t").append(name).append(" - ").appendln(command.getDescription());
            }
            catch (Exception e) {
                help.append("\t\t").append(name).append(" - ").appendln(ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return help.toString();
    }

    private boolean isHelpOption(String arg) {
        return StringUtils.equals((String)"-h", (String)arg) || StringUtils.equals((String)"--help", (String)arg);
    }

    private void printCommandHelp(CommandInterpreter ci, String command, CmdLineParser parser) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append(String.format("%s %s", this.getCommandName(), command));
        parser.printSingleLineUsage((Writer)stringWriter, null);
        stringWriter.append(SystemUtils.LINE_SEPARATOR);
        parser.printUsage((Writer)stringWriter, null);
        stringWriter.flush();
        ci.println((Object)stringWriter.toString());
    }

    protected final void registerCommand(String name, Class<? extends Command> commandClass) {
        this.commands.put(name, commandClass);
    }

    protected final void unregisterCommand(String name) {
        this.commands.remove(name);
    }
}

