/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.common.internal.services;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.gyrex.common.internal.services.ServiceProxy;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;

public class ServiceProxyPool {
    private final ConcurrentHashMap<String, ServiceProxy<?>> trackedServices = new ConcurrentHashMap();
    private final AtomicReference<BundleContext> bundleContextRef = new AtomicReference();

    public ServiceProxyPool(BundleContext bundleContext) {
        this.bundleContextRef.set(bundleContext);
    }

    public void dispose() {
        this.bundleContextRef.set(null);
        for (ServiceProxy<?> serviceProxy : this.trackedServices.values()) {
            serviceProxy.dispose();
        }
        this.trackedServices.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> IServiceProxy<T> getOrCreate(Class<T> serviceInterface) {
        BundleContext bundleContext = this.bundleContextRef.get();
        if (bundleContext == null) {
            throw new IllegalStateException("inactive");
        }
        String key = serviceInterface.getName().intern();
        if (!this.trackedServices.contains(key)) {
            ConcurrentHashMap<String, ServiceProxy<?>> concurrentHashMap = this.trackedServices;
            synchronized (concurrentHashMap) {
                if (!this.trackedServices.contains(key)) {
                    this.trackedServices.put(key, new ServiceProxy<T>(bundleContext, serviceInterface));
                }
            }
        }
        return this.trackedServices.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> IServiceProxy<T> getOrCreate(Class<T> serviceInterface, Filter filter) {
        BundleContext bundleContext = this.bundleContextRef.get();
        if (bundleContext == null) {
            throw new IllegalStateException("inactive");
        }
        String key = serviceInterface.getName().intern().concat(filter.toString().intern());
        if (!this.trackedServices.contains(key)) {
            ConcurrentHashMap<String, ServiceProxy<?>> concurrentHashMap = this.trackedServices;
            synchronized (concurrentHashMap) {
                if (!this.trackedServices.contains(key)) {
                    this.trackedServices.put(key, new ServiceProxy<T>(bundleContext, serviceInterface, filter));
                }
            }
        }
        return this.trackedServices.get(key);
    }
}

