/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.tests.internal;

import junit.framework.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.internal.ContextActivator;
import org.eclipse.gyrex.context.internal.GyrexContextHandle;
import org.eclipse.gyrex.context.internal.registry.ContextDefinition;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.eclipse.gyrex.context.manager.IRuntimeContextManager;
import org.eclipse.gyrex.context.provider.RuntimeContextObjectProvider;
import org.eclipse.gyrex.context.tests.internal.Activator;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;

public class ContextualRuntimeBlackBoxTests {
    private static final String SERVICE_PID_DUMMY2 = "org.eclipse.gyrex.context.tests.dummy2";
    private static final Path SOME_CONTEXT_PATH = new Path("/some/other/context");
    private ContextRegistryImpl contextRegistry;
    private IServiceProxy<IRuntimeContextManager> contextManagerProxy;
    private IRuntimeContextManager contextManager;

    static void safeUnregister(ServiceRegistration serviceRegistration) {
        if (serviceRegistration != null) {
            try {
                serviceRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    private GyrexContextHandle assertContextDefined(IPath path) {
        ContextDefinition definition = new ContextDefinition(path);
        definition.setName("Test Context");
        this.contextRegistry.saveDefinition(definition);
        Assert.assertNotNull((String)"context definition must exists after create", (Object)this.contextRegistry.get(path));
        GyrexContextHandle context = this.contextRegistry.get(path);
        Assert.assertNotNull((String)"context handle must exists", (Object)context);
        Assert.assertNotNull((String)"context handle must map to real context", (Object)context.get());
        return context;
    }

    @Before
    public void setUp() throws Exception {
        this.contextRegistry = ContextActivator.getInstance().getContextRegistryImpl();
        this.contextManagerProxy = Activator.getActivator().getServiceHelper().trackService(IRuntimeContextManager.class);
        this.contextManager = (IRuntimeContextManager)this.contextManagerProxy.getService();
    }

    @After
    public void tearDown() throws Exception {
        this.contextRegistry = null;
        this.contextManager = null;
        this.contextManagerProxy.dispose();
        this.contextManagerProxy = null;
    }

    @Test
    public void test0001_ContextualDefinition() {
        GyrexContextHandle rootContext = this.contextRegistry.get((IPath)Path.ROOT);
        Assert.assertNotNull((String)"root context may never be null", (Object)rootContext);
        GyrexContextHandle testContext = this.contextRegistry.get((IPath)SOME_CONTEXT_PATH);
        if (testContext != null) {
            this.testRemove(testContext);
        }
        this.assertContextDefined((IPath)SOME_CONTEXT_PATH);
    }

    @Test
    public void testContextualObjectScenario001() {
        ServiceRegistration serviceRegistration = Activator.getActivator().getServiceHelper().registerService(RuntimeContextObjectProvider.class.getName(), (Object)new DummyObjectProvider(), "Eclipse.org Gyrex", "Dummy object provider.", null, null);
        try {
            GyrexContextHandle rootContext = this.contextRegistry.get((IPath)Path.ROOT);
            Assert.assertNotNull((String)"root context may never be null", (Object)rootContext);
            DummyObject dummyObject = (DummyObject)rootContext.get(DummyObject.class);
            Assert.assertNotNull((String)"The dummy object from the root context must not be null!", (Object)dummyObject);
            Assert.assertEquals((String)"The context of the dummy object does not match!", (Object)rootContext, (Object)dummyObject.context);
            GyrexContextHandle testContext = this.assertContextDefined((IPath)SOME_CONTEXT_PATH);
            DummyObject dummyObject2 = (DummyObject)testContext.get(DummyObject.class);
            Assert.assertNotNull((String)"The dummy object from the test context must not be null!", (Object)dummyObject2);
            Assert.assertEquals((String)"The context of the dummy object from the test context does not match!", (Object)testContext, (Object)dummyObject2.context);
            serviceRegistration.unregister();
            serviceRegistration = null;
            Assert.assertEquals((String)"Dummy object from the root context not properly destoryed after unregister!", (int)1, (int)dummyObject.ungetCalled);
            Assert.assertEquals((String)"Dummy object from the test context not properly destoryed after unregister!", (int)1, (int)dummyObject2.ungetCalled);
        }
        finally {
            ContextualRuntimeBlackBoxTests.safeUnregister(serviceRegistration);
        }
    }

    @Test
    public void testContextualObjectScenario002() {
        ServiceRegistration serviceRegistration = null;
        ServiceRegistration serviceRegistration2 = null;
        try {
            serviceRegistration = Activator.getActivator().getServiceHelper().registerService(RuntimeContextObjectProvider.class.getName(), (Object)new DummyObjectProvider(), "Eclipse.org Gyrex", "Dummy object provider.", null, null);
            GyrexContextHandle rootContext = this.contextRegistry.get((IPath)Path.ROOT);
            DummyObject dummyObject = (DummyObject)rootContext.get(DummyObject.class);
            Assert.assertNotNull((String)"The dummy object from the root context must not be null!", (Object)dummyObject);
            Assert.assertEquals((String)"The context of the dummy object does not match!", (Object)rootContext, (Object)dummyObject.context);
            GyrexContextHandle testContext = this.assertContextDefined((IPath)SOME_CONTEXT_PATH);
            DummyObject dummyObject2 = (DummyObject)testContext.get(DummyObject.class);
            Assert.assertNotNull((String)"The dummy object from the test context must not be null!", (Object)dummyObject2);
            Assert.assertEquals((String)"The context of the dummy object from the test context does not match!", (Object)testContext, (Object)dummyObject2.context);
            serviceRegistration2 = Activator.getActivator().getServiceHelper().registerService(RuntimeContextObjectProvider.class.getName(), (Object)new DummyObjectProvider(), "Eclipse.org Gyrex", "Dummy object provider 2.", null, null);
            Assert.assertEquals((String)"Dummy object from the root context not properly destoryed after additional registration!", (int)1, (int)dummyObject.ungetCalled);
            Assert.assertEquals((String)"Dummy object from the test context not properly destoryed after additional registration!", (int)1, (int)dummyObject2.ungetCalled);
            serviceRegistration.unregister();
            serviceRegistration = null;
            serviceRegistration2.unregister();
            serviceRegistration2 = null;
            Assert.assertEquals((String)"Dummy object from the root context destory multiple times!", (int)1, (int)dummyObject.ungetCalled);
            Assert.assertEquals((String)"Dummy object from the test context destory multiple times!", (int)1, (int)dummyObject2.ungetCalled);
        }
        catch (Throwable throwable) {
            ContextualRuntimeBlackBoxTests.safeUnregister(serviceRegistration);
            ContextualRuntimeBlackBoxTests.safeUnregister(serviceRegistration2);
            throw throwable;
        }
        ContextualRuntimeBlackBoxTests.safeUnregister(serviceRegistration);
        ContextualRuntimeBlackBoxTests.safeUnregister(serviceRegistration2);
    }

    @Test
    public void testContextualObjectScenario003() {
        ServiceRegistration serviceRegistration = null;
        ServiceRegistration serviceRegistration2 = null;
        try {
            serviceRegistration = Activator.getActivator().getServiceHelper().registerService(RuntimeContextObjectProvider.class.getName(), (Object)new DummyObjectProvider(), "Eclipse.org Gyrex", "Dummy object provider.", "org.eclipse.gyrex.context.tests.dummy1", Integer.valueOf(Integer.MAX_VALUE));
            serviceRegistration2 = Activator.getActivator().getServiceHelper().registerService(RuntimeContextObjectProvider.class.getName(), (Object)new DummyObjectProvider2(), "Eclipse.org Gyrex", "Dummy object provider 2.", SERVICE_PID_DUMMY2, Integer.valueOf(Integer.MIN_VALUE));
            GyrexContextHandle testContext = this.assertContextDefined((IPath)SOME_CONTEXT_PATH);
            DummyObject dummyObject1 = (DummyObject)testContext.get(DummyObject.class);
            Assert.assertFalse((String)"The returned object was not provided by the expected provider (DummyObjectProvider 1)! Please verify that service ranking is taken into account when having multiple providers!", (boolean)(dummyObject1 instanceof DummyObject2));
            try {
                this.contextManager.set((IRuntimeContext)testContext, DummyObject.class, FrameworkUtil.createFilter((String)"(service.pid=org.eclipse.gyrex.context.tests.dummy2)"));
            }
            catch (InvalidSyntaxException e) {
                Assert.fail((String)("Please check test case implementation, invalid filter string: " + e.getFilter() + "; " + e.getMessage()));
            }
            DummyObject dummyObject2 = (DummyObject)testContext.get(DummyObject.class);
            Assert.assertTrue((String)"The returned object was not provided by the configured provider (DummyObjectProvider 2)! Please verify that configured filters are verified correctly when having multiple providers!", (boolean)(dummyObject2 instanceof DummyObject2));
            this.contextManager.set((IRuntimeContext)testContext, DummyObject.class, null);
            DummyObject dummyObject3 = (DummyObject)testContext.get(DummyObject.class);
            Assert.assertFalse((String)"The returned object was not provided by the expected provider (DummyObjectProvider 1)! Please verify that service ranking is taken into account when having multiple providers!", (boolean)(dummyObject3 instanceof DummyObject2));
        }
        catch (Throwable throwable) {
            ContextualRuntimeBlackBoxTests.safeUnregister(serviceRegistration);
            ContextualRuntimeBlackBoxTests.safeUnregister(serviceRegistration2);
            throw throwable;
        }
        ContextualRuntimeBlackBoxTests.safeUnregister(serviceRegistration);
        ContextualRuntimeBlackBoxTests.safeUnregister(serviceRegistration2);
    }

    private void testRemove(GyrexContextHandle context) {
        IPath path = context.getContextPath();
        ContextDefinition definition = this.contextRegistry.getDefinition(path);
        Assert.assertNotNull((String)"definiton must not be null if a context exists", (Object)definition);
        this.contextRegistry.removeDefinition(definition);
        Assert.assertNotNull((String)"definitiono must be gone after remove", (Object)this.contextRegistry.getDefinition(path));
        try {
            context.get();
            Assert.fail((String)"definition has been removed!");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public static class DummyObject {
        final IRuntimeContext context;
        int ungetCalled = 0;

        public DummyObject(IRuntimeContext context) {
            this.context = context;
        }

        public String toString() {
            return "DummyObject{ " + this.context + " }";
        }
    }

    public static class DummyObject2
    extends DummyObject {
        public DummyObject2(IRuntimeContext context) {
            super(context);
        }

        @Override
        public String toString() {
            return "DummyObject2{ " + this.context + " }";
        }
    }

    public static class DummyObjectProvider
    extends RuntimeContextObjectProvider {
        public Object getObject(Class type, IRuntimeContext context) {
            if (type.equals(DummyObject.class)) {
                return new DummyObject(context);
            }
            return null;
        }

        public Class[] getObjectTypes() {
            return new Class[]{DummyObject.class};
        }

        public void ungetObject(Object object, IRuntimeContext context) {
            if (object instanceof DummyObject) {
                ++((DummyObject)object).ungetCalled;
            }
        }
    }

    public static class DummyObjectProvider2
    extends DummyObjectProvider {
        @Override
        public Object getObject(Class type, IRuntimeContext context) {
            if (type.equals(DummyObject.class)) {
                return new DummyObject2(context);
            }
            return null;
        }
    }
}

