/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.boot.internal.app;

import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.boot.internal.app.BootDebug;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.server.internal.opsmode.OperationMode;
import org.eclipse.gyrex.server.internal.opsmode.OpsMode;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class AppActivator
extends BaseBundleActivator {
    private static final String BUNDLE_STATE_LOCATION = ".metadata/.plugins";
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.boot";
    private static AppActivator sharedInstance;
    private static final AtomicReference<OpsMode> opsModeRef;
    private static final AtomicBoolean debugModeRef;
    private BundleContext context;
    private ServiceTracker<PackageAdmin, PackageAdmin> bundleTracker;
    private volatile IServiceProxy<Location> instanceLocationProxy;
    private volatile IPath instanceLocationPath;

    static {
        opsModeRef = new AtomicReference();
        debugModeRef = new AtomicBoolean();
    }

    public static AppActivator getInstance() {
        return sharedInstance;
    }

    public static OpsMode getOpsMode() {
        return opsModeRef.get();
    }

    public static boolean isDebugMode() {
        return debugModeRef.get();
    }

    public static boolean isDevMode() {
        OpsMode mode = AppActivator.getOpsMode();
        if (mode == null) {
            return true;
        }
        return mode.getMode() != OperationMode.PRODUCTION;
    }

    public AppActivator() {
        super(SYMBOLIC_NAME);
    }

    protected void doStart(BundleContext context) throws Exception {
        sharedInstance = this;
        this.context = context;
        this.instanceLocationProxy = this.getServiceHelper().trackService(Location.class, context.createFilter(Location.INSTANCE_FILTER));
        OpsMode opsMode = new OpsMode();
        opsModeRef.set(opsMode);
        if (!opsMode.isSet()) {
            this.getServiceHelper().registerService(IStatus.class.getName(), (Object)new Status(2, SYMBOLIC_NAME, "The system operation mode has not been configured yet. Therefore the system operates in development mode."), "Eclipse Gyrex", "System operation mode status information.", SYMBOLIC_NAME.concat(".status.operationMode"), null);
        }
        debugModeRef.set(context.getProperty("osgi.debug") != null || AppActivator.getOpsMode().getMode() == OperationMode.DEVELOPMENT);
    }

    protected void doStop(BundleContext context) throws Exception {
        sharedInstance = null;
        this.context = null;
        this.instanceLocationProxy.dispose();
        this.instanceLocationProxy = null;
    }

    public Bundle getBundle(String symbolicName) {
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    @Deprecated
    private PackageAdmin getBundleAdmin() {
        if (this.bundleTracker == null) {
            if (this.context == null) {
                return null;
            }
            this.bundleTracker = new ServiceTracker(this.context, PackageAdmin.class, null);
            this.bundleTracker.open();
        }
        return (PackageAdmin)this.bundleTracker.getService();
    }

    public BundleContext getContext() {
        return this.context;
    }

    protected Class getDebugOptions() {
        return BootDebug.class;
    }

    public ApplicationDescriptor getEclipseApplication(String applicationId) throws IllegalStateException {
        ServiceReference[] serviceReferences;
        String filterString = NLS.bind((String)"(&(objectClass={0})(service.pid={1})(application.container=org.eclipse.equinox.app)(eclipse.application.type=any.thread))", (Object)ApplicationDescriptor.class.getName(), (Object)applicationId);
        try {
            serviceReferences = this.context.getServiceReferences(ApplicationDescriptor.class.getName(), filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(NLS.bind((String)"Internal error while looking for application {0} using filer {1}. {2}", (Object[])new Object[]{applicationId, filterString, e.getMessage()}));
        }
        if (serviceReferences == null || serviceReferences.length == 0) {
            throw new IllegalStateException(NLS.bind((String)"Application {0} not found!", (Object)applicationId));
        }
        if (serviceReferences.length > 1) {
            throw new IllegalStateException(NLS.bind((String)"Multiple applications with id {0} found! Just one expected!", (Object)applicationId));
        }
        try {
            ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)this.context.getService(serviceReferences[0]);
            return applicationDescriptor;
        }
        finally {
            this.context.ungetService(serviceReferences[0]);
        }
    }

    public FrameworkLog getFrameworkLog() {
        try {
            return (FrameworkLog)this.getServiceHelper().trackService(FrameworkLog.class).getService();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public Location getInstanceLocation() {
        IServiceProxy<Location> proxy = this.instanceLocationProxy;
        if (proxy == null) {
            throw this.createBundleInactiveException();
        }
        return (Location)proxy.getService();
    }

    public IPath getInstanceLocationPath() {
        if (this.instanceLocationPath != null) {
            return this.instanceLocationPath;
        }
        URL url = this.getInstanceLocation().getURL();
        if (url == null) {
            throw new IllegalStateException("instance location not available");
        }
        if (!url.getProtocol().equals("file")) {
            throw new IllegalStateException("instance location must be on local file system");
        }
        this.instanceLocationPath = new Path(url.getPath());
        return this.instanceLocationPath;
    }

    public IPath getStateLocation(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle must not be null");
        }
        return this.getInstanceLocationPath().append(BUNDLE_STATE_LOCATION).append(bundle.getSymbolicName());
    }
}

