/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.server.internal.roles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.boot.internal.app.AppActivator;
import org.eclipse.gyrex.boot.internal.app.BootDebug;
import org.eclipse.gyrex.server.internal.roles.ActivationException;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ApplicationHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRole {
    private static final Logger LOG = LoggerFactory.getLogger(ServerRole.class);
    private final String id;
    private final String name;
    private final List<String> requiredBundleNames;
    private final List<String> requiredApplicationIds;
    private final LinkedHashMap<String, ApplicationHandle> launchedApps = new LinkedHashMap(3);
    private final AtomicBoolean active = new AtomicBoolean();

    ServerRole(String id, String name, List<String> requiredBundleNames, List<String> requiredApplicationIds) {
        this.id = id;
        this.name = name;
        this.requiredBundleNames = requiredBundleNames;
        this.requiredApplicationIds = requiredApplicationIds;
    }

    void activate() throws ActivationException {
        if (!this.active.compareAndSet(false, true)) {
            return;
        }
        if (BootDebug.roles) {
            LOG.debug("Activating server role {}...", (Object)this.getId());
        }
        for (String bundleName : this.requiredBundleNames) {
            try {
                this.startBundle(bundleName);
            }
            catch (Exception e) {
                throw new ActivationException(NLS.bind((String)"Error starting bundle \"{0}\": {1}", (Object)bundleName, (Object)e.getMessage()), e);
            }
        }
        for (String applicationId : this.requiredApplicationIds) {
            try {
                this.startApplication(applicationId);
            }
            catch (Exception e) {
                throw new ActivationException(NLS.bind((String)"Error starting application \"{0}\": {1}", (Object)applicationId, (Object)e.getMessage()), e);
            }
        }
    }

    void deactivate() {
        if (!this.active.compareAndSet(true, false)) {
            return;
        }
        if (BootDebug.roles) {
            LOG.debug("Deactivating server role {}...", (Object)this.getId());
        }
        ArrayList<String> launchedAppIds = new ArrayList<String>(this.launchedApps.keySet());
        Collections.reverse(launchedAppIds);
        for (String applicationId : launchedAppIds) {
            this.stopApplication(applicationId);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    private void startApplication(String applicationId) throws IllegalStateException, ApplicationException {
        ApplicationDescriptor applicationDescriptor;
        if (BootDebug.roles) {
            LOG.debug("Starting application {}", (Object)applicationId);
        }
        if ((applicationDescriptor = AppActivator.getInstance().getEclipseApplication(applicationId)) == null) {
            throw new IllegalStateException(NLS.bind((String)"Application {0} not found!", (Object)applicationId));
        }
        ApplicationHandle handle = applicationDescriptor.launch(null);
        this.launchedApps.put(applicationId, handle);
        long timeout = 2000L;
        String state = null;
        do {
            if (StringUtils.equals((String)(state = handle.getState()), (String)"RUNNING")) continue;
            try {
                timeout -= 150L;
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                break;
            }
        } while (timeout > 0L && !StringUtils.equals((String)state, (String)"RUNNING"));
        if (!StringUtils.equals((String)state, (String)"RUNNING")) {
            LOG.warn("Application {} did not reach RUNNING state within timely manner (state ist {}). Server role {} might by dysfunctional!", new Object[]{applicationId, state, this.getId()});
        } else if (BootDebug.roles) {
            LOG.debug("Application {} started.", (Object)applicationId);
        }
    }

    private void startBundle(String symbolicName) throws BundleException, IllegalStateException {
        Bundle bundle;
        if (BootDebug.roles) {
            LOG.debug("Starting bundle {}", (Object)symbolicName);
        }
        if ((bundle = AppActivator.getInstance().getBundle(symbolicName)) == null) {
            LOG.warn("Bundle {} not avaiable. Server role {} might by dysfunctional!", (Object)symbolicName, (Object)this.getId());
            return;
        }
        int originalState = bundle.getState();
        if ((originalState & 0x20) != 0) {
            return;
        }
        try {
            bundle.start(1);
        }
        catch (BundleException e) {
            if ((bundle.getState() & 0x20) != 0) {
                return;
            }
            if ((originalState & 8) != 0 && (bundle.getState() & 8) != 0) {
                return;
            }
            throw e;
        }
    }

    private void stopApplication(String applicationId) {
        if (BootDebug.roles) {
            LOG.debug("Stopping application {}", (Object)applicationId);
        }
        try {
            String state;
            block16: {
                ApplicationHandle handle;
                block15: {
                    handle = this.launchedApps.get(applicationId);
                    if (handle == null) {
                        LOG.warn("Application handle for application {} not found! Unable to stop application.", (Object)applicationId);
                        return;
                    }
                    try {
                        handle.destroy();
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (!BootDebug.roles) break block15;
                        LOG.debug("Application {} not active.", (Object)applicationId);
                    }
                }
                long timeout = 2000L;
                state = null;
                try {
                    do {
                        state = handle.getState();
                        if (BootDebug.roles) {
                            LOG.debug("Application {} state: {}", (Object)applicationId, (Object)state);
                        }
                        if (!StringUtils.equals((String)state, (String)"STOPPING")) continue;
                        try {
                            timeout -= 150L;
                            Thread.sleep(150L);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    } while (timeout > 0L && StringUtils.equals((String)state, (String)"STOPPING"));
                }
                catch (IllegalStateException e) {
                    if (!BootDebug.roles) break block16;
                    LOG.debug("Application {} state {}: {}", new Object[]{applicationId, state, e.getMessage()});
                }
            }
            if (StringUtils.equals((String)state, (String)"STOPPING")) {
                LOG.warn("Application {} still in STOPPING state after waiting for ordered shutdown. Server role {} might not be shutdown cleanly!", new Object[]{applicationId, state, this.getId()});
            } else if (BootDebug.roles) {
                LOG.debug("Application {} stopped.", (Object)applicationId);
            }
        }
        catch (Exception e) {
            LOG.warn("Error during shutdown of application {} while deactivating role {}. {}", (Object)new Object[]{applicationId, this.getId(), e.getMessage()}, (Object)e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ServerRole [id=").append(this.id).append(", name=").append(this.name).append(", active=").append(this.active).append("]");
        return builder.toString();
    }
}

