/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.application;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.application.ApplicationException;
import org.eclipse.gyrex.http.application.context.IApplicationContext;

public abstract class Application
extends PlatformObject {
    private final String id;
    private final IRuntimeContext context;
    private final AtomicReference<IApplicationContext> applicationContext = new AtomicReference();
    private final AtomicReference<IStatus> status = new AtomicReference();
    private final AtomicLong initTimestamp = new AtomicLong();
    private final Lock initLock = new ReentrantLock();
    private final AtomicBoolean destroyed = new AtomicBoolean();

    protected Application(String id, IRuntimeContext context) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this.id = id.intern();
        this.context = context;
    }

    private void deferredInit() {
        block8: {
            try {
                if (!this.initLock.tryLock(2L, TimeUnit.SECONDS)) {
                    throw new ApplicationException(503, "Initialization In Progress");
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new ApplicationException(503, "Not Initialized");
            }
            try {
                if (this.initTimestamp.get() != 0L) break block8;
                try {
                    this.doInit();
                    this.initTimestamp.set(System.currentTimeMillis());
                }
                catch (Exception e) {
                    throw new ApplicationException(503, "Inititalization Error", e);
                }
            }
            finally {
                this.initLock.unlock();
            }
        }
    }

    public final void destroy() {
        this.destroyed.set(true);
        try {
            this.doDestroy();
        }
        finally {
            this.applicationContext.set(null);
        }
    }

    protected void doDestroy() {
    }

    protected void doInit() throws IllegalStateException, Exception {
    }

    protected IApplicationContext getApplicationContext() {
        return this.applicationContext.get();
    }

    public final IRuntimeContext getContext() {
        return this.context;
    }

    public final String getId() {
        return this.id;
    }

    public final IStatus getStatus() {
        if (this.destroyed.get()) {
            return Status.CANCEL_STATUS;
        }
        IStatus status = this.status.get();
        if (status != null) {
            return status;
        }
        return Status.OK_STATUS;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ApplicationException {
        if (this.initTimestamp.get() == 0L) {
            this.deferredInit();
        }
        if (!this.handleSecurity(request, response)) {
            return;
        }
        IApplicationContext context = this.getApplicationContext();
        if (context == null) {
            response.sendError(501);
            return;
        }
        if (context.handleRequest(request, response)) {
            return;
        }
        response.sendError(404);
    }

    protected boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return true;
    }

    public final void initialize(IApplicationContext applicationContext) throws CoreException {
        if (applicationContext == null) {
            throw new IllegalArgumentException("application context must not be null");
        }
        this.applicationContext.set(applicationContext);
        try {
            this.doInit();
            this.initTimestamp.set(System.currentTimeMillis());
        }
        catch (CoreException e) {
            throw e;
        }
        catch (IllegalStateException illegalStateException) {
            this.initTimestamp.set(0L);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.gyrex.http", String.format("Error while initializing applicaion %s. %s", this.id, ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e));
        }
    }

    public final void setStatus(IStatus status) {
        this.status.set(status);
    }

    public String toString() {
        StringBuilder toString = new StringBuilder();
        toString.append(((Object)((Object)this)).getClass().getSimpleName());
        toString.append("[");
        toString.append(this.id);
        toString.append("]");
        return toString.toString();
    }
}

