/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.internal.GyrexContextHandle;
import org.eclipse.gyrex.context.internal.GyrexContextImpl;
import org.eclipse.gyrex.context.internal.provider.ObjectProviderRegistry;
import org.eclipse.gyrex.context.internal.registry.ContextDefinition;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.preferences.CloudScope;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ContextRegistryImpl
implements IRuntimeContextRegistry {
    private static final Set<String> forbiddenPathSegments;
    private final Map<IPath, GyrexContextImpl> contexts;
    private final ConcurrentMap<IPath, GyrexContextHandle> handles;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ReadWriteLock contextRegistryLock = new ReentrantReadWriteLock();
    private final ObjectProviderRegistry objectProviderRegistry;

    static {
        HashSet<String> segments = new HashSet<String>(1);
        segments.add(".settings");
        forbiddenPathSegments = Collections.unmodifiableSet(segments);
    }

    public static IPath sanitize(IPath contextPath) throws IllegalArgumentException {
        if (contextPath == null) {
            throw new IllegalArgumentException("context path must not be null");
        }
        if (contextPath.getDevice() != null) {
            throw new IllegalArgumentException("invalid context path; device id must be null; " + contextPath);
        }
        if (contextPath.isEmpty()) {
            return Path.ROOT;
        }
        String[] stringArray = contextPath.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (forbiddenPathSegments.contains(segment)) {
                throw new IllegalArgumentException(NLS.bind((String)"Segment \"{0}\" not allowed in context path \"{1}\"", (Object)segment, (Object)contextPath));
            }
            ++n2;
        }
        return contextPath.makeAbsolute().addTrailingSeparator();
    }

    public ContextRegistryImpl(ObjectProviderRegistry objectProviderRegistry) {
        this.contexts = new HashMap<IPath, GyrexContextImpl>();
        this.handles = new ConcurrentHashMap<IPath, GyrexContextHandle>();
        this.objectProviderRegistry = objectProviderRegistry;
    }

    private void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException("context registry closed");
        }
    }

    public void close() throws Exception {
        IRuntimeContext[] activeContexts;
        this.closed.set(true);
        Lock lock = this.contextRegistryLock.writeLock();
        lock.lock();
        try {
            activeContexts = this.contexts.values().toArray(new IRuntimeContext[this.contexts.size()]);
            this.contexts.clear();
        }
        finally {
            lock.unlock();
        }
        IRuntimeContext[] iRuntimeContextArray = activeContexts;
        int n = activeContexts.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeContext context = iRuntimeContextArray[n2];
            if (context instanceof IDisposable) {
                ((IDisposable)context).dispose();
            }
            ++n2;
        }
        this.handles.clear();
    }

    public void flushContextHierarchy(IRuntimeContext context) {
        this.checkClosed();
        IPath contextPath = context.getContextPath();
        ArrayList<GyrexContextImpl> removedContexts = new ArrayList<GyrexContextImpl>();
        Lock lock = this.contextRegistryLock.writeLock();
        lock.lock();
        try {
            Map.Entry[] entrySet;
            this.checkClosed();
            Map.Entry[] entryArray = entrySet = this.contexts.entrySet().toArray(new Map.Entry[0]);
            int n = entrySet.length;
            int n2 = 0;
            while (n2 < n) {
                GyrexContextImpl contextImpl;
                Map.Entry entry = entryArray[n2];
                IPath entryPath = (IPath)entry.getKey();
                if (contextPath.isPrefixOf(entryPath) && (contextImpl = this.contexts.remove(entryPath)) != null) {
                    removedContexts.add(contextImpl);
                }
                ++n2;
            }
        }
        finally {
            lock.unlock();
        }
        for (GyrexContextImpl contextImpl : removedContexts) {
            contextImpl.dispose();
        }
    }

    @Override
    public GyrexContextHandle get(IPath contextPath) throws IllegalArgumentException {
        return this.getHandle(contextPath);
    }

    private Preferences getContextDefinitionStore() {
        return CloudScope.INSTANCE.getNode("org.eclipse.gyrex.context").node("definedContexts");
    }

    public Collection<ContextDefinition> getDefinedContexts() {
        this.checkClosed();
        try {
            Preferences node = this.getContextDefinitionStore();
            String[] keys = node.keys();
            ArrayList<ContextDefinition> contexts = new ArrayList<ContextDefinition>(keys.length + 1);
            contexts.add(this.getRootDefinition());
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                ContextDefinition definition = new ContextDefinition((IPath)new Path(path));
                definition.setName(node.get(path, null));
                contexts.add(definition);
                ++n2;
            }
            return Collections.unmodifiableList(contexts);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error reading context definitions. %s", ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    public ContextDefinition getDefinition(IPath contextPath) {
        this.checkClosed();
        contextPath = ContextRegistryImpl.sanitize(contextPath);
        if (contextPath.isRoot()) {
            return this.getRootDefinition();
        }
        Preferences node = this.getContextDefinitionStore();
        String name = node.get(contextPath.toString(), null);
        if (name == null) {
            return null;
        }
        ContextDefinition definition = new ContextDefinition(contextPath);
        definition.setName(name);
        return definition;
    }

    public GyrexContextHandle getHandle(IPath contextPath) {
        this.checkClosed();
        contextPath = ContextRegistryImpl.sanitize(contextPath);
        GyrexContextHandle contextHandle = (GyrexContextHandle)this.handles.get(contextPath);
        if (contextHandle == null) {
            ContextDefinition definition = this.getDefinition(contextPath);
            if (definition == null) {
                return null;
            }
            contextHandle = this.handles.putIfAbsent(contextPath, new GyrexContextHandle(contextPath, this));
            if (contextHandle == null) {
                contextHandle = (GyrexContextHandle)this.handles.get(contextPath);
            }
        }
        return contextHandle;
    }

    public ObjectProviderRegistry getObjectProviderRegistry() {
        return this.objectProviderRegistry;
    }

    public GyrexContextImpl getRealContext(IPath contextPath) throws IllegalArgumentException {
        this.checkClosed();
        contextPath = ContextRegistryImpl.sanitize(contextPath);
        GyrexContextImpl context = null;
        Lock readLock = this.contextRegistryLock.readLock();
        readLock.lock();
        try {
            context = this.contexts.get(contextPath);
            if (context != null) {
                GyrexContextImpl gyrexContextImpl = context;
                return gyrexContextImpl;
            }
        }
        finally {
            readLock.unlock();
        }
        Lock lock = this.contextRegistryLock.writeLock();
        lock.lock();
        try {
            this.checkClosed();
            context = this.contexts.get(contextPath);
            if (context != null) {
                GyrexContextImpl gyrexContextImpl = context;
                return gyrexContextImpl;
            }
            ContextDefinition definition = this.getDefinition(contextPath);
            if (definition == null) {
                throw new IllegalStateException(String.format("Context '%s' does not exists.", contextPath.toString()));
            }
            context = new GyrexContextImpl(contextPath, this);
            this.contexts.put(contextPath, context);
        }
        finally {
            lock.unlock();
        }
        return context;
    }

    private ContextDefinition getRootDefinition() {
        ContextDefinition rootDefinition = new ContextDefinition((IPath)Path.ROOT);
        rootDefinition.setName("ROOT");
        return rootDefinition;
    }

    public void removeDefinition(ContextDefinition contextDefinition) {
        this.checkClosed();
        IPath path = ContextRegistryImpl.sanitize(contextDefinition.getPath());
        if (path.isRoot()) {
            throw new IllegalArgumentException("cannot remove root context");
        }
        try {
            Preferences node = this.getContextDefinitionStore();
            node.remove(path.toString());
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error removing context definition %s. %s", path, ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    public void saveDefinition(ContextDefinition contextDefinition) {
        this.checkClosed();
        IPath path = ContextRegistryImpl.sanitize(contextDefinition.getPath());
        if (path.isRoot()) {
            throw new IllegalArgumentException("cannot modify root context");
        }
        try {
            Preferences node = this.getContextDefinitionStore();
            String name = contextDefinition.getName();
            node.put(path.toString(), StringUtils.isNotBlank((String)name) ? name : "");
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error saving context definition %s. %s", path, ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }
}

