/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.resources;

import com.yahoo.platform.yui.compressor.JavaScriptToken;
import java.util.List;

public class TokenList {
    private final List tokens;

    public TokenList(List tokens) {
        this.tokens = tokens;
    }

    public int size() {
        return this.tokens.size();
    }

    public JavaScriptToken getToken(int index) {
        JavaScriptToken token = null;
        if (index >= 0 && index < this.tokens.size()) {
            token = (JavaScriptToken)this.tokens.get(index);
        }
        return token;
    }

    public void removeToken(int index) {
        this.replaceToken(index, null);
    }

    public void replaceToken(int index, JavaScriptToken[] replacement) {
        this.replaceTokens(index, index, replacement);
    }

    public void replaceTokens(int begin, int end, JavaScriptToken[] replacement) {
        if (begin >= 0 && begin <= end && end < this.tokens.size()) {
            int i = begin;
            while (i <= end) {
                this.tokens.remove(begin);
                ++i;
            }
            if (replacement != null) {
                i = 0;
                while (i < replacement.length) {
                    this.tokens.add(begin + i, replacement[i]);
                    ++i;
                }
            }
        }
    }

    public int readExpression(int offset) {
        int result = -1;
        JavaScriptToken token = this.getToken(offset);
        if (TokenMatcher.LEFT_BRACE.matches(token) || TokenMatcher.LEFT_BRACKET.matches(token)) {
            result = this.findClosing(offset);
        }
        int pos = offset;
        while (pos >= 0 && pos < this.size() && result == -1) {
            token = this.getToken(pos);
            if (TokenMatcher.LEFT_BRACE.matches(token) || TokenMatcher.LEFT_BRACKET.matches(token) || TokenMatcher.LEFT_PAREN.matches(token)) {
                pos = this.findClosing(pos) + 1;
                continue;
            }
            if (TokenMatcher.RIGHT_BRACE.matches(token) || TokenMatcher.RIGHT_BRACKET.matches(token) || TokenMatcher.RIGHT_PAREN.matches(token) || TokenMatcher.COMMA.matches(token) || TokenMatcher.SEMI.matches(token)) {
                result = pos - 1;
                continue;
            }
            ++pos;
        }
        if (result == -1) {
            result = pos - 1;
        }
        return result;
    }

    public int findClosing(int offset) {
        TokenMatcher rightMatcher;
        TokenMatcher leftMatcher;
        int result = -1;
        JavaScriptToken token = this.getToken(offset);
        if (TokenMatcher.LEFT_BRACE.matches(token)) {
            leftMatcher = TokenMatcher.LEFT_BRACE;
            rightMatcher = TokenMatcher.RIGHT_BRACE;
        } else if (TokenMatcher.LEFT_BRACKET.matches(token)) {
            leftMatcher = TokenMatcher.LEFT_BRACKET;
            rightMatcher = TokenMatcher.RIGHT_BRACKET;
        } else if (TokenMatcher.LEFT_PAREN.matches(token)) {
            leftMatcher = TokenMatcher.LEFT_PAREN;
            rightMatcher = TokenMatcher.RIGHT_PAREN;
        } else {
            String message = "Not an opening brace, bracket or parenthesis at pos " + offset;
            throw new IllegalArgumentException(message);
        }
        int level = 0;
        int pos = offset;
        while (pos < this.tokens.size() && result == -1) {
            token = this.getToken(pos);
            if (leftMatcher.matches(token)) {
                ++level;
            } else if (rightMatcher.matches(token) && --level == 0) {
                result = pos;
            }
            ++pos;
        }
        return result;
    }

    public int findInObjectLiteral(String key, int offset) {
        if (!TokenMatcher.LEFT_BRACE.matches(this.getToken(offset))) {
            throw new IllegalArgumentException("Not an object literal at pos " + offset);
        }
        int result = -1;
        int closingBrace = this.findClosing(offset);
        if (closingBrace == -1) {
            throw new IllegalArgumentException("No closing brace found for pos " + offset);
        }
        int pos = offset + 1;
        TokenMatcher keyStringMatcher = TokenMatcher.string();
        TokenMatcher keyNameMatcher = TokenMatcher.name();
        while (pos < closingBrace - 2) {
            JavaScriptToken token = this.getToken(pos);
            if ((keyStringMatcher.matches(token) || keyNameMatcher.matches(token)) && (key.equals(keyStringMatcher.matchedValue) || key.equals(keyNameMatcher.matchedValue) || "default".equals(keyStringMatcher.matchedValue) || "default".equals(keyNameMatcher.matchedValue)) && TokenMatcher.OBJECTLIT.matches(this.getToken(pos + 1))) {
                result = pos + 2;
            }
            ++pos;
        }
        return result;
    }

    public static class TokenMatcher {
        public static final TokenMatcher DOT = TokenMatcher.literal(104);
        public static final TokenMatcher IF = TokenMatcher.literal(108);
        public static final TokenMatcher ELSE = TokenMatcher.literal(109);
        public static final TokenMatcher COMMA = TokenMatcher.literal(85);
        public static final TokenMatcher SEMI = TokenMatcher.literal(78);
        public static final TokenMatcher OBJECTLIT = TokenMatcher.literal(64);
        public static final TokenMatcher LEFT_PAREN = TokenMatcher.literal(83);
        public static final TokenMatcher RIGHT_PAREN = TokenMatcher.literal(84);
        public static final TokenMatcher LEFT_BRACE = TokenMatcher.literal(81);
        public static final TokenMatcher RIGHT_BRACE = TokenMatcher.literal(82);
        public static final TokenMatcher LEFT_BRACKET = TokenMatcher.literal(79);
        public static final TokenMatcher RIGHT_BRACKET = TokenMatcher.literal(80);
        private final int expectedType;
        private final String expectedValue;
        public String matchedValue;

        public static TokenMatcher string() {
            return new TokenMatcher(40, null);
        }

        public static TokenMatcher name() {
            return new TokenMatcher(38, null);
        }

        public static TokenMatcher string(String string) {
            return new TokenMatcher(40, string);
        }

        public static TokenMatcher name(String string) {
            return new TokenMatcher(38, string);
        }

        public static TokenMatcher literal(int type) {
            return new TokenMatcher(type, null);
        }

        private TokenMatcher(int type, String value) {
            this.expectedType = type;
            this.expectedValue = value;
        }

        public boolean matches(JavaScriptToken token) {
            boolean result = false;
            this.matchedValue = null;
            if (token != null) {
                boolean bl = result = token.getType() == this.expectedType;
                if (this.expectedValue != null) {
                    result &= this.expectedValue.equals(token.getValue());
                } else {
                    this.matchedValue = token.getValue();
                }
            }
            return result;
        }

        public String getMatchedValue() {
            return this.matchedValue;
        }

        public void clear() {
            this.matchedValue = null;
        }
    }

    public static class TokenPattern {
        private final TokenMatcher[] matchers;

        public TokenPattern(TokenMatcher[] matchers) {
            this.matchers = matchers;
        }

        public int read(TokenList reader, int offset) {
            boolean result = true;
            int i = 0;
            while (i < this.matchers.length && result) {
                this.matchers[i].clear();
                ++i;
            }
            int pos = offset;
            int i2 = 0;
            while (i2 < this.matchers.length && result) {
                result &= this.matchers[i2].matches(reader.getToken(pos));
                ++pos;
                ++i2;
            }
            if (result) {
                return pos - 1;
            }
            return -1;
        }
    }
}

