/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.internal.widgets.IBrowserAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class Browser
extends Composite {
    private static final String FUNCTIONS_TO_CREATE;
    private static final String FUNCTIONS_TO_DESTROY;
    private static final String ABOUT_BLANK = "about:blank";
    private String url;
    private String html;
    private boolean urlChanged = false;
    public String executeScript;
    private Boolean executeResult;
    private boolean executePending;
    private Object evaluateResult;
    private final IBrowserAdapter browserAdapter;
    private List functions;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.browser.Browser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FUNCTIONS_TO_CREATE = String.valueOf(clazz.getName()) + "#functionsToCreate.";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.browser.Browser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FUNCTIONS_TO_DESTROY = String.valueOf(clazz2.getName()) + "#functionsToDestroy.";
    }

    public Browser(Composite parent, int style) {
        super(parent, style);
        if ((style & 0x18000) != 0) {
            throw new SWTError(2, "Unsupported Browser type");
        }
        this.html = "";
        this.url = "";
        this.browserAdapter = new BrowserAdapter();
        this.functions = new ArrayList();
    }

    public boolean setUrl(String url) {
        this.checkWidget();
        if (url == null) {
            SWT.error(4);
        }
        LocationEvent event = new LocationEvent(this, 1, url);
        event.processEvent();
        boolean result = event.doit;
        if (result) {
            this.url = url;
            this.urlChanged = true;
            this.html = "";
            event = new LocationEvent(this, 2, url);
            event.top = true;
            event.processEvent();
            ProgressEvent progressEvent = new ProgressEvent(this, 1);
            progressEvent.processEvent();
        }
        return result;
    }

    public String getUrl() {
        this.checkWidget();
        return this.url;
    }

    public boolean setText(String html) {
        this.checkWidget();
        if (html == null) {
            SWT.error(4);
        }
        LocationEvent event = new LocationEvent(this, 1, ABOUT_BLANK);
        event.processEvent();
        boolean result = event.doit;
        if (result) {
            this.html = html;
            this.url = "";
            this.urlChanged = true;
            event = new LocationEvent(this, 2, ABOUT_BLANK);
            event.top = true;
            event.processEvent();
            ProgressEvent progressEvent = new ProgressEvent(this, 1);
            progressEvent.processEvent();
        }
        return result;
    }

    public boolean execute(String script) {
        this.checkWidget();
        if (script == null) {
            SWT.error(4);
        }
        boolean result = false;
        if (this.executeScript == null) {
            this.executeScript = script;
            this.executeResult = null;
            while (this.executeResult == null) {
                Display display = this.getDisplay();
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            this.executeScript = null;
            this.executePending = false;
            result = this.executeResult;
        }
        return result;
    }

    public Object evaluate(String script) throws SWTException {
        if (script == null) {
            SWT.error(4);
        }
        StringBuffer buffer = new StringBuffer("(function(){");
        buffer.append(script);
        buffer.append("})();");
        boolean success = this.execute(buffer.toString());
        if (!success) {
            String errorString = "Failed to evaluate javascript expression";
            throw new SWTException(50, errorString);
        }
        return this.evaluateResult;
    }

    public void addLocationListener(LocationListener listener) {
        this.checkWidget();
        LocationEvent.addListener(this, listener);
    }

    public void removeLocationListener(LocationListener listener) {
        this.checkWidget();
        LocationEvent.removeListener(this, listener);
    }

    public void addProgressListener(ProgressListener listener) {
        this.checkWidget();
        ProgressEvent.addListener(this, listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.checkWidget();
        ProgressEvent.removeListener(this, listener);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IBrowserAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object result = clazz.equals(adapter) ? this.browserAdapter : super.getAdapter(adapter);
        return result;
    }

    public Object getWebBrowser() {
        this.checkWidget();
        return null;
    }

    private BrowserFunction[] getBrowserFunctions() {
        BrowserFunction[] result = new BrowserFunction[this.functions.size()];
        this.functions.toArray(result);
        return result;
    }

    void createFunction(BrowserFunction function) {
        boolean removed = false;
        int i = 0;
        while (!removed && i < this.functions.size()) {
            BrowserFunction current = (BrowserFunction)this.functions.get(i);
            if (current.name.equals(function.name)) {
                this.functions.remove(current);
                removed = true;
            }
            ++i;
        }
        this.functions.add(function);
        if (!removed) {
            this.updateBrowserFunctions(function.getName(), true);
        }
    }

    void destroyFunction(BrowserFunction function) {
        this.functions.remove(function);
        this.updateBrowserFunctions(function.getName(), false);
    }

    private void updateBrowserFunctions(String function, boolean create) {
        String[] newList;
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        String id = WidgetUtil.getId(this);
        String key = create ? String.valueOf(FUNCTIONS_TO_CREATE) + id : String.valueOf(FUNCTIONS_TO_DESTROY) + id;
        String[] funcList = (String[])stateInfo.getAttribute(key);
        if (funcList == null) {
            newList = new String[]{function};
        } else {
            newList = new String[funcList.length + 1];
            System.arraycopy(funcList, 0, newList, 0, funcList.length);
            newList[funcList.length] = function;
        }
        stateInfo.setAttribute(key, newList);
    }

    protected void checkWidget() {
        super.checkWidget();
    }

    static /* synthetic */ void access$1(Browser browser, Boolean bl) {
        browser.executeResult = bl;
    }

    static /* synthetic */ void access$2(Browser browser, Object object) {
        browser.evaluateResult = object;
    }

    private final class BrowserAdapter
    implements IBrowserAdapter {
        private BrowserAdapter() {
        }

        public String getText() {
            return Browser.this.html;
        }

        public String getExecuteScript() {
            return Browser.this.executeScript;
        }

        public void setExecuteResult(boolean result, Object value) {
            ProcessActionRunner.add(new Runnable(this, result, value){
                final /* synthetic */ BrowserAdapter this$1;
                private final /* synthetic */ boolean val$result;
                private final /* synthetic */ Object val$value;
                {
                    this.this$1 = browserAdapter;
                    this.val$result = bl;
                    this.val$value = object;
                }

                public void run() {
                    Browser.access$1(BrowserAdapter.access$1(this.this$1), this.val$result);
                    Browser.access$2(BrowserAdapter.access$1(this.this$1), this.val$value);
                }
            });
        }

        public void setExecutePending(boolean executePending) {
            Browser.this.executePending = executePending;
        }

        public boolean getExecutePending() {
            return Browser.this.executePending;
        }

        public BrowserFunction[] getBrowserFunctions() {
            return Browser.this.getBrowserFunctions();
        }

        public boolean getAndResetUrlChanged() {
            boolean result = Browser.this.urlChanged;
            Browser.this.urlChanged = false;
            return result;
        }

        static /* synthetic */ Browser access$1(BrowserAdapter browserAdapter) {
            return browserAdapter.Browser.this;
        }
    }
}

