/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.impl.tpt.timer;

import java.security.AccessControlContext;
import org.eclipse.equinox.internal.util.impl.tpt.ServiceFactoryImpl;
import org.eclipse.equinox.internal.util.impl.tpt.timer.TimerImpl;
import org.eclipse.equinox.internal.util.pool.ObjectCreator;
import org.eclipse.equinox.internal.util.timer.TimerListener;

class TimerQueueNode
implements Runnable,
ObjectCreator {
    public static final String PERIODICAL_TASK_NAME = "[Timer] - Periodical Task";
    public static final String PERIODICAL_NO_DELAY_TASK_NAME = "[Timer] - Periodical No Delay Task";
    public static final String ONE_SHOT_TASK_NAME = "[Timer] - One Shot Task";
    public static final String ONE_SHOT_NO_DELAY_TASK_NAME = "[Timer] - One Shot No Delay Task";
    TimerListener listener = null;
    int event;
    long runOn = -1L;
    int type = -1;
    int priority = -1;
    long period = -1L;
    boolean running = false;
    private int theHash;
    String name;
    boolean named = false;
    String context;
    AccessControlContext acc;
    boolean enabled = false;

    public String getEName() {
        if (ServiceFactoryImpl.useNames && !this.named) {
            this.named = true;
            String tmp = null;
            switch (this.type) {
                case 0: {
                    tmp = ONE_SHOT_TASK_NAME;
                    break;
                }
                case 2: {
                    tmp = ONE_SHOT_NO_DELAY_TASK_NAME;
                    break;
                }
                case 1: {
                    tmp = PERIODICAL_TASK_NAME;
                    break;
                }
                case 3: {
                    tmp = PERIODICAL_NO_DELAY_TASK_NAME;
                }
            }
            this.name = this.name != null ? tmp.concat(this.name) : tmp;
        }
        return this.name == null ? "" : this.name;
    }

    public void setEvent(TimerListener listener, int priority, int timerType, long runOn, long periodMilis, int event, String name, AccessControlContext acc) {
        this.enabled = true;
        this.listener = listener;
        this.theHash = listener.hashCode() + event;
        this.priority = priority;
        this.type = timerType;
        this.period = periodMilis;
        this.runOn = runOn;
        this.event = event;
        this.name = name;
        this.named = false;
        this.acc = acc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnInPool() {
        TimerQueueNode timerQueueNode = this;
        synchronized (timerQueueNode) {
            if (!this.enabled || this.running && this.type == 0) {
                return;
            }
            this.clear();
        }
        if (TimerImpl.nodePool != null) {
            TimerImpl.nodePool.releaseObject(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TimerListener tmp;
        block7: {
            TimerQueueNode timerQueueNode = this;
            synchronized (timerQueueNode) {
                this.running = true;
            }
            tmp = this.listener;
            try {
                if (tmp != null && this.enabled) {
                    tmp.timer(this.event);
                }
            }
            catch (Throwable t) {
                if (ServiceFactoryImpl.log == null) break block7;
                ServiceFactoryImpl.log.error("[Timer] - Error while notifying:\r\n" + tmp, t);
            }
        }
        tmp = null;
        if (this.type == 0) {
            this.returnInPool();
        }
        this.running = false;
    }

    public Object getInstance() {
        return new TimerQueueNode();
    }

    private void clear() {
        this.named = false;
        this.name = null;
        this.enabled = false;
        this.listener = null;
        this.event = -1;
        this.runOn = Long.MAX_VALUE;
        this.type = -1;
        this.acc = null;
    }

    public int hashCode() {
        TimerListener lis = this.listener;
        return lis != null ? (this.theHash = lis.hashCode() + this.event) : this.theHash;
    }

    public String toString() {
        return "QueueNode: " + super.toString() + "\r\n" + "\t\tListener: " + this.listener + "\r\n" + "\t\tEvent: " + this.event + "\r\n" + "\t\tType: " + this.type + "\r\n" + "\t\trunafter: " + (this.runOn - System.currentTimeMillis()) + "\r\n" + "\t\tEnabled: " + this.enabled;
    }

    public boolean equals(Object a) {
        if (a instanceof TimerQueueNode) {
            TimerQueueNode b = (TimerQueueNode)a;
            return b.listener == this.listener && b.event == this.event;
        }
        return false;
    }
}

