/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.boot.internal.app;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.boot.internal.app.AppActivator;
import org.eclipse.gyrex.boot.internal.app.BootDebug;
import org.eclipse.gyrex.boot.internal.app.LogbackConfigurator;
import org.eclipse.gyrex.common.internal.applications.BaseApplication;
import org.eclipse.gyrex.server.internal.roles.LocalRolesManager;
import org.eclipse.gyrex.server.internal.roles.ServerRoleDefaultStartOption;
import org.eclipse.gyrex.server.internal.roles.ServerRolesRegistry;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerApplication
extends BaseApplication {
    private static final Logger LOG = LoggerFactory.getLogger(ServerApplication.class);
    private static final Thread shutdownHook = new Thread("Shutdown Hook"){

        @Override
        public void run() {
            try {
                LOG.info("Shutting down...");
                ServerApplication.shutdown(null);
            }
            catch (Exception exception) {}
        }
    };
    private static final AtomicReference<ServerApplication> singletonInstance = new AtomicReference();
    private volatile boolean running;
    private volatile boolean restart;
    private volatile Throwable shutdownReason;
    private ServiceRegistration frameworkLogServiceRegistration;
    private Location instanceLocation;

    public static boolean isRunning() {
        ServerApplication application = singletonInstance.get();
        return application != null && application.running;
    }

    private static void printError(String message, Throwable cause) {
        System.err.println();
        System.err.println();
        System.err.println(StringUtils.leftPad((String)"", (int)72, (char)'*'));
        System.err.println(StringUtils.center((String)" Server Startup Error ", (int)72));
        System.err.println(StringUtils.leftPad((String)"", (int)72, (char)'*'));
        System.err.println();
        System.err.println(WordUtils.wrap((String)message, (int)72));
        System.err.println();
        if (cause != null) {
            System.err.println("Reported error:");
            System.err.println(WordUtils.wrap((String)cause.getMessage(), (int)72));
            Throwable root = ExceptionUtils.getRootCause((Throwable)cause);
            if (root != null) {
                System.err.println();
                System.err.println("Caused by:");
                System.err.println(WordUtils.wrap((String)ExceptionUtils.getMessage((Throwable)root), (int)72));
            }
            System.err.println();
        }
        System.err.println(StringUtils.leftPad((String)"", (int)72, (char)'*'));
        System.err.println();
        System.err.println();
    }

    public static void restart() {
        ServerApplication application = singletonInstance.get();
        if (application == null) {
            throw new IllegalStateException("Platform not started.");
        }
        if (BootDebug.debug) {
            LOG.debug("Relaunch request received!");
        }
        application.restart = true;
        application.shutdownReason = null;
        application.stop();
    }

    public static void shutdown(Throwable cause) {
        ServerApplication application = singletonInstance.get();
        if (application == null) {
            throw new IllegalStateException("Platform not started.");
        }
        application.restart = false;
        application.shutdownReason = cause;
        application.stop();
    }

    public ServerApplication() {
        this.debug = BootDebug.debug;
    }

    private void bootstrap() throws Exception {
        Bundle dsImplBundle;
        if (BootDebug.debug) {
            LOG.debug("Bootstrapping platform.");
        }
        if ((dsImplBundle = AppActivator.getInstance().getBundle("org.eclipse.equinox.ds")) == null) {
            ServerApplication.printError("Bundle 'org.eclipse.equinox.ds' not available but may be required by parts of the system. Your system will not function properly.", null);
            throw new BaseApplication.StartAbortedException();
        }
        dsImplBundle.start(1);
    }

    private void checkInstanceLocation(Location instanceLocation) {
        if (instanceLocation == null || instanceLocation.getURL() == null || !instanceLocation.getURL().toExternalForm().startsWith("file:") || instanceLocation.isReadOnly()) {
            ServerApplication.printError("Gyrex needs a valid local instance location (aka. 'workspace'). Please start with the -data option pointing to a valid, writable file system path.", null);
            throw new BaseApplication.StartAbortedException();
        }
        try {
            if (instanceLocation.lock()) {
                return;
            }
            File workspaceDirectory = new File(instanceLocation.getURL().getFile());
            if (workspaceDirectory.exists()) {
                ServerApplication.printError("Could not launch the server because the associated workspace '" + workspaceDirectory.getAbsolutePath() + "' is currently in use by another Eclipse application.", null);
            } else {
                ServerApplication.printError("Could not launch the server because the specified workspace cannot be created. The specified workspace directory '" + workspaceDirectory.getAbsolutePath() + "' is either invalid or read-only.", null);
            }
        }
        catch (IOException e) {
            ServerApplication.printError("Unable to verify the specified workspace directory " + instanceLocation.getURL().toExternalForm() + ".", e);
        }
        throw new BaseApplication.StartAbortedException();
    }

    protected void doCleanup() {
        this.running = false;
        if (this.instanceLocation != null) {
            this.instanceLocation.release();
            this.instanceLocation = null;
        }
        this.shutdownReason = null;
        try {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
        catch (Exception exception) {}
    }

    protected void doStart(Map arguments) throws Exception {
        String[] args = ServerApplication.getApplicationArguments((Map)arguments);
        if (!singletonInstance.compareAndSet(null, this)) {
            throw new IllegalStateException("server application already running");
        }
        try {
            this.instanceLocation = AppActivator.getInstance().getInstanceLocation();
        }
        catch (Exception e) {
            ServerApplication.printError("An error occurred reading the instance location (aka. 'workspace'). Please verify that the installation is correct and all required components are available.", e);
            throw new BaseApplication.StartAbortedException();
        }
        this.checkInstanceLocation(this.instanceLocation);
        this.loggingOn(args);
        try {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            this.bootstrap();
            this.running = true;
            List<String> roles = this.getEnabledServerRoles(args);
            LocalRolesManager.activateRoles(roles, true);
        }
        catch (Exception e) {
            if (BootDebug.debug) {
                LOG.debug("Platform start failed!", (Throwable)e);
            }
            this.loggingOff();
            ServerApplication.printError("Unable to start server. Please verify the installation is correct and all required components are available.", e);
            throw new BaseApplication.StartAbortedException();
        }
    }

    protected Object doStop() {
        this.running = false;
        try {
            LocalRolesManager.deactivateAllRoles();
        }
        catch (Exception exception) {}
        this.loggingOff();
        Throwable reason = this.shutdownReason;
        if (reason != null) {
            ServerApplication.printError("Server shutdown forced due to error in underlying system. Please verify the installation is correct and all required components are available. ", reason);
            return EXIT_ERROR;
        }
        return this.restart ? EXIT_RESTART : EXIT_OK;
    }

    private List<String> getEnabledServerRoles(String[] arguments) {
        boolean ignoreDefaultRoles = false;
        ArrayList<String> roleIds = new ArrayList<String>();
        int i = 0;
        while (i < arguments.length) {
            String arg = arguments[i];
            if ("-roles".equalsIgnoreCase(arg)) {
                ignoreDefaultRoles = true;
                if (++i >= arguments.length) {
                    throw new IllegalArgumentException("The argument '-roles' requires a following argument with the server roles to start.");
                }
                String[] specifiedRoles = StringUtils.split((String)arguments[i], (char)',');
                if (specifiedRoles == null || specifiedRoles.length == 0) {
                    throw new IllegalArgumentException("The specified server roles could not be identified. Please specify at least one role. You may specify multiple rows using a comma separated list.");
                }
                String[] stringArray = specifiedRoles;
                int n = specifiedRoles.length;
                int n2 = 0;
                while (n2 < n) {
                    String role = stringArray[n2];
                    if (StringUtils.isNotBlank((String)role) && !roleIds.contains(role)) {
                        if (BootDebug.roles) {
                            LOG.debug("Role submitted via command line: " + role);
                        }
                        roleIds.add(role);
                    }
                    ++n2;
                }
            }
            ++i;
        }
        if (!ignoreDefaultRoles) {
            Collection<String> defaultRoles = ServerRolesRegistry.getDefault().getRolesToStartByDefault(ServerRoleDefaultStartOption.Trigger.ON_BOOT);
            for (String role : defaultRoles) {
                if (roleIds.contains(role)) continue;
                if (BootDebug.roles) {
                    LOG.debug("Default start boot role: " + role);
                }
                roleIds.add(role);
            }
        }
        return roleIds;
    }

    protected Logger getLogger() {
        return LOG;
    }

    private void loggingOff() {
        if (this.frameworkLogServiceRegistration != null) {
            this.frameworkLogServiceRegistration.unregister();
            this.frameworkLogServiceRegistration = null;
        }
        try {
            LogbackConfigurator.reset();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception e) {
            LOG.warn("Error while de-configuring logback. Please re-configure logging manually. ({})", (Object)e.getMessage());
        }
    }

    private void loggingOn(String[] arguments) {
        try {
            LogbackConfigurator.configureDefaultContext(arguments);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Logback not available. Please configure logging manually. ({})", (Object)e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            LOG.debug("Logback not available. Please configure logging manually. ({})", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOG.warn("Error while configuring logback. Please configure logging manually. ({})", (Throwable)e);
        }
        this.frameworkLogServiceRegistration = AppActivator.getInstance().getServiceHelper().registerService(Logger.class.getName(), (Object)LoggerFactory.getLogger((String)"org.eclipse.equinox.logger"), "Eclipse Gyrex", "SLF4J Equinox Framework Logger", "org.slf4j.Logger-org.eclipse.equinox.logger", null);
    }
}

