/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.preferences;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScope;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.preferences.NodePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodePreferencesScopeFactory
implements IScope {
    private static final Logger LOG = LoggerFactory.getLogger(NodePreferencesScopeFactory.class);
    private static final AtomicReference<NodePreferences> rootNode = new AtomicReference();

    public static void stop() {
        NodePreferences node = rootNode.get();
        if (node != null) {
            try {
                node.flush();
            }
            catch (Exception e) {
                LOG.warn("Failed to flush node preferences. Changes migt be lost. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    public IEclipsePreferences create(IEclipsePreferences parent, String name) {
        if (!"node".equals(name)) {
            LOG.error("Node preference factory called with illegal node name {} for parent {}.", new Object[]{name, parent.absolutePath(), new Exception("Call Stack")});
            throw new IllegalArgumentException("invalid node name");
        }
        NodePreferences node = rootNode.get();
        if (node != null) {
            if (CloudDebug.debug) {
                LOG.debug("Node preference factory called multiple times for name {} and parent {}.", new Object[]{name, parent.absolutePath(), new Exception("Call Stack")});
            }
            return node;
        }
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("Creating ZooKeeper preferences '{}' (parent {})", (Object)name, (Object)parent);
        }
        rootNode.compareAndSet(null, new NodePreferences(parent, name));
        return rootNode.get();
    }
}

