/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.jetty.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IUploadAdapter;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.UploadDialogField;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.http.jetty.admin.IJettyManager;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.rwt.widgets.UploadItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportCertificateDialog
extends StatusDialog {
    private final StringDialogField idField = new StringDialogField();
    private final StringDialogField keyStorePasswordField = new StringDialogField();
    private final StringDialogField keyPasswordField = new StringDialogField();
    private final SelectionButtonDialogFieldGroup keystoreTypeField = new SelectionButtonDialogFieldGroup(16, new String[]{"JKS", "PKCS12"}, 2);
    private final UploadDialogField keystoreUploadField = new UploadDialogField(new IUploadAdapter(){

        public void uploadFinished(UploadItem uploadItem) {
            block5: {
                InputStream in = null;
                try {
                    try {
                        in = uploadItem.getFileInputStream();
                        ImportCertificateDialog.this.importKeystore(in);
                        ImportCertificateDialog.this.importError = null;
                    }
                    catch (Exception e) {
                        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                        ImportCertificateDialog.this.importError = rootCause != null ? rootCause : e;
                        ImportCertificateDialog.this.keystoreBytes = null;
                        ImportCertificateDialog.this.generatedKeyPassword = null;
                        ImportCertificateDialog.this.generatedKeystorePassword = null;
                        IOUtils.closeQuietly((InputStream)in);
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
            }
            ImportCertificateDialog.this.validate();
        }
    });
    private Throwable importError;
    private byte[] keystoreBytes;
    private char[] generatedKeystorePassword;
    private char[] generatedKeyPassword;
    private final IJettyManager jettyManager;

    public ImportCertificateDialog(Shell parent, IJettyManager jettyManager) {
        super(parent);
        this.jettyManager = jettyManager;
        this.setTitle("New Certificate");
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(200);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        this.idField.setLabelText("Id");
        this.keystoreTypeField.setLabelText("Keystore Type");
        this.keyStorePasswordField.setLabelText("Keystore Password");
        this.keyPasswordField.setLabelText("Key Password");
        this.keystoreUploadField.setLabelText("Keystore");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ImportCertificateDialog.this.validate();
            }
        };
        this.idField.setDialogFieldListener(validateListener);
        this.keystoreTypeField.setDialogFieldListener(validateListener);
        this.keyStorePasswordField.setDialogFieldListener(validateListener);
        this.keyPasswordField.setDialogFieldListener(validateListener);
        this.keystoreUploadField.setDialogFieldListener(validateListener);
        Text warning = new Text(composite, 72);
        warning.setText("Warning: this dialog is ugly. Please help us improve the UI. Any mockups and/or patches are very much appreciated!");
        warning.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.idField, new Separator(), this.keystoreUploadField, this.keystoreTypeField, this.keyStorePasswordField, this.keyPasswordField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.idField.getTextControl(null));
        GridLayout masterLayout = (GridLayout)composite.getLayout();
        masterLayout.marginWidth = 5;
        masterLayout.marginHeight = 5;
        LayoutUtil.setHorizontalSpan((Control)warning, (int)masterLayout.numColumns);
        return composite;
    }

    void importKeystore(InputStream in) throws Exception {
        KeyStore tempKs;
        if (this.keystoreTypeField.isSelected(0)) {
            tempKs = KeyStore.getInstance("JKS");
        } else if (this.keystoreTypeField.isSelected(1)) {
            tempKs = KeyStore.getInstance("PKCS12");
        } else {
            throw new IllegalArgumentException("Please select a keystore type before uploading a keystore and retry.");
        }
        String keystorePassword = this.keyStorePasswordField.getText();
        String keyPassword = this.keyPasswordField.getText();
        tempKs.load(new BufferedInputStream(in), keystorePassword != null ? keystorePassword.toCharArray() : null);
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null);
        this.generatedKeystorePassword = UUID.randomUUID().toString().toCharArray();
        this.generatedKeyPassword = UUID.randomUUID().toString().toCharArray();
        Enumeration<String> aliases = tempKs.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!tempKs.isKeyEntry(alias)) continue;
            Key key = tempKs.getKey(alias, keyPassword != null ? keyPassword.toCharArray() : (char[])(keystorePassword != null ? keystorePassword.toCharArray() : null));
            Certificate[] chain = tempKs.getCertificateChain(alias);
            if (chain == null) {
                Certificate certificate = tempKs.getCertificate(alias);
                if (certificate == null) continue;
                chain = new Certificate[]{certificate};
            }
            ks.setKeyEntry("jetty", key, this.generatedKeyPassword, chain);
            break;
        }
        if (!ks.aliases().hasMoreElements()) {
            throw new IllegalArgumentException("The uploaded keystore does not have a valid key + certificate chain entry. Please use a different keystore and retry.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ks.store(out, this.generatedKeystorePassword);
        this.keystoreBytes = out.toByteArray();
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        try {
            this.jettyManager.addCertificate(this.idField.getText(), this.keystoreBytes, this.generatedKeystorePassword, this.generatedKeyPassword);
        }
        catch (Exception e) {
            this.setError(e.getMessage());
            return;
        }
        super.okPressed();
    }

    private void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.http.jetty", message));
        this.getShell().pack(true);
    }

    private void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.http.jetty", message));
    }

    void validate() {
        String id = this.idField.getText();
        if (StringUtils.isNotBlank((String)id) && !IdHelper.isValidId((String)id)) {
            this.setError("The entered id is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.");
            return;
        }
        if (this.importError != null) {
            this.setError("The uploaded keystore could not be imported.\n" + this.importError.getMessage());
            return;
        }
        if (StringUtils.isBlank((String)id)) {
            this.setInfo("Please enter a certificate id.");
            return;
        }
        if (StringUtils.isBlank((String)this.keystoreUploadField.getUploadPath())) {
            this.setInfo("Please select a keystore.");
            return;
        }
        if (!this.keystoreTypeField.isSelected(0) && !this.keystoreTypeField.isSelected(1)) {
            this.setInfo("Please select a keystore type.");
            return;
        }
        if (this.keystoreBytes == null) {
            this.setInfo("Please upload the selected keystore.");
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

