/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.Reader;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.iapi.services.sanity.SanityManager;

public class ClobLocatorReader
extends Reader {
    private final Connection connection;
    private final Clob clob;
    private long currentPos;
    private final long maxPos;
    private boolean isClosed = false;

    public ClobLocatorReader(Connection connection, Clob clob) throws SqlException {
        SanityManager.ASSERT(clob.isLocator());
        this.connection = connection;
        this.clob = clob;
        this.currentPos = 1L;
        this.maxPos = -1L;
    }

    public ClobLocatorReader(Connection connection, Clob clob, long pos, long len) throws SqlException {
        SanityManager.ASSERT(clob.isLocator());
        this.connection = connection;
        this.clob = clob;
        this.currentPos = pos;
        this.maxPos = len != -1L ? Math.min(clob.sqlLength(), pos + len - 1L) : -1L;
    }

    public int read() throws IOException {
        this.checkClosed();
        char[] chars = this.readCharacters(1);
        if (chars.length == 0) {
            return -1;
        }
        return chars[0];
    }

    public int read(char[] c, int off, int len) throws IOException {
        this.checkClosed();
        if (len == 0) {
            return 0;
        }
        if (off < 0 || len < 0 || len > c.length - off) {
            throw new IndexOutOfBoundsException();
        }
        char[] chars = this.readCharacters(len);
        if (chars.length == 0) {
            return -1;
        }
        System.arraycopy(chars, 0, c, off, chars.length);
        return chars.length;
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("This operation is not permitted because theReader has been closed");
        }
    }

    private char[] readCharacters(int len) throws IOException {
        try {
            int actualLength = -1;
            actualLength = this.maxPos != -1L ? (int)Math.min((long)len, this.maxPos - this.currentPos + 1L) : (int)Math.min((long)len, this.clob.sqlLength() - this.currentPos + 1L);
            String resultStr = this.connection.locatorProcedureCall().clobGetSubString(this.clob.getLocator(), this.currentPos, actualLength);
            char[] result = resultStr.toCharArray();
            this.currentPos += (long)result.length;
            return result;
        }
        catch (SqlException ex) {
            IOException ioEx = new IOException();
            ioEx.initCause(ex);
            throw ioEx;
        }
    }
}

