/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.DerbyIOException;
import org.apache.derby.iapi.services.io.LimitInputStream;

public final class RawToBinaryFormatStream
extends LimitInputStream {
    private int encodedOffset;
    private byte[] encodedLength;
    private boolean eof = false;
    private final int length;
    private final int maximumLength;
    private final String typeName;

    public RawToBinaryFormatStream(InputStream in, int length) {
        super(in);
        if (length < 0) {
            throw new IllegalArgumentException("Stream length cannot be negative: " + length);
        }
        this.length = length;
        this.maximumLength = -1;
        this.typeName = null;
        this.setLimit(length);
        if (length <= 31) {
            this.encodedLength = new byte[1];
            this.encodedLength[0] = (byte)(0x80 | length & 0xFF);
        } else if (length <= 65535) {
            this.encodedLength = new byte[3];
            this.encodedLength[0] = -96;
            this.encodedLength[1] = (byte)(length >> 8);
            this.encodedLength[2] = (byte)length;
        } else {
            this.encodedLength = new byte[5];
            this.encodedLength[0] = -64;
            this.encodedLength[1] = (byte)(length >> 24);
            this.encodedLength[2] = (byte)(length >> 16);
            this.encodedLength[3] = (byte)(length >> 8);
            this.encodedLength[4] = (byte)length;
        }
    }

    public RawToBinaryFormatStream(InputStream in, int maximumLength, String typeName) {
        super(in);
        if (maximumLength < 0) {
            throw new IllegalArgumentException("Maximum length for a capped stream cannot be negative: " + maximumLength);
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Type name cannot be null");
        }
        this.length = -1;
        this.maximumLength = maximumLength;
        this.typeName = typeName;
        this.encodedLength = new byte[4];
        this.setLimit(maximumLength);
    }

    public int read() throws IOException {
        if (this.eof) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S"));
        }
        if (this.encodedOffset < this.encodedLength.length) {
            return this.encodedLength[this.encodedOffset++] & 0xFF;
        }
        int ret = super.read();
        if (ret == -1) {
            this.checkSufficientData();
        }
        return ret;
    }

    private void checkSufficientData() throws IOException {
        this.eof = true;
        if (!this.limitInPlace) {
            return;
        }
        int remainingBytes = this.clearLimit();
        if (this.length > -1 && remainingBytes > 0) {
            throw new DerbyIOException(MessageService.getTextMessage("XJ023.S"), "XJ023.S");
        }
        if (remainingBytes == 0) {
            int c;
            try {
                c = super.read();
            }
            catch (IOException ioe) {
                c = -1;
            }
            if (c != -1) {
                if (this.length > -1) {
                    throw new DerbyIOException(MessageService.getTextMessage("XJ023.S"), "XJ023.S");
                }
                throw new DerbyIOException(MessageService.getTextMessage("22001", this.typeName, "XXXX", String.valueOf(this.maximumLength)), "22001");
            }
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int realRead;
        if (this.eof) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S"));
        }
        int elen = this.encodedLength.length - this.encodedOffset;
        if (elen != 0) {
            if (len < elen) {
                elen = len;
            }
            System.arraycopy(this.encodedLength, this.encodedOffset, b, off, elen);
            this.encodedOffset += elen;
            off += elen;
            if ((len -= elen) == 0) {
                return elen;
            }
        }
        if ((realRead = super.read(b, off, len)) < 0) {
            if (elen != 0) {
                return elen;
            }
            this.checkSufficientData();
            return realRead;
        }
        return elen + realRead;
    }
}

