/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.derby.impl.io.vfmem.DataStore;
import org.apache.derby.impl.io.vfmem.PathUtil;
import org.apache.derby.impl.io.vfmem.VirtualFile;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

public class VFMemoryStorageFactory
implements StorageFactory,
WritableStorageFactory {
    private static final Map DATABASES = new HashMap();
    private String canonicalName;
    private StorageFile dataDirectory;
    private StorageFile tempDir;
    private DataStore dbData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean purgeDatabase(String dbName) {
        Map map = DATABASES;
        synchronized (map) {
            DataStore store = (DataStore)DATABASES.remove(dbName);
            if (store != null) {
                store.purge();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String home, String databaseName, String tempDirNameIgnored, String uniqueName) throws IOException {
        if (databaseName != null) {
            this.canonicalName = home != null && !new File(databaseName).isAbsolute() ? new File(home, databaseName).getCanonicalPath() : new File(databaseName).getCanonicalPath();
            Map map = DATABASES;
            synchronized (map) {
                if (DATABASES.containsKey(this.canonicalName)) {
                    this.dbData = (DataStore)DATABASES.get(this.canonicalName);
                } else {
                    this.dbData = new DataStore(this.canonicalName);
                    DATABASES.put(this.canonicalName, this.dbData);
                }
            }
            this.dataDirectory = new VirtualFile(this.canonicalName, this.dbData);
            this.tempDir = new VirtualFile(this.normalizePath(this.canonicalName, "tmp"), this.dbData);
        } else if (home != null) {
            String absHome = new File(home).getCanonicalPath();
            Map map = DATABASES;
            synchronized (map) {
                this.dbData = (DataStore)DATABASES.get(absHome);
                if (this.dbData == null) {
                    this.dbData = new DataStore(absHome);
                    DATABASES.put(absHome, this.dbData);
                }
            }
            this.dataDirectory = new VirtualFile(absHome, this.dbData);
            this.tempDir = new VirtualFile(this.getSeparator() + "tmp", this.dbData);
        }
        if (uniqueName != null && this.tempDir != null && !this.tempDir.exists()) {
            this.tempDir.mkdirs();
        }
    }

    public void shutdown() {
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public StorageFile newStorageFile(String path) {
        if (path == null) {
            return this.dataDirectory;
        }
        return new VirtualFile(this.normalizePath(path), this.dbData);
    }

    public StorageFile newStorageFile(String directoryName, String fileName) {
        return new VirtualFile(this.normalizePath(directoryName, fileName), this.dbData);
    }

    public StorageFile newStorageFile(StorageFile directoryName, String fileName) {
        return this.newStorageFile(directoryName == null ? null : directoryName.getPath(), fileName);
    }

    public StorageFile getTempDir() {
        return this.tempDir;
    }

    public boolean isFast() {
        return true;
    }

    public boolean isReadOnlyDatabase() {
        return false;
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    public int getStorageFactoryVersion() {
        return 1;
    }

    public StorageFile createTemporaryFile(String prefix, String suffix) {
        if (suffix == null) {
            suffix = ".tmp";
        }
        String name = prefix == null ? this.dbData.getTempFileCounter() + suffix : prefix + this.dbData.getTempFileCounter() + suffix;
        return this.newStorageFile(this.tempDir, name);
    }

    public char getSeparator() {
        return PathUtil.SEP;
    }

    public void sync(OutputStream stream, boolean metaData) {
    }

    public boolean supportsWriteSync() {
        return true;
    }

    private String normalizePath(String dir, String file) {
        if (dir == null || dir.equals("")) {
            dir = this.dataDirectory.getPath();
        } else if (!new File(dir).isAbsolute()) {
            dir = new File(this.dataDirectory.getPath(), dir).getPath();
        }
        return new File(dir, file).getPath();
    }

    private String normalizePath(String path) {
        if (path == null || path.equals("")) {
            return this.dataDirectory.getPath();
        }
        if (new File(path).isAbsolute()) {
            return path;
        }
        return new File(this.dataDirectory.getPath(), path).getPath();
    }
}

