/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.util.Locale;
import java.util.Properties;
import org.apache.derby.impl.load.LoadError;

class ControlInfo {
    static final String ESCAPE = "Escape";
    static final String DEFAULT_ESCAPE = "\\";
    static final String QUOTE = "Quote";
    static final String DEFAULT_QUOTE = "'";
    static final String COMMIT_COUNT = "CommitCount";
    static final String DEFAULT_COMMIT_COUNT = "0";
    static final String START_ROW = "StartRow";
    static final String DEFAULT_START_ROW = "1";
    static final String STOP_ROW = "StopRow";
    static final String DEFAULT_STOP_ROW = "0";
    static final String FIELD_SEPARATOR = "FieldSeparator";
    static final String DEFAULT_FIELD_SEPARATOR = ",";
    static final String RECORD_SEPARATOR = "RecordSeparator";
    static final String DEFAULT_RECORD_SEPARATOR = System.getProperty("line.separator");
    static final String COLUMN_DEFINITION = "ColumnDefinition";
    static final String DEFAULT_COLUMN_DEFINITION = "FALSE";
    static final String NULL_STRING = "Null";
    static final String DEFAULT_NULL_STRING = "NULL";
    static final String FORMAT = "Format";
    static final String DEFAULT_FORMAT = "ASCII_DELIMITED";
    static final String DB2_DELIMITED_FORMAT = "DB2_DELIMITED";
    static final String FIELD_START_DELIMITER = "FieldStartDelimiter";
    static final String DEFAULT_FIELD_START_DELIMITER = "\"";
    static final String FIELD_END_DELIMITER = "FieldEndDelimiter";
    static final String DEFAULT_FIELD_END_DELIMITER = "\"";
    static final String COLUMN_WIDTHS = "ColumnWidths";
    static final String MESSAGE_FILE = "MessageFile";
    static final String DEFAULT_VERSION = "1";
    static final String VERSION = "Version";
    static final String NEWLINE = "\n";
    static final String COMMA = ",";
    static final String SPACE = " ";
    static final String TAB = "\t";
    static final String CR = "\r";
    static final String LF = "\n";
    static final String CRLF = "\r\n";
    static final String LFCR = "\n\r";
    static final String FF = "\f";
    static final String EMPTY_LINE = "\n\n";
    static final String SEMICOLON = ";";
    static final String DATA_CODESET = "DataCodeset";
    static final String HAS_DELIMETER_AT_END = "HasDelimeterAtEnd";
    static final String INTERNAL_NONE = "None";
    static final String INTERNAL_TRUE = "True";
    static final String INTERNAL_FALSE = "False";
    static final String INTERNAL_TAB = "Tab";
    static final String INTERNAL_SPACE = "Space";
    static final String INTERNAL_CR = "CR";
    static final String INTERNAL_LF = "LF";
    static final String INTERNAL_CRLF = "CR-LF";
    static final String INTERNAL_LFCR = "LF-CR";
    static final String INTERNAL_COMMA = "Comma";
    static final String INTERNAL_SEMICOLON = "Semicolon";
    static final String INTERNAL_NEWLINE = "New Line";
    static final String INTERNAL_FF = "FF";
    static final String INTERNAL_EMPTY_LINE = "Empty line";
    private Properties currentProperties;

    public ControlInfo() throws Exception {
        this.getCurrentProperties();
        if (this.getFieldSeparator().indexOf(this.getRecordSeparator()) != -1) {
            throw LoadError.fieldAndRecordSeparatorsSubset();
        }
    }

    String getPropertyValue(String aKey) throws Exception {
        return this.getCurrentProperties().getProperty(aKey);
    }

    private void loadDefaultValues() {
        this.currentProperties = new Properties();
        this.currentProperties.put(FIELD_SEPARATOR, ",");
        this.currentProperties.put(RECORD_SEPARATOR, DEFAULT_RECORD_SEPARATOR);
        this.currentProperties.put(COLUMN_DEFINITION, DEFAULT_COLUMN_DEFINITION);
        this.currentProperties.put(NULL_STRING, DEFAULT_NULL_STRING);
        this.currentProperties.put(FORMAT, DEFAULT_FORMAT);
        this.currentProperties.put(FIELD_START_DELIMITER, "\"");
        this.currentProperties.put(FIELD_END_DELIMITER, "\"");
        this.currentProperties.put(VERSION, "1");
        this.currentProperties.put(HAS_DELIMETER_AT_END, INTERNAL_FALSE);
    }

    String getCurrentVersion() throws Exception {
        return "1";
    }

    String getFormat() throws Exception {
        return this.getCurrentProperties().getProperty(FORMAT);
    }

    int[] getColumnWidths() {
        return null;
    }

    String getFieldSeparator() throws Exception {
        String fieldSeparator = this.getCurrentProperties().getProperty(FIELD_SEPARATOR);
        fieldSeparator = this.mapFromUserFriendlyFieldDelimiters(fieldSeparator);
        return fieldSeparator;
    }

    String getFieldStartDelimiter() throws Exception {
        return this.getCurrentProperties().getProperty(FIELD_START_DELIMITER);
    }

    String getFieldEndDelimiter() throws Exception {
        return this.getCurrentProperties().getProperty(FIELD_END_DELIMITER);
    }

    String getRecordSeparator() throws Exception {
        String recordSeparator = this.getCurrentProperties().getProperty(RECORD_SEPARATOR);
        recordSeparator = this.mapFromUserFriendlyRecordDelimiters(recordSeparator);
        return recordSeparator;
    }

    boolean getHasDelimiterAtEnd() throws Exception {
        String hasDelimeterAtEnd = this.getCurrentProperties().getProperty(HAS_DELIMETER_AT_END);
        return hasDelimeterAtEnd.equals(INTERNAL_TRUE);
    }

    String getHasDelimeterAtEndString() throws Exception {
        String hasDelimeterAtEnd = this.getCurrentProperties().getProperty(HAS_DELIMETER_AT_END);
        return hasDelimeterAtEnd;
    }

    String getNullString() throws Exception {
        return this.getCurrentProperties().getProperty(NULL_STRING);
    }

    String getColumnDefinition() throws Exception {
        return this.getCurrentProperties().getProperty(COLUMN_DEFINITION);
    }

    private String mapFromUserFriendlyFieldDelimiters(String aDelimiter) {
        if (aDelimiter.toUpperCase(Locale.ENGLISH).equals(INTERNAL_TAB.toUpperCase(Locale.ENGLISH))) {
            return TAB;
        }
        if (aDelimiter.toUpperCase(Locale.ENGLISH).equals(INTERNAL_SPACE.toUpperCase(Locale.ENGLISH))) {
            return SPACE;
        }
        if (aDelimiter.toUpperCase(Locale.ENGLISH).equals(INTERNAL_CR.toUpperCase(Locale.ENGLISH))) {
            return CR;
        }
        if (aDelimiter.toUpperCase(Locale.ENGLISH).equals(INTERNAL_LF.toUpperCase(Locale.ENGLISH))) {
            return "\n";
        }
        if (aDelimiter.toUpperCase(Locale.ENGLISH).equals(INTERNAL_CRLF.toUpperCase(Locale.ENGLISH))) {
            return CRLF;
        }
        if (aDelimiter.toUpperCase(Locale.ENGLISH).equals(INTERNAL_LFCR.toUpperCase(Locale.ENGLISH))) {
            return LFCR;
        }
        if (aDelimiter.toUpperCase(Locale.ENGLISH).equals(INTERNAL_COMMA.toUpperCase(Locale.ENGLISH))) {
            return ",";
        }
        if (aDelimiter.toUpperCase(Locale.ENGLISH).equals(INTERNAL_SEMICOLON.toUpperCase(Locale.ENGLISH))) {
            return SEMICOLON;
        }
        aDelimiter = this.commonToFieldAndRecordDelimiters(aDelimiter, "\\n", '\n');
        aDelimiter = this.commonToFieldAndRecordDelimiters(aDelimiter, "\\t", '\t');
        aDelimiter = this.commonToFieldAndRecordDelimiters(aDelimiter, "\\r", '\r');
        aDelimiter = this.commonToFieldAndRecordDelimiters(aDelimiter, "\\f", '\f');
        return aDelimiter;
    }

    private String commonToFieldAndRecordDelimiters(String aDelimiter, String specialChars, char replacementChar) {
        while (aDelimiter.indexOf(specialChars) != -1) {
            int specialCharsPosition = aDelimiter.indexOf(specialChars);
            String beforeSpecialChars = aDelimiter.substring(0, specialCharsPosition);
            String afterSpecialChars = aDelimiter.substring(specialCharsPosition + 2);
            aDelimiter = beforeSpecialChars + replacementChar + afterSpecialChars;
        }
        return aDelimiter;
    }

    private String mapFromUserFriendlyRecordDelimiters(String aDelimiter) {
        if (aDelimiter.equals("\n")) {
            aDelimiter = INTERNAL_NEWLINE;
        }
        if (aDelimiter.toUpperCase(Locale.ENGLISH).equals(INTERNAL_NEWLINE.toUpperCase(Locale.ENGLISH))) {
            return "\n";
        }
        if (aDelimiter.toUpperCase(Locale.ENGLISH).equals(INTERNAL_CR.toUpperCase(Locale.ENGLISH))) {
            return CR;
        }
        if (aDelimiter.toUpperCase(Locale.ENGLISH).equals(INTERNAL_LF.toUpperCase(Locale.ENGLISH))) {
            return "\n";
        }
        if (aDelimiter.toUpperCase(Locale.ENGLISH).equals(INTERNAL_CRLF.toUpperCase(Locale.ENGLISH))) {
            return CRLF;
        }
        if (aDelimiter.toUpperCase(Locale.ENGLISH).equals(INTERNAL_LFCR.toUpperCase(Locale.ENGLISH))) {
            return LFCR;
        }
        if (aDelimiter.toUpperCase(Locale.ENGLISH).equals(INTERNAL_FF.toUpperCase(Locale.ENGLISH))) {
            return FF;
        }
        if (aDelimiter.toUpperCase(Locale.ENGLISH).equals(INTERNAL_EMPTY_LINE.toUpperCase(Locale.ENGLISH))) {
            return EMPTY_LINE;
        }
        aDelimiter = this.commonToFieldAndRecordDelimiters(aDelimiter, "\\n", '\n');
        aDelimiter = this.commonToFieldAndRecordDelimiters(aDelimiter, "\\t", '\t');
        aDelimiter = this.commonToFieldAndRecordDelimiters(aDelimiter, "\\r", '\r');
        aDelimiter = this.commonToFieldAndRecordDelimiters(aDelimiter, "\\f", '\f');
        return aDelimiter;
    }

    String getDataCodeset() throws Exception {
        return this.getCurrentProperties().getProperty(DATA_CODESET);
    }

    Properties getCurrentProperties() throws Exception {
        if (this.currentProperties == null) {
            this.loadDefaultValues();
        }
        return this.currentProperties;
    }

    public void setColumnWidths(String columnWidths) throws Exception {
        if (columnWidths != null) {
            this.currentProperties.setProperty(COLUMN_WIDTHS, columnWidths);
        }
    }

    public void setFieldSeparator(String fieldSeperator) throws Exception {
        if (fieldSeperator != null) {
            this.currentProperties.setProperty(FIELD_SEPARATOR, fieldSeperator);
        }
    }

    public void setFieldStartDelimiter(String fsdl) throws Exception {
        if (fsdl != null) {
            this.currentProperties.setProperty(FIELD_START_DELIMITER, fsdl);
        }
    }

    public void setFieldEndDelimiter(String fedl) throws Exception {
        if (fedl != null) {
            this.currentProperties.setProperty(FIELD_END_DELIMITER, fedl);
        }
    }

    public void setRecordSeparator(String recordSeperator) throws Exception {
        if (recordSeperator != null) {
            this.currentProperties.setProperty(RECORD_SEPARATOR, recordSeperator);
        }
    }

    public void setHasDelimiterAtEnd(String hasDelimeterAtEnd) throws Exception {
        if (hasDelimeterAtEnd != null) {
            this.currentProperties.setProperty(HAS_DELIMETER_AT_END, hasDelimeterAtEnd);
        }
    }

    public void setNullString(String nullString) throws Exception {
        if (nullString != null) {
            this.currentProperties.setProperty(NULL_STRING, nullString);
        }
    }

    public void setcolumnDefinition(String columnDefinition) throws Exception {
        if (columnDefinition != null) {
            this.currentProperties.setProperty(COLUMN_DEFINITION, columnDefinition);
        }
    }

    public void setDataCodeset(String codeset) throws Exception {
        if (codeset != null) {
            this.currentProperties.setProperty(DATA_CODESET, codeset);
        }
    }

    public void setCharacterDelimiter(String charDelimiter) throws Exception {
        if (charDelimiter != null) {
            this.setFieldStartDelimiter(charDelimiter);
            this.setFieldEndDelimiter(charDelimiter);
        }
    }

    public void setControlProperties(String characterDelimiter, String columnDelimiter, String codeset) throws Exception {
        this.setCharacterDelimiter(characterDelimiter);
        this.setFieldSeparator(columnDelimiter);
        this.setDataCodeset(codeset);
        this.validateDelimiters();
    }

    private void validateDelimiters() throws Exception {
        char colDel = this.getFieldSeparator().charAt(0);
        char charDel = this.getFieldStartDelimiter().charAt(0);
        if (charDel == '.') {
            throw LoadError.periodAsCharDelimiterNotAllowed();
        }
        if (colDel == charDel || colDel == '.' || Character.isSpaceChar(colDel) || Character.isSpaceChar(charDel) || Character.digit(colDel, 16) != -1 || Character.digit(charDel, 16) != -1) {
            throw LoadError.delimitersAreNotMutuallyExclusive();
        }
    }
}

