/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.ShExLockable;
import org.apache.derby.iapi.services.locks.ShExQual;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.sanity.AssertFailure;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubCheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.ScanQualifier;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.services.locks.Timeout;
import org.apache.derby.impl.sql.catalog.DD_Version;
import org.apache.derby.impl.sql.catalog.DropDependencyFilter;
import org.apache.derby.impl.sql.catalog.NameTDCacheable;
import org.apache.derby.impl.sql.catalog.OIDTDCacheable;
import org.apache.derby.impl.sql.catalog.PermissionsCacheable;
import org.apache.derby.impl.sql.catalog.PermissionsCatalogRowFactory;
import org.apache.derby.impl.sql.catalog.RoleClosureIteratorImpl;
import org.apache.derby.impl.sql.catalog.SPSNameCacheable;
import org.apache.derby.impl.sql.catalog.SYSALIASESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCHECKSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCOLPERMSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCOLUMNSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCONGLOMERATESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCONSTRAINTSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSDEPENDSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSDUMMY1RowFactory;
import org.apache.derby.impl.sql.catalog.SYSFILESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSFOREIGNKEYSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSKEYSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSROLESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSROUTINEPERMSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSSCHEMASRowFactory;
import org.apache.derby.impl.sql.catalog.SYSSTATEMENTSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSSTATISTICSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSTABLEPERMSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSTABLESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSTRIGGERSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSVIEWSRowFactory;
import org.apache.derby.impl.sql.catalog.TDCacheable;
import org.apache.derby.impl.sql.catalog.TabInfoImpl;
import org.apache.derby.impl.sql.catalog.TableKey;
import org.apache.derby.impl.sql.depend.BasicDependencyManager;

public final class DataDictionaryImpl
implements DataDictionary,
CacheableFactory,
ModuleControl,
ModuleSupportable,
PrivilegedAction {
    private static final String CFG_SYSTABLES_ID = "SystablesIdentifier";
    private static final String CFG_SYSTABLES_INDEX1_ID = "SystablesIndex1Identifier";
    private static final String CFG_SYSTABLES_INDEX2_ID = "SystablesIndex2Identifier";
    private static final String CFG_SYSCOLUMNS_ID = "SyscolumnsIdentifier";
    private static final String CFG_SYSCOLUMNS_INDEX1_ID = "SyscolumnsIndex1Identifier";
    private static final String CFG_SYSCOLUMNS_INDEX2_ID = "SyscolumnsIndex2Identifier";
    private static final String CFG_SYSCONGLOMERATES_ID = "SysconglomeratesIdentifier";
    private static final String CFG_SYSCONGLOMERATES_INDEX1_ID = "SysconglomeratesIndex1Identifier";
    private static final String CFG_SYSCONGLOMERATES_INDEX2_ID = "SysconglomeratesIndex2Identifier";
    private static final String CFG_SYSCONGLOMERATES_INDEX3_ID = "SysconglomeratesIndex3Identifier";
    private static final String CFG_SYSSCHEMAS_ID = "SysschemasIdentifier";
    private static final String CFG_SYSSCHEMAS_INDEX1_ID = "SysschemasIndex1Identifier";
    private static final String CFG_SYSSCHEMAS_INDEX2_ID = "SysschemasIndex2Identifier";
    private static final int SYSCONGLOMERATES_CORE_NUM = 0;
    private static final int SYSTABLES_CORE_NUM = 1;
    private static final int SYSCOLUMNS_CORE_NUM = 2;
    private static final int SYSSCHEMAS_CORE_NUM = 3;
    private static final int NUM_CORE = 4;
    private static final String[][] SYSFUN_FUNCTIONS = new String[][]{{"ACOS", "DOUBLE", "java.lang.StrictMath", "acos(double)", "true", "DOUBLE"}, {"ASIN", "DOUBLE", "java.lang.StrictMath", "asin(double)", "true", "DOUBLE"}, {"ATAN", "DOUBLE", "java.lang.StrictMath", "atan(double)", "true", "DOUBLE"}, {"ATAN2", "DOUBLE", "java.lang.StrictMath", "atan2(double,double)", "true", "DOUBLE", "DOUBLE"}, {"COS", "DOUBLE", "java.lang.StrictMath", "cos(double)", "true", "DOUBLE"}, {"SIN", "DOUBLE", "java.lang.StrictMath", "sin(double)", "true", "DOUBLE"}, {"TAN", "DOUBLE", "java.lang.StrictMath", "tan(double)", "true", "DOUBLE"}, {"PI", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "PI()", "true"}, {"DEGREES", "DOUBLE", "java.lang.StrictMath", "toDegrees(double)", "true", "DOUBLE"}, {"RADIANS", "DOUBLE", "java.lang.StrictMath", "toRadians(double)", "true", "DOUBLE"}, {"LN", "DOUBLE", "java.lang.StrictMath", "log(double)", "true", "DOUBLE"}, {"LOG", "DOUBLE", "java.lang.StrictMath", "log(double)", "true", "DOUBLE"}, {"LOG10", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "LOG10(double)", "true", "DOUBLE"}, {"EXP", "DOUBLE", "java.lang.StrictMath", "exp(double)", "true", "DOUBLE"}, {"CEIL", "DOUBLE", "java.lang.StrictMath", "ceil(double)", "true", "DOUBLE"}, {"CEILING", "DOUBLE", "java.lang.StrictMath", "ceil(double)", "true", "DOUBLE"}, {"FLOOR", "DOUBLE", "java.lang.StrictMath", "floor(double)", "true", "DOUBLE"}, {"SIGN", "INTEGER", "org.apache.derby.catalog.SystemProcedures", "SIGN(double)", "true", "DOUBLE"}, {"RANDOM", "DOUBLE", "java.lang.StrictMath", "random()", "false"}, {"RAND", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "RAND(int)", "false", "INTEGER"}, {"COT", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "COT(double)", "true", "DOUBLE"}, {"COSH", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "COSH(double)", "true", "DOUBLE"}, {"SINH", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "SINH(double)", "true", "DOUBLE"}, {"TANH", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "TANH(double)", "true", "DOUBLE"}};
    private static final int SYSFUN_DETERMINISTIC_INDEX = 4;
    private static final int SYSFUN_FIRST_PARAMETER_INDEX = 5;
    private static final AliasDescriptor[] SYSFUN_AD = new AliasDescriptor[SYSFUN_FUNCTIONS.length];
    private TabInfoImpl[] coreInfo;
    private SchemaDescriptor systemSchemaDesc;
    private SchemaDescriptor sysIBMSchemaDesc;
    private SchemaDescriptor declaredGlobalTemporaryTablesSchemaDesc;
    private SchemaDescriptor systemUtilSchemaDesc;
    private static final String[] nonCoreNames = new String[]{"SYSCONSTRAINTS", "SYSKEYS", "SYSDEPENDS", "SYSALIASES", "SYSVIEWS", "SYSCHECKS", "SYSFOREIGNKEYS", "SYSSTATEMENTS", "SYSFILES", "SYSTRIGGERS", "SYSSTATISTICS", "SYSDUMMY1", "SYSTABLEPERMS", "SYSCOLPERMS", "SYSROUTINEPERMS", "SYSROLES"};
    private static final int NUM_NONCORE = nonCoreNames.length;
    private static final String[] systemSchemaNames = new String[]{"SYSCAT", "SYSFUN", "SYSPROC", "SYSSTAT", "NULLID", "SYSCS_DIAG", "SYSCS_UTIL", "SYSIBM", "SQLJ", "SYS"};
    private DD_Version dictionaryVersion;
    private DD_Version softwareVersion;
    private String authorizationDatabaseOwner;
    private boolean usesSqlAuthorization;
    private TabInfoImpl[] noncoreInfo;
    public DataDescriptorGenerator dataDescriptorGenerator;
    private DataValueFactory dvf;
    AccessFactory af;
    private ExecutionFactory exFactory;
    protected UUIDFactory uuidFactory;
    Properties startupParameters;
    int engineType;
    protected boolean booting;
    private TransactionController bootingTC;
    protected DependencyManager dmgr;
    CacheManager OIDTdCache;
    CacheManager nameTdCache;
    private CacheManager spsNameCache;
    private Hashtable spsIdHash;
    int tdCacheSize;
    int stmtCacheSize;
    CacheManager permissionsCache;
    int permissionsCacheSize;
    ShExLockable cacheCoordinator;
    public LockFactory lockFactory;
    volatile int cacheMode = 0;
    volatile int ddlUsers;
    volatile int readersInDDLMode;
    public boolean readOnlyUpgrade;
    private int systemSQLNameNumber;
    private GregorianCalendar calendarForLastSystemSQLName = new GregorianCalendar();
    private long timeForLastSystemSQLName;
    private static final String[] sysUtilProceduresWithPublicAccess = new String[]{"SYSCS_SET_RUNTIMESTATISTICS", "SYSCS_SET_STATISTICS_TIMING", "SYSCS_INPLACE_COMPRESS_TABLE", "SYSCS_COMPRESS_TABLE", "SYSCS_UPDATE_STATISTICS"};
    private static final String[] sysUtilFunctionsWithPublicAccess = new String[]{"SYSCS_GET_RUNTIMESTATISTICS"};
    private int collationTypeOfSystemSchemas;
    private int collationTypeOfUserSchemas;
    static final int DROP = 0;
    static final int EXISTS = 1;
    private String spsSet;
    private static final String[] colPrivTypeMap = new String[7];
    private static final String[] colPrivTypeMapForGrant = new String[7];
    private String[][] DIAG_VTI_TABLE_CLASSES = new String[][]{{"LOCK_TABLE", "org.apache.derby.diag.LockTable"}, {"STATEMENT_CACHE", "org.apache.derby.diag.StatementCache"}, {"TRANSACTION_TABLE", "org.apache.derby.diag.TransactionTable"}, {"ERROR_MESSAGES", "org.apache.derby.diag.ErrorMessages"}};
    private String[][] DIAG_VTI_TABLE_FUNCTION_CLASSES = new String[][]{{"SPACE_TABLE", "org.apache.derby.diag.SpaceTable"}, {"ERROR_LOG_READER", "org.apache.derby.diag.ErrorLogReader"}, {"STATEMENT_DURATION", "org.apache.derby.diag.StatementDuration"}, {"CONTAINED_ROLES", "org.apache.derby.diag.ContainedRoles"}};

    public boolean canSupport(Properties startParams) {
        return Monitor.isDesiredType(startParams, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot(boolean create, Properties startParams) throws StandardException {
        this.softwareVersion = new DD_Version(this, 170);
        this.startupParameters = startParams;
        this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        this.engineType = Monitor.getEngineType(startParams);
        this.collationTypeOfSystemSchemas = 0;
        this.getBuiltinSystemSchemas();
        LanguageConnectionFactory langConnFactory = (LanguageConnectionFactory)Monitor.bootServiceModule(create, this, "org.apache.derby.iapi.sql.conn.LanguageConnectionFactory", startParams);
        this.dvf = langConnFactory.getDataValueFactory();
        this.exFactory = (ExecutionFactory)Monitor.bootServiceModule(create, this, "org.apache.derby.iapi.sql.execute.ExecutionFactory", startParams);
        this.initializeCatalogInfo();
        this.booting = true;
        if (this.dataDescriptorGenerator == null) {
            this.dataDescriptorGenerator = new DataDescriptorGenerator(this);
        }
        if (!create) {
            this.coreInfo[1].setHeapConglomerate(this.getBootParameter(startParams, CFG_SYSTABLES_ID, true));
            this.coreInfo[1].setIndexConglomerate(0, this.getBootParameter(startParams, CFG_SYSTABLES_INDEX1_ID, true));
            this.coreInfo[1].setIndexConglomerate(1, this.getBootParameter(startParams, CFG_SYSTABLES_INDEX2_ID, true));
            this.coreInfo[2].setHeapConglomerate(this.getBootParameter(startParams, CFG_SYSCOLUMNS_ID, true));
            this.coreInfo[2].setIndexConglomerate(0, this.getBootParameter(startParams, CFG_SYSCOLUMNS_INDEX1_ID, true));
            this.coreInfo[2].setIndexConglomerate(1, this.getBootParameter(startParams, CFG_SYSCOLUMNS_INDEX2_ID, false));
            this.coreInfo[0].setHeapConglomerate(this.getBootParameter(startParams, CFG_SYSCONGLOMERATES_ID, true));
            this.coreInfo[0].setIndexConglomerate(0, this.getBootParameter(startParams, CFG_SYSCONGLOMERATES_INDEX1_ID, true));
            this.coreInfo[0].setIndexConglomerate(1, this.getBootParameter(startParams, CFG_SYSCONGLOMERATES_INDEX2_ID, true));
            this.coreInfo[0].setIndexConglomerate(2, this.getBootParameter(startParams, CFG_SYSCONGLOMERATES_INDEX3_ID, true));
            this.coreInfo[3].setHeapConglomerate(this.getBootParameter(startParams, CFG_SYSSCHEMAS_ID, true));
            this.coreInfo[3].setIndexConglomerate(0, this.getBootParameter(startParams, CFG_SYSSCHEMAS_INDEX1_ID, true));
            this.coreInfo[3].setIndexConglomerate(1, this.getBootParameter(startParams, CFG_SYSSCHEMAS_INDEX2_ID, true));
        }
        String value = startParams.getProperty("derby.language.tableDescriptorCacheSize");
        this.tdCacheSize = PropertyUtil.intPropertyValue("derby.language.tableDescriptorCacheSize", (Serializable)((Object)value), 0, Integer.MAX_VALUE, 64);
        value = startParams.getProperty("derby.language.spsCacheSize");
        this.stmtCacheSize = PropertyUtil.intPropertyValue("derby.language.spsCacheSize", (Serializable)((Object)value), 0, Integer.MAX_VALUE, 32);
        value = startParams.getProperty("derby.language.permissionsCacheSize");
        this.permissionsCacheSize = PropertyUtil.intPropertyValue("derby.language.permissionsCacheSize", (Serializable)((Object)value), 0, Integer.MAX_VALUE, 64);
        CacheFactory cf = (CacheFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
        this.OIDTdCache = cf.newCacheManager(this, "TableDescriptorOIDCache", this.tdCacheSize, this.tdCacheSize);
        this.nameTdCache = cf.newCacheManager(this, "TableDescriptorNameCache", this.tdCacheSize, this.tdCacheSize);
        if (this.stmtCacheSize > 0) {
            this.spsNameCache = cf.newCacheManager(this, "SPSNameDescriptorCache", this.stmtCacheSize, this.stmtCacheSize);
            this.spsIdHash = new Hashtable(this.stmtCacheSize);
        }
        this.cacheCoordinator = new ShExLockable();
        this.af = (AccessFactory)Monitor.findServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        this.lockFactory = this.af.getLockFactory();
        ContextService csf = ContextService.getFactory();
        ContextManager cm = csf.getCurrentContextManager();
        SanityManager.ASSERT(cm != null, "Failed to get current ContextManager");
        this.bootingTC = null;
        try {
            String userDefinedCollation;
            this.bootingTC = this.af.getTransaction(cm);
            this.exFactory.newExecutionContext(cm);
            DataDescriptorGenerator ddg = this.getDataDescriptorGenerator();
            if (create) {
                userDefinedCollation = startParams.getProperty("collation", "UCS_BASIC");
                this.bootingTC.setProperty("derby.database.collation", (Serializable)((Object)userDefinedCollation), true);
            } else {
                userDefinedCollation = startParams.getProperty("derby.database.collation", "UCS_BASIC");
            }
            this.collationTypeOfUserSchemas = userDefinedCollation.equalsIgnoreCase("UCS_BASIC") ? 0 : 1;
            this.declaredGlobalTemporaryTablesSchemaDesc = this.newDeclaredGlobalTemporaryTablesSchemaDesc("SESSION");
            if (create) {
                String userName = IdUtil.getUserNameFromURLProps(startParams);
                this.authorizationDatabaseOwner = IdUtil.getUserAuthorizationId(userName);
                HashSet newlyCreatedRoutines = new HashSet();
                this.createDictionaryTables(startParams, this.bootingTC, ddg);
                this.create_SYSIBM_procedures(this.bootingTC, newlyCreatedRoutines);
                this.createSystemSps(this.bootingTC);
                this.create_SYSCS_procedures(this.bootingTC, newlyCreatedRoutines);
                this.grantPublicAccessToSystemRoutines(newlyCreatedRoutines, this.bootingTC, this.authorizationDatabaseOwner);
                this.dictionaryVersion = this.softwareVersion;
                this.bootingTC.setProperty("DataDictionaryVersion", this.dictionaryVersion, true);
                this.bootingTC.setProperty("CreateDataDictionaryVersion", this.dictionaryVersion, true);
                if (PropertyUtil.getSystemBoolean("derby.database.sqlAuthorization")) {
                    this.bootingTC.setProperty("derby.database.sqlAuthorization", (Serializable)((Object)"true"), true);
                    this.usesSqlAuthorization = true;
                }
            } else {
                this.loadDictionaryTables(this.bootingTC, ddg, startParams);
                String sqlAuth = PropertyUtil.getDatabaseProperty(this.bootingTC, "derby.database.sqlAuthorization");
                if (Boolean.valueOf(startParams.getProperty("softUpgradeNoFeatureCheck")).booleanValue()) {
                    if (this.dictionaryVersion.majorVersionNumber >= 140) {
                        this.usesSqlAuthorization = Boolean.valueOf(sqlAuth);
                    }
                } else if (Boolean.valueOf(sqlAuth).booleanValue()) {
                    this.checkVersion(140, "sqlAuthorization");
                    this.usesSqlAuthorization = true;
                }
            }
            SanityManager.ASSERT(this.authorizationDatabaseOwner != null, "Failed to get Database Owner authorization");
            this.bootingTC.commit();
            cm.getContext("ExecutionContext").popMe();
        }
        finally {
            if (this.bootingTC != null) {
                this.bootingTC.destroy();
                this.bootingTC = null;
            }
        }
        this.setDependencyManager();
        this.booting = false;
    }

    private CacheManager getPermissionsCache() throws StandardException {
        if (this.permissionsCache == null) {
            CacheFactory cf = (CacheFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
            LanguageConnectionContext lcc = DataDictionaryImpl.getLCC();
            TransactionController tc = lcc.getTransactionExecute();
            this.permissionsCacheSize = PropertyUtil.getServiceInt(tc, "derby.language.permissionsCacheSize", 40, Integer.MAX_VALUE, this.permissionsCacheSize);
            this.permissionsCache = cf.newCacheManager(this, "PermissionsCache", this.permissionsCacheSize, this.permissionsCacheSize);
        }
        return this.permissionsCache;
    }

    protected void setDependencyManager() {
        this.dmgr = new BasicDependencyManager(this);
    }

    public DependencyManager getDependencyManager() {
        return this.dmgr;
    }

    public void stop() {
    }

    public Cacheable newCacheable(CacheManager cm) {
        if (cm == this.OIDTdCache) {
            return new OIDTDCacheable(this);
        }
        if (cm == this.nameTdCache) {
            return new NameTDCacheable(this);
        }
        if (cm == this.permissionsCache) {
            return new PermissionsCacheable(this);
        }
        return new SPSNameCacheable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startReading(LanguageConnectionContext lcc) throws StandardException {
        int localCacheMode;
        int bindCount = lcc.incrementBindCount();
        boolean needRetry = false;
        do {
            if (needRetry) {
                try {
                    this.lockFactory.zeroDurationlockObject(lcc.getTransactionExecute().getLockSpace(), this.cacheCoordinator, ShExQual.SH, -1);
                }
                catch (StandardException e) {
                    lcc.decrementBindCount();
                    throw e;
                }
                needRetry = false;
            }
            DataDictionaryImpl dataDictionaryImpl = this;
            synchronized (dataDictionaryImpl) {
                localCacheMode = this.getCacheMode();
                if (bindCount == 1) {
                    if (localCacheMode == 0) {
                        SanityManager.ASSERT(this.ddlUsers == 0, "Cache mode is COMPILE_ONLY and there are DDL users.");
                        boolean lockGranted = false;
                        try {
                            CompatibilitySpace space = lcc.getTransactionExecute().getLockSpace();
                            lockGranted = this.lockFactory.lockObject(space, space.getOwner(), this.cacheCoordinator, ShExQual.SH, 0);
                        }
                        catch (StandardException e) {
                            lcc.decrementBindCount();
                            throw e;
                        }
                        if (!lockGranted) {
                            needRetry = true;
                        }
                    } else {
                        ++this.readersInDDLMode;
                    }
                }
            }
        } while (needRetry);
        return localCacheMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneReading(int mode, LanguageConnectionContext lcc) throws StandardException {
        int bindCount = lcc.decrementBindCount();
        DataDictionaryImpl dataDictionaryImpl = this;
        synchronized (dataDictionaryImpl) {
            if (bindCount == 0) {
                if (mode == 0) {
                    CompatibilitySpace space;
                    int unlockCount;
                    if (lcc.getStatementContext() != null && lcc.getStatementContext().inUse() && (unlockCount = this.lockFactory.unlock(space = lcc.getTransactionExecute().getLockSpace(), space.getOwner(), this.cacheCoordinator, ShExQual.SH)) != 1) {
                        SanityManager.THROWASSERT("unlockCount not 1 as expected, it is " + unlockCount);
                    }
                } else {
                    --this.readersInDDLMode;
                    if (this.ddlUsers == 0 && this.readersInDDLMode == 0) {
                        this.clearCaches();
                        this.setCacheMode(0);
                    }
                    SanityManager.ASSERT(this.readersInDDLMode >= 0, "readersInDDLMode is invalid -- should never be < 0");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWriting(LanguageConnectionContext lcc) throws StandardException {
        boolean blocked = true;
        if (lcc.getBindCount() != 0) {
            throw StandardException.newException("XCL21.S");
        }
        if (!lcc.dataDictionaryInWriteMode()) {
            int i = 0;
            while (blocked) {
                block13: {
                    if (i > 4 && this.getCacheMode() == 0) {
                        this.lockFactory.zeroDurationlockObject(lcc.getTransactionExecute().getLockSpace(), this.cacheCoordinator, ShExQual.EX, -2);
                        i = 1;
                    }
                    if (i > 0) {
                        try {
                            Thread.sleep((long)(Math.random() * 1131.0 % 20.0));
                        }
                        catch (InterruptedException ie) {
                            throw StandardException.interrupt(ie);
                        }
                    }
                    DataDictionaryImpl dataDictionaryImpl = this;
                    synchronized (dataDictionaryImpl) {
                        if (this.getCacheMode() == 0) {
                            boolean lockGranted = this.lockFactory.zeroDurationlockObject(lcc.getTransactionExecute().getLockSpace(), this.cacheCoordinator, ShExQual.EX, 0);
                            if (!lockGranted) {
                                break block13;
                            }
                            this.setCacheMode(1);
                            this.clearCaches();
                        }
                        ++this.ddlUsers;
                    }
                    lcc.setDataDictionaryWriteMode();
                    blocked = false;
                }
                ++i;
            }
        } else {
            SanityManager.ASSERT(this.getCacheMode() == 1, "lcc.getDictionaryInWriteMode() but DataDictionary is COMPILE_MODE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionFinished() throws StandardException {
        DataDictionaryImpl dataDictionaryImpl = this;
        synchronized (dataDictionaryImpl) {
            SanityManager.ASSERT(this.ddlUsers > 0, "Number of DDL Users is <= 0 when finishing a transaction");
            SanityManager.ASSERT(this.getCacheMode() == 1, "transactionFinished called when not in DDL_MODE");
            --this.ddlUsers;
            if (this.ddlUsers == 0 && this.readersInDDLMode == 0) {
                this.clearCaches();
                this.setCacheMode(0);
            }
        }
    }

    public int getCacheMode() {
        return this.cacheMode;
    }

    private void setCacheMode(int newMode) {
        this.cacheMode = newMode;
    }

    public DataDescriptorGenerator getDataDescriptorGenerator() {
        return this.dataDescriptorGenerator;
    }

    public String getAuthorizationDatabaseOwner() {
        return this.authorizationDatabaseOwner;
    }

    public boolean usesSqlAuthorization() {
        return this.usesSqlAuthorization;
    }

    public int getCollationTypeOfSystemSchemas() {
        return this.collationTypeOfSystemSchemas;
    }

    public int getCollationTypeOfUserSchemas() {
        return this.collationTypeOfUserSchemas;
    }

    public DataValueFactory getDataValueFactory() {
        return this.dvf;
    }

    public ExecutionFactory getExecutionFactory() {
        return this.exFactory;
    }

    private void getBuiltinSystemSchemas() {
        if (this.systemSchemaDesc != null) {
            return;
        }
        this.systemSchemaDesc = this.newSystemSchemaDesc("SYS", "8000000d-00d0-fd77-3ed8-000a0a0b1900");
        this.sysIBMSchemaDesc = this.newSystemSchemaDesc("SYSIBM", "c013800d-00f8-5b53-28a9-00000019ed88");
        this.systemUtilSchemaDesc = this.newSystemSchemaDesc("SYSCS_UTIL", "c013800d-00fb-2649-07ec-000000134f30");
    }

    public SchemaDescriptor getSystemSchemaDescriptor() throws StandardException {
        return this.systemSchemaDesc;
    }

    public SchemaDescriptor getSystemUtilSchemaDescriptor() throws StandardException {
        return this.systemUtilSchemaDesc;
    }

    public SchemaDescriptor getSysIBMSchemaDescriptor() throws StandardException {
        return this.sysIBMSchemaDesc;
    }

    public SchemaDescriptor getDeclaredGlobalTemporaryTablesSchemaDescriptor() throws StandardException {
        return this.declaredGlobalTemporaryTablesSchemaDesc;
    }

    public boolean isSystemSchemaName(String name) throws StandardException {
        boolean ret_val = false;
        int i = systemSchemaNames.length - 1;
        while (i >= 0 && !(ret_val = systemSchemaNames[i--].equals(name))) {
        }
        return ret_val;
    }

    public SchemaDescriptor getSchemaDescriptor(String schemaName, TransactionController tc, boolean raiseError) throws StandardException {
        if (tc == null) {
            tc = this.getTransactionCompile();
        }
        if (this.getSystemSchemaDescriptor().getSchemaName().equals(schemaName)) {
            return this.getSystemSchemaDescriptor();
        }
        if (this.getSysIBMSchemaDescriptor().getSchemaName().equals(schemaName) && this.dictionaryVersion.checkVersion(100, null)) {
            return this.getSysIBMSchemaDescriptor();
        }
        SchemaDescriptor sd = this.locateSchemaRow(schemaName, tc);
        if (sd == null && this.getDeclaredGlobalTemporaryTablesSchemaDescriptor().getSchemaName().equals(schemaName)) {
            return this.getDeclaredGlobalTemporaryTablesSchemaDescriptor();
        }
        if (sd == null && raiseError) {
            throw StandardException.newException("42Y07", schemaName);
        }
        return sd;
    }

    private SchemaDescriptor locateSchemaRow(UUID schemaId, TransactionController tc) throws StandardException {
        return this.locateSchemaRowBody(schemaId, 4, tc);
    }

    private SchemaDescriptor locateSchemaRow(UUID schemaId, int isolationLevel, TransactionController tc) throws StandardException {
        return this.locateSchemaRowBody(schemaId, isolationLevel, tc);
    }

    private SchemaDescriptor locateSchemaRowBody(UUID schemaId, int isolationLevel, TransactionController tc) throws StandardException {
        TabInfoImpl ti = this.coreInfo[3];
        SQLChar UUIDStringOrderable = DataDictionaryImpl.getIDValueAsCHAR(schemaId);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, UUIDStringOrderable);
        return (SchemaDescriptor)this.getDescriptorViaIndex(1, keyRow, null, ti, null, null, false, isolationLevel, tc);
    }

    private SchemaDescriptor locateSchemaRow(String schemaName, TransactionController tc) throws StandardException {
        TabInfoImpl ti = this.coreInfo[3];
        SQLVarchar schemaNameOrderable = new SQLVarchar(schemaName);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, schemaNameOrderable);
        return (SchemaDescriptor)this.getDescriptorViaIndex(0, keyRow, null, ti, null, null, false, tc);
    }

    public SchemaDescriptor getSchemaDescriptor(UUID schemaId, TransactionController tc) throws StandardException {
        return this.getSchemaDescriptorBody(schemaId, 4, tc);
    }

    public SchemaDescriptor getSchemaDescriptor(UUID schemaId, int isolationLevel, TransactionController tc) throws StandardException {
        return this.getSchemaDescriptorBody(schemaId, isolationLevel, tc);
    }

    private SchemaDescriptor getSchemaDescriptorBody(UUID schemaId, int isolationLevel, TransactionController tc) throws StandardException {
        LanguageConnectionContext lcc;
        SchemaDescriptor sd = null;
        if (tc == null) {
            tc = this.getTransactionCompile();
        }
        if (schemaId != null) {
            if (this.getSystemSchemaDescriptor().getUUID().equals(schemaId)) {
                return this.getSystemSchemaDescriptor();
            }
            if (this.getSysIBMSchemaDescriptor().getUUID().equals(schemaId)) {
                return this.getSysIBMSchemaDescriptor();
            }
        }
        if (!this.booting && (lcc = DataDictionaryImpl.getLCC()) != null && (sd = lcc.getDefaultSchema()) != null && (schemaId == null || schemaId.equals(sd.getUUID()))) {
            return sd;
        }
        return this.locateSchemaRow(schemaId, isolationLevel, tc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsSchemaOwnedBy(String authid, TransactionController tc) throws StandardException {
        TabInfoImpl ti = this.coreInfo[3];
        SYSSCHEMASRowFactory rf = (SYSSCHEMASRowFactory)ti.getCatalogRowFactory();
        ConglomerateController heapCC = tc.openConglomerate(ti.getHeapConglomerate(), false, 0, 6, 4);
        SQLVarchar authIdOrderable = new SQLVarchar(authid);
        Qualifier[][] scanQualifier = this.exFactory.getScanQualifier(1);
        scanQualifier[0][0].setQualifier(2, authIdOrderable, 2, false, false, false);
        ScanController sc = tc.openScan(ti.getHeapConglomerate(), false, 0, 6, 4, null, null, 0, scanQualifier, null, 0);
        boolean result = false;
        try {
            ExecRow outRow = rf.makeEmptyRow();
            if (sc.fetchNext(outRow.getRowArray())) {
                result = true;
            }
        }
        finally {
            if (sc != null) {
                sc.close();
            }
            if (heapCC != null) {
                heapCC.close();
            }
        }
        return result;
    }

    public void addDescriptor(TupleDescriptor td, TupleDescriptor parent, int catalogNumber, boolean duplicatesAllowed, TransactionController tc) throws StandardException {
        TabInfoImpl ti = catalogNumber < 4 ? this.coreInfo[catalogNumber] : this.getNonCoreTI(catalogNumber);
        ExecRow row = ti.getCatalogRowFactory().makeRow(td, parent);
        int insertRetCode = ti.insertRow(row, tc);
        if (!duplicatesAllowed && insertRetCode != -1) {
            throw this.duplicateDescriptorException(td, parent);
        }
    }

    private StandardException duplicateDescriptorException(TupleDescriptor tuple, TupleDescriptor parent) {
        if (parent != null) {
            return StandardException.newException("X0Y32.S", tuple.getDescriptorType(), (Object)tuple.getDescriptorName(), (Object)parent.getDescriptorType(), (Object)parent.getDescriptorName());
        }
        return StandardException.newException("X0Y68.S", (Object)tuple.getDescriptorType(), (Object)tuple.getDescriptorName());
    }

    public void addDescriptorArray(TupleDescriptor[] td, TupleDescriptor parent, int catalogNumber, boolean allowDuplicates, TransactionController tc) throws StandardException {
        TabInfoImpl ti = catalogNumber < 4 ? this.coreInfo[catalogNumber] : this.getNonCoreTI(catalogNumber);
        CatalogRowFactory crf = ti.getCatalogRowFactory();
        ExecRow[] rl = new ExecRow[td.length];
        for (int index = 0; index < td.length; ++index) {
            ExecRow row;
            rl[index] = row = crf.makeRow(td[index], parent);
        }
        int insertRetCode = ti.insertRowList(rl, tc);
        if (!allowDuplicates && insertRetCode != -1) {
            throw this.duplicateDescriptorException(td[insertRetCode], parent);
        }
    }

    public void dropRoleGrant(String roleName, String grantee, String grantor, TransactionController tc) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(19);
        SQLVarchar roleNameOrderable = new SQLVarchar(roleName);
        SQLVarchar granteeOrderable = new SQLVarchar(grantee);
        SQLVarchar grantorOrderable = new SQLVarchar(grantor);
        ExecIndexRow keyRow = null;
        keyRow = this.exFactory.getIndexableRow(3);
        keyRow.setColumn(1, roleNameOrderable);
        keyRow.setColumn(2, granteeOrderable);
        keyRow.setColumn(3, grantorOrderable);
        ti.deleteRow(tc, keyRow, 0);
    }

    public void dropSchemaDescriptor(String schemaName, TransactionController tc) throws StandardException {
        ExecIndexRow keyRow1 = null;
        TabInfoImpl ti = this.coreInfo[3];
        SchemaDescriptor sd = this.getSchemaDescriptor(schemaName, this.getTransactionCompile(), true);
        if (!this.isSchemaEmpty(sd)) {
            SanityManager.THROWASSERT("Attempt to drop schema " + schemaName + " that is not empty");
        }
        SQLVarchar schemaNameOrderable = new SQLVarchar(schemaName);
        keyRow1 = this.exFactory.getIndexableRow(1);
        keyRow1.setColumn(1, schemaNameOrderable);
        ti.deleteRow(tc, keyRow1, 0);
    }

    public TableDescriptor getTableDescriptor(String tableName, SchemaDescriptor schema, TransactionController tc) throws StandardException {
        TableDescriptor td;
        TableDescriptor retval = null;
        if (schema == null && !tableName.startsWith("SYS")) {
            SanityManager.THROWASSERT("null schema for non system table " + tableName);
        }
        SchemaDescriptor sd = schema == null ? this.getSystemSchemaDescriptor() : schema;
        UUID schemaUUID = sd.getUUID();
        if ("SYSCS_DIAG".equals(sd.getSchemaName()) && this.getVTIClass(td = new TableDescriptor(this, tableName, sd, 5, 'R'), false) != null) {
            return td;
        }
        TableKey tableKey = new TableKey(schemaUUID, tableName);
        if (this.getCacheMode() == 0) {
            NameTDCacheable cacheEntry = (NameTDCacheable)this.nameTdCache.find(tableKey);
            if (cacheEntry != null) {
                retval = cacheEntry.getTableDescriptor();
                retval.setReferencedColumnMap(null);
                this.nameTdCache.release(cacheEntry);
            }
            return retval;
        }
        return this.getTableDescriptorIndex1Scan(tableName, schemaUUID.toString());
    }

    private TableDescriptor getTableDescriptorIndex1Scan(String tableName, String schemaUUID) throws StandardException {
        TabInfoImpl ti = this.coreInfo[1];
        SQLVarchar tableNameOrderable = new SQLVarchar(tableName);
        SQLChar schemaIDOrderable = new SQLChar(schemaUUID);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(2);
        keyRow.setColumn(1, tableNameOrderable);
        keyRow.setColumn(2, schemaIDOrderable);
        TableDescriptor td = (TableDescriptor)this.getDescriptorViaIndex(0, keyRow, null, ti, null, null, false);
        return this.finishTableDescriptor(td);
    }

    TableDescriptor getUncachedTableDescriptor(TableKey tableKey) throws StandardException {
        return this.getTableDescriptorIndex1Scan(tableKey.getTableName(), tableKey.getSchemaId().toString());
    }

    public TableDescriptor getTableDescriptor(UUID tableID) throws StandardException {
        TableDescriptor retval = null;
        if (this.getCacheMode() == 0) {
            OIDTDCacheable cacheEntry = (OIDTDCacheable)this.OIDTdCache.find(tableID);
            if (cacheEntry != null) {
                retval = cacheEntry.getTableDescriptor();
                retval.setReferencedColumnMap(null);
                this.OIDTdCache.release(cacheEntry);
            }
            return retval;
        }
        return this.getTableDescriptorIndex2Scan(tableID.toString());
    }

    protected TableDescriptor getUncachedTableDescriptor(UUID tableID) throws StandardException {
        return this.getTableDescriptorIndex2Scan(tableID.toString());
    }

    private TableDescriptor getTableDescriptorIndex2Scan(String tableUUID) throws StandardException {
        TabInfoImpl ti = this.coreInfo[1];
        SQLChar tableIDOrderable = new SQLChar(tableUUID);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, tableIDOrderable);
        TableDescriptor td = (TableDescriptor)this.getDescriptorViaIndex(1, keyRow, null, ti, null, null, false);
        return this.finishTableDescriptor(td);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableDescriptor finishTableDescriptor(TableDescriptor td) throws StandardException {
        if (td != null) {
            TableDescriptor tableDescriptor = td;
            synchronized (tableDescriptor) {
                this.getColumnDescriptorsScan(td);
                this.getConglomerateDescriptorsScan(td);
            }
        }
        return td;
    }

    public boolean isSchemaEmpty(SchemaDescriptor sd) throws StandardException {
        SQLChar schemaIdOrderable;
        TransactionController tc = this.getTransactionCompile();
        if (this.isSchemaReferenced(tc, this.coreInfo[1], 0, 2, schemaIdOrderable = DataDictionaryImpl.getIDValueAsCHAR(sd.getUUID()))) {
            return false;
        }
        if (this.isSchemaReferenced(tc, this.getNonCoreTI(4), 1, 2, schemaIdOrderable)) {
            return false;
        }
        if (this.isSchemaReferenced(tc, this.getNonCoreTI(11), 1, 2, schemaIdOrderable)) {
            return false;
        }
        return !this.isSchemaReferenced(tc, this.getNonCoreTI(13), 1, 2, schemaIdOrderable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSchemaReferenced(TransactionController tc, TabInfoImpl ti, int indexId, int indexCol, DataValueDescriptor schemaIdOrderable) throws StandardException {
        boolean foundRow;
        ConglomerateController heapCC = null;
        GenericScanController scanController = null;
        FormatableBitSet colToCheck = new FormatableBitSet(indexCol);
        CatalogRowFactory rf = ti.getCatalogRowFactory();
        SanityManager.ASSERT(indexId >= 0, "code needs to be enhanced to support a table scan to find the index id");
        colToCheck.set(indexCol - 1);
        Qualifier[][] qualifier = this.exFactory.getScanQualifier(1);
        qualifier[0][0].setQualifier(indexCol - 1, schemaIdOrderable, 2, false, false, false);
        ExecRow outRow = rf.makeEmptyRow();
        try {
            heapCC = tc.openConglomerate(ti.getHeapConglomerate(), false, 0, 6, 4);
            scanController = tc.openScan(ti.getIndexConglomerate(indexId), false, 0, 6, 4, colToCheck, null, 1, qualifier, null, -1);
            foundRow = scanController.next();
        }
        finally {
            if (scanController != null) {
                scanController.close();
            }
            if (heapCC != null) {
                heapCC.close();
            }
        }
        return foundRow;
    }

    public void dropTableDescriptor(TableDescriptor td, SchemaDescriptor schema, TransactionController tc) throws StandardException {
        ExecIndexRow keyRow1 = null;
        TabInfoImpl ti = this.coreInfo[1];
        SQLVarchar tableNameOrderable = new SQLVarchar(td.getName());
        SQLChar schemaIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(schema.getUUID());
        keyRow1 = this.exFactory.getIndexableRow(2);
        keyRow1.setColumn(1, tableNameOrderable);
        keyRow1.setColumn(2, schemaIDOrderable);
        ti.deleteRow(tc, keyRow1, 0);
    }

    public void updateLockGranularity(TableDescriptor td, SchemaDescriptor schema, char lockGranularity, TransactionController tc) throws StandardException {
        ExecIndexRow keyRow1 = null;
        TabInfoImpl ti = this.coreInfo[1];
        SYSTABLESRowFactory rf = (SYSTABLESRowFactory)ti.getCatalogRowFactory();
        SQLVarchar tableNameOrderable = new SQLVarchar(td.getName());
        SQLChar schemaIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(schema.getUUID());
        keyRow1 = this.exFactory.getIndexableRow(2);
        keyRow1.setColumn(1, tableNameOrderable);
        keyRow1.setColumn(2, schemaIDOrderable);
        ExecRow row = rf.makeRow(td, schema);
        boolean[] bArray = new boolean[2];
        for (int index = 0; index < 2; ++index) {
            bArray[index] = false;
        }
        ti.updateRow(keyRow1, row, 0, bArray, (int[])null, tc);
    }

    public ColumnDescriptor getColumnDescriptorByDefaultId(UUID uuid) throws StandardException {
        TabInfoImpl ti = this.coreInfo[2];
        SQLChar UUIDStringOrderable = DataDictionaryImpl.getIDValueAsCHAR(uuid);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, UUIDStringOrderable);
        return (ColumnDescriptor)this.getDescriptorViaIndex(1, keyRow, null, ti, null, null, false);
    }

    private void getColumnDescriptorsScan(TableDescriptor td) throws StandardException {
        this.getColumnDescriptorsScan(td.getUUID(), td.getColumnDescriptorList(), td);
    }

    private void getColumnDescriptorsScan(UUID uuid, ColumnDescriptorList cdl, TupleDescriptor td) throws StandardException {
        int index;
        ColumnDescriptorList cdlCopy = new ColumnDescriptorList();
        SQLChar refIDOrderable = null;
        TabInfoImpl ti = this.coreInfo[2];
        refIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(uuid);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, refIDOrderable);
        this.getDescriptorViaIndex(0, keyRow, null, ti, td, cdl, false);
        int cdlSize = cdl.size();
        for (index = 0; index < cdlSize; ++index) {
            cdlCopy.add(cdl.get(index));
        }
        for (index = 0; index < cdlSize; ++index) {
            ColumnDescriptor cd = cdlCopy.elementAt(index);
            cdl.set(cd.getPosition() - 1, cd);
        }
    }

    public void dropColumnDescriptor(UUID tableID, String columnName, TransactionController tc) throws StandardException {
        SQLChar tableIdOrderable = DataDictionaryImpl.getIDValueAsCHAR(tableID);
        SQLVarchar columnNameOrderable = new SQLVarchar(columnName);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(2);
        keyRow.setColumn(1, tableIdOrderable);
        keyRow.setColumn(2, columnNameOrderable);
        this.dropColumnDescriptorCore(tc, keyRow);
    }

    public void dropAllColumnDescriptors(UUID tableID, TransactionController tc) throws StandardException {
        SQLChar tableIdOrderable = DataDictionaryImpl.getIDValueAsCHAR(tableID);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, tableIdOrderable);
        this.dropColumnDescriptorCore(tc, keyRow);
    }

    public void dropAllTableAndColPermDescriptors(UUID tableID, TransactionController tc) throws StandardException {
        if (!this.usesSqlAuthorization) {
            return;
        }
        SQLChar tableIdOrderable = DataDictionaryImpl.getIDValueAsCHAR(tableID);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, tableIdOrderable);
        this.dropTablePermDescriptor(tc, keyRow);
        this.dropColumnPermDescriptor(tc, keyRow);
    }

    public void updateSYSCOLPERMSforAddColumnToUserTable(UUID tableID, TransactionController tc) throws StandardException {
        this.rewriteSYSCOLPERMSforAlterTable(tableID, tc, null);
    }

    public void updateSYSCOLPERMSforDropColumn(UUID tableID, TransactionController tc, ColumnDescriptor columnDescriptor) throws StandardException {
        this.rewriteSYSCOLPERMSforAlterTable(tableID, tc, columnDescriptor);
    }

    private void rewriteSYSCOLPERMSforAlterTable(UUID tableID, TransactionController tc, ColumnDescriptor columnDescriptor) throws StandardException {
        if (!this.usesSqlAuthorization) {
            return;
        }
        SQLChar tableIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(tableID);
        TabInfoImpl ti = this.getNonCoreTI(17);
        SYSCOLPERMSRowFactory rf = (SYSCOLPERMSRowFactory)ti.getCatalogRowFactory();
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, tableIDOrderable);
        List permissionDescriptorsList = DataDictionaryImpl.newSList();
        this.getDescriptorViaIndex(2, keyRow, null, ti, null, permissionDescriptorsList, false);
        boolean[] bArray = new boolean[3];
        int[] colsToUpdate = new int[]{6};
        Iterator iterator = permissionDescriptorsList.iterator();
        while (iterator.hasNext()) {
            ColPermsDescriptor colPermsDescriptor = (ColPermsDescriptor)iterator.next();
            this.removePermEntryInCache(colPermsDescriptor);
            ExecIndexRow uuidKey = rf.buildIndexKeyRow(1, colPermsDescriptor);
            ExecRow curRow = ti.getRow(tc, uuidKey, 1);
            FormatableBitSet columns = (FormatableBitSet)curRow.getColumn(6).getObject();
            if (columnDescriptor == null) {
                int currentLength = columns.getLength();
                columns.grow(currentLength + 1);
            } else {
                FormatableBitSet modifiedColumns = new FormatableBitSet(columns);
                modifiedColumns.shrink(columns.getLength() - 1);
                for (int i = columnDescriptor.getPosition() - 1; i < modifiedColumns.getLength(); ++i) {
                    if (columns.isSet(i + 1)) {
                        modifiedColumns.set(i);
                        continue;
                    }
                    modifiedColumns.clear(i);
                }
                columns = modifiedColumns;
            }
            curRow.setColumn(6, this.dvf.getDataValue(columns));
            ti.updateRow(uuidKey, curRow, 1, bArray, colsToUpdate, tc);
        }
    }

    private void removePermEntryInCache(PermissionsDescriptor perm) throws StandardException {
        Cacheable cacheEntry = this.getPermissionsCache().findCached(perm);
        if (cacheEntry != null) {
            this.getPermissionsCache().remove(cacheEntry);
        }
    }

    public void dropAllRoutinePermDescriptors(UUID routineID, TransactionController tc) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(18);
        SYSROUTINEPERMSRowFactory rf = (SYSROUTINEPERMSRowFactory)ti.getCatalogRowFactory();
        if (!this.usesSqlAuthorization) {
            return;
        }
        SQLChar routineIdOrderable = DataDictionaryImpl.getIDValueAsCHAR(routineID);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, routineIdOrderable);
        while (true) {
            ExecRow curRow = ti.getRow(tc, keyRow, 2);
            if (curRow == null) break;
            PermissionsDescriptor perm = (PermissionsDescriptor)rf.buildDescriptor(curRow, null, this);
            this.removePermEntryInCache(perm);
            ExecIndexRow uuidKey = rf.buildIndexKeyRow(1, perm);
            ti.deleteRow(tc, uuidKey, 1);
        }
    }

    public void dropRoleGrantsByGrantee(String grantee, TransactionController tc) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(19);
        SYSROLESRowFactory rf = (SYSROLESRowFactory)ti.getCatalogRowFactory();
        this.visitRoleGrants(ti, rf, 2, grantee, tc, 0);
    }

    private boolean existsRoleGrantByGrantee(String grantee, TransactionController tc) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(19);
        SYSROLESRowFactory rf = (SYSROLESRowFactory)ti.getCatalogRowFactory();
        return this.visitRoleGrants(ti, rf, 2, grantee, tc, 1);
    }

    public void dropRoleGrantsByName(String roleName, TransactionController tc) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(19);
        SYSROLESRowFactory rf = (SYSROLESRowFactory)ti.getCatalogRowFactory();
        this.visitRoleGrants(ti, rf, 1, roleName, tc, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean visitRoleGrants(TabInfoImpl ti, SYSROLESRowFactory rf, int columnNo, String authId, TransactionController tc, int action) throws StandardException {
        ConglomerateController heapCC = tc.openConglomerate(ti.getHeapConglomerate(), false, 0, 6, 4);
        SQLVarchar authIdOrderable = new SQLVarchar(authId);
        Qualifier[][] scanQualifier = this.exFactory.getScanQualifier(1);
        scanQualifier[0][0].setQualifier(columnNo - 1, authIdOrderable, 2, false, false, false);
        ScanController sc = tc.openScan(ti.getIndexConglomerate(0), false, 0, 6, 4, null, null, 0, scanQualifier, null, 0);
        try {
            ExecRow outRow = rf.makeEmptyRow();
            ExecIndexRow indexRow = DataDictionaryImpl.getIndexRowFromHeapRow(ti.getIndexRowGenerator(0), heapCC.newRowLocationTemplate(), outRow);
            while (sc.fetchNext(indexRow.getRowArray())) {
                if (action == 1) {
                    boolean bl = true;
                    return bl;
                }
                if (action != 0) continue;
                ti.deleteRow(tc, indexRow, 0);
            }
        }
        finally {
            if (sc != null) {
                sc.close();
            }
            if (heapCC != null) {
                heapCC.close();
            }
        }
        return false;
    }

    HashMap getRoleGrantGraph(TransactionController tc, boolean inverse) throws StandardException {
        HashMap<String, LinkedList<RoleGrantDescriptor>> hm = new HashMap<String, LinkedList<RoleGrantDescriptor>>();
        TabInfoImpl ti = this.getNonCoreTI(19);
        SYSROLESRowFactory rf = (SYSROLESRowFactory)ti.getCatalogRowFactory();
        SQLVarchar isDefOrderable = new SQLVarchar("N");
        Qualifier[][] scanQualifier = this.exFactory.getScanQualifier(1);
        scanQualifier[0][0].setQualifier(5, isDefOrderable, 2, false, false, false);
        ScanController sc = tc.openScan(ti.getHeapConglomerate(), false, 0, 6, 4, null, null, 0, scanQualifier, null, 0);
        ExecRow outRow = rf.makeEmptyRow();
        while (sc.fetchNext(outRow.getRowArray())) {
            RoleGrantDescriptor grantDescr = (RoleGrantDescriptor)rf.buildDescriptor(outRow, null, this);
            RoleGrantDescriptor granteeDef = this.getRoleDefinitionDescriptor(grantDescr.getGrantee());
            if (granteeDef == null) continue;
            String hashKey = inverse ? granteeDef.getRoleName() : grantDescr.getRoleName();
            LinkedList<RoleGrantDescriptor> arcs = (LinkedList<RoleGrantDescriptor>)hm.get(hashKey);
            if (arcs == null) {
                arcs = new LinkedList<RoleGrantDescriptor>();
            }
            arcs.add(grantDescr);
            hm.put(hashKey, arcs);
        }
        sc.close();
        return hm;
    }

    public RoleClosureIterator createRoleClosureIterator(TransactionController tc, String role, boolean inverse) throws StandardException {
        return new RoleClosureIteratorImpl(role, inverse, this, tc);
    }

    public void dropAllPermsByGrantee(String authId, TransactionController tc) throws StandardException {
        this.dropPermsByGrantee(authId, tc, 16, 0, 1);
        this.dropPermsByGrantee(authId, tc, 17, 0, 1);
        this.dropPermsByGrantee(authId, tc, 18, 0, 1);
    }

    private void dropPermsByGrantee(String authId, TransactionController tc, int catalog, int indexNo, int granteeColnoInIndex) throws StandardException {
        this.visitPermsByGrantee(authId, tc, catalog, indexNo, granteeColnoInIndex, 0);
    }

    private boolean existsPermByGrantee(String authId, TransactionController tc, int catalog, int indexNo, int granteeColnoInIndex) throws StandardException {
        return this.visitPermsByGrantee(authId, tc, catalog, indexNo, granteeColnoInIndex, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean visitPermsByGrantee(String authId, TransactionController tc, int catalog, int indexNo, int granteeColnoInIndex, int action) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(catalog);
        PermissionsCatalogRowFactory rf = (PermissionsCatalogRowFactory)ti.getCatalogRowFactory();
        ConglomerateController heapCC = tc.openConglomerate(ti.getHeapConglomerate(), false, 0, 6, 4);
        SQLVarchar authIdOrderable = new SQLVarchar(authId);
        Qualifier[][] scanQualifier = this.exFactory.getScanQualifier(1);
        scanQualifier[0][0].setQualifier(granteeColnoInIndex - 1, authIdOrderable, 2, false, false, false);
        ScanController sc = tc.openScan(ti.getIndexConglomerate(indexNo), false, 0, 6, 4, null, null, 0, scanQualifier, null, 0);
        try {
            ExecRow outRow = rf.makeEmptyRow();
            ExecIndexRow indexRow = DataDictionaryImpl.getIndexRowFromHeapRow(ti.getIndexRowGenerator(indexNo), heapCC.newRowLocationTemplate(), outRow);
            while (sc.fetchNext(indexRow.getRowArray())) {
                RowLocation baseRowLocation = (RowLocation)indexRow.getColumn(indexRow.nColumns());
                boolean base_row_exists = heapCC.fetch(baseRowLocation, outRow.getRowArray(), null);
                SanityManager.ASSERT(base_row_exists, "base row doesn't exist");
                if (action == 1) {
                    boolean bl = true;
                    return bl;
                }
                if (action != 0) continue;
                PermissionsDescriptor perm = (PermissionsDescriptor)rf.buildDescriptor(outRow, null, this);
                this.removePermEntryInCache(perm);
                ti.deleteRow(tc, indexRow, indexNo);
            }
        }
        finally {
            if (sc != null) {
                sc.close();
            }
            if (heapCC != null) {
                heapCC.close();
            }
        }
        return false;
    }

    private void dropColumnDescriptorCore(TransactionController tc, ExecIndexRow keyRow) throws StandardException {
        TabInfoImpl ti = this.coreInfo[2];
        ti.deleteRow(tc, keyRow, 0);
    }

    private void dropTablePermDescriptor(TransactionController tc, ExecIndexRow keyRow) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(16);
        SYSTABLEPERMSRowFactory rf = (SYSTABLEPERMSRowFactory)ti.getCatalogRowFactory();
        while (true) {
            ExecRow curRow = ti.getRow(tc, keyRow, 2);
            if (curRow == null) break;
            PermissionsDescriptor perm = (PermissionsDescriptor)rf.buildDescriptor(curRow, null, this);
            this.removePermEntryInCache(perm);
            ExecIndexRow uuidKey = rf.buildIndexKeyRow(1, perm);
            ti.deleteRow(tc, uuidKey, 1);
        }
    }

    private void dropColumnPermDescriptor(TransactionController tc, ExecIndexRow keyRow) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(17);
        SYSCOLPERMSRowFactory rf = (SYSCOLPERMSRowFactory)ti.getCatalogRowFactory();
        while (true) {
            ExecRow curRow = ti.getRow(tc, keyRow, 2);
            if (curRow == null) break;
            PermissionsDescriptor perm = (PermissionsDescriptor)rf.buildDescriptor(curRow, null, this);
            this.removePermEntryInCache(perm);
            ExecIndexRow uuidKey = rf.buildIndexKeyRow(1, perm);
            ti.deleteRow(tc, uuidKey, 1);
        }
    }

    private void updateColumnDescriptor(ColumnDescriptor cd, UUID formerUUID, String formerName, int[] colsToSet, TransactionController tc) throws StandardException {
        boolean[] bArray;
        ExecRow row;
        TabInfoImpl ti;
        ExecIndexRow keyRow1;
        block4: {
            block3: {
                keyRow1 = null;
                ti = this.coreInfo[2];
                SYSCOLUMNSRowFactory rf = (SYSCOLUMNSRowFactory)ti.getCatalogRowFactory();
                SQLChar refIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(formerUUID);
                SQLVarchar columnNameOrderable = new SQLVarchar(formerName);
                keyRow1 = this.exFactory.getIndexableRow(2);
                keyRow1.setColumn(1, refIDOrderable);
                keyRow1.setColumn(2, columnNameOrderable);
                row = rf.makeRow(cd, null);
                SanityManager.ASSERT(rf.getNumIndexes() == 2, "There are more indexes on syscolumns than expected, the code herein needs to change");
                bArray = new boolean[rf.getNumIndexes()];
                if (colsToSet != null) break block3;
                bArray[0] = true;
                bArray[1] = true;
                break block4;
            }
            for (int i = 0; i < colsToSet.length; ++i) {
                block6: {
                    block5: {
                        if (colsToSet[i] == 2) break block5;
                        if (colsToSet[i] != 1) break block6;
                    }
                    bArray[0] = true;
                    break;
                }
                if (colsToSet[i] != 6) continue;
                bArray[1] = true;
                break;
            }
        }
        ti.updateRow(keyRow1, row, 0, bArray, colsToSet, tc);
    }

    public ViewDescriptor getViewDescriptor(UUID uuid) throws StandardException {
        return this.getViewDescriptor(this.getTableDescriptor(uuid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewDescriptor getViewDescriptor(TableDescriptor td) throws StandardException {
        TableDescriptor tdi = td;
        if (tdi.getViewDescriptor() != null) {
            return tdi.getViewDescriptor();
        }
        TableDescriptor tableDescriptor = tdi;
        synchronized (tableDescriptor) {
            if (tdi.getViewDescriptor() != null) {
                return tdi.getViewDescriptor();
            }
            tdi.setViewDescriptor(this.getViewDescriptorScan(tdi));
        }
        return tdi.getViewDescriptor();
    }

    private ViewDescriptor getViewDescriptorScan(TableDescriptor tdi) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(8);
        UUID viewID = tdi.getUUID();
        SQLChar viewIdOrderable = DataDictionaryImpl.getIDValueAsCHAR(viewID);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, viewIdOrderable);
        ViewDescriptor vd = (ViewDescriptor)this.getDescriptorViaIndex(0, keyRow, null, ti, null, null, false);
        if (vd != null) {
            vd.setViewName(tdi.getName());
        }
        return vd;
    }

    public void dropViewDescriptor(ViewDescriptor vd, TransactionController tc) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(8);
        SQLChar viewIdOrderable = DataDictionaryImpl.getIDValueAsCHAR(vd.getUUID());
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, viewIdOrderable);
        ti.deleteRow(tc, keyRow, 0);
    }

    private FileInfoDescriptor getFileInfoDescriptorIndex2Scan(UUID id) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(12);
        SQLChar idOrderable = DataDictionaryImpl.getIDValueAsCHAR(id);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, idOrderable);
        return (FileInfoDescriptor)this.getDescriptorViaIndex(1, keyRow, null, ti, null, null, false);
    }

    public FileInfoDescriptor getFileInfoDescriptor(UUID id) throws StandardException {
        return this.getFileInfoDescriptorIndex2Scan(id);
    }

    private FileInfoDescriptor getFileInfoDescriptorIndex1Scan(UUID schemaId, String name) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(12);
        SQLVarchar nameOrderable = new SQLVarchar(name);
        SQLChar schemaIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(schemaId);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(2);
        keyRow.setColumn(1, nameOrderable);
        keyRow.setColumn(2, schemaIDOrderable);
        FileInfoDescriptor r = (FileInfoDescriptor)this.getDescriptorViaIndex(0, keyRow, null, ti, null, null, false);
        return r;
    }

    public FileInfoDescriptor getFileInfoDescriptor(SchemaDescriptor sd, String name) throws StandardException {
        return this.getFileInfoDescriptorIndex1Scan(sd.getUUID(), name);
    }

    public void dropFileInfoDescriptor(FileInfoDescriptor fid) throws StandardException {
        ExecIndexRow keyRow1 = null;
        TabInfoImpl ti = this.getNonCoreTI(12);
        TransactionController tc = this.getTransactionExecute();
        SQLChar idOrderable = DataDictionaryImpl.getIDValueAsCHAR(fid.getUUID());
        keyRow1 = this.exFactory.getIndexableRow(1);
        keyRow1.setColumn(1, idOrderable);
        ti.deleteRow(tc, keyRow1, 1);
    }

    public SPSDescriptor getSPSDescriptor(UUID uuid) throws StandardException {
        SPSDescriptor sps;
        this.getNonCoreTI(11);
        if (this.spsNameCache != null && this.getCacheMode() == 0) {
            sps = (SPSDescriptor)this.spsIdHash.get(uuid);
            if (sps != null) {
                return sps;
            }
            sps = this.getSPSDescriptorIndex2Scan(uuid.toString());
            TableKey stmtKey = new TableKey(sps.getSchemaDescriptor().getUUID(), sps.getName());
            try {
                SPSNameCacheable cacheEntry = (SPSNameCacheable)this.spsNameCache.create(stmtKey, sps);
                this.spsNameCache.release(cacheEntry);
            }
            catch (StandardException se) {
                if ("XBCA0.S".equals(se.getMessageId())) {
                    return sps;
                }
                throw se;
            }
        } else {
            sps = this.getSPSDescriptorIndex2Scan(uuid.toString());
        }
        return sps;
    }

    void spsCacheEntryAdded(SPSDescriptor spsd) {
        this.spsIdHash.put(spsd.getUUID(), spsd);
    }

    void spsCacheEntryRemoved(SPSDescriptor spsd) {
        this.spsIdHash.remove(spsd.getUUID());
    }

    public SPSDescriptor getUncachedSPSDescriptor(TableKey stmtKey) throws StandardException {
        return this.getSPSDescriptorIndex1Scan(stmtKey.getTableName(), stmtKey.getSchemaId().toString());
    }

    protected SPSDescriptor getUncachedSPSDescriptor(UUID stmtId) throws StandardException {
        return this.getSPSDescriptorIndex2Scan(stmtId.toString());
    }

    private SPSDescriptor getSPSDescriptorIndex2Scan(String stmtUUID) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(11);
        SQLChar stmtIDOrderable = new SQLChar(stmtUUID);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, stmtIDOrderable);
        SPSDescriptor spsd = (SPSDescriptor)this.getDescriptorViaIndex(0, keyRow, null, ti, null, null, false);
        return spsd;
    }

    public SPSDescriptor getSPSDescriptor(String stmtName, SchemaDescriptor sd) throws StandardException {
        SPSDescriptor sps = null;
        if (sd == null) {
            SanityManager.THROWASSERT("null schema for statement " + stmtName);
        }
        UUID schemaUUID = sd.getUUID();
        TableKey stmtKey = new TableKey(schemaUUID, stmtName);
        if (this.spsNameCache != null && this.getCacheMode() == 0) {
            SPSNameCacheable cacheEntry = (SPSNameCacheable)this.spsNameCache.find(stmtKey);
            if (cacheEntry != null) {
                sps = cacheEntry.getSPSDescriptor();
                this.spsNameCache.release(cacheEntry);
            }
            return sps;
        }
        return this.getSPSDescriptorIndex1Scan(stmtName, schemaUUID.toString());
    }

    private SPSDescriptor getSPSDescriptorIndex1Scan(String stmtName, String schemaUUID) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(11);
        SQLVarchar stmtNameOrderable = new SQLVarchar(stmtName);
        SQLChar schemaIDOrderable = new SQLChar(schemaUUID);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(2);
        keyRow.setColumn(1, stmtNameOrderable);
        keyRow.setColumn(2, schemaIDOrderable);
        SPSDescriptor spsd = (SPSDescriptor)this.getDescriptorViaIndex(1, keyRow, null, ti, null, null, false);
        if (spsd != null) {
            Vector v = new Vector();
            spsd.setParams(this.getSPSParams(spsd, v));
            Object[] defaults = new Object[v.size()];
            v.copyInto(defaults);
            spsd.setParameterDefaults(defaults);
        }
        return spsd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSPSDescriptor(SPSDescriptor descriptor, TransactionController tc) throws StandardException {
        int insertRetCode;
        TabInfoImpl ti = this.getNonCoreTI(11);
        SYSSTATEMENTSRowFactory rf = (SYSSTATEMENTSRowFactory)ti.getCatalogRowFactory();
        SPSDescriptor sPSDescriptor = descriptor;
        synchronized (sPSDescriptor) {
            boolean compileMe = descriptor.initiallyCompilable();
            ExecRow row = rf.makeSYSSTATEMENTSrow(compileMe, descriptor);
            insertRetCode = ti.insertRow(row, tc);
        }
        if (insertRetCode != -1) {
            throw StandardException.newException("X0Y32.S", descriptor.getDescriptorType(), (Object)descriptor.getDescriptorName(), (Object)descriptor.getSchemaDescriptor().getDescriptorType(), (Object)descriptor.getSchemaDescriptor().getSchemaName());
        }
        this.addSPSParams(descriptor, tc);
    }

    private void addSPSParams(SPSDescriptor spsd, TransactionController tc) throws StandardException {
        UUID uuid = spsd.getUUID();
        DataTypeDescriptor[] params = spsd.getParams();
        Object[] parameterDefaults = spsd.getParameterDefaults();
        if (params == null) {
            return;
        }
        int pdlSize = params.length;
        for (int index = 0; index < pdlSize; ++index) {
            int parameterId = index + 1;
            ColumnDescriptor cd = new ColumnDescriptor("PARAM" + parameterId, parameterId, params[index], parameterDefaults == null || index >= parameterDefaults.length ? (DataValueDescriptor)null : (DataValueDescriptor)parameterDefaults[index], (DefaultInfo)null, uuid, (UUID)null, 0L, 0L, 0L);
            this.addDescriptor(cd, null, 2, false, tc);
        }
    }

    public DataTypeDescriptor[] getSPSParams(SPSDescriptor spsd, Vector defaults) throws StandardException {
        ColumnDescriptorList cdl = new ColumnDescriptorList();
        this.getColumnDescriptorsScan(spsd.getUUID(), cdl, spsd);
        int cdlSize = cdl.size();
        DataTypeDescriptor[] params = new DataTypeDescriptor[cdlSize];
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor cd = cdl.elementAt(index);
            params[index] = cd.getType();
            if (defaults == null) continue;
            defaults.addElement(cd.getDefaultValue());
        }
        return params;
    }

    public void updateSPS(SPSDescriptor spsd, TransactionController tc, boolean recompile, boolean updateParamDescriptors, boolean firstCompilation) throws StandardException {
        ExecIndexRow keyRow1 = null;
        TabInfoImpl ti = this.getNonCoreTI(11);
        SYSSTATEMENTSRowFactory rf = (SYSSTATEMENTSRowFactory)ti.getCatalogRowFactory();
        int[] updCols = recompile ? (firstCompilation ? new int[]{5, 7, 9, 10, 11} : new int[]{5, 7, 9, 10}) : new int[]{5};
        SQLChar idOrderable = DataDictionaryImpl.getIDValueAsCHAR(spsd.getUUID());
        keyRow1 = this.exFactory.getIndexableRow(1);
        keyRow1.setColumn(1, idOrderable);
        ExecRow row = rf.makeSYSSTATEMENTSrow(false, spsd);
        boolean[] bArray = new boolean[2];
        ti.updateRow(keyRow1, row, 0, bArray, updCols, tc);
        if (!updateParamDescriptors) {
            return;
        }
        DataTypeDescriptor[] params = spsd.getParams();
        if (params == null) {
            return;
        }
        if (firstCompilation) {
            this.addSPSParams(spsd, tc);
        } else {
            Object[] parameterDefaults = spsd.getParameterDefaults();
            int[] columnsToSet = new int[]{4, 5};
            UUID uuid = spsd.getUUID();
            for (int index = 0; index < params.length; ++index) {
                int parameterId = index + 1;
                ColumnDescriptor cd = new ColumnDescriptor("PARAM" + parameterId, parameterId, params[index], parameterDefaults == null || index >= parameterDefaults.length ? (DataValueDescriptor)null : (DataValueDescriptor)parameterDefaults[index], (DefaultInfo)null, uuid, (UUID)null, 0L, 0L, 0L);
                this.updateColumnDescriptor(cd, cd.getReferencingUUID(), cd.getColumnName(), columnsToSet, tc);
            }
        }
    }

    public void invalidateAllSPSPlans() throws StandardException {
        LanguageConnectionContext lcc = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        this.startWriting(lcc);
        Iterator li = this.getAllSPSDescriptors().iterator();
        while (li.hasNext()) {
            SPSDescriptor spsd = (SPSDescriptor)li.next();
            spsd.makeInvalid(14, lcc);
        }
    }

    void clearSPSPlans() throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(11);
        this.faultInTabInfo(ti);
        TransactionController tc = this.getTransactionExecute();
        FormatableBitSet columnToReadSet = new FormatableBitSet(11);
        FormatableBitSet columnToUpdateSet = new FormatableBitSet(11);
        columnToUpdateSet.set(4);
        columnToUpdateSet.set(9);
        DataValueDescriptor[] replaceRow = new DataValueDescriptor[11];
        replaceRow[4] = this.dvf.getDataValue(false);
        replaceRow[9] = this.dvf.getDataValue((Object)null);
        ScanController sc = tc.openScan(ti.getHeapConglomerate(), false, 4, 7, 4, columnToReadSet, null, 0, null, null, 0);
        while (sc.fetchNext(null)) {
            sc.replace(replaceRow, columnToUpdateSet);
        }
        sc.close();
    }

    public void dropSPSDescriptor(SPSDescriptor descriptor, TransactionController tc) throws StandardException {
        this.dropSPSDescriptor(descriptor.getUUID(), tc);
    }

    public void dropSPSDescriptor(UUID uuid, TransactionController tc) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(11);
        SQLChar stmtIdOrderable = DataDictionaryImpl.getIDValueAsCHAR(uuid);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, stmtIdOrderable);
        ti.deleteRow(tc, keyRow, 0);
        this.dropAllColumnDescriptors(uuid, tc);
    }

    public List getAllSPSDescriptors() throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(11);
        List list = DataDictionaryImpl.newSList();
        this.getDescriptorViaHeap(null, ti, null, list);
        return list;
    }

    private ConstraintDescriptorList getAllConstraintDescriptors() throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(4);
        ConstraintDescriptorList list = new ConstraintDescriptorList();
        this.getConstraintDescriptorViaHeap(null, ti, null, list);
        return list;
    }

    private GenericDescriptorList getAllTriggerDescriptors() throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(13);
        GenericDescriptorList list = new GenericDescriptorList();
        this.getDescriptorViaHeap(null, ti, null, list);
        return list;
    }

    public TriggerDescriptor getTriggerDescriptor(UUID uuid) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(13);
        SQLChar triggerIdOrderable = DataDictionaryImpl.getIDValueAsCHAR(uuid);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, triggerIdOrderable);
        return (TriggerDescriptor)this.getDescriptorViaIndex(0, keyRow, null, ti, null, null, false);
    }

    public TriggerDescriptor getTriggerDescriptor(String name, SchemaDescriptor sd) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(13);
        SQLVarchar triggerNameOrderable = new SQLVarchar(name);
        SQLChar schemaIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(sd.getUUID());
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(2);
        keyRow.setColumn(1, triggerNameOrderable);
        keyRow.setColumn(2, schemaIDOrderable);
        return (TriggerDescriptor)this.getDescriptorViaIndex(1, keyRow, null, ti, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericDescriptorList getTriggerDescriptors(TableDescriptor td) throws StandardException {
        GenericDescriptorList gdl;
        if (td == null) {
            return this.getAllTriggerDescriptors();
        }
        GenericDescriptorList genericDescriptorList = gdl = td.getTriggerDescriptorList();
        synchronized (genericDescriptorList) {
            if (!gdl.getScanned()) {
                this.getTriggerDescriptorsScan(td, false);
            }
        }
        return gdl;
    }

    private void getTriggerDescriptorsScan(TableDescriptor td, boolean forUpdate) throws StandardException {
        GenericDescriptorList gdl = td.getTriggerDescriptorList();
        SQLChar tableIDOrderable = null;
        TabInfoImpl ti = this.getNonCoreTI(13);
        tableIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(td.getUUID());
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, tableIDOrderable);
        this.getDescriptorViaIndex(2, keyRow, null, ti, null, gdl, forUpdate);
        gdl.setScanned(true);
    }

    public void dropTriggerDescriptor(TriggerDescriptor descriptor, TransactionController tc) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(13);
        SQLChar idOrderable = DataDictionaryImpl.getIDValueAsCHAR(descriptor.getUUID());
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, idOrderable);
        ti.deleteRow(tc, keyRow, 0);
    }

    public void updateTriggerDescriptor(TriggerDescriptor triggerd, UUID formerUUID, int[] colsToSet, TransactionController tc) throws StandardException {
        ExecIndexRow keyRow1 = null;
        TabInfoImpl ti = this.getNonCoreTI(13);
        SYSTRIGGERSRowFactory rf = (SYSTRIGGERSRowFactory)ti.getCatalogRowFactory();
        SQLChar IDOrderable = DataDictionaryImpl.getIDValueAsCHAR(formerUUID);
        keyRow1 = this.exFactory.getIndexableRow(1);
        keyRow1.setColumn(1, IDOrderable);
        ExecRow row = rf.makeRow(triggerd, null);
        SanityManager.ASSERT(rf.getNumIndexes() == 3, "There are more indexes on systriggers than expected, the code herein needs to change");
        boolean[] bArray = new boolean[3];
        if (colsToSet == null) {
            bArray[0] = true;
            bArray[1] = true;
            bArray[2] = true;
        } else {
            block5: for (int i = 0; i < colsToSet.length; ++i) {
                switch (colsToSet[i]) {
                    case 1: {
                        bArray[0] = true;
                        continue block5;
                    }
                    case 2: 
                    case 3: {
                        bArray[1] = true;
                        continue block5;
                    }
                    case 9: {
                        bArray[2] = true;
                    }
                }
            }
        }
        ti.updateRow(keyRow1, row, 0, bArray, colsToSet, tc);
    }

    public ConstraintDescriptor getConstraintDescriptor(UUID uuid) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(4);
        SQLChar UUIDStringOrderable = DataDictionaryImpl.getIDValueAsCHAR(uuid);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, UUIDStringOrderable);
        return this.getConstraintDescriptorViaIndex(0, keyRow, ti, null, null, false);
    }

    public ConstraintDescriptor getConstraintDescriptor(String constraintName, UUID schemaID) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(4);
        SQLVarchar constraintNameOrderable = new SQLVarchar(constraintName);
        SQLChar UUIDStringOrderable = DataDictionaryImpl.getIDValueAsCHAR(schemaID);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(2);
        keyRow.setColumn(1, constraintNameOrderable);
        keyRow.setColumn(2, UUIDStringOrderable);
        return this.getConstraintDescriptorViaIndex(1, keyRow, ti, null, null, false);
    }

    public List getStatisticsDescriptors(TableDescriptor td) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(14);
        List statDescriptorList = DataDictionaryImpl.newSList();
        SQLChar UUIDStringOrderable = DataDictionaryImpl.getIDValueAsCHAR(td.getUUID());
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, UUIDStringOrderable);
        this.getDescriptorViaIndex(0, keyRow, null, ti, null, statDescriptorList, false);
        return statDescriptorList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintDescriptorList getConstraintDescriptors(TableDescriptor td) throws StandardException {
        ConstraintDescriptorList cdl;
        if (td == null) {
            return this.getAllConstraintDescriptors();
        }
        ConstraintDescriptorList constraintDescriptorList = cdl = td.getConstraintDescriptorList();
        synchronized (constraintDescriptorList) {
            if (!cdl.getScanned()) {
                this.getConstraintDescriptorsScan(td, false);
            }
        }
        return cdl;
    }

    public ConstraintDescriptorList getActiveConstraintDescriptors(ConstraintDescriptorList cdl) throws StandardException {
        return cdl;
    }

    public boolean activeConstraint(ConstraintDescriptor constraint) throws StandardException {
        return true;
    }

    public ConstraintDescriptor getConstraintDescriptor(TableDescriptor td, UUID uuid) throws StandardException {
        return this.getConstraintDescriptors(td).getConstraintDescriptor(uuid);
    }

    public ConstraintDescriptor getConstraintDescriptorById(TableDescriptor td, UUID uuid) throws StandardException {
        return this.getConstraintDescriptors(td).getConstraintDescriptorById(uuid);
    }

    public ConstraintDescriptor getConstraintDescriptorByName(TableDescriptor td, SchemaDescriptor sd, String constraintName, boolean forUpdate) throws StandardException {
        if (forUpdate) {
            td.emptyConstraintDescriptorList();
            this.getConstraintDescriptorsScan(td, true);
        }
        return this.getConstraintDescriptors(td).getConstraintDescriptorByName(sd, constraintName);
    }

    private void getConstraintDescriptorsScan(TableDescriptor td, boolean forUpdate) throws StandardException {
        ConstraintDescriptorList cdl = td.getConstraintDescriptorList();
        SQLChar tableIDOrderable = null;
        TabInfoImpl ti = this.getNonCoreTI(4);
        tableIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(td.getUUID());
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, tableIDOrderable);
        this.getConstraintDescriptorViaIndex(2, keyRow, ti, td, cdl, forUpdate);
        cdl.setScanned(true);
    }

    protected ConstraintDescriptor getConstraintDescriptorViaIndex(int indexId, ExecIndexRow keyRow, TabInfoImpl ti, TableDescriptor td, ConstraintDescriptorList dList, boolean forUpdate) throws StandardException {
        SYSCONSTRAINTSRowFactory rf = (SYSCONSTRAINTSRowFactory)ti.getCatalogRowFactory();
        ConstraintDescriptor cd = null;
        TransactionController tc = this.getTransactionCompile();
        ExecRow outRow = rf.makeEmptyRow();
        ConglomerateController heapCC = tc.openConglomerate(ti.getHeapConglomerate(), false, 0, 6, 4);
        ScanController scanController = tc.openScan(ti.getIndexConglomerate(indexId), false, forUpdate ? 4 : 0, 6, 4, null, keyRow.getRowArray(), 1, null, keyRow.getRowArray(), -1);
        while (scanController.next()) {
            SubConstraintDescriptor subCD = null;
            ExecIndexRow indexRow1 = DataDictionaryImpl.getIndexRowFromHeapRow(ti.getIndexRowGenerator(indexId), heapCC.newRowLocationTemplate(), outRow);
            scanController.fetch(indexRow1.getRowArray());
            RowLocation baseRowLocation = (RowLocation)indexRow1.getColumn(indexRow1.nColumns());
            boolean base_row_exists = heapCC.fetch(baseRowLocation, outRow.getRowArray(), null);
            SanityManager.ASSERT(base_row_exists, "base row doesn't exist");
            switch (rf.getConstraintType(outRow)) {
                case 2: 
                case 3: 
                case 6: {
                    subCD = this.getSubKeyConstraint(rf.getConstraintId(outRow), rf.getConstraintType(outRow));
                    break;
                }
                case 4: {
                    subCD = this.getSubCheckConstraint(rf.getConstraintId(outRow));
                    break;
                }
                default: {
                    SanityManager.THROWASSERT("unexpected value from rf.getConstraintType(outRow)" + rf.getConstraintType(outRow));
                }
            }
            SanityManager.ASSERT(subCD != null, "subCD is expected to be non-null");
            subCD.setTableDescriptor(td);
            cd = (ConstraintDescriptor)rf.buildDescriptor(outRow, subCD, this);
            if (dList == null) break;
            dList.add(cd);
        }
        scanController.close();
        heapCC.close();
        return cd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TupleDescriptor getConstraintDescriptorViaHeap(ScanQualifier[][] scanQualifiers, TabInfoImpl ti, TupleDescriptor parentTupleDescriptor, List list) throws StandardException {
        SYSCONSTRAINTSRowFactory rf = (SYSCONSTRAINTSRowFactory)ti.getCatalogRowFactory();
        ConstraintDescriptor cd = null;
        TransactionController tc = this.getTransactionCompile();
        ExecRow outRow = rf.makeEmptyRow();
        ScanController scanController = tc.openScan(ti.getHeapConglomerate(), false, 0, 7, 4, null, null, 0, scanQualifiers, null, 0);
        try {
            while (scanController.fetchNext(outRow.getRowArray())) {
                SubConstraintDescriptor subCD = null;
                switch (rf.getConstraintType(outRow)) {
                    case 2: 
                    case 3: 
                    case 6: {
                        subCD = this.getSubKeyConstraint(rf.getConstraintId(outRow), rf.getConstraintType(outRow));
                        break;
                    }
                    case 4: {
                        subCD = this.getSubCheckConstraint(rf.getConstraintId(outRow));
                        break;
                    }
                    default: {
                        SanityManager.THROWASSERT("unexpected value from  rf.getConstraintType(outRow) " + rf.getConstraintType(outRow));
                    }
                }
                SanityManager.ASSERT(subCD != null, "subCD is expected to be non-null");
                cd = (ConstraintDescriptor)rf.buildDescriptor(outRow, subCD, this);
                if (list == null) {
                    break;
                }
                list.add(cd);
            }
        }
        finally {
            scanController.close();
        }
        return cd;
    }

    public TableDescriptor getConstraintTableDescriptor(UUID constraintId) throws StandardException {
        List slist = this.getConstraints(constraintId, 0, 2);
        if (slist.size() == 0) {
            return null;
        }
        return this.getTableDescriptor((UUID)slist.get(0));
    }

    public ConstraintDescriptorList getForeignKeys(UUID constraintId) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(10);
        List fkList = DataDictionaryImpl.newSList();
        SQLChar constraintIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(constraintId);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, constraintIDOrderable);
        this.getDescriptorViaIndex(1, keyRow, null, ti, null, fkList, false);
        ConstraintDescriptorList cdl = new ConstraintDescriptorList();
        Iterator iterator = fkList.iterator();
        while (iterator.hasNext()) {
            SubKeyConstraintDescriptor cd = (SubKeyConstraintDescriptor)iterator.next();
            TableDescriptor td = this.getConstraintTableDescriptor(cd.getUUID());
            cdl.add(this.getConstraintDescriptors(td).getConstraintDescriptorById(cd.getUUID()));
        }
        return cdl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getConstraints(UUID uuid, int indexId, int columnNum) throws StandardException {
        ConglomerateController heapCC = null;
        GenericScanController scanController = null;
        TabInfoImpl ti = this.getNonCoreTI(4);
        SYSCONSTRAINTSRowFactory rf = (SYSCONSTRAINTSRowFactory)ti.getCatalogRowFactory();
        Object td = null;
        List slist = DataDictionaryImpl.newSList();
        SanityManager.ASSERT(indexId == 0 || indexId == 2, "bad index id, must be one of the indexes on a uuid");
        SanityManager.ASSERT(columnNum > 0 && columnNum <= 7, "invalid column number for column to be retrieved");
        try {
            SQLChar orderable = DataDictionaryImpl.getIDValueAsCHAR(uuid);
            ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
            keyRow.setColumn(1, orderable);
            TransactionController tc = this.getTransactionCompile();
            ExecRow outRow = rf.makeEmptyRow();
            heapCC = tc.openConglomerate(ti.getHeapConglomerate(), false, 0, 6, 4);
            ExecIndexRow indexRow1 = DataDictionaryImpl.getIndexRowFromHeapRow(ti.getIndexRowGenerator(indexId), heapCC.newRowLocationTemplate(), outRow);
            DataValueDescriptor[] rowTemplate = new DataValueDescriptor[7];
            FormatableBitSet columnToGetSet = new FormatableBitSet(7);
            columnToGetSet.set(columnNum - 1);
            rowTemplate[columnNum - 1] = new SQLChar();
            scanController = tc.openScan(ti.getIndexConglomerate(indexId), false, 0, 6, 4, null, keyRow.getRowArray(), 1, null, keyRow.getRowArray(), -1);
            while (scanController.fetchNext(indexRow1.getRowArray())) {
                RowLocation baseRowLocation = (RowLocation)indexRow1.getColumn(indexRow1.nColumns());
                boolean base_row_exists = heapCC.fetch(baseRowLocation, rowTemplate, columnToGetSet);
                SanityManager.ASSERT(base_row_exists, "base row not found");
                slist.add(this.uuidFactory.recreateUUID((String)rowTemplate[columnNum - 1].getObject()));
            }
        }
        finally {
            if (heapCC != null) {
                heapCC.close();
            }
            if (scanController != null) {
                scanController.close();
            }
        }
        return slist;
    }

    public void addConstraintDescriptor(ConstraintDescriptor descriptor, TransactionController tc) throws StandardException {
        Object row = null;
        int type = descriptor.getConstraintType();
        TabInfoImpl ti = this.getNonCoreTI(4);
        SYSCONSTRAINTSRowFactory rf = (SYSCONSTRAINTSRowFactory)ti.getCatalogRowFactory();
        if (type != 2 && type != 6 && type != 3 && type != 4) {
            SanityManager.THROWASSERT("constraint type (" + type + ") is unexpected value");
        }
        this.addDescriptor(descriptor, descriptor.getSchemaDescriptor(), 4, false, tc);
        switch (type) {
            case 2: 
            case 3: 
            case 6: {
                if (!(descriptor instanceof KeyConstraintDescriptor)) {
                    SanityManager.THROWASSERT("descriptor expected to be instanceof KeyConstraintDescriptor, not, " + descriptor.getClass().getName());
                }
                this.addSubKeyConstraint((KeyConstraintDescriptor)descriptor, tc);
                break;
            }
            case 4: {
                if (!(descriptor instanceof CheckConstraintDescriptor)) {
                    SanityManager.THROWASSERT("descriptor expected to be instanceof CheckConstraintDescriptorImpl, not, " + descriptor.getClass().getName());
                }
                this.addDescriptor(descriptor, null, 9, true, tc);
            }
        }
    }

    public void updateConstraintDescriptor(ConstraintDescriptor cd, UUID formerUUID, int[] colsToSet, TransactionController tc) throws StandardException {
        ExecIndexRow keyRow1 = null;
        TabInfoImpl ti = this.getNonCoreTI(4);
        SYSCONSTRAINTSRowFactory rf = (SYSCONSTRAINTSRowFactory)ti.getCatalogRowFactory();
        SQLChar IDOrderable = DataDictionaryImpl.getIDValueAsCHAR(formerUUID);
        keyRow1 = this.exFactory.getIndexableRow(1);
        keyRow1.setColumn(1, IDOrderable);
        ExecRow row = rf.makeRow(cd, null);
        SanityManager.ASSERT(rf.getNumIndexes() == 3, "There are more indexes on sysconstraints than expected, the code herein needs to change");
        boolean[] bArray = new boolean[3];
        if (colsToSet == null) {
            bArray[0] = true;
            bArray[1] = true;
            bArray[2] = true;
        } else {
            block5: for (int i = 0; i < colsToSet.length; ++i) {
                switch (colsToSet[i]) {
                    case 1: {
                        bArray[0] = true;
                        continue block5;
                    }
                    case 3: 
                    case 5: {
                        bArray[1] = true;
                        continue block5;
                    }
                    case 2: {
                        bArray[2] = true;
                    }
                }
            }
        }
        ti.updateRow(keyRow1, row, 0, bArray, colsToSet, tc);
    }

    public void dropConstraintDescriptor(ConstraintDescriptor descriptor, TransactionController tc) throws StandardException {
        ExecIndexRow keyRow = null;
        TabInfoImpl ti = this.getNonCoreTI(4);
        switch (descriptor.getConstraintType()) {
            case 2: 
            case 3: 
            case 6: {
                this.dropSubKeyConstraint(descriptor, tc);
                break;
            }
            case 4: {
                this.dropSubCheckConstraint(descriptor.getUUID(), tc);
            }
        }
        SQLVarchar constraintNameOrderable = new SQLVarchar(descriptor.getConstraintName());
        SQLChar schemaIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(descriptor.getSchemaDescriptor().getUUID());
        keyRow = this.exFactory.getIndexableRow(2);
        keyRow.setColumn(1, constraintNameOrderable);
        keyRow.setColumn(2, schemaIDOrderable);
        ti.deleteRow(tc, keyRow, 1);
    }

    public void dropAllConstraintDescriptors(TableDescriptor table, TransactionController tc) throws StandardException {
        ConstraintDescriptorList cdl = this.getConstraintDescriptors(table);
        Iterator iterator = cdl.iterator();
        while (iterator.hasNext()) {
            ConstraintDescriptor cd = (ConstraintDescriptor)iterator.next();
            this.dropConstraintDescriptor(cd, tc);
        }
        table.setConstraintDescriptorList(null);
    }

    public SubKeyConstraintDescriptor getSubKeyConstraint(UUID constraintId, int type) throws StandardException {
        int indexNum;
        int baseNum;
        SQLChar constraintIDOrderable = null;
        if (type == 6) {
            baseNum = 10;
            indexNum = 0;
        } else {
            baseNum = 5;
            indexNum = 0;
        }
        TabInfoImpl ti = this.getNonCoreTI(baseNum);
        constraintIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(constraintId);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, constraintIDOrderable);
        return (SubKeyConstraintDescriptor)this.getDescriptorViaIndex(indexNum, keyRow, null, ti, null, null, false);
    }

    private void addSubKeyConstraint(KeyConstraintDescriptor descriptor, TransactionController tc) throws StandardException {
        ExecRow row;
        TabInfoImpl ti;
        if (descriptor.getConstraintType() == 6) {
            ForeignKeyConstraintDescriptor fkDescriptor = (ForeignKeyConstraintDescriptor)descriptor;
            if (!(descriptor instanceof ForeignKeyConstraintDescriptor)) {
                SanityManager.THROWASSERT("descriptor not an fk descriptor, is " + descriptor.getClass().getName());
            }
            ti = this.getNonCoreTI(10);
            SYSFOREIGNKEYSRowFactory fkkeysRF = (SYSFOREIGNKEYSRowFactory)ti.getCatalogRowFactory();
            row = fkkeysRF.makeRow(fkDescriptor, null);
            ReferencedKeyConstraintDescriptor refDescriptor = fkDescriptor.getReferencedConstraint();
            refDescriptor.incrementReferenceCount();
            int[] colsToSet = new int[]{7};
            this.updateConstraintDescriptor(refDescriptor, refDescriptor.getUUID(), colsToSet, tc);
        } else {
            ti = this.getNonCoreTI(5);
            SYSKEYSRowFactory keysRF = (SYSKEYSRowFactory)ti.getCatalogRowFactory();
            row = keysRF.makeRow(descriptor, null);
        }
        ti.insertRow(row, tc);
    }

    private void dropSubKeyConstraint(ConstraintDescriptor constraint, TransactionController tc) throws StandardException {
        int indexNum;
        int baseNum;
        ExecIndexRow keyRow1 = null;
        if (constraint.getConstraintType() == 6) {
            ReferencedKeyConstraintDescriptor refDescriptor;
            baseNum = 10;
            indexNum = 0;
            if (constraint.getConstraintType() == 6 && (refDescriptor = (ReferencedKeyConstraintDescriptor)this.getConstraintDescriptor(((ForeignKeyConstraintDescriptor)constraint).getReferencedConstraintId())) != null) {
                refDescriptor.decrementReferenceCount();
                int[] colsToSet = new int[]{7};
                this.updateConstraintDescriptor(refDescriptor, refDescriptor.getUUID(), colsToSet, tc);
            }
        } else {
            baseNum = 5;
            indexNum = 0;
        }
        TabInfoImpl ti = this.getNonCoreTI(baseNum);
        SQLChar constraintIdOrderable = DataDictionaryImpl.getIDValueAsCHAR(constraint.getUUID());
        keyRow1 = this.exFactory.getIndexableRow(1);
        keyRow1.setColumn(1, constraintIdOrderable);
        ti.deleteRow(tc, keyRow1, indexNum);
    }

    private SubCheckConstraintDescriptor getSubCheckConstraint(UUID constraintId) throws StandardException {
        SQLChar constraintIDOrderable = null;
        TabInfoImpl ti = this.getNonCoreTI(9);
        SYSCHECKSRowFactory rf = (SYSCHECKSRowFactory)ti.getCatalogRowFactory();
        constraintIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(constraintId);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, constraintIDOrderable);
        return (SubCheckConstraintDescriptor)this.getDescriptorViaIndex(0, keyRow, null, ti, null, null, false);
    }

    private void dropSubCheckConstraint(UUID constraintId, TransactionController tc) throws StandardException {
        ExecIndexRow checkRow1 = null;
        TabInfoImpl ti = this.getNonCoreTI(9);
        SQLChar constraintIdOrderable = DataDictionaryImpl.getIDValueAsCHAR(constraintId);
        checkRow1 = this.exFactory.getIndexableRow(1);
        checkRow1.setColumn(1, constraintIdOrderable);
        ti.deleteRow(tc, checkRow1, 0);
    }

    public Hashtable hashAllConglomerateDescriptorsByNumber(TransactionController tc) throws StandardException {
        Hashtable<Long, ConglomerateDescriptor> ht = new Hashtable<Long, ConglomerateDescriptor>();
        ConglomerateDescriptor cd = null;
        TabInfoImpl ti = this.coreInfo[0];
        SYSCONGLOMERATESRowFactory rf = (SYSCONGLOMERATESRowFactory)ti.getCatalogRowFactory();
        ExecRow outRow = rf.makeEmptyRow();
        ScanController scanController = tc.openScan(ti.getHeapConglomerate(), false, 0, 6, 1, null, null, 1, null, null, -1);
        while (scanController.fetchNext(outRow.getRowArray())) {
            cd = (ConglomerateDescriptor)rf.buildDescriptor(outRow, null, this);
            Long hashKey = new Long(cd.getConglomerateNumber());
            ht.put(hashKey, cd);
        }
        scanController.close();
        return ht;
    }

    public Hashtable hashAllTableDescriptorsByTableId(TransactionController tc) throws StandardException {
        Hashtable<UUID, TableDescriptor> ht = new Hashtable<UUID, TableDescriptor>();
        TabInfoImpl ti = this.coreInfo[1];
        SYSTABLESRowFactory rf = (SYSTABLESRowFactory)ti.getCatalogRowFactory();
        ExecRow outRow = rf.makeEmptyRow();
        ScanController scanController = tc.openScan(ti.getHeapConglomerate(), false, 0, 6, 1, null, null, 1, null, null, -1);
        while (scanController.fetchNext(outRow.getRowArray())) {
            TableDescriptor td = (TableDescriptor)rf.buildDescriptor(outRow, null, this, 1);
            ht.put(td.getUUID(), td);
        }
        scanController.close();
        return ht;
    }

    public ConglomerateDescriptor getConglomerateDescriptor(UUID uuid) throws StandardException {
        ConglomerateDescriptor[] cds = this.getConglomerateDescriptors(uuid);
        if (cds.length == 0) {
            return null;
        }
        return cds[0];
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(UUID uuid) throws StandardException {
        TabInfoImpl ti = this.coreInfo[0];
        SQLChar UUIDStringOrderable = DataDictionaryImpl.getIDValueAsCHAR(uuid);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, UUIDStringOrderable);
        List cdl = DataDictionaryImpl.newSList();
        this.getDescriptorViaIndex(0, keyRow, null, ti, null, cdl, false);
        ConglomerateDescriptor[] cda = new ConglomerateDescriptor[cdl.size()];
        cdl.toArray(cda);
        return cda;
    }

    public ConglomerateDescriptor getConglomerateDescriptor(long conglomerateNumber) throws StandardException {
        ConglomerateDescriptor[] cds = this.getConglomerateDescriptors(conglomerateNumber);
        if (cds.length == 0) {
            return null;
        }
        return cds[0];
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(long conglomerateNumber) throws StandardException {
        NumberDataValue conglomNumberOrderable = null;
        TabInfoImpl ti = this.coreInfo[0];
        SYSCONGLOMERATESRowFactory rf = (SYSCONGLOMERATESRowFactory)ti.getCatalogRowFactory();
        conglomNumberOrderable = this.dvf.getDataValue(conglomerateNumber);
        ScanQualifier[][] scanQualifier = this.exFactory.getScanQualifier(1);
        scanQualifier[0][0].setQualifier(3 - 1, conglomNumberOrderable, 2, false, false, false);
        ConglomerateDescriptorList cdl = new ConglomerateDescriptorList();
        this.getDescriptorViaHeap(scanQualifier, ti, null, cdl);
        int size = cdl.size();
        ConglomerateDescriptor[] cda = new ConglomerateDescriptor[size];
        for (int index = 0; index < size; ++index) {
            cda[index] = (ConglomerateDescriptor)cdl.get(index);
        }
        return cda;
    }

    private void getConglomerateDescriptorsScan(TableDescriptor td) throws StandardException {
        ConglomerateDescriptorList cdl = td.getConglomerateDescriptorList();
        ExecIndexRow keyRow3 = null;
        TabInfoImpl ti = this.coreInfo[0];
        SQLChar tableIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(td.getUUID());
        keyRow3 = this.exFactory.getIndexableRow(1);
        keyRow3.setColumn(1, tableIDOrderable);
        this.getDescriptorViaIndex(2, keyRow3, null, ti, null, cdl, false);
    }

    public ConglomerateDescriptor getConglomerateDescriptor(String indexName, SchemaDescriptor sd, boolean forUpdate) throws StandardException {
        ExecIndexRow keyRow2 = null;
        SQLChar schemaIDOrderable = null;
        TabInfoImpl ti = this.coreInfo[0];
        SQLVarchar nameOrderable = new SQLVarchar(indexName);
        schemaIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(sd.getUUID());
        keyRow2 = this.exFactory.getIndexableRow(2);
        keyRow2.setColumn(1, nameOrderable);
        keyRow2.setColumn(2, schemaIDOrderable);
        return (ConglomerateDescriptor)this.getDescriptorViaIndex(1, keyRow2, null, ti, null, null, forUpdate);
    }

    public void dropConglomerateDescriptor(ConglomerateDescriptor conglomerate, TransactionController tc) throws StandardException {
        ExecIndexRow keyRow2 = null;
        SQLChar schemaIDOrderable = null;
        TabInfoImpl ti = this.coreInfo[0];
        SQLVarchar nameOrderable = new SQLVarchar(conglomerate.getConglomerateName());
        schemaIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(conglomerate.getSchemaID());
        keyRow2 = this.exFactory.getIndexableRow(2);
        keyRow2.setColumn(1, nameOrderable);
        keyRow2.setColumn(2, schemaIDOrderable);
        ti.deleteRow(tc, keyRow2, 1);
    }

    public void dropAllConglomerateDescriptors(TableDescriptor td, TransactionController tc) throws StandardException {
        ExecIndexRow keyRow3 = null;
        TabInfoImpl ti = this.coreInfo[0];
        SQLChar tableIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(td.getUUID());
        keyRow3 = this.exFactory.getIndexableRow(1);
        keyRow3.setColumn(1, tableIDOrderable);
        ti.deleteRow(tc, keyRow3, 2);
    }

    public void updateConglomerateDescriptor(ConglomerateDescriptor cd, long conglomerateNumber, TransactionController tc) throws StandardException {
        ConglomerateDescriptor[] cds = new ConglomerateDescriptor[]{cd};
        this.updateConglomerateDescriptor(cds, conglomerateNumber, tc);
    }

    public void updateSystemSchemaAuthorization(String aid, TransactionController tc) throws StandardException {
        this.updateSchemaAuth("SYS", aid, tc);
        this.updateSchemaAuth("SYSIBM", aid, tc);
        this.updateSchemaAuth("SYSCAT", aid, tc);
        this.updateSchemaAuth("SYSFUN", aid, tc);
        this.updateSchemaAuth("SYSPROC", aid, tc);
        this.updateSchemaAuth("SYSSTAT", aid, tc);
        this.updateSchemaAuth("NULLID", aid, tc);
        this.updateSchemaAuth("SQLJ", aid, tc);
        this.updateSchemaAuth("SYSCS_DIAG", aid, tc);
        this.updateSchemaAuth("SYSCS_UTIL", aid, tc);
        this.resetDatabaseOwner(tc);
    }

    public void updateSchemaAuth(String schemaName, String authorizationId, TransactionController tc) throws StandardException {
        TabInfoImpl ti = this.coreInfo[3];
        SQLVarchar schemaNameOrderable = new SQLVarchar(schemaName);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, schemaNameOrderable);
        SYSSCHEMASRowFactory rf = (SYSSCHEMASRowFactory)ti.getCatalogRowFactory();
        ExecRow row = rf.makeEmptyRow();
        row.setColumn(3, new SQLVarchar(authorizationId));
        boolean[] bArray = new boolean[]{false, false};
        int[] colsToUpdate = new int[]{3};
        ti.updateRow(keyRow, row, 0, bArray, colsToUpdate, tc);
    }

    public void updateConglomerateDescriptor(ConglomerateDescriptor[] cds, long conglomerateNumber, TransactionController tc) throws StandardException {
        ExecIndexRow keyRow1 = null;
        TabInfoImpl ti = this.coreInfo[0];
        SYSCONGLOMERATESRowFactory rf = (SYSCONGLOMERATESRowFactory)ti.getCatalogRowFactory();
        boolean[] bArray = new boolean[]{false, false, false};
        for (int i = 0; i < cds.length; ++i) {
            SQLChar conglomIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(cds[i].getUUID());
            keyRow1 = this.exFactory.getIndexableRow(1);
            keyRow1.setColumn(1, conglomIDOrderable);
            cds[i].setConglomerateNumber(conglomerateNumber);
            ExecRow row = rf.makeRow(cds[i], null);
            ti.updateRow(keyRow1, row, 0, bArray, (int[])null, tc);
        }
    }

    public List getDependentsDescriptorList(String dependentID) throws StandardException {
        List ddlList = DataDictionaryImpl.newSList();
        TabInfoImpl ti = this.getNonCoreTI(6);
        SQLChar dependentIDOrderable = new SQLChar(dependentID);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, dependentIDOrderable);
        this.getDescriptorViaIndex(0, keyRow, null, ti, null, ddlList, false);
        return ddlList;
    }

    public List getProvidersDescriptorList(String providerID) throws StandardException {
        List ddlList = DataDictionaryImpl.newSList();
        TabInfoImpl ti = this.getNonCoreTI(6);
        SQLChar providerIDOrderable = new SQLChar(providerID);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, providerIDOrderable);
        this.getDescriptorViaIndex(1, keyRow, null, ti, null, ddlList, false);
        return ddlList;
    }

    public List getAllDependencyDescriptorsList() throws StandardException {
        List ddl = DataDictionaryImpl.newSList();
        TabInfoImpl ti = this.getNonCoreTI(6);
        SYSDEPENDSRowFactory rf = (SYSDEPENDSRowFactory)ti.getCatalogRowFactory();
        TransactionController tc = this.getTransactionCompile();
        ExecRow outRow = rf.makeEmptyRow();
        ScanController scanController = tc.openScan(ti.getHeapConglomerate(), false, 0, 7, 4, null, null, 1, null, null, -1);
        while (scanController.fetchNext(outRow.getRowArray())) {
            DependencyDescriptor dependencyDescriptor = (DependencyDescriptor)rf.buildDescriptor(outRow, null, this);
            ddl.add(dependencyDescriptor);
        }
        scanController.close();
        return ddl;
    }

    public void dropStoredDependency(DependencyDescriptor dd, TransactionController tc) throws StandardException {
        ExecIndexRow keyRow1 = null;
        UUID dependentID = dd.getUUID();
        UUID providerID = dd.getProviderID();
        SQLChar dependentIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(dependentID);
        TabInfoImpl ti = this.getNonCoreTI(6);
        keyRow1 = this.exFactory.getIndexableRow(1);
        keyRow1.setColumn(1, dependentIDOrderable);
        DropDependencyFilter filter = new DropDependencyFilter(providerID);
        ti.deleteRows(tc, keyRow1, 1, null, filter, keyRow1, -1, 0);
    }

    public void dropDependentsStoredDependencies(UUID dependentsUUID, TransactionController tc) throws StandardException {
        this.dropDependentsStoredDependencies(dependentsUUID, tc, true);
    }

    public void dropDependentsStoredDependencies(UUID dependentsUUID, TransactionController tc, boolean wait) throws StandardException {
        ExecIndexRow keyRow1 = null;
        TabInfoImpl ti = this.getNonCoreTI(6);
        SQLChar dependentIDOrderable = DataDictionaryImpl.getIDValueAsCHAR(dependentsUUID);
        keyRow1 = this.exFactory.getIndexableRow(1);
        keyRow1.setColumn(1, dependentIDOrderable);
        ti.deleteRow(tc, keyRow1, 0, wait);
    }

    public UUIDFactory getUUIDFactory() {
        return this.uuidFactory;
    }

    public AliasDescriptor getAliasDescriptor(UUID uuid) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(7);
        SYSALIASESRowFactory rf = (SYSALIASESRowFactory)ti.getCatalogRowFactory();
        SQLChar UUIDStringOrderable = DataDictionaryImpl.getIDValueAsCHAR(uuid);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, UUIDStringOrderable);
        return (AliasDescriptor)this.getDescriptorViaIndex(1, keyRow, null, ti, null, null, false);
    }

    public AliasDescriptor getAliasDescriptor(String schemaId, String aliasName, char nameSpace) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(7);
        SYSALIASESRowFactory rf = (SYSALIASESRowFactory)ti.getCatalogRowFactory();
        SQLVarchar aliasNameOrderable = new SQLVarchar(aliasName);
        char[] charArray = new char[]{nameSpace};
        SQLChar nameSpaceOrderable = new SQLChar(new String(charArray));
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(3);
        keyRow.setColumn(1, new SQLChar(schemaId));
        keyRow.setColumn(2, aliasNameOrderable);
        keyRow.setColumn(3, nameSpaceOrderable);
        return (AliasDescriptor)this.getDescriptorViaIndex(0, keyRow, null, ti, null, null, false);
    }

    public List getRoutineList(String schemaID, String routineName, char nameSpace) throws StandardException {
        ArrayList<AliasDescriptor> list = new ArrayList<AliasDescriptor>();
        if (schemaID.equals("c013800d-00fb-2642-07ec-000000134f30") && nameSpace == 'F') {
            for (int f = 0; f < SYSFUN_FUNCTIONS.length; ++f) {
                String[] details = SYSFUN_FUNCTIONS[f];
                String name = details[0];
                if (!name.equals(routineName)) continue;
                AliasDescriptor ad = SYSFUN_AD[f];
                if (ad == null) {
                    TypeDescriptor rt = DataTypeDescriptor.getBuiltInDataTypeDescriptor(details[1]).getCatalogType();
                    boolean isDeterministic = Boolean.valueOf(details[4]);
                    int paramCount = details.length - 5;
                    TypeDescriptor[] pt = new TypeDescriptor[paramCount];
                    String[] paramNames = new String[paramCount];
                    int[] paramModes = new int[paramCount];
                    for (int i = 0; i < paramCount; ++i) {
                        pt[i] = DataTypeDescriptor.getBuiltInDataTypeDescriptor(details[5 + i]).getCatalogType();
                        paramNames[i] = "P" + (i + 1);
                        paramModes[i] = 1;
                    }
                    RoutineAliasInfo ai = new RoutineAliasInfo(details[3], paramCount, paramNames, pt, paramModes, 0, 0, 3, isDeterministic, false, rt);
                    DataDictionaryImpl.SYSFUN_AD[f] = ad = new AliasDescriptor(this, this.uuidFactory.createUUID(), name, this.uuidFactory.recreateUUID(schemaID), details[2], 'F', 'F', true, ai, null);
                }
                list.add(ad);
            }
            return list;
        }
        AliasDescriptor ad = this.getAliasDescriptor(schemaID, routineName, nameSpace);
        if (ad != null) {
            list.add(ad);
        }
        return list;
    }

    public void dropAliasDescriptor(AliasDescriptor ad, TransactionController tc) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(7);
        char[] charArray = new char[]{ad.getNameSpace()};
        ExecIndexRow keyRow1 = this.exFactory.getIndexableRow(3);
        keyRow1.setColumn(1, DataDictionaryImpl.getIDValueAsCHAR(ad.getSchemaUUID()));
        keyRow1.setColumn(2, new SQLVarchar(ad.getDescriptorName()));
        keyRow1.setColumn(3, new SQLChar(new String(charArray)));
        ti.deleteRow(tc, keyRow1, 0);
    }

    protected void loadDictionaryTables(TransactionController tc, DataDescriptorGenerator ddg, Properties startParams) throws StandardException {
        this.loadCatalogs(ddg, this.coreInfo);
        this.dictionaryVersion = (DD_Version)tc.getProperty("DataDictionaryVersion");
        this.resetDatabaseOwner(tc);
        this.softwareVersion.upgradeIfNeeded(this.dictionaryVersion, tc, startParams);
    }

    public void resetDatabaseOwner(TransactionController tc) throws StandardException {
        SchemaDescriptor sd = this.locateSchemaRow("SYSIBM", tc);
        this.authorizationDatabaseOwner = sd.getAuthorizationId();
    }

    public void loadCatalogs(DataDescriptorGenerator ddg, TabInfoImpl[] catalogArray) throws StandardException {
        int catalogCount = catalogArray.length;
        for (int ictr = 0; ictr < catalogCount; ++ictr) {
            TabInfoImpl catalog = catalogArray[ictr];
            int numIndexes = catalog.getNumberOfIndexes();
            if (numIndexes <= 0) continue;
            for (int indexCtr = 0; indexCtr < numIndexes; ++indexCtr) {
                this.initSystemIndexVariables(ddg, catalog, indexCtr);
            }
        }
    }

    protected void createDictionaryTables(Properties params, TransactionController tc, DataDescriptorGenerator ddg) throws StandardException {
        TabInfoImpl ti;
        this.systemSchemaDesc = this.newSystemSchemaDesc("SYS", "8000000d-00d0-fd77-3ed8-000a0a0b1900");
        for (int coreCtr = 0; coreCtr < 4; ++coreCtr) {
            ti = this.coreInfo[coreCtr];
            Properties heapProperties = ti.getCreateHeapProperties();
            ti.setHeapConglomerate(this.createConglomerate(ti.getTableName(), tc, ti.getCatalogRowFactory().makeEmptyRow(), heapProperties));
            if (this.coreInfo[coreCtr].getNumberOfIndexes() <= 0) continue;
            this.bootStrapSystemIndexes(this.systemSchemaDesc, tc, ddg, ti);
        }
        for (int ictr = 0; ictr < 4; ++ictr) {
            ti = this.coreInfo[ictr];
            this.addSystemTableToDictionary(ti, this.systemSchemaDesc, tc, ddg);
        }
        params.put(CFG_SYSTABLES_ID, Long.toString(this.coreInfo[1].getHeapConglomerate()));
        SYSTABLESRowFactory cfr_ignored_0 = (SYSTABLESRowFactory)this.coreInfo[1].getCatalogRowFactory();
        params.put(CFG_SYSTABLES_INDEX1_ID, Long.toString(this.coreInfo[1].getIndexConglomerate(0)));
        SYSTABLESRowFactory cfr_ignored_1 = (SYSTABLESRowFactory)this.coreInfo[1].getCatalogRowFactory();
        params.put(CFG_SYSTABLES_INDEX2_ID, Long.toString(this.coreInfo[1].getIndexConglomerate(1)));
        params.put(CFG_SYSCOLUMNS_ID, Long.toString(this.coreInfo[2].getHeapConglomerate()));
        SYSCOLUMNSRowFactory cfr_ignored_2 = (SYSCOLUMNSRowFactory)this.coreInfo[2].getCatalogRowFactory();
        params.put(CFG_SYSCOLUMNS_INDEX1_ID, Long.toString(this.coreInfo[2].getIndexConglomerate(0)));
        SYSCOLUMNSRowFactory cfr_ignored_3 = (SYSCOLUMNSRowFactory)this.coreInfo[2].getCatalogRowFactory();
        params.put(CFG_SYSCOLUMNS_INDEX2_ID, Long.toString(this.coreInfo[2].getIndexConglomerate(1)));
        params.put(CFG_SYSCONGLOMERATES_ID, Long.toString(this.coreInfo[0].getHeapConglomerate()));
        SYSCONGLOMERATESRowFactory cfr_ignored_4 = (SYSCONGLOMERATESRowFactory)this.coreInfo[0].getCatalogRowFactory();
        params.put(CFG_SYSCONGLOMERATES_INDEX1_ID, Long.toString(this.coreInfo[0].getIndexConglomerate(0)));
        SYSCONGLOMERATESRowFactory cfr_ignored_5 = (SYSCONGLOMERATESRowFactory)this.coreInfo[0].getCatalogRowFactory();
        params.put(CFG_SYSCONGLOMERATES_INDEX2_ID, Long.toString(this.coreInfo[0].getIndexConglomerate(1)));
        SYSCONGLOMERATESRowFactory cfr_ignored_6 = (SYSCONGLOMERATESRowFactory)this.coreInfo[0].getCatalogRowFactory();
        params.put(CFG_SYSCONGLOMERATES_INDEX3_ID, Long.toString(this.coreInfo[0].getIndexConglomerate(2)));
        params.put(CFG_SYSSCHEMAS_ID, Long.toString(this.coreInfo[3].getHeapConglomerate()));
        SYSSCHEMASRowFactory cfr_ignored_7 = (SYSSCHEMASRowFactory)this.coreInfo[3].getCatalogRowFactory();
        params.put(CFG_SYSSCHEMAS_INDEX1_ID, Long.toString(this.coreInfo[3].getIndexConglomerate(0)));
        SYSSCHEMASRowFactory cfr_ignored_8 = (SYSSCHEMASRowFactory)this.coreInfo[3].getCatalogRowFactory();
        params.put(CFG_SYSSCHEMAS_INDEX2_ID, Long.toString(this.coreInfo[3].getIndexConglomerate(1)));
        this.sysIBMSchemaDesc = this.addSystemSchema("SYSIBM", "c013800d-00f8-5b53-28a9-00000019ed88", tc);
        for (int noncoreCtr = 0; noncoreCtr < NUM_NONCORE; ++noncoreCtr) {
            int catalogNumber = noncoreCtr + 4;
            boolean isDummy = catalogNumber == 15;
            TabInfoImpl ti2 = this.getNonCoreTIByNumber(catalogNumber);
            this.makeCatalog(ti2, isDummy ? this.sysIBMSchemaDesc : this.systemSchemaDesc, tc);
            if (isDummy) {
                this.populateSYSDUMMY1(tc);
            }
            this.clearNoncoreTable(noncoreCtr);
        }
        this.addDescriptor(this.systemSchemaDesc, null, 3, false, tc);
        this.addSystemSchema("SYSCAT", "c013800d-00fb-2641-07ec-000000134f30", tc);
        this.addSystemSchema("SYSFUN", "c013800d-00fb-2642-07ec-000000134f30", tc);
        this.addSystemSchema("SYSPROC", "c013800d-00fb-2643-07ec-000000134f30", tc);
        this.addSystemSchema("SYSSTAT", "c013800d-00fb-2644-07ec-000000134f30", tc);
        this.addSystemSchema("NULLID", "c013800d-00fb-2647-07ec-000000134f30", tc);
        this.addSystemSchema("SQLJ", "c013800d-00fb-2648-07ec-000000134f30", tc);
        this.addSystemSchema("SYSCS_DIAG", "c013800d-00fb-2646-07ec-000000134f30", tc);
        this.addSystemSchema("SYSCS_UTIL", "c013800d-00fb-2649-07ec-000000134f30", tc);
        SchemaDescriptor appSchemaDesc = new SchemaDescriptor(this, "APP", "APP", this.uuidFactory.recreateUUID("80000000-00d2-b38f-4cda-000a0a412c00"), false);
        this.addDescriptor(appSchemaDesc, null, 3, false, tc);
    }

    private SchemaDescriptor addSystemSchema(String schema_name, String schema_uuid, TransactionController tc) throws StandardException {
        SchemaDescriptor schema_desc = new SchemaDescriptor(this, schema_name, this.authorizationDatabaseOwner, this.uuidFactory.recreateUUID(schema_uuid), true);
        this.addDescriptor(schema_desc, null, 3, false, tc);
        return schema_desc;
    }

    protected void upgradeMakeCatalog(TransactionController tc, int catalogNumber) throws StandardException {
        TabInfoImpl ti = catalogNumber >= 4 ? this.getNonCoreTIByNumber(catalogNumber) : this.coreInfo[catalogNumber];
        this.makeCatalog(ti, catalogNumber == 15 ? this.getSysIBMSchemaDescriptor() : this.getSystemSchemaDescriptor(), tc);
    }

    public void makeCatalog(TabInfoImpl ti, SchemaDescriptor sd, TransactionController tc) throws StandardException {
        DataDescriptorGenerator ddg = this.getDataDescriptorGenerator();
        Properties heapProperties = ti.getCreateHeapProperties();
        ti.setHeapConglomerate(this.createConglomerate(ti.getTableName(), tc, ti.getCatalogRowFactory().makeEmptyRow(), heapProperties));
        if (ti.getNumberOfIndexes() > 0) {
            this.bootStrapSystemIndexes(sd, tc, ddg, ti);
        }
        this.addSystemTableToDictionary(ti, sd, tc, ddg);
    }

    public void upgradeFixSystemColumnDefinition(CatalogRowFactory rowFactory, int columnNumber, TransactionController tc) throws StandardException {
        SystemColumn[] columns = rowFactory.buildColumnList();
        SchemaDescriptor sd = this.getSystemSchemaDescriptor();
        TableDescriptor td = this.getTableDescriptor(rowFactory.getCatalogName(), sd, tc);
        SystemColumn theColumn = columns[columnNumber - 1];
        ColumnDescriptor cd = this.makeColumnDescriptor(theColumn, columnNumber, td);
        String columnName = cd.getColumnName();
        int[] columnNameColArray = new int[]{4};
        this.updateColumnDescriptor(cd, td.getUUID(), columnName, columnNameColArray, tc);
    }

    public void upgrade_addColumns(CatalogRowFactory rowFactory, int[] newColumnIDs, TransactionController tc) throws StandardException {
        long conglomID;
        TableDescriptor td;
        SystemColumn[] columns = rowFactory.buildColumnList();
        ExecRow templateRow = rowFactory.makeEmptyRow();
        int columnCount = newColumnIDs.length;
        SchemaDescriptor sd = this.getSystemSchemaDescriptor();
        if (rowFactory instanceof SYSTABLESRowFactory) {
            td = this.dataDescriptorGenerator.newTableDescriptor("SYSTABLES", sd, 0, 'R');
            td.setUUID(this.getUUIDForCoreTable("SYSTABLES", sd.getUUID().toString(), tc));
            conglomID = this.coreInfo[1].getHeapConglomerate();
        } else if (rowFactory instanceof SYSCOLUMNSRowFactory) {
            td = this.dataDescriptorGenerator.newTableDescriptor("SYSCOLUMNS", sd, 0, 'R');
            td.setUUID(this.getUUIDForCoreTable("SYSCOLUMNS", sd.getUUID().toString(), tc));
            conglomID = this.coreInfo[2].getHeapConglomerate();
        } else {
            td = this.getTableDescriptor(rowFactory.getCatalogName(), sd, tc);
            conglomID = td.getHeapConglomerateId();
        }
        this.widenConglomerate(templateRow, newColumnIDs, conglomID, tc);
        TupleDescriptor[] cdArray = new ColumnDescriptor[columnCount];
        for (int ix = 0; ix < columnCount; ++ix) {
            int columnID = newColumnIDs[ix];
            SystemColumn currentColumn = columns[columnID - 1];
            cdArray[ix] = this.makeColumnDescriptor(currentColumn, ix + 1, td);
        }
        this.addDescriptorArray(cdArray, td, 2, false, tc);
    }

    public void upgrade_addInvisibleColumns(CatalogRowFactory rowFactory, int[] newColumnIDs, TransactionController tc) throws StandardException {
        ExecRow templateRow = rowFactory.makeEmptyRow();
        SchemaDescriptor sd = this.getSystemSchemaDescriptor();
        long conglomID = this.getTableDescriptor(rowFactory.getCatalogName(), sd, tc).getHeapConglomerateId();
        this.widenConglomerate(templateRow, newColumnIDs, conglomID, tc);
    }

    private void widenConglomerate(ExecRow templateRow, int[] newColumnIDs, long conglomID, TransactionController tc) throws StandardException {
        int columnCount = newColumnIDs.length;
        for (int ix = 0; ix < columnCount; ++ix) {
            int columnID = newColumnIDs[ix];
            int storablePosition = columnID - 1;
            tc.addColumnToConglomerate(conglomID, storablePosition, templateRow.getColumn(columnID), 0);
        }
    }

    public long upgrade_makeOneIndex(TransactionController tc, TabInfoImpl ti, int indexNumber, long heapConglomerateNumber) throws StandardException {
        SchemaDescriptor sd = this.getSystemSchemaDescriptor();
        DataDescriptorGenerator ddg = this.getDataDescriptorGenerator();
        ConglomerateDescriptor conglomerateDescriptor = this.bootstrapOneIndex(sd, tc, ddg, ti, indexNumber, heapConglomerateNumber);
        long indexConglomerateNumber = conglomerateDescriptor.getConglomerateNumber();
        this.addDescriptor(conglomerateDescriptor, sd, 0, false, tc);
        return indexConglomerateNumber;
    }

    private UUID getUUIDForCoreTable(String tableName, String schemaUUID, TransactionController tc) throws StandardException {
        TabInfoImpl ti = this.coreInfo[1];
        SYSTABLESRowFactory rf = (SYSTABLESRowFactory)ti.getCatalogRowFactory();
        ExecRow row = this.exFactory.getValueRow(1);
        SQLVarchar tableNameOrderable = new SQLVarchar(tableName);
        SQLChar schemaIDOrderable = new SQLChar(schemaUUID);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(2);
        keyRow.setColumn(1, tableNameOrderable);
        keyRow.setColumn(2, schemaIDOrderable);
        ConglomerateController heapCC = tc.openConglomerate(ti.getHeapConglomerate(), false, 0, 6, 4);
        ExecIndexRow indexTemplateRow = rf.buildEmptyIndexRow(0, heapCC.newRowLocationTemplate());
        ScanController scanController = tc.openScan(ti.getIndexConglomerate(0), false, 0, 6, 4, null, keyRow.getRowArray(), 1, null, keyRow.getRowArray(), -1);
        if (scanController.fetchNext(indexTemplateRow.getRowArray())) {
            RowLocation baseRowLocation = (RowLocation)indexTemplateRow.getColumn(indexTemplateRow.nColumns());
            row.setColumn(1, new SQLChar());
            FormatableBitSet bi = new FormatableBitSet(1);
            bi.set(0);
            boolean base_row_exists = heapCC.fetch(baseRowLocation, row.getRowArray(), null);
            SanityManager.ASSERT(base_row_exists, "base row not found");
        }
        scanController.close();
        heapCC.close();
        return this.uuidFactory.recreateUUID(row.getColumn(1).toString());
    }

    void upgrade_initSystemTableCols(TransactionController tc, boolean isCoreTable, int tableNum, FormatableBitSet columnsToUpdateSet, DataValueDescriptor[] replaceRow) throws StandardException {
        TabInfoImpl ti;
        TabInfoImpl tabInfoImpl = ti = isCoreTable ? this.coreInfo[tableNum] : this.getNonCoreTIByNumber(tableNum);
        if (!isCoreTable) {
            this.faultInTabInfo(ti);
        }
        ScanController sc = tc.openScan(ti.getHeapConglomerate(), false, 4, 7, 4, RowUtil.EMPTY_ROW_BITSET, null, 0, null, null, 0);
        while (sc.next()) {
            sc.replace(replaceRow, columnsToUpdateSet);
        }
        sc.close();
    }

    private void bootStrapSystemIndexes(SchemaDescriptor sd, TransactionController tc, DataDescriptorGenerator ddg, TabInfoImpl ti) throws StandardException {
        int indexCtr;
        ConglomerateDescriptor[] cgd = new ConglomerateDescriptor[ti.getNumberOfIndexes()];
        for (indexCtr = 0; indexCtr < ti.getNumberOfIndexes(); ++indexCtr) {
            cgd[indexCtr] = this.bootstrapOneIndex(sd, tc, ddg, ti, indexCtr, ti.getHeapConglomerate());
        }
        for (indexCtr = 0; indexCtr < ti.getNumberOfIndexes(); ++indexCtr) {
            this.addDescriptor(cgd[indexCtr], sd, 0, false, tc);
        }
    }

    public RowLocation[] computeAutoincRowLocations(TransactionController tc, TableDescriptor td) throws StandardException {
        if (!td.tableHasAutoincrement()) {
            return null;
        }
        int size = td.getNumberOfColumns();
        RowLocation[] rla = new RowLocation[size];
        for (int i = 0; i < size; ++i) {
            ColumnDescriptor cd = td.getColumnDescriptor(i + 1);
            if (!cd.isAutoincrement()) continue;
            rla[i] = this.computeRowLocation(tc, td, cd.getColumnName());
        }
        return rla;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberDataValue getSetAutoincrementValue(RowLocation rl, TransactionController tc, boolean doUpdate, NumberDataValue newValue, boolean wait) throws StandardException {
        FormatableBitSet columnToUpdate = new FormatableBitSet(9);
        int columnNum = 7;
        TabInfoImpl ti = this.coreInfo[2];
        ConglomerateController heapCC = null;
        SYSCOLUMNSRowFactory rf = (SYSCOLUMNSRowFactory)ti.getCatalogRowFactory();
        ExecRow row = rf.makeEmptyRow();
        FormatableBitSet columnToRead = new FormatableBitSet(9);
        columnToRead.set(columnNum - 1);
        columnToRead.set(columnNum);
        columnToRead.set(columnNum + 1);
        try {
            heapCC = tc.openConglomerate(ti.getHeapConglomerate(), false, 4 | (wait ? 0 : 128), 6, 4);
            boolean baseRowExists = heapCC.fetch(rl, row.getRowArray(), columnToRead, wait);
            columnToUpdate.set(columnNum - 1);
            NumberDataValue currentAI = (NumberDataValue)row.getColumn(columnNum);
            long currentAIValue = currentAI.getLong();
            NumberDataValue increment = (NumberDataValue)row.getColumn(columnNum + 2);
            if (doUpdate) {
                currentAI = currentAI.plus(currentAI, increment, currentAI);
                row.setColumn(columnNum, currentAI);
                heapCC.replace(rl, row.getRowArray(), columnToUpdate);
            }
            if (newValue != null) {
                newValue.setValue(currentAIValue);
                NumberDataValue numberDataValue = newValue;
                return numberDataValue;
            }
            currentAI.setValue(currentAIValue);
            NumberDataValue numberDataValue = currentAI;
            return numberDataValue;
        }
        finally {
            if (heapCC != null) {
                heapCC.close();
            }
        }
    }

    private ConglomerateDescriptor bootstrapOneIndex(SchemaDescriptor sd, TransactionController tc, DataDescriptorGenerator ddg, TabInfoImpl ti, int indexNumber, long heapConglomerateNumber) throws StandardException {
        CatalogRowFactory rf = ti.getCatalogRowFactory();
        this.initSystemIndexVariables(ddg, ti, indexNumber);
        IndexRowGenerator irg = ti.getIndexRowGenerator(indexNumber);
        int numColumns = ti.getIndexColumnCount(indexNumber);
        boolean isUnique = ti.isIndexUnique(indexNumber);
        ExecIndexRow indexableRow = irg.getIndexRowTemplate();
        ExecRow baseRow = rf.makeEmptyRow();
        ConglomerateController cc = tc.openConglomerate(heapConglomerateNumber, false, 0, 6, 4);
        RowLocation rl = cc.newRowLocationTemplate();
        cc.close();
        irg.getIndexRow(baseRow, rl, indexableRow, null);
        Properties indexProperties = ti.getCreateIndexProperties(indexNumber);
        indexProperties.put("baseConglomerateId", Long.toString(heapConglomerateNumber));
        indexProperties.put("nUniqueColumns", Integer.toString(isUnique ? numColumns : numColumns + 1));
        indexProperties.put("rowLocationColumn", Integer.toString(numColumns));
        indexProperties.put("nKeyFields", Integer.toString(numColumns + 1));
        long conglomId = tc.createConglomerate("BTREE", indexableRow.getRowArray(), null, null, indexProperties, 0);
        ConglomerateDescriptor conglomerateDescriptor = ddg.newConglomerateDescriptor(conglomId, rf.getIndexName(indexNumber), true, irg, false, rf.getCanonicalIndexUUID(indexNumber), rf.getCanonicalTableUUID(), sd.getUUID());
        ti.setIndexConglomerate(conglomerateDescriptor);
        return conglomerateDescriptor;
    }

    public void initSystemIndexVariables(DataDescriptorGenerator ddg, TabInfoImpl ti, int indexNumber) throws StandardException {
        int numCols = ti.getIndexColumnCount(indexNumber);
        int[] baseColumnPositions = new int[numCols];
        CatalogRowFactory rf = ti.getCatalogRowFactory();
        for (int colCtr = 0; colCtr < numCols; ++colCtr) {
            baseColumnPositions[colCtr] = ti.getBaseColumnPosition(indexNumber, colCtr);
        }
        boolean[] isAscending = new boolean[baseColumnPositions.length];
        for (int i = 0; i < baseColumnPositions.length; ++i) {
            isAscending[i] = true;
        }
        IndexRowGenerator irg = null;
        irg = this.softwareVersion.checkVersion(160, null) ? new IndexRowGenerator("BTREE", ti.isIndexUnique(indexNumber), false, baseColumnPositions, isAscending, baseColumnPositions.length) : new IndexRowGenerator("BTREE", ti.isIndexUnique(indexNumber), baseColumnPositions, isAscending, baseColumnPositions.length);
        ti.setIndexRowGenerator(indexNumber, irg);
    }

    protected void populateSYSDUMMY1(TransactionController tc) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(15);
        ExecRow row = ti.getCatalogRowFactory().makeRow(null, null);
        int insertRetCode = ti.insertRow(row, tc);
    }

    public void clearCaches() throws StandardException {
        this.nameTdCache.cleanAll();
        this.nameTdCache.ageOut();
        this.OIDTdCache.cleanAll();
        this.OIDTdCache.ageOut();
        if (this.spsNameCache != null) {
            this.spsNameCache.cleanAll();
            this.spsNameCache.ageOut();
            this.spsIdHash.clear();
        }
    }

    private void addSystemTableToDictionary(TabInfoImpl ti, SchemaDescriptor sd, TransactionController tc, DataDescriptorGenerator ddg) throws StandardException {
        CatalogRowFactory crf = ti.getCatalogRowFactory();
        String name = ti.getTableName();
        long conglomId = ti.getHeapConglomerate();
        SystemColumn[] columnList = crf.buildColumnList();
        UUID heapUUID = crf.getCanonicalHeapUUID();
        String heapName = crf.getCanonicalHeapName();
        int columnCount = columnList.length;
        TableDescriptor td = ddg.newTableDescriptor(name, sd, 1, 'R');
        td.setUUID(crf.getCanonicalTableUUID());
        this.addDescriptor(td, sd, 1, false, tc);
        UUID toid = td.getUUID();
        ConglomerateDescriptor cgd = ddg.newConglomerateDescriptor(conglomId, heapName, false, null, false, heapUUID, toid, sd.getUUID());
        this.addDescriptor(cgd, sd, 0, false, tc);
        TupleDescriptor[] cdlArray = new ColumnDescriptor[columnCount];
        for (int columnNumber = 0; columnNumber < columnCount; ++columnNumber) {
            SystemColumn column = columnList[columnNumber];
            if (column == null) {
                SanityManager.THROWASSERT("column " + columnNumber + " for table " + ti.getTableName() + " is null");
            }
            cdlArray[columnNumber] = this.makeColumnDescriptor(column, columnNumber + 1, td);
        }
        this.addDescriptorArray(cdlArray, td, 2, false, tc);
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        for (int i = 0; i < columnCount; ++i) {
            cdl.add(cdlArray[i]);
        }
    }

    private ColumnDescriptor makeColumnDescriptor(SystemColumn column, int columnPosition, TableDescriptor td) throws StandardException {
        return new ColumnDescriptor(column.getName(), columnPosition, column.getType(), null, null, td, null, 0L, 0L);
    }

    private long createConglomerate(String name, TransactionController tc, ExecRow rowTemplate, Properties properties) throws StandardException {
        long conglomId = tc.createConglomerate("heap", rowTemplate.getRowArray(), null, null, properties, 0);
        return conglomId;
    }

    private static SQLChar getIDValueAsCHAR(UUID uuid) {
        String uuidString = uuid.toString();
        return new SQLChar(uuidString);
    }

    public void initializeCatalogInfo() throws StandardException {
        this.initializeCoreInfo();
        this.initializeNoncoreInfo();
    }

    private void initializeCoreInfo() throws StandardException {
        this.coreInfo = new TabInfoImpl[4];
        TabInfoImpl[] lcoreInfo = this.coreInfo;
        UUIDFactory luuidFactory = this.uuidFactory;
        lcoreInfo[1] = new TabInfoImpl(new SYSTABLESRowFactory(luuidFactory, this.exFactory, this.dvf));
        lcoreInfo[2] = new TabInfoImpl(new SYSCOLUMNSRowFactory(luuidFactory, this.exFactory, this.dvf));
        lcoreInfo[0] = new TabInfoImpl(new SYSCONGLOMERATESRowFactory(luuidFactory, this.exFactory, this.dvf));
        lcoreInfo[3] = new TabInfoImpl(new SYSSCHEMASRowFactory(luuidFactory, this.exFactory, this.dvf));
    }

    private void initializeNoncoreInfo() throws StandardException {
        this.noncoreInfo = new TabInfoImpl[NUM_NONCORE];
    }

    public TransactionController getTransactionCompile() throws StandardException {
        if (this.bootingTC != null) {
            SanityManager.ASSERT(this.booting, "booting is expected to be true");
            return this.bootingTC;
        }
        SanityManager.ASSERT(!this.booting, "booting is expected to be false");
        LanguageConnectionContext lcc = DataDictionaryImpl.getLCC();
        return lcc.getTransactionCompile();
    }

    public TransactionController getTransactionExecute() throws StandardException {
        if (this.bootingTC != null) {
            SanityManager.ASSERT(this.booting, "booting is expected to be true");
            return this.bootingTC;
        }
        SanityManager.ASSERT(!this.booting, "booting is expected to be false");
        LanguageConnectionContext lcc = DataDictionaryImpl.getLCC();
        return lcc.getTransactionExecute();
    }

    private final TupleDescriptor getDescriptorViaIndex(int indexId, ExecIndexRow keyRow, ScanQualifier[][] scanQualifiers, TabInfoImpl ti, TupleDescriptor parentTupleDescriptor, List list, boolean forUpdate) throws StandardException {
        TransactionController tc = this.getTransactionCompile();
        return this.getDescriptorViaIndexMinion(indexId, keyRow, scanQualifiers, ti, parentTupleDescriptor, list, forUpdate, 4, tc);
    }

    private final TupleDescriptor getDescriptorViaIndex(int indexId, ExecIndexRow keyRow, ScanQualifier[][] scanQualifiers, TabInfoImpl ti, TupleDescriptor parentTupleDescriptor, List list, boolean forUpdate, TransactionController tc) throws StandardException {
        if (tc == null) {
            tc = this.getTransactionCompile();
        }
        return this.getDescriptorViaIndexMinion(indexId, keyRow, scanQualifiers, ti, parentTupleDescriptor, list, forUpdate, 4, tc);
    }

    private final TupleDescriptor getDescriptorViaIndex(int indexId, ExecIndexRow keyRow, ScanQualifier[][] scanQualifiers, TabInfoImpl ti, TupleDescriptor parentTupleDescriptor, List list, boolean forUpdate, int isolationLevel, TransactionController tc) throws StandardException {
        if (tc == null) {
            tc = this.getTransactionCompile();
        }
        return this.getDescriptorViaIndexMinion(indexId, keyRow, scanQualifiers, ti, parentTupleDescriptor, list, forUpdate, isolationLevel, tc);
    }

    private final TupleDescriptor getDescriptorViaIndexMinion(int indexId, ExecIndexRow keyRow, ScanQualifier[][] scanQualifiers, TabInfoImpl ti, TupleDescriptor parentTupleDescriptor, List list, boolean forUpdate, int isolationLevel, TransactionController tc) throws StandardException {
        ExecIndexRow indexRow1;
        CatalogRowFactory rf = ti.getCatalogRowFactory();
        TupleDescriptor td = null;
        SanityManager.ASSERT(isolationLevel == 4 || isolationLevel == 1);
        if (isolationLevel == 1) {
            SanityManager.ASSERT(list == null);
        }
        ExecRow outRow = rf.makeEmptyRow();
        ConglomerateController heapCC = tc.openConglomerate(ti.getHeapConglomerate(), false, 0, 6, isolationLevel);
        ScanController scanController = tc.openScan(ti.getIndexConglomerate(indexId), false, forUpdate ? 4 : 0, 6, isolationLevel, null, keyRow.getRowArray(), 1, scanQualifiers, keyRow.getRowArray(), -1);
        while (scanController.fetchNext((indexRow1 = DataDictionaryImpl.getIndexRowFromHeapRow(ti.getIndexRowGenerator(indexId), heapCC.newRowLocationTemplate(), outRow)).getRowArray())) {
            RowLocation baseRowLocation = (RowLocation)indexRow1.getColumn(indexRow1.nColumns());
            boolean base_row_exists = false;
            try {
                base_row_exists = heapCC.fetch(baseRowLocation, outRow.getRowArray(), null);
            }
            catch (RuntimeException re) {
                if (re instanceof AssertFailure) {
                    StringBuffer strbuf = new StringBuffer("Error retrieving base row in table " + ti.getTableName());
                    strbuf.append(": An ASSERT was thrown when trying to locate a row matching index row " + indexRow1 + " from index " + ti.getIndexName(indexId) + ", conglom number " + ti.getIndexConglomerate(indexId));
                    this.debugGenerateInfo(strbuf, tc, heapCC, ti, indexId);
                }
                throw re;
            }
            catch (StandardException se) {
                if (se.getSQLState().equals("XSRS9")) {
                    StringBuffer strbuf = new StringBuffer("Error retrieving base row in table " + ti.getTableName());
                    strbuf.append(": A StandardException was thrown when trying to locate a row matching index row " + indexRow1 + " from index " + ti.getIndexName(indexId) + ", conglom number " + ti.getIndexConglomerate(indexId));
                    this.debugGenerateInfo(strbuf, tc, heapCC, ti, indexId);
                }
                throw se;
            }
            if (!base_row_exists && isolationLevel == 4) {
                StringBuffer strbuf = new StringBuffer("Error retrieving base row in table " + ti.getTableName());
                strbuf.append(": could not locate a row matching index row " + indexRow1 + " from index " + ti.getIndexName(indexId) + ", conglom number " + ti.getIndexConglomerate(indexId));
                this.debugGenerateInfo(strbuf, tc, heapCC, ti, indexId);
                System.exit(1);
            }
            td = !base_row_exists && isolationLevel == 1 ? null : rf.buildDescriptor(outRow, parentTupleDescriptor, this);
            if (list == null) break;
            list.add(td);
        }
        scanController.close();
        heapCC.close();
        return td;
    }

    private void debugGenerateInfo(StringBuffer strbuf, TransactionController tc, ConglomerateController heapCC, TabInfoImpl ti, int indexId) {
        try {
            strbuf.append("\nadditional information: ");
            LanguageConnectionContext lcc = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
            if (lcc != null) {
                long currentTime = System.currentTimeMillis();
                Enumeration lockTable = this.lockFactory.makeVirtualLockTable();
                String lockTableString = Timeout.buildString(lockTable, currentTime);
                strbuf.append("lock table at time of failure\n\n");
                strbuf.append(lockTableString);
            }
            ConglomerateController btreeCC = tc.openConglomerate(ti.getIndexConglomerate(indexId), false, 0, 6, 4);
            btreeCC.debugConglomerate();
            heapCC.debugConglomerate();
            heapCC.checkConsistency();
            strbuf.append("\nheapCC.checkConsistency() = true");
            ConglomerateController indexCC = tc.openConglomerate(ti.getIndexConglomerate(indexId), false, 0, 7, 4);
            indexCC.checkConsistency();
            strbuf.append("\nindexCC.checkConsistency() = true");
            System.err.println("ASSERT FAILURE: " + strbuf.toString());
            System.out.println("ASSERT FAILURE: " + strbuf.toString());
            SanityManager.DEBUG_PRINT("ASSERT FAILURE", strbuf.toString());
        }
        catch (StandardException se) {
            strbuf.append("\ngot the following error when doing extra consistency checks:\n" + se.toString());
        }
    }

    protected TupleDescriptor getDescriptorViaHeap(ScanQualifier[][] scanQualifiers, TabInfoImpl ti, TupleDescriptor parentTupleDescriptor, List list) throws StandardException {
        CatalogRowFactory rf = ti.getCatalogRowFactory();
        TupleDescriptor td = null;
        TransactionController tc = this.getTransactionCompile();
        ExecRow outRow = rf.makeEmptyRow();
        ScanController scanController = tc.openScan(ti.getHeapConglomerate(), false, 0, 7, 4, null, null, 0, scanQualifiers, null, 0);
        while (scanController.fetchNext(outRow.getRowArray())) {
            td = rf.buildDescriptor(outRow, parentTupleDescriptor, this);
            if (list == null) break;
            list.add(td);
        }
        scanController.close();
        return td;
    }

    private TabInfoImpl getNonCoreTI(int catalogNumber) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTIByNumber(catalogNumber);
        this.faultInTabInfo(ti);
        return ti;
    }

    protected TabInfoImpl getNonCoreTIByNumber(int catalogNumber) throws StandardException {
        int nonCoreNum = catalogNumber - 4;
        TabInfoImpl retval = this.noncoreInfo[nonCoreNum];
        if (retval == null) {
            UUIDFactory luuidFactory = this.uuidFactory;
            switch (catalogNumber) {
                case 4: {
                    retval = new TabInfoImpl(new SYSCONSTRAINTSRowFactory(luuidFactory, this.exFactory, this.dvf));
                    break;
                }
                case 5: {
                    retval = new TabInfoImpl(new SYSKEYSRowFactory(luuidFactory, this.exFactory, this.dvf));
                    break;
                }
                case 6: {
                    retval = new TabInfoImpl(new SYSDEPENDSRowFactory(luuidFactory, this.exFactory, this.dvf));
                    break;
                }
                case 8: {
                    retval = new TabInfoImpl(new SYSVIEWSRowFactory(luuidFactory, this.exFactory, this.dvf));
                    break;
                }
                case 9: {
                    retval = new TabInfoImpl(new SYSCHECKSRowFactory(luuidFactory, this.exFactory, this.dvf));
                    break;
                }
                case 10: {
                    retval = new TabInfoImpl(new SYSFOREIGNKEYSRowFactory(luuidFactory, this.exFactory, this.dvf));
                    break;
                }
                case 11: {
                    retval = new TabInfoImpl(new SYSSTATEMENTSRowFactory(luuidFactory, this.exFactory, this.dvf));
                    break;
                }
                case 12: {
                    retval = new TabInfoImpl(new SYSFILESRowFactory(luuidFactory, this.exFactory, this.dvf));
                    break;
                }
                case 7: {
                    retval = new TabInfoImpl(new SYSALIASESRowFactory(luuidFactory, this.exFactory, this.dvf));
                    break;
                }
                case 13: {
                    retval = new TabInfoImpl(new SYSTRIGGERSRowFactory(luuidFactory, this.exFactory, this.dvf));
                    break;
                }
                case 14: {
                    retval = new TabInfoImpl(new SYSSTATISTICSRowFactory(luuidFactory, this.exFactory, this.dvf));
                    break;
                }
                case 15: {
                    retval = new TabInfoImpl(new SYSDUMMY1RowFactory(luuidFactory, this.exFactory, this.dvf));
                    break;
                }
                case 16: {
                    retval = new TabInfoImpl(new SYSTABLEPERMSRowFactory(luuidFactory, this.exFactory, this.dvf));
                    break;
                }
                case 17: {
                    retval = new TabInfoImpl(new SYSCOLPERMSRowFactory(luuidFactory, this.exFactory, this.dvf));
                    break;
                }
                case 18: {
                    retval = new TabInfoImpl(new SYSROUTINEPERMSRowFactory(luuidFactory, this.exFactory, this.dvf));
                    break;
                }
                case 19: {
                    retval = new TabInfoImpl(new SYSROLESRowFactory(luuidFactory, this.exFactory, this.dvf));
                }
            }
            this.initSystemIndexVariables(retval);
            this.noncoreInfo[nonCoreNum] = retval;
        }
        return retval;
    }

    protected void initSystemIndexVariables(TabInfoImpl ti) throws StandardException {
        int numIndexes = ti.getNumberOfIndexes();
        if (numIndexes > 0) {
            DataDescriptorGenerator ddg = this.getDataDescriptorGenerator();
            for (int indexCtr = 0; indexCtr < numIndexes; ++indexCtr) {
                this.initSystemIndexVariables(ddg, ti, indexCtr);
            }
        }
    }

    private void clearNoncoreTable(int nonCoreNum) {
        this.noncoreInfo[nonCoreNum] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void faultInTabInfo(TabInfoImpl ti) throws StandardException {
        if (ti.isComplete()) {
            return;
        }
        TabInfoImpl tabInfoImpl = ti;
        synchronized (tabInfoImpl) {
            int numIndexes;
            if (ti.isComplete()) {
                return;
            }
            TableDescriptor td = this.getTableDescriptor(ti.getTableName(), this.getSystemSchemaDescriptor(), null);
            if (td == null) {
                return;
            }
            ConglomerateDescriptor cd = null;
            ConglomerateDescriptor[] cds = td.getConglomerateDescriptors();
            for (int index = 0; index < cds.length; ++index) {
                cd = cds[index];
                if (cd.isIndex()) continue;
                ti.setHeapConglomerate(cd.getConglomerateNumber());
                break;
            }
            if (cd == null) {
                SanityManager.THROWASSERT("No heap conglomerate found for " + ti.getTableName());
            }
            if ((numIndexes = ti.getCatalogRowFactory().getNumIndexes()) == 0) {
                return;
            }
            ConglomerateDescriptor icd = null;
            int indexCount = 0;
            for (int index = 0; index < cds.length; ++index) {
                icd = cds[index];
                if (!icd.isIndex()) continue;
                ti.setIndexConglomerate(icd);
                ++indexCount;
            }
            if (indexCount != ti.getCatalogRowFactory().getNumIndexes()) {
                SanityManager.THROWASSERT("Number of indexes found (" + indexCount + ") does not match the number expected (" + ti.getCatalogRowFactory().getNumIndexes() + ")");
            }
        }
    }

    public static ExecIndexRow getIndexRowFromHeapRow(IndexRowGenerator irg, RowLocation rl, ExecRow heapRow) throws StandardException {
        ExecIndexRow indexRow = irg.getIndexRowTemplate();
        irg.getIndexRow(heapRow, rl, indexRow, null);
        return indexRow;
    }

    public int getEngineType() {
        return this.engineType;
    }

    public long getSYSCOLUMNSHeapConglomerateNumber() {
        return this.coreInfo[2].getHeapConglomerate();
    }

    void addSYSCOLUMNSIndex2Property(TransactionController tc, long index2ConglomerateNumber) {
        this.startupParameters.put(CFG_SYSCOLUMNS_INDEX2_ID, Long.toString(index2ConglomerateNumber));
    }

    private long getBootParameter(Properties startParams, String key, boolean required) throws StandardException {
        String value = startParams.getProperty(key);
        if (value == null) {
            if (!required) {
                return -1L;
            }
            throw StandardException.newException("XCY03.S", key);
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("XCY00.S", (Object)key, (Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSystemSQLName() {
        StringBuffer generatedSystemSQLName = new StringBuffer("SQL");
        DataDictionaryImpl dataDictionaryImpl = this;
        synchronized (dataDictionaryImpl) {
            long timeNow = System.currentTimeMillis() / 10L * 10L;
            if (timeNow > this.timeForLastSystemSQLName) {
                this.systemSQLNameNumber = 0;
                this.calendarForLastSystemSQLName.setTimeInMillis(timeNow);
                this.timeForLastSystemSQLName = timeNow;
            } else {
                ++this.systemSQLNameNumber;
                if (this.systemSQLNameNumber == 10) {
                    this.systemSQLNameNumber = 0;
                    this.timeForLastSystemSQLName += 10L;
                    this.calendarForLastSystemSQLName.setTimeInMillis(this.timeForLastSystemSQLName);
                }
            }
            generatedSystemSQLName.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(1)));
            generatedSystemSQLName.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(2) + 1));
            generatedSystemSQLName.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(5)));
            generatedSystemSQLName.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(11)));
            generatedSystemSQLName.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(12)));
            generatedSystemSQLName.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(13)));
            generatedSystemSQLName.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(14) / 10));
            generatedSystemSQLName.append(this.systemSQLNameNumber);
        }
        return generatedSystemSQLName.toString();
    }

    private static String twoDigits(int val) {
        String retval;
        if (val < 10) {
            retval = "0" + val;
        } else {
            int retvalLength = Integer.toString(val).length();
            retval = Integer.toString(val).substring(retvalLength - 2);
        }
        return retval;
    }

    public void setAutoincrementValue(TransactionController tc, UUID tableUUID, String columnName, long aiValue, boolean incrementNeeded) throws StandardException {
        TabInfoImpl ti = this.coreInfo[2];
        ExecIndexRow keyRow = null;
        keyRow = this.exFactory.getIndexableRow(2);
        keyRow.setColumn(1, DataDictionaryImpl.getIDValueAsCHAR(tableUUID));
        keyRow.setColumn(2, new SQLChar(columnName));
        SYSCOLUMNSRowFactory rf = (SYSCOLUMNSRowFactory)ti.getCatalogRowFactory();
        ExecRow row = rf.makeEmptyRow();
        boolean[] bArray = new boolean[2];
        for (int index = 0; index < 2; ++index) {
            bArray[index] = false;
        }
        int[] colsToUpdate = new int[]{7};
        if (incrementNeeded) {
            ExecRow readRow = ti.getRow(tc, keyRow, 0);
            NumberDataValue increment = (NumberDataValue)readRow.getColumn(9);
            aiValue += increment.getLong();
        }
        row.setColumn(7, this.dvf.getDataValue(aiValue));
        ti.updateRow(keyRow, row, 0, bArray, colsToUpdate, tc);
    }

    private RowLocation computeRowLocation(TransactionController tc, TableDescriptor td, String columnName) throws StandardException {
        TabInfoImpl ti = this.coreInfo[2];
        ExecIndexRow keyRow = null;
        UUID tableUUID = td.getUUID();
        keyRow = this.exFactory.getIndexableRow(2);
        keyRow.setColumn(1, DataDictionaryImpl.getIDValueAsCHAR(tableUUID));
        keyRow.setColumn(2, new SQLChar(columnName));
        return ti.getRowLocation(tc, keyRow, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowLocation getRowLocationTemplate(LanguageConnectionContext lcc, TableDescriptor td) throws StandardException {
        RowLocation rl;
        ConglomerateController heapCC = null;
        TransactionController tc = lcc.getTransactionCompile();
        long tableId = td.getHeapConglomerateId();
        heapCC = tc.openConglomerate(tableId, false, 0, 6, 2);
        try {
            rl = heapCC.newRowLocationTemplate();
        }
        finally {
            heapCC.close();
        }
        return rl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableDescriptorToOtherCache(TableDescriptor td, Cacheable c) throws StandardException {
        CacheManager otherCache = c instanceof OIDTDCacheable ? this.nameTdCache : this.OIDTdCache;
        TDCacheable otherCacheEntry = null;
        Object key = otherCache == this.nameTdCache ? new TableKey(td.getSchemaDescriptor().getUUID(), td.getName()) : td.getUUID();
        try {
            otherCacheEntry = (TDCacheable)otherCache.create(key, td);
        }
        catch (StandardException se) {
            if (!se.getMessageId().equals("XBCA0.S")) {
                throw se;
            }
        }
        finally {
            if (otherCacheEntry != null) {
                otherCache.release(otherCacheEntry);
            }
        }
    }

    public void dropStatisticsDescriptors(UUID tableUUID, UUID referenceUUID, TransactionController tc) throws StandardException {
        ExecIndexRow keyRow;
        TabInfoImpl ti = this.getNonCoreTI(14);
        SQLChar first = DataDictionaryImpl.getIDValueAsCHAR(tableUUID);
        if (referenceUUID != null) {
            keyRow = this.exFactory.getIndexableRow(2);
            SQLChar second = DataDictionaryImpl.getIDValueAsCHAR(referenceUUID);
            keyRow.setColumn(2, second);
        } else {
            keyRow = this.exFactory.getIndexableRow(1);
        }
        keyRow.setColumn(1, first);
        ti.deleteRow(tc, keyRow, 0);
    }

    private static LanguageConnectionContext getLCC() {
        return (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
    }

    private SchemaDescriptor newSystemSchemaDesc(String name, String uuid) {
        return new SchemaDescriptor(this, name, this.authorizationDatabaseOwner, this.uuidFactory.recreateUUID(uuid), true);
    }

    private SchemaDescriptor newDeclaredGlobalTemporaryTablesSchemaDesc(String name) {
        return new SchemaDescriptor(this, name, this.authorizationDatabaseOwner, null, false);
    }

    public boolean checkVersion(int requiredMajorVersion, String feature) throws StandardException {
        if (requiredMajorVersion == -1) {
            requiredMajorVersion = this.softwareVersion.majorVersionNumber;
        }
        return this.dictionaryVersion.checkVersion(requiredMajorVersion, feature);
    }

    void createSystemSps(TransactionController tc) throws StandardException {
        this.createSPSSet(tc, false, this.getSystemSchemaDescriptor().getUUID());
        this.createSPSSet(tc, true, this.getSysIBMSchemaDescriptor().getUUID());
    }

    protected void createSPSSet(TransactionController tc, boolean net, UUID schemaID) throws StandardException {
        Properties p = this.getQueryDescriptions(net);
        Enumeration<Object> e = p.keys();
        boolean nocompile = true;
        while (e.hasMoreElements()) {
            String spsName = (String)e.nextElement();
            String spsText = p.getProperty(spsName);
            SPSDescriptor spsd = new SPSDescriptor(this, spsName, this.getUUIDFactory().createUUID(), schemaID, schemaID, 'S', !nocompile, spsText, !nocompile);
            this.addSPSDescriptor(spsd, tc);
        }
    }

    private final UUID createSystemProcedureOrFunction(String routine_name, UUID schema_uuid, String[] arg_names, TypeDescriptor[] arg_types, int num_out_param, int num_result_sets, short routine_sql_control, boolean isDeterministic, TypeDescriptor return_type, HashSet newlyCreatedRoutines, TransactionController tc, String procClass) throws StandardException {
        int num_args = 0;
        if (arg_names != null) {
            num_args = arg_names.length;
        }
        if (num_args != 0) {
            SanityManager.ASSERT(arg_names != null);
            SanityManager.ASSERT(arg_types != null);
            SanityManager.ASSERT(arg_names.length == arg_types.length);
        }
        int[] arg_modes = null;
        if (num_args != 0) {
            int i;
            arg_modes = new int[num_args];
            int num_in_param = num_args - num_out_param;
            for (i = 0; i < num_in_param; ++i) {
                arg_modes[i] = 1;
            }
            for (i = 0; i < num_out_param; ++i) {
                arg_modes[num_in_param + i] = 4;
            }
        }
        RoutineAliasInfo routine_alias_info = new RoutineAliasInfo(routine_name, num_args, arg_names, arg_types, arg_modes, num_result_sets, 0, routine_sql_control, isDeterministic, true, return_type);
        UUID routine_uuid = this.getUUIDFactory().createUUID();
        AliasDescriptor ads = new AliasDescriptor(this, routine_uuid, routine_name, schema_uuid, procClass, return_type == null ? (char)'P' : 'F', return_type == null ? (char)'P' : 'F', false, routine_alias_info, null);
        this.addDescriptor(ads, null, 7, false, tc);
        newlyCreatedRoutines.add(routine_name);
        return routine_uuid;
    }

    private final UUID createSystemProcedureOrFunction(String routine_name, UUID schema_uuid, String[] arg_names, TypeDescriptor[] arg_types, int num_out_param, int num_result_sets, short routine_sql_control, boolean isDeterministic, TypeDescriptor return_type, HashSet newlyCreatedRoutines, TransactionController tc) throws StandardException {
        UUID routine_uuid = this.createSystemProcedureOrFunction(routine_name, schema_uuid, arg_names, arg_types, num_out_param, num_result_sets, routine_sql_control, isDeterministic, return_type, newlyCreatedRoutines, tc, "org.apache.derby.catalog.SystemProcedures");
        return routine_uuid;
    }

    private final void create_SYSCS_procedures(TransactionController tc, HashSet newlyCreatedRoutines) throws StandardException {
        TypeDescriptor varchar32672Type = DataTypeDescriptor.getCatalogType(12, 32672);
        UUID routine_uuid = null;
        UUID sysUtilUUID = this.getSystemUtilSchemaDescriptor().getUUID();
        String[] arg_names = new String[]{"KEY", "VALUE"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_SET_DATABASE_PROPERTY", sysUtilUUID, arg_names, arg_types, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"SCHEMANAME", "TABLENAME", "SEQUENTIAL"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT};
        routine_uuid = this.createSystemProcedureOrFunction("SYSCS_COMPRESS_TABLE", sysUtilUUID, arg_names, arg_types, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
        this.createSystemProcedureOrFunction("SYSCS_CHECKPOINT_DATABASE", sysUtilUUID, null, null, 0, 0, (short)2, false, null, newlyCreatedRoutines, tc);
        this.createSystemProcedureOrFunction("SYSCS_FREEZE_DATABASE", sysUtilUUID, null, null, 0, 0, (short)2, false, null, newlyCreatedRoutines, tc);
        this.createSystemProcedureOrFunction("SYSCS_UNFREEZE_DATABASE", sysUtilUUID, null, null, 0, 0, (short)2, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"BACKUPDIR"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_BACKUP_DATABASE", sysUtilUUID, arg_names, arg_types, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"BACKUPDIR", "DELETE_ARCHIVED_LOG_FILES"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 32672), TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE", sysUtilUUID, arg_names, arg_types, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"DELETE_ARCHIVED_LOG_FILES"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_DISABLE_LOG_ARCHIVE_MODE", sysUtilUUID, arg_names, arg_types, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"ENABLE"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.SMALLINT};
        routine_uuid = this.createSystemProcedureOrFunction("SYSCS_SET_RUNTIMESTATISTICS", sysUtilUUID, arg_names, arg_types, 0, 0, (short)2, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"ENABLE"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.SMALLINT};
        routine_uuid = this.createSystemProcedureOrFunction("SYSCS_SET_STATISTICS_TIMING", sysUtilUUID, arg_names, arg_types, 0, 0, (short)2, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"KEY"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_GET_DATABASE_PROPERTY", sysUtilUUID, arg_names, arg_types, 0, 0, (short)1, false, DataTypeDescriptor.getCatalogType(12, 32672), newlyCreatedRoutines, tc);
        arg_names = new String[]{"SCHEMANAME", "TABLENAME"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_CHECK_TABLE", sysUtilUUID, arg_names, arg_types, 0, 0, (short)1, false, TypeDescriptor.INTEGER, newlyCreatedRoutines, tc);
        routine_uuid = this.createSystemProcedureOrFunction("SYSCS_GET_RUNTIMESTATISTICS", sysUtilUUID, null, null, 0, 0, (short)2, false, DataTypeDescriptor.getCatalogType(12, 32672), newlyCreatedRoutines, tc);
        UUID sqlJUUID = this.getSchemaDescriptor("SQLJ", tc, true).getUUID();
        String[] arg_names2 = new String[]{"URL", "JAR", "DEPLOY"};
        TypeDescriptor[] arg_types2 = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 256), CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.INTEGER};
        this.createSystemProcedureOrFunction("INSTALL_JAR", sqlJUUID, arg_names2, arg_types2, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
        arg_names2 = new String[]{"URL", "JAR"};
        arg_types2 = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 256), CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("REPLACE_JAR", sqlJUUID, arg_names2, arg_types2, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
        arg_names2 = new String[]{"JAR", "UNDEPLOY"};
        arg_types2 = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.INTEGER};
        this.createSystemProcedureOrFunction("REMOVE_JAR", sqlJUUID, arg_names2, arg_types2, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
        arg_names2 = new String[]{"schemaName", "tableName", "fileName", " columnDelimiter", "characterDelimiter", "codeset"};
        arg_types2 = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, varchar32672Type, DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_EXPORT_TABLE", sysUtilUUID, arg_names2, arg_types2, 0, 0, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names2 = new String[]{"selectStatement", "fileName", " columnDelimiter", "characterDelimiter", "codeset"};
        arg_types2 = new TypeDescriptor[]{varchar32672Type, varchar32672Type, DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_EXPORT_QUERY", sysUtilUUID, arg_names2, arg_types2, 0, 0, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names2 = new String[]{"schemaName", "tableName", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace"};
        arg_types2 = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, varchar32672Type, DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_IMPORT_TABLE", sysUtilUUID, arg_names2, arg_types2, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
        arg_names2 = new String[]{"schemaName", "tableName", "insertColumnList", "columnIndexes", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace"};
        arg_types2 = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, varchar32672Type, varchar32672Type, varchar32672Type, DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_IMPORT_DATA", sysUtilUUID, arg_names2, arg_types2, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
        arg_names2 = new String[]{"schemaName", "tableName", "vtiName", "vtiArg"};
        arg_types2 = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, varchar32672Type, varchar32672Type};
        this.createSystemProcedureOrFunction("SYSCS_BULK_INSERT", sysUtilUUID, arg_names2, arg_types2, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
        this.create_10_1_system_procedures(tc, newlyCreatedRoutines, sysUtilUUID);
        this.create_10_2_system_procedures(tc, newlyCreatedRoutines, sysUtilUUID);
        this.create_10_3_system_procedures(tc, newlyCreatedRoutines);
        this.create_10_5_system_procedures(tc, newlyCreatedRoutines);
    }

    protected final void create_SYSIBM_procedures(TransactionController tc, HashSet newlyCreatedRoutines) throws StandardException {
        UUID sysIBMUUID = this.getSysIBMSchemaDescriptor().getUUID();
        String[] arg_names = new String[]{"SQLCODE", "SQLERRML", "SQLERRMC", "SQLERRP", "SQLERRD0", "SQLERRD1", "SQLERRD2", "SQLERRD3", "SQLERRD4", "SQLERRD5", "SQLWARN", "SQLSTATE", "FILE", "LOCALE", "MESSAGE", "RETURNCODE"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{TypeDescriptor.INTEGER, TypeDescriptor.SMALLINT, DataTypeDescriptor.getCatalogType(12, 2400), DataTypeDescriptor.getCatalogType(1, 8), TypeDescriptor.INTEGER, TypeDescriptor.INTEGER, TypeDescriptor.INTEGER, TypeDescriptor.INTEGER, TypeDescriptor.INTEGER, TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(1, 11), DataTypeDescriptor.getCatalogType(1, 5), DataTypeDescriptor.getCatalogType(12, 50), DataTypeDescriptor.getCatalogType(1, 5), DataTypeDescriptor.getCatalogType(12, 2400), TypeDescriptor.INTEGER};
        this.createSystemProcedureOrFunction("SQLCAMESSAGE", sysIBMUUID, arg_names, arg_types, 2, 0, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"CATALOGNAME", "SCHEMANAME", "PROCNAME", "OPTIONS"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLPROCEDURES", sysIBMUUID, arg_names, arg_types, 0, 1, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "OPTIONS"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLTABLEPRIVILEGES", sysIBMUUID, arg_names, arg_types, 0, 1, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "OPTIONS"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLPRIMARYKEYS", sysIBMUUID, arg_names, arg_types, 0, 1, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "TABLETYPE", "OPTIONS"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000), DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLTABLES", sysIBMUUID, arg_names, arg_types, 0, 1, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"CATALOGNAME", "SCHEMANAME", "PROCNAME", "PARAMNAME", "OPTIONS"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLPROCEDURECOLS", sysIBMUUID, arg_names, arg_types, 0, 1, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "COLUMNNAME", "OPTIONS"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLCOLUMNS", sysIBMUUID, arg_names, arg_types, 0, 1, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "COLUMNNAME", "OPTIONS"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLCOLPRIVILEGES", sysIBMUUID, arg_names, arg_types, 0, 1, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"CATALOGNAME", "SCHEMAPATTERN", "TYPENAMEPATTERN", "UDTTYPES", "OPTIONS"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLUDTS", sysIBMUUID, arg_names, arg_types, 0, 1, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"PKCATALOGNAME", "PKSCHEMANAME", "PKTABLENAME", "FKCATALOGNAME", "FKSCHEMANAME", "FKTABLENAME", "OPTIONS"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLFOREIGNKEYS", sysIBMUUID, arg_names, arg_types, 0, 1, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"COLTYPE", "CATALOGNAME", "SCHEMANAME", "TABLENAME", "SCOPE", "NULLABLE", "OPTIONS"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.SMALLINT, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT, TypeDescriptor.SMALLINT, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLSPECIALCOLUMNS", sysIBMUUID, arg_names, arg_types, 0, 1, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"DATATYPE", "OPTIONS"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.SMALLINT, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLGETTYPEINFO", sysIBMUUID, arg_names, arg_types, 0, 1, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "UNIQUE", "RESERVED", "OPTIONS"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT, TypeDescriptor.SMALLINT, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLSTATISTICS", sysIBMUUID, arg_names, arg_types, 0, 1, (short)1, false, null, newlyCreatedRoutines, tc);
        this.createSystemProcedureOrFunction("METADATA", sysIBMUUID, null, null, 0, 1, (short)1, false, null, newlyCreatedRoutines, tc);
    }

    public void grantPublicAccessToSystemRoutines(HashSet newlyCreatedRoutines, TransactionController tc, String authorizationID) throws StandardException {
        String routineName;
        int i;
        String schemaID = this.getSystemUtilSchemaDescriptor().getUUID().toString();
        for (i = 0; i < sysUtilProceduresWithPublicAccess.length; ++i) {
            routineName = sysUtilProceduresWithPublicAccess[i];
            if (!newlyCreatedRoutines.contains(routineName)) continue;
            this.grantPublicAccessToSystemRoutine(schemaID, routineName, 'P', tc, authorizationID);
        }
        for (i = 0; i < sysUtilFunctionsWithPublicAccess.length; ++i) {
            routineName = sysUtilFunctionsWithPublicAccess[i];
            if (!newlyCreatedRoutines.contains(routineName)) continue;
            this.grantPublicAccessToSystemRoutine(schemaID, routineName, 'F', tc, authorizationID);
        }
    }

    private void grantPublicAccessToSystemRoutine(String schemaID, String routineName, char nameSpace, TransactionController tc, String authorizationID) throws StandardException {
        AliasDescriptor ad = this.getAliasDescriptor(schemaID, routineName, nameSpace);
        if (ad == null) {
            return;
        }
        UUID routineUUID = ad.getUUID();
        this.createRoutinePermPublicDescriptor(routineUUID, tc, authorizationID);
    }

    void createRoutinePermPublicDescriptor(UUID routineUUID, TransactionController tc, String authorizationID) throws StandardException {
        RoutinePermsDescriptor routinePermDesc = new RoutinePermsDescriptor(this, "PUBLIC", authorizationID, routineUUID);
        this.addDescriptor(routinePermDesc, null, 18, false, tc);
    }

    void create_10_1_system_procedures(TransactionController tc, HashSet newlyCreatedRoutines, UUID sysUtilUUID) throws StandardException {
        UUID routine_uuid = null;
        String[] arg_names = new String[]{"SCHEMANAME", "TABLENAME", "PURGE_ROWS", "DEFRAGMENT_ROWS", "TRUNCATE_END"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT, TypeDescriptor.SMALLINT, TypeDescriptor.SMALLINT};
        routine_uuid = this.createSystemProcedureOrFunction("SYSCS_INPLACE_COMPRESS_TABLE", sysUtilUUID, arg_names, arg_types, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
    }

    void create_10_2_system_procedures(TransactionController tc, HashSet newlyCreatedRoutines, UUID sysUtilUUID) throws StandardException {
        String[] arg_names = new String[]{"BACKUPDIR"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_BACKUP_DATABASE_NOWAIT", sysUtilUUID, arg_names, arg_types, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"BACKUPDIR", "DELETE_ARCHIVED_LOG_FILES"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 32672), TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT", sysUtilUUID, arg_names, arg_types, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"CATALOGNAME", "SCHEMANAME", "FUNCNAME", "OPTIONS"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLFUNCTIONS", this.getSysIBMSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 1, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"CATALOGNAME", "SCHEMANAME", "FUNCNAME", "PARAMNAME", "OPTIONS"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLFUNCTIONPARAMS", this.getSysIBMSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 1, (short)1, false, null, newlyCreatedRoutines, tc);
    }

    private void create_10_3_system_procedures_SYSIBM(TransactionController tc, HashSet newlyCreatedRoutines) throws StandardException {
        UUID schema_uuid = this.getSysIBMSchemaDescriptor().getUUID();
        UUID routine_uuid = null;
        String[] arg_names = null;
        TypeDescriptor[] arg_types = null;
        routine_uuid = this.createSystemProcedureOrFunction("CLOBCREATELOCATOR", schema_uuid, arg_names, arg_types, 0, 0, (short)2, false, TypeDescriptor.INTEGER, newlyCreatedRoutines, tc, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        routine_uuid = null;
        arg_names = new String[]{"LOCATOR"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.INTEGER};
        routine_uuid = this.createSystemProcedureOrFunction("CLOBRELEASELOCATOR", schema_uuid, arg_names, arg_types, 0, 0, (short)2, false, null, newlyCreatedRoutines, tc, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        routine_uuid = null;
        arg_names = new String[]{"LOCATOR", "SEARCHSTR", "POS"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(-5)};
        routine_uuid = this.createSystemProcedureOrFunction("CLOBGETPOSITIONFROMSTRING", schema_uuid, arg_names, arg_types, 0, 0, (short)2, false, DataTypeDescriptor.getCatalogType(-5), newlyCreatedRoutines, tc, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        routine_uuid = null;
        arg_names = new String[]{"LOCATOR", "SEARCHLOCATOR", "POS"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.INTEGER, TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-5)};
        routine_uuid = this.createSystemProcedureOrFunction("CLOBGETPOSITIONFROMLOCATOR", schema_uuid, arg_names, arg_types, 0, 0, (short)2, false, DataTypeDescriptor.getCatalogType(-5), newlyCreatedRoutines, tc, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        routine_uuid = null;
        arg_names = new String[]{"LOCATOR"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.INTEGER};
        routine_uuid = this.createSystemProcedureOrFunction("CLOBGETLENGTH", schema_uuid, arg_names, arg_types, 0, 0, (short)2, false, DataTypeDescriptor.getCatalogType(-5), newlyCreatedRoutines, tc, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        routine_uuid = null;
        arg_names = new String[]{"LOCATOR", "POS", "LEN"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-5), TypeDescriptor.INTEGER};
        routine_uuid = this.createSystemProcedureOrFunction("CLOBGETSUBSTRING", schema_uuid, arg_names, arg_types, 0, 0, (short)2, false, DataTypeDescriptor.getCatalogType(12, 10890), newlyCreatedRoutines, tc, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        routine_uuid = null;
        arg_names = new String[]{"LOCATOR", "POS", "LEN", "REPLACESTR"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-5), TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(12)};
        routine_uuid = this.createSystemProcedureOrFunction("CLOBSETSTRING", schema_uuid, arg_names, arg_types, 0, 0, (short)2, false, null, newlyCreatedRoutines, tc, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        routine_uuid = null;
        arg_names = new String[]{"LOCATOR", "LEN"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-5)};
        routine_uuid = this.createSystemProcedureOrFunction("CLOBTRUNCATE", schema_uuid, arg_names, arg_types, 0, 0, (short)2, false, null, newlyCreatedRoutines, tc, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        routine_uuid = null;
        arg_names = null;
        arg_types = null;
        routine_uuid = this.createSystemProcedureOrFunction("BLOBCREATELOCATOR", schema_uuid, arg_names, arg_types, 0, 0, (short)2, false, TypeDescriptor.INTEGER, newlyCreatedRoutines, tc, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        routine_uuid = null;
        arg_names = new String[]{"LOCATOR"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.INTEGER};
        routine_uuid = this.createSystemProcedureOrFunction("BLOBRELEASELOCATOR", schema_uuid, arg_names, arg_types, 0, 0, (short)2, false, null, newlyCreatedRoutines, tc, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        routine_uuid = null;
        arg_names = new String[]{"LOCATOR", "SEARCHBYTES", "POS"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-3), DataTypeDescriptor.getCatalogType(-5)};
        routine_uuid = this.createSystemProcedureOrFunction("BLOBGETPOSITIONFROMBYTES", schema_uuid, arg_names, arg_types, 0, 0, (short)2, false, DataTypeDescriptor.getCatalogType(-5), newlyCreatedRoutines, tc, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        routine_uuid = null;
        arg_names = new String[]{"LOCATOR", "SEARCHLOCATOR", "POS"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.INTEGER, TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-5)};
        routine_uuid = this.createSystemProcedureOrFunction("BLOBGETPOSITIONFROMLOCATOR", schema_uuid, arg_names, arg_types, 0, 0, (short)2, false, DataTypeDescriptor.getCatalogType(-5), newlyCreatedRoutines, tc, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        routine_uuid = null;
        arg_names = new String[]{"LOCATOR"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.INTEGER};
        routine_uuid = this.createSystemProcedureOrFunction("BLOBGETLENGTH", schema_uuid, arg_names, arg_types, 0, 0, (short)2, false, DataTypeDescriptor.getCatalogType(-5), newlyCreatedRoutines, tc, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        routine_uuid = null;
        arg_names = new String[]{"LOCATOR", "POS", "LEN"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-5), TypeDescriptor.INTEGER};
        routine_uuid = this.createSystemProcedureOrFunction("BLOBGETBYTES", schema_uuid, arg_names, arg_types, 0, 0, (short)2, false, DataTypeDescriptor.getCatalogType(-3, 32672), newlyCreatedRoutines, tc, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        routine_uuid = null;
        arg_names = new String[]{"LOCATOR", "POS", "LEN", "REPLACEBYTES"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-5), TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-3)};
        routine_uuid = this.createSystemProcedureOrFunction("BLOBSETBYTES", schema_uuid, arg_names, arg_types, 0, 0, (short)2, false, null, newlyCreatedRoutines, tc, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        routine_uuid = null;
        arg_names = new String[]{"LOCATOR", "LEN"};
        arg_types = new TypeDescriptor[]{TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-5)};
        routine_uuid = this.createSystemProcedureOrFunction("BLOBTRUNCATE", schema_uuid, arg_names, arg_types, 0, 0, (short)2, false, null, newlyCreatedRoutines, tc, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
    }

    void create_10_5_system_procedures(TransactionController tc, HashSet newlyCreatedRoutines) throws StandardException {
        UUID sysUtilUUID = this.getSystemUtilSchemaDescriptor().getUUID();
        String[] arg_names = new String[]{"SCHEMANAME", "TABLENAME", "INDEXNAME"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER};
        UUID routine_uuid = this.createSystemProcedureOrFunction("SYSCS_UPDATE_STATISTICS", sysUtilUUID, arg_names, arg_types, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
    }

    void create_10_3_system_procedures(TransactionController tc, HashSet newlyCreatedRoutines) throws StandardException {
        this.create_10_3_system_procedures_SYSCS_UTIL(tc, newlyCreatedRoutines);
        this.create_10_3_system_procedures_SYSIBM(tc, newlyCreatedRoutines);
    }

    void create_10_3_system_procedures_SYSCS_UTIL(TransactionController tc, HashSet newlyCreatedRoutines) throws StandardException {
        UUID sysUtilUUID = this.getSystemUtilSchemaDescriptor().getUUID();
        String[] arg_names = new String[]{"schemaName", "tableName", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "lobsFileName"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_EXPORT_TABLE_LOBS_TO_EXTFILE", sysUtilUUID, arg_names, arg_types, 0, 0, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"selectStatement", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "lobsFileName"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_EXPORT_QUERY_LOBS_TO_EXTFILE", sysUtilUUID, arg_names, arg_types, 0, 0, (short)1, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"schemaName", "tableName", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE", sysUtilUUID, arg_names, arg_types, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
        arg_names = new String[]{"schemaName", "tableName", "insertColumnList", "columnIndexes", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE", sysUtilUUID, arg_names, arg_types, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
        this.createSystemProcedureOrFunction("SYSCS_RELOAD_SECURITY_POLICY", sysUtilUUID, null, null, 0, 0, (short)3, false, null, newlyCreatedRoutines, tc);
        TypeDescriptor[] arg_types2 = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_SET_USER_ACCESS", sysUtilUUID, new String[]{"USERNAME", "CONNECTIONPERMISSION"}, arg_types2, 0, 0, (short)0, false, null, newlyCreatedRoutines, tc);
        arg_types2 = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_GET_USER_ACCESS", sysUtilUUID, new String[]{"USERNAME"}, arg_types2, 0, 0, (short)1, false, CATALOG_TYPE_SYSTEM_IDENTIFIER, newlyCreatedRoutines, tc);
        this.createSystemProcedureOrFunction("SYSCS_EMPTY_STATEMENT_CACHE", sysUtilUUID, null, null, 0, 0, (short)3, false, null, newlyCreatedRoutines, tc);
    }

    private final synchronized Properties getQueryDescriptions(boolean net) {
        this.spsSet = net ? "metadata_net.properties" : "/org/apache/derby/impl/jdbc/metadata.properties";
        return (Properties)AccessController.doPrivileged(this);
    }

    public final Object run() {
        Properties p = new Properties();
        try {
            InputStream is = this.getClass().getResourceAsStream(this.spsSet);
            p.load(is);
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return p;
    }

    private static List newSList() {
        return Collections.synchronizedList(new LinkedList());
    }

    public TablePermsDescriptor getTablePermissions(UUID tableUUID, String authorizationId) throws StandardException {
        TablePermsDescriptor key = new TablePermsDescriptor(this, authorizationId, null, tableUUID);
        return (TablePermsDescriptor)this.getPermissions(key);
    }

    public TablePermsDescriptor getTablePermissions(UUID tablePermsUUID) throws StandardException {
        TablePermsDescriptor key = new TablePermsDescriptor(this, tablePermsUUID);
        return this.getUncachedTablePermsDescriptor(key);
    }

    private Object getPermissions(PermissionsDescriptor key) throws StandardException {
        Cacheable entry = this.getPermissionsCache().find(key);
        if (entry == null) {
            return null;
        }
        Object perms = entry.getIdentity();
        this.getPermissionsCache().release(entry);
        return perms;
    }

    public ColPermsDescriptor getColumnPermissions(UUID colPermsUUID) throws StandardException {
        ColPermsDescriptor key = new ColPermsDescriptor(this, colPermsUUID);
        return this.getUncachedColPermsDescriptor(key);
    }

    public ColPermsDescriptor getColumnPermissions(UUID tableUUID, int privType, boolean forGrant, String authorizationId) throws StandardException {
        String privTypeStr = forGrant ? colPrivTypeMapForGrant[privType] : colPrivTypeMap[privType];
        SanityManager.ASSERT(privTypeStr != null, "Invalid column privilege type: " + privType);
        ColPermsDescriptor key = new ColPermsDescriptor(this, authorizationId, null, tableUUID, privTypeStr);
        return (ColPermsDescriptor)this.getPermissions(key);
    }

    public ColPermsDescriptor getColumnPermissions(UUID tableUUID, String privTypeStr, boolean forGrant, String authorizationId) throws StandardException {
        ColPermsDescriptor key = new ColPermsDescriptor(this, authorizationId, null, tableUUID, privTypeStr);
        return (ColPermsDescriptor)this.getPermissions(key);
    }

    public RoutinePermsDescriptor getRoutinePermissions(UUID routineUUID, String authorizationId) throws StandardException {
        RoutinePermsDescriptor key = new RoutinePermsDescriptor(this, authorizationId, null, routineUUID);
        return (RoutinePermsDescriptor)this.getPermissions(key);
    }

    public RoutinePermsDescriptor getRoutinePermissions(UUID routinePermsUUID) throws StandardException {
        RoutinePermsDescriptor key = new RoutinePermsDescriptor(this, routinePermsUUID);
        return this.getUncachedRoutinePermsDescriptor(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRemovePermissionsDescriptor(boolean add, PermissionsDescriptor perm, String grantee, TransactionController tc) throws StandardException {
        int catalogNumber = perm.getCatalogNumber();
        perm.setUUID(null);
        perm.setGrantee(grantee);
        TabInfoImpl ti = this.getNonCoreTI(catalogNumber);
        PermissionsCatalogRowFactory rf = (PermissionsCatalogRowFactory)ti.getCatalogRowFactory();
        int primaryIndexNumber = rf.getPrimaryKeyIndexNumber();
        ConglomerateController heapCC = tc.openConglomerate(ti.getHeapConglomerate(), false, 0, 6, 4);
        RowLocation rl = null;
        try {
            rl = heapCC.newRowLocationTemplate();
        }
        finally {
            heapCC.close();
            heapCC = null;
        }
        ExecIndexRow key = rf.buildIndexKeyRow(primaryIndexNumber, perm);
        ExecRow existingRow = ti.getRow(tc, key, primaryIndexNumber);
        if (existingRow == null) {
            if (!add) {
                return false;
            }
            ExecRow row = ti.getCatalogRowFactory().makeRow(perm, null);
            int insertRetCode = ti.insertRow(row, tc);
            SanityManager.ASSERT(insertRetCode == -1, "Race condition in inserting table privilege.");
        } else {
            boolean[] colsChanged = new boolean[existingRow.nColumns()];
            boolean[] indicesToUpdate = new boolean[rf.getNumIndexes()];
            int changedColCount = 0;
            changedColCount = add ? rf.orPermissions(existingRow, perm, colsChanged) : rf.removePermissions(existingRow, perm, colsChanged);
            if (changedColCount == 0) {
                return false;
            }
            if (!add) {
                rf.setUUIDOfThePassedDescriptor(existingRow, perm);
            }
            if (changedColCount < 0) {
                ti.deleteRow(tc, key, primaryIndexNumber);
            } else if (changedColCount > 0) {
                int[] colsToUpdate = new int[changedColCount];
                changedColCount = 0;
                for (int i = 0; i < colsChanged.length; ++i) {
                    if (!colsChanged[i]) continue;
                    colsToUpdate[changedColCount++] = i + 1;
                }
                SanityManager.ASSERT(changedColCount == colsToUpdate.length, "return value of " + rf.getClass().getName() + ".orPermissions does not match the number of booleans it set in colsChanged.");
                ti.updateRow(key, existingRow, primaryIndexNumber, indicesToUpdate, colsToUpdate, tc);
            }
        }
        this.removePermEntryInCache(perm);
        return !add;
    }

    TablePermsDescriptor getUncachedTablePermsDescriptor(TablePermsDescriptor key) throws StandardException {
        if (key.getObjectID() == null) {
            return (TablePermsDescriptor)this.getUncachedPermissionsDescriptor(16, 0, key);
        }
        return (TablePermsDescriptor)this.getUncachedPermissionsDescriptor(16, 1, key);
    }

    ColPermsDescriptor getUncachedColPermsDescriptor(ColPermsDescriptor key) throws StandardException {
        if (key.getObjectID() == null) {
            return (ColPermsDescriptor)this.getUncachedPermissionsDescriptor(17, 0, key);
        }
        return (ColPermsDescriptor)this.getUncachedPermissionsDescriptor(17, 1, key);
    }

    private TupleDescriptor getUncachedPermissionsDescriptor(int catalogNumber, int indexNumber, PermissionsDescriptor key) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(catalogNumber);
        PermissionsCatalogRowFactory rowFactory = (PermissionsCatalogRowFactory)ti.getCatalogRowFactory();
        ExecIndexRow keyRow = rowFactory.buildIndexKeyRow(indexNumber, key);
        return this.getDescriptorViaIndex(indexNumber, keyRow, null, ti, null, null, false);
    }

    RoutinePermsDescriptor getUncachedRoutinePermsDescriptor(RoutinePermsDescriptor key) throws StandardException {
        if (key.getObjectID() == null) {
            return (RoutinePermsDescriptor)this.getUncachedPermissionsDescriptor(18, 0, key);
        }
        return (RoutinePermsDescriptor)this.getUncachedPermissionsDescriptor(18, 1, key);
    }

    public String getVTIClass(TableDescriptor td, boolean asTableFunction) throws StandardException {
        if ("SYSCS_DIAG".equals(td.getSchemaName())) {
            return this.getBuiltinVTIClass(td, asTableFunction);
        }
        String schemaName = td.getSchemaName();
        String functionName = td.getDescriptorName();
        SchemaDescriptor sd = this.getSchemaDescriptor(td.getSchemaName(), null, true);
        if (sd != null) {
            AliasDescriptor ad = this.getAliasDescriptor(sd.getUUID().toString(), functionName, 'F');
            if (ad != null && ad.isTableFunction()) {
                return ad.getJavaClassName();
            }
            throw StandardException.newException("42ZB4", (Object)schemaName, (Object)functionName);
        }
        return null;
    }

    public String getBuiltinVTIClass(TableDescriptor td, boolean asTableFunction) throws StandardException {
        if (td.getTableType() != 5) {
            SanityManager.THROWASSERT("getVTIClass: Invalid table type " + td);
        }
        if ("SYSCS_DIAG".equals(td.getSchemaName())) {
            String[][] vtiMappings = asTableFunction ? this.DIAG_VTI_TABLE_FUNCTION_CLASSES : this.DIAG_VTI_TABLE_CLASSES;
            for (int i = 0; i < vtiMappings.length; ++i) {
                String[] entry = vtiMappings[i];
                if (!entry[0].equals(td.getDescriptorName())) continue;
                return entry[1];
            }
        }
        return null;
    }

    public RoleGrantDescriptor getRoleGrantDescriptor(UUID uuid) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(19);
        SQLChar UUIDStringOrderable = DataDictionaryImpl.getIDValueAsCHAR(uuid);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(1);
        keyRow.setColumn(1, UUIDStringOrderable);
        return (RoleGrantDescriptor)this.getDescriptorViaIndex(2, keyRow, null, ti, null, null, false);
    }

    public RoleGrantDescriptor getRoleDefinitionDescriptor(String roleName) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(19);
        SQLVarchar roleNameOrderable = new SQLVarchar(roleName);
        SQLVarchar isDefOrderable = new SQLVarchar("Y");
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(2);
        keyRow.setColumn(1, roleNameOrderable);
        keyRow.setColumn(2, isDefOrderable);
        return (RoleGrantDescriptor)this.getDescriptorViaIndex(1, keyRow, null, ti, null, null, false);
    }

    public RoleGrantDescriptor getRoleGrantDescriptor(String roleName, String grantee, String grantor) throws StandardException {
        TabInfoImpl ti = this.getNonCoreTI(19);
        SQLVarchar roleNameOrderable = new SQLVarchar(roleName);
        SQLVarchar granteeOrderable = new SQLVarchar(grantee);
        SQLVarchar grantorOrderable = new SQLVarchar(grantor);
        ExecIndexRow keyRow = this.exFactory.getIndexableRow(3);
        keyRow.setColumn(1, roleNameOrderable);
        keyRow.setColumn(2, granteeOrderable);
        keyRow.setColumn(3, grantorOrderable);
        return (RoleGrantDescriptor)this.getDescriptorViaIndex(0, keyRow, null, ti, null, null, false);
    }

    public boolean existsGrantToAuthid(String authId, TransactionController tc) throws StandardException {
        return this.existsPermByGrantee(authId, tc, 16, 0, 1) || this.existsPermByGrantee(authId, tc, 17, 0, 1) || this.existsPermByGrantee(authId, tc, 18, 0, 1) || this.existsRoleGrantByGrantee(authId, tc);
    }

    private void dropJDBCMetadataSPSes(TransactionController tc) throws StandardException {
        Iterator it = this.getAllSPSDescriptors().iterator();
        while (it.hasNext()) {
            SPSDescriptor spsd = (SPSDescriptor)it.next();
            SchemaDescriptor sd = spsd.getSchemaDescriptor();
            if (!sd.isSystemSchema()) continue;
            this.dropSPSDescriptor(spsd, tc);
            this.dropDependentsStoredDependencies(spsd.getUUID(), tc);
        }
    }

    public void updateMetadataSPSes(TransactionController tc) throws StandardException {
        this.dropJDBCMetadataSPSes(tc);
        this.createSystemSps(tc);
    }

    static {
        DataDictionaryImpl.colPrivTypeMap[0] = "s";
        DataDictionaryImpl.colPrivTypeMapForGrant[0] = "S";
        DataDictionaryImpl.colPrivTypeMap[1] = "u";
        DataDictionaryImpl.colPrivTypeMapForGrant[1] = "U";
        DataDictionaryImpl.colPrivTypeMap[2] = "r";
        DataDictionaryImpl.colPrivTypeMapForGrant[2] = "R";
    }
}

