/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;

public class RenameNode
extends DDLStatementNode {
    protected TableName newTableName;
    protected String oldObjectName;
    protected String newObjectName;
    protected TableDescriptor td;
    private long conglomerateNumber;
    protected boolean usedAlterTable;
    protected int renamingWhat;

    public void init(Object tableName, Object oldObjectName, Object newObjectName, Object usedAlterTable, Object renamingWhat) throws StandardException {
        this.usedAlterTable = (Boolean)usedAlterTable;
        this.renamingWhat = (Integer)renamingWhat;
        switch (this.renamingWhat) {
            case 1: {
                this.initAndCheck((TableName)tableName);
                this.newTableName = this.makeTableName(this.getObjectName().getSchemaName(), (String)newObjectName);
                this.oldObjectName = null;
                this.newObjectName = this.newTableName.getTableName();
                break;
            }
            case 2: {
                TableName actingObjectName = tableName instanceof TableName ? (TableName)tableName : this.makeTableName(null, (String)tableName);
                this.initAndCheck(actingObjectName);
                this.oldObjectName = (String)oldObjectName;
                this.newObjectName = (String)newObjectName;
                break;
            }
            case 3: {
                this.oldObjectName = (String)oldObjectName;
                this.newObjectName = (String)newObjectName;
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected rename action in RenameNode");
            }
        }
    }

    public String toString() {
        switch (this.renamingWhat) {
            case 1: {
                return super.toString() + "oldTableName: " + "\n" + this.getRelativeName() + "\n" + "newTableName: " + "\n" + this.newTableName + "\n";
            }
            case 2: {
                return super.toString() + "oldTableName.oldColumnName:" + "\n" + this.getRelativeName() + "." + this.oldObjectName + "\n" + "newColumnName: " + "\n" + this.newObjectName + "\n";
            }
            case 3: {
                return super.toString() + "oldIndexName:" + "\n" + this.oldObjectName + "\n" + "newIndexName: " + "\n" + this.newObjectName + "\n";
            }
        }
        SanityManager.THROWASSERT("Unexpected rename action in RenameNode");
        return "UNKNOWN";
    }

    public String statementToString() {
        if (this.usedAlterTable) {
            return "ALTER TABLE";
        }
        switch (this.renamingWhat) {
            case 1: {
                return "RENAME TABLE";
            }
            case 2: {
                return "RENAME COLUMN";
            }
            case 3: {
                return "RENAME INDEX";
            }
        }
        SanityManager.THROWASSERT("Unexpected rename action in RenameNode");
        return "UNKNOWN";
    }

    public void bindStatement() throws StandardException {
        SchemaDescriptor sd;
        CompilerContext cc = this.getCompilerContext();
        DataDictionary dd = this.getDataDictionary();
        if (this.renamingWhat == 3) {
            sd = this.getSchemaDescriptor(null);
            ConglomerateDescriptor indexDescriptor = dd.getConglomerateDescriptor(this.oldObjectName, sd, false);
            if (indexDescriptor == null) {
                throw StandardException.newException("42X65", this.oldObjectName);
            }
            this.td = dd.getTableDescriptor(indexDescriptor.getTableID());
            this.initAndCheck(this.makeTableName(this.td.getSchemaName(), this.td.getName()));
        } else {
            sd = this.getSchemaDescriptor();
        }
        this.td = this.getTableDescriptor();
        if (this.td.getTableType() == 3) {
            throw StandardException.newException("42995");
        }
        switch (this.renamingWhat) {
            case 1: {
                TableDescriptor td = this.getTableDescriptor(this.newObjectName, sd);
                if (td != null) {
                    throw this.descriptorExistsException(td, sd);
                }
                this.renameTableBind(dd);
                break;
            }
            case 2: {
                this.renameColumnBind(dd);
                break;
            }
            case 3: {
                ConglomerateDescriptor conglomDesc = dd.getConglomerateDescriptor(this.newObjectName, sd, false);
                if (conglomDesc == null) break;
                throw this.descriptorExistsException(conglomDesc, sd);
            }
            default: {
                SanityManager.THROWASSERT("Unexpected rename action in RenameNode");
            }
        }
        this.conglomerateNumber = this.td.getHeapConglomerateId();
        ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(this.conglomerateNumber);
        cc.createDependency(this.td);
        cc.createDependency(cd);
    }

    public boolean referencesSessionSchema() throws StandardException {
        if (this.isSessionSchema(this.td.getSchemaName())) {
            return true;
        }
        return this.renamingWhat == 1 && this.isSessionSchema(this.getSchemaDescriptor());
    }

    private void renameTableBind(DataDictionary dd) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList = dd.getConstraintDescriptors(this.td);
        int size = constraintDescriptorList == null ? 0 : constraintDescriptorList.size();
        for (int index = 0; index < size; ++index) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(index);
            if (constraintDescriptor.getConstraintType() != 4) continue;
            throw StandardException.newException("X0Y25.S", "RENAME", (Object)this.td.getName(), (Object)"CONSTRAINT", (Object)constraintDescriptor.getConstraintName());
        }
    }

    private void renameColumnBind(DataDictionary dd) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.oldObjectName);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", (Object)this.oldObjectName, (Object)this.getFullName());
        }
        ColumnDescriptor cd = this.td.getColumnDescriptor(this.newObjectName);
        if (cd != null) {
            throw this.descriptorExistsException(cd, this.td);
        }
        ColumnDescriptorList generatedColumns = this.td.getGeneratedColumns();
        int generatedColumnCount = generatedColumns.size();
        for (int i = 0; i < generatedColumnCount; ++i) {
            ColumnDescriptor gc = generatedColumns.elementAt(i);
            String[] referencedColumns = gc.getDefaultInfo().getReferencedColumnNames();
            int refColCount = referencedColumns.length;
            for (int j = 0; j < refColCount; ++j) {
                String refName = referencedColumns[j];
                if (!this.oldObjectName.equals(refName)) continue;
                throw StandardException.newException("42XA8", (Object)this.oldObjectName, (Object)gc.getColumnName());
            }
        }
        ConstraintDescriptorList constraintDescriptorList = dd.getConstraintDescriptors(this.td);
        int size = constraintDescriptorList == null ? 0 : constraintDescriptorList.size();
        for (int index = 0; index < size; ++index) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(index);
            if (constraintDescriptor.getConstraintType() != 4) continue;
            ColumnDescriptorList checkConstraintCDL = constraintDescriptor.getColumnDescriptors();
            int checkConstraintCDLSize = checkConstraintCDL.size();
            for (int index2 = 0; index2 < checkConstraintCDLSize; ++index2) {
                if (checkConstraintCDL.elementAt(index2) != columnDescriptor) continue;
                throw StandardException.newException("42Z97", (Object)this.oldObjectName, (Object)constraintDescriptor.getConstraintName());
            }
        }
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getRenameConstantAction(this.getFullName(), this.getRelativeName(), this.oldObjectName, this.newObjectName, this.getSchemaDescriptor(), this.td.getUUID(), this.usedAlterTable, this.renamingWhat);
    }

    private StandardException descriptorExistsException(TupleDescriptor tuple, TupleDescriptor parent) {
        return StandardException.newException("X0Y32.S", tuple.getDescriptorType(), (Object)tuple.getDescriptorName(), (Object)parent.getDescriptorType(), (Object)parent.getDescriptorName());
    }
}

