/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class RowCountNode
extends SingleChildResultSetNode {
    private ValueNode offset;
    private ValueNode fetchFirst;

    public void init(Object childResult, Object rcl, Object offset, Object fetchFirst) throws StandardException {
        this.init(childResult, null);
        this.resultColumns = (ResultColumnList)rcl;
        this.offset = (ValueNode)offset;
        this.fetchFirst = (ValueNode)fetchFirst;
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.assignResultSetNumber();
        this.costEstimate = this.childResult.getFinalCostEstimate();
        acb.pushGetResultSetFactoryExpression(mb);
        this.childResult.generate(acb, mb);
        acb.pushThisAsActivation(mb);
        mb.push(this.resultSetNumber);
        long offsetVal = this.offset != null ? ((ConstantNode)this.offset).getValue().getLong() : 0L;
        long fetchFirstVal = this.fetchFirst != null ? ((ConstantNode)this.fetchFirst).getValue().getLong() : -1L;
        mb.push(offsetVal);
        mb.push(fetchFirstVal);
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getRowCountResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 7);
    }

    public String toString() {
        return "offset: " + this.offset + "\n" + "fetchFirst:" + this.fetchFirst + "\n" + super.toString();
    }
}

