/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashSet;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.GroupByNode;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.OptimizerImpl;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VerifyAggregateExpressionsVisitor;
import org.apache.derby.impl.sql.compile.WindowFunctionColumnNode;
import org.apache.derby.impl.sql.compile.WindowNode;

public class SelectNode
extends ResultSetNode {
    FromList fromList;
    FromTable targetTable;
    Vector selectAggregates;
    Vector whereAggregates;
    Vector havingAggregates;
    ValueNode whereClause;
    ValueNode originalWhereClause;
    GroupByList groupByList;
    private boolean wasGroupBy;
    OrderByList orderByList;
    boolean orderByQuery;
    PredicateList wherePredicates;
    SubqueryList selectSubquerys;
    SubqueryList whereSubquerys;
    SubqueryList havingSubquerys;
    private boolean bindTargetListOnly;
    private boolean isDistinct;
    private boolean orderByAndDistinctMerged;
    boolean originalWhereClauseHadSubqueries;
    private FromList preJoinFL;
    ValueNode havingClause;
    private int nestingLevel;

    public void init(Object selectList, Object aggregateVector, Object fromList, Object whereClause, Object groupByList, Object havingClause) throws StandardException {
        this.resultColumns = (ResultColumnList)selectList;
        if (this.resultColumns != null) {
            this.resultColumns.markInitialSize();
        }
        this.fromList = (FromList)fromList;
        this.whereClause = (ValueNode)whereClause;
        this.originalWhereClause = (ValueNode)whereClause;
        this.groupByList = (GroupByList)groupByList;
        this.havingClause = (ValueNode)havingClause;
        this.bindTargetListOnly = false;
        this.originalWhereClauseHadSubqueries = false;
        if (this.whereClause != null) {
            CollectNodesVisitor cnv = new CollectNodesVisitor(SubqueryNode.class, SubqueryNode.class);
            this.whereClause.accept(cnv);
            if (!cnv.getList().isEmpty()) {
                this.originalWhereClauseHadSubqueries = true;
            }
        }
    }

    public String toString() {
        return "isDistinct: " + this.isDistinct + "\n" + "groupByList: " + (this.groupByList != null ? this.groupByList.toString() : "null") + "\n" + "orderByList: " + (this.orderByList != null ? this.orderByList.toString() : "null") + "\n" + super.toString();
    }

    public String statementToString() {
        return "SELECT";
    }

    public void makeDistinct() {
        this.isDistinct = true;
    }

    public void clearDistinct() {
        this.isDistinct = false;
    }

    boolean hasDistinct() {
        return this.isDistinct;
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.selectSubquerys != null) {
            this.printLabel(depth, "selectSubquerys: ");
            this.selectSubquerys.treePrint(depth + 1);
        }
        this.printLabel(depth, "fromList: ");
        if (this.fromList != null) {
            this.fromList.treePrint(depth + 1);
        }
        if (this.whereClause != null) {
            this.printLabel(depth, "whereClause: ");
            this.whereClause.treePrint(depth + 1);
        }
        if (this.wherePredicates != null && this.wherePredicates.size() > 0) {
            this.printLabel(depth, "wherePredicates: ");
            this.wherePredicates.treePrint(depth + 1);
        }
        if (this.whereSubquerys != null) {
            this.printLabel(depth, "whereSubquerys: ");
            this.whereSubquerys.treePrint(depth + 1);
        }
        this.printLabel(depth, "preJoinFL: ");
        if (this.preJoinFL != null) {
            this.preJoinFL.treePrint(depth + 1);
        }
    }

    public FromList getFromList() {
        return this.fromList;
    }

    public ColumnReference findColumnReferenceInResult(String colName) throws StandardException {
        if (this.fromList.size() != 1) {
            return null;
        }
        FromTable ft = (FromTable)this.fromList.elementAt(0);
        if (!(ft instanceof ProjectRestrictNode && ((ProjectRestrictNode)ft).getChildResult() instanceof FromBaseTable || ft instanceof FromBaseTable)) {
            return null;
        }
        int rclSize = this.resultColumns.size();
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(index);
            if (!(rc.getExpression() instanceof ColumnReference)) {
                return null;
            }
            ColumnReference crNode = (ColumnReference)rc.getExpression();
            if (!crNode.columnName.equals(colName)) continue;
            return (ColumnReference)crNode.getClone();
        }
        return null;
    }

    public ValueNode getWhereClause() {
        return this.whereClause;
    }

    public PredicateList getWherePredicates() {
        return this.wherePredicates;
    }

    public SubqueryList getSelectSubquerys() {
        return this.selectSubquerys;
    }

    public SubqueryList getWhereSubquerys() {
        return this.whereSubquerys;
    }

    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        int index;
        int fromListSize = this.fromList.size();
        this.wherePredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        this.preJoinFL = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        this.nestingLevel = fromListParam.size() == 0 ? 0 : ((FromTable)fromListParam.elementAt(0)).getLevel() + 1;
        this.fromList.setLevel(this.nestingLevel);
        for (index = 0; index < fromListSize; ++index) {
            fromListParam.insertElementAt(this.fromList.elementAt(index), 0);
        }
        this.fromList.bindTables(dataDictionary, fromListParam);
        for (index = 0; index < fromListSize; ++index) {
            fromListParam.removeElementAt(0);
        }
        return this;
    }

    public void bindExpressions(FromList fromListParam) throws StandardException {
        int numDistinctAggs;
        int index;
        int fromListParamSize = fromListParam.size();
        int fromListSize = this.fromList.size();
        SanityManager.ASSERT(this.fromList != null && this.resultColumns != null, "Both fromList and resultColumns are expected to be non-null");
        if (!this.bindTargetListOnly) {
            this.fromList.bindExpressions(fromListParam);
        }
        this.selectSubquerys = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        this.selectAggregates = new Vector();
        for (index = 0; index < fromListSize; ++index) {
            fromListParam.insertElementAt(this.fromList.elementAt(index), index);
        }
        this.resultColumns.bindExpressions(fromListParam, this.selectSubquerys, this.selectAggregates);
        if (this.bindTargetListOnly) {
            for (index = 0; index < fromListSize; ++index) {
                fromListParam.removeElementAt(0);
            }
            return;
        }
        this.whereAggregates = new Vector();
        this.whereSubquerys = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        if (this.whereClause != null) {
            this.getCompilerContext().pushCurrentPrivType(0);
            this.whereClause = this.whereClause.bindExpression(fromListParam, this.whereSubquerys, this.whereAggregates);
            if (this.whereAggregates.size() > 0) {
                throw StandardException.newException("42903");
            }
            if (this.whereClause.isParameterNode()) {
                throw StandardException.newException("42X19", "PARAMETER");
            }
            this.whereClause = this.whereClause.checkIsBoolean();
            this.getCompilerContext().popCurrentPrivType();
        }
        if (this.havingClause != null) {
            this.havingAggregates = new Vector();
            this.havingSubquerys = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
            this.havingClause.bindExpression(fromListParam, this.havingSubquerys, this.havingAggregates);
            this.havingClause = this.havingClause.checkIsBoolean();
        }
        for (index = 0; index < fromListSize; ++index) {
            fromListParam.removeElementAt(0);
        }
        SanityManager.ASSERT(fromListParam.size() == fromListParamSize, "fromListParam.size() = " + fromListParam.size() + ", expected to be restored to " + fromListParamSize);
        SanityManager.ASSERT(this.fromList.size() == fromListSize, "fromList.size() = " + this.fromList.size() + ", expected to be restored to " + fromListSize);
        if (this.groupByList != null) {
            Vector gbAggregateVector = new Vector();
            this.groupByList.bindGroupByColumns(this, gbAggregateVector);
            SanityManager.ASSERT(gbAggregateVector.size() == 0, "Unexpected Aggregate vector generated by Group By clause");
        }
        if (this.groupByList != null || this.selectAggregates.size() > 0) {
            VerifyAggregateExpressionsVisitor visitor = new VerifyAggregateExpressionsVisitor(this.groupByList);
            this.resultColumns.accept(visitor);
        }
        if ((numDistinctAggs = SelectNode.numDistinctAggregates(this.selectAggregates)) > 1) {
            throw StandardException.newException("42Z02");
        }
    }

    public void bindExpressionsWithTables(FromList fromListParam) throws StandardException {
        this.bindExpressions(fromListParam);
    }

    public void bindTargetExpressions(FromList fromListParam) throws StandardException {
        CollectNodesVisitor cnv = new CollectNodesVisitor(FromSubquery.class, FromSubquery.class);
        this.fromList.accept(cnv);
        this.bindTargetListOnly = cnv.getList().isEmpty();
        this.bindExpressions(fromListParam);
        this.bindTargetListOnly = false;
    }

    public void bindResultColumns(FromList fromListParam) throws StandardException {
        this.fromList.bindResultColumns(fromListParam);
        super.bindResultColumns(fromListParam);
        if (this.resultColumns.size() > 1012) {
            throw StandardException.newException("54004");
        }
        if (this.fromList.hasOuterJoins()) {
            this.resultColumns.setNullability(true);
        }
    }

    public void bindResultColumns(TableDescriptor targetTableDescriptor, FromVTI targetVTI, ResultColumnList targetColumnList, DMLStatementNode statement, FromList fromListParam) throws StandardException {
        this.fromList.bindResultColumns(fromListParam);
        super.bindResultColumns(targetTableDescriptor, targetVTI, targetColumnList, statement, fromListParam);
    }

    void pushExpressionsIntoSelect(Predicate predicate) throws StandardException {
        this.wherePredicates.pullExpressions(this.referencedTableMap.size(), predicate.getAndNode());
        this.fromList.pushPredicates(this.wherePredicates);
    }

    public void verifySelectStarSubquery(FromList outerFromList, int subqueryType) throws StandardException {
        if (!((ResultColumn)this.resultColumns.elementAt(0) instanceof AllResultColumn)) {
            return;
        }
        if (subqueryType != 15) {
            throw StandardException.newException("42X38");
        }
        String fullTableName = ((AllResultColumn)this.resultColumns.elementAt(0)).getFullTableName();
        if (fullTableName != null && this.fromList.getFromTableByName(fullTableName, null, true) == null && outerFromList.getFromTableByName(fullTableName, null, true) == null && this.fromList.getFromTableByName(fullTableName, null, false) == null && outerFromList.getFromTableByName(fullTableName, null, false) == null) {
            throw StandardException.newException("42X10", fullTableName);
        }
    }

    protected FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        return this.fromList.getFromTableByName(name, schemaName, exactMatch);
    }

    public void rejectParameters() throws StandardException {
        super.rejectParameters();
        this.fromList.rejectParameters();
    }

    void pushOrderByList(OrderByList orderByList) {
        this.orderByList = orderByList;
        this.orderByQuery = true;
    }

    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fl) throws StandardException {
        ResultSetNode newTop = this;
        this.whereClause = this.normExpressions(this.whereClause);
        this.havingClause = this.normExpressions(this.havingClause);
        boolean anyChange = this.fromList.LOJ_reorderable(numTables);
        if (anyChange) {
            FromList afromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            this.bindExpressions(afromList);
        }
        this.fromList.preprocess(numTables, this.groupByList, this.whereClause);
        SanityManager.ASSERT(this.selectSubquerys != null, "selectSubquerys is expected to be non-null");
        this.resultColumns.preprocess(numTables, this.fromList, this.whereSubquerys, this.wherePredicates);
        if (this.whereClause != null) {
            if (this.whereSubquerys != null) {
                this.whereSubquerys.markWhereSubqueries();
            }
            this.whereClause.preprocess(numTables, this.fromList, this.whereSubquerys, this.wherePredicates);
        }
        if (this.groupByList != null) {
            this.groupByList.preprocess(numTables, this.fromList, this.whereSubquerys, this.wherePredicates);
        }
        if (this.havingClause != null) {
            this.havingSubquerys.markHavingSubqueries();
            this.havingClause = this.havingClause.preprocess(numTables, this.fromList, this.havingSubquerys, this.wherePredicates);
        }
        if (this.whereClause != null) {
            this.wherePredicates.pullExpressions(numTables, this.whereClause);
            this.whereClause = null;
        }
        this.fromList.flattenFromTables(this.resultColumns, this.wherePredicates, this.whereSubquerys, this.groupByList);
        if (this.wherePredicates != null && this.wherePredicates.size() > 0 && this.fromList.size() > 0) {
            if (this.fromList.size() > 1) {
                this.performTransitiveClosure(numTables);
            }
            if (this.orderByList != null) {
                this.orderByList.removeConstantColumns(this.wherePredicates);
                if (this.orderByList.size() == 0) {
                    this.orderByList = null;
                    this.resultColumns.removeOrderByColumns();
                }
            }
        }
        if (this.groupByList != null && this.havingClause == null && this.selectAggregates.size() == 0 && this.whereAggregates.size() == 0) {
            this.isDistinct = true;
            this.groupByList = null;
            this.wasGroupBy = true;
        }
        if (this.isDistinct && this.groupByList == null) {
            int distinctTable = this.resultColumns.allTopCRsFromSameTable();
            if (distinctTable != -1 && this.fromList.returnsAtMostSingleRow(this.resultColumns, this.whereClause, this.wherePredicates, this.getDataDictionary())) {
                this.isDistinct = false;
            }
            if (this.isDistinct && this.orderByList != null && this.orderByList.allAscending()) {
                if (this.orderByList.isInOrderPrefix(this.resultColumns)) {
                    this.orderByList = null;
                } else {
                    newTop = this.genProjectRestrictForReordering();
                    this.orderByList.resetToSourceRCs();
                    this.resultColumns = this.orderByList.reorderRCL(this.resultColumns);
                    newTop.getResultColumns().removeOrderByColumns();
                    this.orderByList = null;
                }
                this.orderByAndDistinctMerged = true;
            }
        }
        this.fromList.pushPredicates(this.wherePredicates);
        this.referencedTableMap = new JBitSet(numTables);
        int flSize = this.fromList.size();
        for (int index = 0; index < flSize; ++index) {
            this.referencedTableMap.or(((FromTable)this.fromList.elementAt(index)).getReferencedTableMap());
        }
        if (newTop != this) {
            newTop.setReferencedTableMap((JBitSet)this.referencedTableMap.clone());
        }
        return newTop;
    }

    private void performTransitiveClosure(int numTables) throws StandardException {
        this.wherePredicates.joinClauseTransitiveClosure(numTables, this.fromList, this.getCompilerContext());
        this.wherePredicates.searchClauseTransitiveClosure(numTables, this.fromList.hashJoinSpecified());
    }

    private ValueNode normExpressions(ValueNode boolClause) throws StandardException {
        if (boolClause != null) {
            if (!(boolClause = boolClause.eliminateNots(false)).verifyEliminateNots()) {
                boolClause.treePrint();
                SanityManager.THROWASSERT("boolClause in invalid form: " + boolClause);
            }
            if (!((boolClause = boolClause.putAndsOnTop()) instanceof AndNode) || !boolClause.verifyPutAndsOnTop()) {
                boolClause.treePrint();
                SanityManager.THROWASSERT("boolClause in invalid form: " + boolClause);
            }
            if (!((boolClause = boolClause.changeToCNF(true)) instanceof AndNode) || !boolClause.verifyChangeToCNF()) {
                boolClause.treePrint();
                SanityManager.THROWASSERT("boolClause in invalid form: " + boolClause);
            }
        }
        return boolClause;
    }

    public ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        this.wherePredicates.addPredicate(predicate);
        return this;
    }

    public boolean flattenableInFromSubquery(FromList fromList) {
        if (this.isDistinct) {
            return false;
        }
        if (this.fromList.size() > 1) {
            return false;
        }
        if (this.selectSubquerys != null && this.selectSubquerys.size() > 0) {
            return false;
        }
        if (this.groupByList != null || this.havingClause != null) {
            return false;
        }
        if (!this.resultColumns.isCloneable()) {
            return false;
        }
        return this.selectAggregates == null || this.selectAggregates.size() <= 0;
    }

    public ResultSetNode genProjectRestrict(int origFromListSize) throws StandardException {
        boolean eliminateSort = false;
        boolean hasWindowFunction = false;
        ResultColumnList originalRCL = this.resultColumns.copyListAndObjects();
        hasWindowFunction = this.resultColumns.containsWindowFunctionResultColumn();
        if (hasWindowFunction) {
            this.resultColumns.removeWindowFunctionColumns();
            if (this.orderByList != null) {
                this.orderByList.adjustForWindowFunctionColumns();
            }
        }
        ResultSetNode prnRSN = (ResultSetNode)this.getNodeFactory().getNode(151, this.fromList.elementAt(0), this.resultColumns, this.whereClause, this.wherePredicates, this.selectSubquerys, this.whereSubquerys, null, this.getContextManager());
        if (this.selectAggregates != null && this.selectAggregates.size() > 0 || this.groupByList != null) {
            Vector aggs = this.selectAggregates;
            if (this.havingAggregates != null && !this.havingAggregates.isEmpty()) {
                this.havingAggregates.addAll(this.selectAggregates);
                aggs = this.havingAggregates;
            }
            GroupByNode gbn = (GroupByNode)this.getNodeFactory().getNode(137, prnRSN, this.groupByList, aggs, this.havingClause, this.havingSubquerys, null, new Integer(this.nestingLevel), this.getContextManager());
            gbn.considerPostOptimizeOptimizations(this.originalWhereClause != null);
            gbn.assignCostEstimate(this.optimizer.getOptimizedCost());
            this.groupByList = null;
            prnRSN = gbn.getParent();
            boolean bl = eliminateSort = eliminateSort || gbn.getIsInSortedOrder();
        }
        if (this.isDistinct && !hasWindowFunction) {
            this.resultColumns.verifyAllOrderable();
            boolean distinctScanPossible = false;
            if (origFromListSize == 1 && !this.orderByAndDistinctMerged) {
                boolean simpleColumns = true;
                HashSet<BaseColumnNode> distinctColumns = new HashSet<BaseColumnNode>();
                int size = this.resultColumns.size();
                for (int i = 1; i <= size; ++i) {
                    BaseColumnNode bc = this.resultColumns.getResultColumn(i).getBaseColumnNode();
                    if (bc == null) {
                        simpleColumns = false;
                        break;
                    }
                    distinctColumns.add(bc);
                }
                if (simpleColumns && prnRSN.isPossibleDistinctScan(distinctColumns)) {
                    prnRSN.markForDistinctScan();
                    distinctScanPossible = true;
                }
            }
            if (!distinctScanPossible) {
                boolean inSortedOrder = this.isOrderedResult(this.resultColumns, prnRSN, !this.orderByAndDistinctMerged);
                prnRSN = (ResultSetNode)this.getNodeFactory().getNode(124, prnRSN, new Boolean(inSortedOrder), null, this.getContextManager());
                prnRSN.costEstimate = this.costEstimate.cloneMe();
                boolean bl = eliminateSort = eliminateSort || inSortedOrder;
            }
        }
        if (this.orderByList != null) {
            int orderBySelect;
            if (this.orderByList.getSortNeeded()) {
                prnRSN = (ResultSetNode)this.getNodeFactory().getNode(140, prnRSN, this.orderByList, null, this.getContextManager());
                prnRSN.costEstimate = this.costEstimate.cloneMe();
            }
            if ((orderBySelect = this.getResultColumns().getOrderBySelect()) > 0) {
                ResultColumnList selectRCs = prnRSN.getResultColumns().copyListAndObjects();
                selectRCs.removeOrderByColumns();
                selectRCs.genVirtualColumnNodes(prnRSN, prnRSN.getResultColumns());
                prnRSN = (ResultSetNode)this.getNodeFactory().getNode(151, prnRSN, selectRCs, null, null, null, null, null, this.getContextManager());
                originalRCL.removeOrderByColumns();
            }
        }
        if (this.wasGroupBy && this.resultColumns.numGeneratedColumnsForGroupBy() > 0) {
            ResultColumnList newSelectList = prnRSN.getResultColumns().copyListAndObjects();
            newSelectList.removeGeneratedGroupingColumns();
            newSelectList.genVirtualColumnNodes(prnRSN, prnRSN.getResultColumns());
            prnRSN = (ResultSetNode)this.getNodeFactory().getNode(151, prnRSN, newSelectList, null, null, null, null, null, this.getContextManager());
        }
        if ((this.orderByList == null || !this.orderByList.getSortNeeded()) && this.orderByQuery) {
            eliminateSort = true;
        }
        if (eliminateSort) {
            prnRSN.adjustForSortElimination(this.orderByList);
        }
        prnRSN.costEstimate = this.costEstimate.cloneMe();
        if (hasWindowFunction) {
            int size = originalRCL.size();
            int windowFunctionLevel = 0;
            ResultColumnList windowFunctionRCL = originalRCL.copyListAndObjects();
            for (int index = 0; index < size; ++index) {
                ResultColumn rc = (ResultColumn)originalRCL.elementAt(index);
                if (!rc.expressionIsWindowFunction()) continue;
                WindowFunctionColumnNode wfcn = (WindowFunctionColumnNode)rc.getExpression();
                WindowNode windowNode = wfcn.getWindowNode();
                windowNode.setResultColumns(windowFunctionRCL);
                windowNode.setChildResult(prnRSN);
                windowNode.setWindowFunctionLevel(++windowFunctionLevel);
                windowNode.costEstimate = this.costEstimate.cloneMe();
                prnRSN = windowNode;
            }
            if (this.isDistinct) {
                prnRSN.getResultColumns().verifyAllOrderable();
                boolean inSortedOrder = this.isOrderedResult(prnRSN.getResultColumns(), prnRSN, !this.orderByAndDistinctMerged);
                prnRSN = (ResultSetNode)this.getNodeFactory().getNode(124, prnRSN, new Boolean(inSortedOrder), null, this.getContextManager());
                prnRSN.costEstimate = this.costEstimate.cloneMe();
            }
            ResultColumnList newRCL = prnRSN.getResultColumns().copyListAndObjects();
            newRCL.genVirtualColumnNodes(prnRSN, prnRSN.getResultColumns());
            prnRSN = (ResultSetNode)this.getNodeFactory().getNode(151, prnRSN, newRCL, null, null, null, null, null, this.getContextManager());
            prnRSN.costEstimate = this.costEstimate.cloneMe();
        }
        return prnRSN;
    }

    private boolean isOrderedResult(ResultColumnList resultColumns, ResultSetNode newTopRSN, boolean permuteOrdering) throws StandardException {
        int rclSize = resultColumns.size();
        int numCRs = 0;
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn rc = (ResultColumn)resultColumns.elementAt(index);
            if (rc.getExpression() instanceof ColumnReference) {
                ++numCRs;
                continue;
            }
            if (rc.getExpression() instanceof ConstantNode) continue;
            return false;
        }
        if (numCRs == 0) {
            return true;
        }
        ColumnReference[] crs = new ColumnReference[numCRs];
        int crsIndex = 0;
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn rc = (ResultColumn)resultColumns.elementAt(index);
            if (!(rc.getExpression() instanceof ColumnReference)) continue;
            crs[crsIndex++] = (ColumnReference)rc.getExpression();
        }
        return newTopRSN.isOrderedOn(crs, permuteOrdering, null);
    }

    public ResultSetNode ensurePredicateList(int numTables) throws StandardException {
        return this;
    }

    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double outerRows) throws StandardException {
        SanityManager.ASSERT(this.selectSubquerys != null, "selectSubquerys is expected to be non-null");
        if (this.wherePredicates != null) {
            for (int i = this.wherePredicates.size() - 1; i >= 0; --i) {
                if (!((Predicate)this.wherePredicates.elementAt(i)).isScopedForPush()) continue;
                this.wherePredicates.removeOptPredicate(i);
            }
        }
        if (predicateList != null) {
            if (this.wherePredicates == null) {
                this.wherePredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
            }
            Predicate pred = null;
            int sz = predicateList.size();
            for (int i = sz - 1; i >= 0; --i) {
                pred = (Predicate)predicateList.getOptPredicate(i);
                if (!pred.isScopedToSourceResultSet()) continue;
                this.wherePredicates.addOptPredicate(pred);
                predicateList.removeOptPredicate(pred);
            }
        }
        Optimizer optimizer = this.getOptimizer(this.fromList, this.wherePredicates, dataDictionary, this.orderByList);
        optimizer.setOuterRows(outerRows);
        while (optimizer.getNextPermutation()) {
            while (optimizer.getNextDecoratedPermutation()) {
                optimizer.costPermutation();
            }
        }
        if (this.wherePredicates != null) {
            Predicate pred = null;
            for (int i = this.wherePredicates.size() - 1; i >= 0; --i) {
                pred = (Predicate)this.wherePredicates.getOptPredicate(i);
                if (!pred.isScopedForPush()) continue;
                predicateList.addOptPredicate(pred);
                this.wherePredicates.removeOptPredicate(pred);
            }
        }
        this.costEstimate = optimizer.getOptimizedCost();
        if (this.selectAggregates != null && this.selectAggregates.size() > 0) {
            this.costEstimate.setEstimatedRowCount((long)outerRows);
            this.costEstimate.setSingleScanRowCount(1.0);
        }
        this.selectSubquerys.optimize(dataDictionary, this.costEstimate.rowCount());
        if (this.whereSubquerys != null && this.whereSubquerys.size() > 0) {
            this.whereSubquerys.optimize(dataDictionary, this.costEstimate.rowCount());
        }
        if (this.havingSubquerys != null && this.havingSubquerys.size() > 0) {
            this.havingSubquerys.optimize(dataDictionary, this.costEstimate.rowCount());
        }
        return this;
    }

    public ResultSetNode modifyAccessPaths(PredicateList predList) throws StandardException {
        SanityManager.ASSERT(this.optimizer != null, "SelectNode's optimizer not expected to be null when modifying access paths.");
        ((OptimizerImpl)this.optimizer).addScopedPredicatesToList(predList);
        return this.modifyAccessPaths();
    }

    public ResultSetNode modifyAccessPaths() throws StandardException {
        int origFromListSize = this.fromList.size();
        this.optimizer.modifyAccessPaths();
        this.costEstimate = this.optimizer.getFinalCost();
        if (this.wherePredicates != null) {
            Predicate pred = null;
            for (int i = this.wherePredicates.size() - 1; i >= 0; --i) {
                pred = (Predicate)this.wherePredicates.getOptPredicate(i);
                if (!pred.isScopedForPush()) continue;
                SanityManager.THROWASSERT("Found scoped predicate " + pred.binaryRelOpColRefsToString() + " in WHERE list when no scoped predicates were" + " expected.");
            }
        }
        this.selectSubquerys.modifyAccessPaths();
        if (this.whereSubquerys != null && this.whereSubquerys.size() > 0) {
            this.whereSubquerys.modifyAccessPaths();
        }
        if (this.havingSubquerys != null && this.havingSubquerys.size() > 0) {
            this.havingSubquerys.modifyAccessPaths();
        }
        this.preJoinFL.removeAllElements();
        this.preJoinFL.nondestructiveAppend(this.fromList);
        while (this.fromList.size() > 1) {
            ResultSetNode leftResultSet = (ResultSetNode)this.fromList.elementAt(0);
            ResultColumnList leftRCList = leftResultSet.getResultColumns();
            leftResultSet.setResultColumns(leftRCList.copyListAndObjects());
            leftRCList.genVirtualColumnNodes(leftResultSet, leftResultSet.resultColumns);
            ResultSetNode rightResultSet = (ResultSetNode)this.fromList.elementAt(1);
            ResultColumnList rightRCList = rightResultSet.getResultColumns();
            rightResultSet.setResultColumns(rightRCList.copyListAndObjects());
            rightRCList.genVirtualColumnNodes(rightResultSet, rightResultSet.resultColumns);
            rightRCList.adjustVirtualColumnIds(leftRCList.size());
            leftRCList.nondestructiveAppend(rightRCList);
            this.fromList.setElementAt((JoinNode)this.getNodeFactory().getNode(139, leftResultSet, rightResultSet, null, null, leftRCList, null, this.fromList.properties, this.getContextManager()), 0);
            this.fromList.removeElementAt(1);
        }
        return this.genProjectRestrict(origFromListSize);
    }

    public CostEstimate getFinalCostEstimate() throws StandardException {
        return this.optimizer.getFinalCost();
    }

    boolean isUpdatableCursor(DataDictionary dd) throws StandardException {
        if (this.isDistinct) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor select has distinct");
            return false;
        }
        if (this.selectAggregates == null || this.selectAggregates.size() > 0) {
            return false;
        }
        if (this.groupByList != null || this.havingClause != null) {
            return false;
        }
        SanityManager.ASSERT(this.fromList != null, "select must have from tables");
        if (this.fromList.size() != 1) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor select has more than one from table");
            return false;
        }
        this.targetTable = (FromTable)this.fromList.elementAt(0);
        if (this.targetTable instanceof FromVTI) {
            return ((FromVTI)this.targetTable).isUpdatableCursor();
        }
        if (!(this.targetTable instanceof FromBaseTable)) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor select has non base table as target table");
            return false;
        }
        TableDescriptor targetTableDescriptor = this.getTableDescriptor(((FromBaseTable)this.targetTable).getBaseTableName(), this.getSchemaDescriptor(((FromBaseTable)this.targetTable).getTableNameField().getSchemaName()));
        if (targetTableDescriptor.getTableType() == 1) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor select is on system table");
            return false;
        }
        if (targetTableDescriptor.getTableType() == 2) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor select is on view");
            return false;
        }
        if (this.getSelectSubquerys() != null && this.getSelectSubquerys().size() != 0) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor select has subquery in SELECT list");
            return false;
        }
        if (this.getWhereSubquerys() != null && this.getWhereSubquerys().size() != 0) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor select has subquery in WHERE clause");
            return false;
        }
        return true;
    }

    FromTable getCursorTargetTable() {
        SanityManager.ASSERT(this.targetTable != null, "must call isUpdatableCursor() first, and must be updatable");
        return this.targetTable;
    }

    public boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return this.fromList.referencesTarget(name, baseTable) || this.selectSubquerys != null && this.selectSubquerys.referencesTarget(name, baseTable) || this.whereSubquerys != null && this.whereSubquerys.referencesTarget(name, baseTable);
    }

    public void disablePrivilegeCollection() {
        super.disablePrivilegeCollection();
        int fromListSize = this.fromList.size();
        for (int i = 0; i < fromListSize; ++i) {
            ((FromTable)this.fromList.elementAt(i)).disablePrivilegeCollection();
        }
    }

    boolean subqueryReferencesTarget(String name, boolean baseTable) throws StandardException {
        return this.selectSubquerys != null && this.selectSubquerys.referencesTarget(name, baseTable) || this.whereSubquerys != null && this.whereSubquerys.referencesTarget(name, baseTable);
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList bindingRCL) throws StandardException {
        this.fromList.bindUntypedNullsToResultColumns(bindingRCL);
    }

    void decrementLevel(int decrement) {
        this.fromList.decrementLevel(decrement);
        this.selectSubquerys.decrementLevel(decrement);
        this.whereSubquerys.decrementLevel(decrement);
        this.wherePredicates.decrementLevel(this.fromList, decrement);
    }

    boolean uniqueSubquery(boolean additionalEQ) throws StandardException {
        ColumnReference additionalCR = null;
        ResultColumn rc = (ResultColumn)this.getResultColumns().elementAt(0);
        if (additionalEQ && rc.getExpression() instanceof ColumnReference && (additionalCR = (ColumnReference)rc.getExpression()).getCorrelated()) {
            additionalCR = null;
        }
        return this.fromList.returnsAtMostSingleRow(additionalCR == null ? null : this.getResultColumns(), this.whereClause, this.wherePredicates, this.getDataDictionary());
    }

    public int updateTargetLockMode() {
        return this.fromList.updateTargetLockMode();
    }

    boolean returnsAtMostOneRow() {
        return this.groupByList == null && this.selectAggregates != null && this.selectAggregates.size() != 0;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.fromList.referencesSessionSchema() || this.selectSubquerys != null && this.selectSubquerys.referencesSessionSchema() || this.whereSubquerys != null && this.whereSubquerys.referencesSessionSchema();
    }

    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (!v.stopTraversal()) {
            super.accept(v);
        }
        if (this.fromList != null && !v.stopTraversal()) {
            this.fromList = (FromList)this.fromList.accept(v);
        }
        if (this.whereClause != null && !v.stopTraversal()) {
            this.whereClause = (ValueNode)this.whereClause.accept(v);
        }
        if (this.wherePredicates != null && !v.stopTraversal()) {
            this.wherePredicates = (PredicateList)this.wherePredicates.accept(v);
        }
        if (this.havingClause != null && !v.stopTraversal()) {
            this.havingClause = (ValueNode)this.havingClause.accept(v);
        }
        return returnNode;
    }

    public boolean hasAggregatesInSelectList() {
        return !this.selectAggregates.isEmpty();
    }
}

