/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.ResultSet;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.impl.sql.execute.DMLVTIResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.ValueRow;

class DeleteVTIResultSet
extends DMLVTIResultSet {
    private ResultSet rs;
    private TemporaryRowHolderImpl rowHolder;

    public DeleteVTIResultSet(NoPutResultSet source, Activation activation) throws StandardException {
        super(source, activation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void openCore() throws StandardException {
        this.lcc.getStatementContext().setTopResultSet(this, this.subqueryTrackingArray);
        ExecRow row = this.getNextRowCore(this.sourceResultSet);
        if (row != null) {
            this.rs = this.activation.getTargetVTI();
            SanityManager.ASSERT(this.rs != null, "rs expected to be non-null");
        }
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
            if (null == this.rowHolder) {
                this.rowHolder = new TemporaryRowHolderImpl(this.activation, new Properties());
            }
        }
        try {
            while (row != null) {
                if (!this.constants.deferred) {
                    this.rs.deleteRow();
                } else {
                    ValueRow rowId = new ValueRow(1);
                    rowId.setColumn(1, new SQLInteger(this.rs.getRow()));
                    this.rowHolder.insert(rowId);
                }
                ++this.rowCount;
                if (this.constants.singleRowSource) {
                    row = null;
                    continue;
                }
                row = this.getNextRowCore(this.sourceResultSet);
            }
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
        if (this.constants.deferred) {
            CursorResultSet tempRS = this.rowHolder.getResultSet();
            try {
                try {
                    ExecRow deferredRowBuffer = null;
                    tempRS.open();
                    while ((deferredRowBuffer = tempRS.getNextRow()) != null) {
                        int rowNumber = deferredRowBuffer.getColumn(1).getInt();
                        this.rs.absolute(rowNumber);
                        this.rs.deleteRow();
                    }
                    Object var6_8 = null;
                }
                catch (Throwable t) {
                    throw StandardException.unexpectedUserException(t);
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.sourceResultSet.clearCurrentRow();
                tempRS.close();
                throw throwable;
            }
            this.sourceResultSet.clearCurrentRow();
            tempRS.close();
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
    }
}

