/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Properties;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.impl.sql.execute.rts.RealHashScanStatistics;

public class RealDistinctScanStatistics
extends RealHashScanStatistics {
    public RealDistinctScanStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, String tableName, String indexName, boolean isConstraint, int hashtableSize, int[] hashKeyColumns, String scanQualifiers, String nextQualifiers, Properties scanProperties, String startPosition, String stopPosition, String isolationLevel, String lockString, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, tableName, indexName, isConstraint, hashtableSize, hashKeyColumns, scanQualifiers, nextQualifiers, scanProperties, startPosition, stopPosition, isolationLevel, lockString, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public String getStatementExecutionPlanText(int depth) {
        String hashKeyColumnString;
        Object isolationString = null;
        this.initFormatInfo(depth);
        String header = this.indexName != null ? this.indent + MessageService.getTextMessage("43X23.U", this.tableName, this.isConstraint ? MessageService.getTextMessage("43X24.U") : MessageService.getTextMessage("43X25.U"), this.indexName) : this.indent + MessageService.getTextMessage("43X26.U", this.tableName);
        header = header + " " + MessageService.getTextMessage("43X27.U", this.isolationLevel, this.lockString) + ": \n";
        String scanInfo = this.indent + MessageService.getTextMessage("43X28.U") + ": \n" + PropertyUtil.sortProperties(this.scanProperties, this.subIndent);
        if (this.hashKeyColumns.length == 1) {
            hashKeyColumnString = MessageService.getTextMessage("43X29.U") + " " + this.hashKeyColumns[0];
        } else {
            hashKeyColumnString = MessageService.getTextMessage("43X30.U") + " (" + this.hashKeyColumns[0];
            for (int index = 1; index < this.hashKeyColumns.length; ++index) {
                hashKeyColumnString = hashKeyColumnString + "," + this.hashKeyColumns[index];
            }
            hashKeyColumnString = hashKeyColumnString + ")";
        }
        return header + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X31.U") + " = " + this.hashtableSize + "\n" + this.indent + hashKeyColumnString + "\n" + this.indent + MessageService.getTextMessage("43X04.U") + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X32.U") + " = " + this.rowsFiltered + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + (this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage("43X33.U") + " = " + this.nextTime / (long)this.rowsSeen + "\n" : "") + "\n" + scanInfo + this.subIndent + MessageService.getTextMessage("43X34.U") + ":\n" + this.startPosition + this.subIndent + MessageService.getTextMessage("43X35.U") + ":\n" + this.stopPosition + this.subIndent + MessageService.getTextMessage("43X36.U") + ":\n" + this.scanQualifiers + "\n" + this.subIndent + MessageService.getTextMessage("43X37.U") + ":\n" + this.nextQualifiers + "\n" + this.dumpEstimatedCosts(this.subIndent);
    }

    public String getScanStatisticsText(String tableName, int depth) {
        if (tableName == null || tableName.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(depth);
        }
        return "";
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    public String getNodeOn() {
        return MessageService.getTextMessage("43X38.U", this.tableName, this.indexName);
    }

    public String getNodeName() {
        return MessageService.getTextMessage("43X39.U");
    }
}

