/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.store.access.StoreCostResult;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.SearchParameters;

public class BTreeCostController
extends OpenBTree
implements StoreCostController {
    private static final double BTREE_CACHED_FETCH_BY_KEY_PER_LEVEL = 0.2705;
    private static final double BTREE_SORTMERGE_FETCH_BY_KEY_PER_LEVEL = 0.716;
    private static final double BTREE_UNCACHED_FETCH_BY_KEY_PER_LEVEL = 1.5715;
    TransactionManager init_xact_manager;
    Transaction init_rawtran;
    Conglomerate init_conglomerate;
    long num_pages;
    long num_rows;
    long page_size;
    int tree_height;

    public void init(TransactionManager xact_manager, BTree conglomerate, Transaction rawtran) throws StandardException {
        super.init(xact_manager, xact_manager, null, rawtran, false, 8, 5, null, conglomerate, null, null);
        this.num_pages = this.container.getEstimatedPageCount(0);
        this.num_rows = this.container.getEstimatedRowCount(0) - this.num_pages;
        Properties prop = new Properties();
        prop.put("derby.storage.pageSize", "");
        this.container.getContainerProperties(prop);
        this.page_size = Integer.parseInt(prop.getProperty("derby.storage.pageSize"));
        this.tree_height = this.getHeight();
    }

    public void close() throws StandardException {
        super.close();
    }

    public double getFetchFromRowLocationCost(FormatableBitSet validColumns, int access_type) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public double getFetchFromFullKeyCost(FormatableBitSet validColumns, int access_type) throws StandardException {
        double ret_cost = (access_type & 1) == 0 ? 1.5715 : 0.716;
        return ret_cost *= (double)this.tree_height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getScanCost(int scan_type, long row_count, int group_size, boolean forUpdate, FormatableBitSet scanColumnList, DataValueDescriptor[] template, DataValueDescriptor[] startKeyValue, int startSearchOperator, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, boolean reopen_scan, int access_type, StoreCostResult cost_result) throws StandardException {
        ControlRow control_row = null;
        long input_row_count = row_count < 0L ? this.num_rows : row_count;
        try {
            float left_of_stop;
            SearchParameters sp;
            float left_of_start;
            if (startKeyValue == null) {
                left_of_start = 0.0f;
            } else {
                sp = new SearchParameters(startKeyValue, startSearchOperator == 1 ? 1 : -1, template, this, true);
                control_row = ControlRow.get(this, 1L).search(sp);
                control_row.release();
                control_row = null;
                left_of_start = sp.left_fraction;
            }
            if (stopKeyValue == null) {
                left_of_stop = 1.0f;
            } else {
                sp = new SearchParameters(stopKeyValue, stopSearchOperator == 1 ? 1 : -1, template, this, true);
                control_row = ControlRow.get(this, 1L).search(sp);
                control_row.release();
                control_row = null;
                left_of_stop = sp.left_fraction;
            }
            float ret_fraction = left_of_stop - left_of_start;
            if (ret_fraction < 0.0f) {
                ret_fraction = 0.0f;
            }
            if (ret_fraction > 1.0f) {
                ret_fraction = 1.0f;
            }
            float estimated_row_count = (float)input_row_count * ret_fraction;
            double cost = this.getFetchFromFullKeyCost(scanColumnList, access_type);
            cost += (double)((float)this.num_pages * ret_fraction) * 1.5;
            long cached_row_count = (long)estimated_row_count - this.num_pages;
            if (cached_row_count < 0L) {
                cached_row_count = 0L;
            }
            cost = scan_type == 2 ? (cost += (double)cached_row_count * 0.12) : (cost += (double)cached_row_count * 0.14);
            long row_size = input_row_count == 0L ? 4L : this.num_pages * this.page_size / input_row_count;
            cost += (double)(estimated_row_count * (float)row_size) * 0.004;
            if (cost < 0.0) {
                SanityManager.THROWASSERT("cost " + cost);
            }
            if (estimated_row_count < 0.0f) {
                SanityManager.THROWASSERT("estimated_row_count = " + estimated_row_count);
            }
            cost_result.setEstimatedCost(cost);
            cost_result.setEstimatedRowCount(Math.round(estimated_row_count));
        }
        finally {
            if (control_row != null) {
                control_row.release();
            }
        }
    }

    public RowLocation newRowLocationTemplate() throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }
}

