/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.jdbc.ClientBaseDataSource;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.derby.jdbc.ClientDriver;
import org.apache.derby.shared.common.i18n.MessageUtil;

public class ClientConnectionPoolDataSource
extends ClientDataSource
implements ConnectionPoolDataSource {
    private static final long serialVersionUID = -539234282156481377L;
    private static final MessageUtil msgUtil = new MessageUtil("org.apache.derby.loc.clientmessages");
    public static final String className__ = "org.apache.derby.jdbc.ClientConnectionPoolDataSource";
    private int maxStatements = 0;

    public PooledConnection getPooledConnection() throws SQLException {
        try {
            LogWriter dncLogWriter = super.computeDncLogWriterForNewConnection("_cpds");
            if (dncLogWriter != null) {
                dncLogWriter.traceEntry(this, "getPooledConnection");
            }
            PooledConnection pooledConnection = this.getPooledConnectionX(dncLogWriter, this, this.getUser(), this.getPassword());
            if (dncLogWriter != null) {
                dncLogWriter.traceExit((Object)this, "getPooledConnection", pooledConnection);
            }
            return pooledConnection;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        try {
            LogWriter dncLogWriter = super.computeDncLogWriterForNewConnection("_cpds");
            if (dncLogWriter != null) {
                dncLogWriter.traceEntry((Object)this, "getPooledConnection", (Object)user, (Object)"<escaped>");
            }
            PooledConnection pooledConnection = this.getPooledConnectionX(dncLogWriter, this, user, password);
            if (dncLogWriter != null) {
                dncLogWriter.traceExit((Object)this, "getPooledConnection", pooledConnection);
            }
            return pooledConnection;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private PooledConnection getPooledConnectionX(LogWriter dncLogWriter, ClientBaseDataSource ds, String user, String password) throws SQLException {
        return ClientDriver.getFactory().newClientPooledConnection(ds, dncLogWriter, user, password);
    }

    public void setMaxStatements(int maxStatements) {
        if (maxStatements < 0) {
            throw new IllegalArgumentException(msgUtil.getTextMessage("J134", new Integer(maxStatements)));
        }
        this.maxStatements = maxStatements;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public int maxStatementsToPool() {
        return this.maxStatements;
    }

    private final void validateState() {
        if (this.maxStatements < 0) {
            throw new IllegalArgumentException(msgUtil.getTextMessage("J134", new Integer(this.maxStatements)));
        }
    }

    private void readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException {
        inputStream.defaultReadObject();
        this.validateState();
    }
}

