/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gyrex.admin.ui.internal.databinding.TrueWhenListSelectionNotEmptyConverter;
import org.eclipse.gyrex.admin.ui.internal.forms.ViewerWithButtonsSectionPart;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsConfigurationPage;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsLabelProvider;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsUiActivator;
import org.eclipse.gyrex.jobs.internal.monitoring.IJobMonitor;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public class RunningJobsSection
extends ViewerWithButtonsSectionPart {
    private Button cancelButton;
    private Button refreshButton;
    private ListViewer dataList;
    private final DataBindingContext bindingContext;
    private IObservableValue selectedValue;

    public RunningJobsSection(Composite parent, JobsConfigurationPage page) {
        super(parent, page.getManagedForm().getToolkit(), 512);
        this.bindingContext = page.getBindingContext();
        Section section = this.getSection();
        section.setText("Running");
        section.setDescription("Currently running jobs.");
        this.createContent(section);
    }

    protected void createButtons(Composite buttonsPanel) {
        this.cancelButton = this.createButton(buttonsPanel, "Cancel...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunningJobsSection.this.removeButtonPressed();
            }
        });
        this.refreshButton = this.createButton(buttonsPanel, "Refresh", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunningJobsSection.this.refresh();
            }
        });
    }

    protected void createViewer(Composite parent) {
        this.dataList = new ListViewer(parent, this.getToolkit().getBorderStyle() | 4 | 0x100 | 0x200);
        List list = this.dataList.getList();
        this.getToolkit().adapt((Control)list, true, true);
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.dataList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataList.setLabelProvider((IBaseLabelProvider)new JobsLabelProvider());
        this.selectedValue = ViewersObservables.observeSingleSelection((Viewer)this.dataList);
        this.setDataInput();
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter((IConverter)new TrueWhenListSelectionNotEmptyConverter());
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.cancelButton), (IObservableValue)SWTObservables.observeSelection((Control)this.dataList.getControl()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
    }

    public void refresh() {
        this.setDataInput();
        super.refresh();
    }

    void removeButtonPressed() {
    }

    private void setDataInput() {
        ArrayList<String> input = new ArrayList<String>();
        for (IJobMonitor jobMonitor : JobsUiActivator.getInstance().getJobMonitor().getJobs()) {
            input.add(String.format("Job '%s' worked %s/%s (current state is %s)", jobMonitor.getJobId(), Integer.toString(jobMonitor.getWorked()), Integer.toString(jobMonitor.getTotalWork()), jobMonitor.getCurrentTask()));
        }
        this.dataList.setInput(input);
    }
}

