/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.tests.internal.queue;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.apache.zookeeper.CreateMode;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.cloud.internal.queue.ZooKeeperQueue;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.cloud.services.queue.IMessage;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ZooKeeperQueueTests {
    private static final String QUEUE_ID = "test";
    private ZooKeeperQueue queue;
    private IPath queuePath;

    @Before
    public void setUp() throws Exception {
        this.queuePath = IZooKeeperLayout.PATH_QUEUES_ROOT.append(QUEUE_ID);
        ZooKeeperGate zk = null;
        int count = 10;
        while (zk == null) {
            try {
                zk = ZooKeeperGate.get();
            }
            catch (IllegalStateException e) {
                if (count <= 0) {
                    throw e;
                }
                --count;
                Thread.sleep(250L);
            }
        }
        if (zk.exists(this.queuePath)) {
            zk.deletePath(this.queuePath);
        }
        zk.createPath(this.queuePath, CreateMode.PERSISTENT, "Test Queue");
        this.queue = new ZooKeeperQueue(QUEUE_ID);
    }

    @After
    public void tearDown() throws Exception {
        ZooKeeperGate.get().deletePath(IZooKeeperLayout.PATH_QUEUES_ROOT.append(QUEUE_ID));
    }

    @Test
    public void test001SendMessage() throws Exception {
        byte[] message = "Hallo ".concat(String.valueOf(System.currentTimeMillis())).getBytes();
        this.queue.sendMessage(message);
        Collection names = ZooKeeperGate.get().readChildrenNames(this.queuePath, null);
        Assert.assertEquals((String)"queue size", (int)1, (int)names.size());
    }

    @Test
    public void test002ConsumeMessage() throws Exception {
        byte[] message = "Hallo ".concat(String.valueOf(System.currentTimeMillis())).getBytes();
        this.queue.sendMessage(message);
        IMessage consumedMessage = this.queue.consumeMessage(5L, TimeUnit.SECONDS);
        Assert.assertNotNull((String)"message must not be null", (Object)consumedMessage);
        Assert.assertTrue((String)"message content must match", (boolean)Arrays.equals(message, consumedMessage.getBody()));
        Collection names = ZooKeeperGate.get().readChildrenNames(this.queuePath, null);
        Assert.assertTrue((String)"queue should be empty after consume", (boolean)names.isEmpty());
        Assert.assertNull((String)"no message should be in queue", (Object)this.queue.consumeMessage(1L, TimeUnit.SECONDS));
    }

    @Test
    public void test003ReceiveMessages() throws Exception {
        byte[] message = "Hallo ".concat(String.valueOf(System.currentTimeMillis())).getBytes();
        this.queue.sendMessage(message);
        HashMap<String, Long> requestProperties = new HashMap<String, Long>(2);
        requestProperties.put("queue.message.receive.timeout", TimeUnit.SECONDS.toMillis(5L));
        List messages = this.queue.receiveMessages(1, requestProperties);
        Assert.assertNotNull((String)"must return collection", (Object)messages);
        Assert.assertEquals((String)"message must be in queue", (int)1, (int)messages.size());
        Assert.assertTrue((String)"message content must match", (boolean)Arrays.equals(message, ((IMessage)messages.get(0)).getBody()));
        Collection names = ZooKeeperGate.get().readChildrenNames(this.queuePath, null);
        Assert.assertEquals((String)"queue should still contain the message", (int)1, (int)names.size());
        Assert.assertTrue((String)"no message should be visible during the timeout", (boolean)this.queue.receiveMessages(1, requestProperties).isEmpty());
        Thread.sleep(TimeUnit.SECONDS.toMillis(6L));
        List messages2 = this.queue.receiveMessages(1, requestProperties);
        Assert.assertEquals((String)"message of second receive must be in queue", (int)1, (int)messages2.size());
        Assert.assertTrue((String)"message content of second receive must match", (boolean)Arrays.equals(message, ((IMessage)messages2.get(0)).getBody()));
    }

    @Test
    public void test004DeleteMessage() throws Exception {
        byte[] message = "Hallo ".concat(String.valueOf(System.currentTimeMillis())).getBytes();
        this.queue.sendMessage(message);
        List messages = this.queue.receiveMessages(1, null);
        Assert.assertNotNull((String)"must return collection", (Object)messages);
        Assert.assertEquals((String)"message must be in queue", (int)1, (int)messages.size());
        IMessage receivedMessage = (IMessage)messages.get(0);
        Assert.assertTrue((String)"message content must match", (boolean)Arrays.equals(message, receivedMessage.getBody()));
        this.queue.deleteMessage(receivedMessage);
        Collection names = ZooKeeperGate.get().readChildrenNames(this.queuePath, null);
        Assert.assertTrue((String)"queue should be empty after delete", (boolean)names.isEmpty());
        Assert.assertNull((String)"no message should be in queue", (Object)this.queue.consumeMessage(1L, TimeUnit.SECONDS));
    }
}

