/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.jdbc.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.eclipse.gyrex.monitoring.metrics.BaseMetric;
import org.eclipse.gyrex.monitoring.metrics.ErrorMetric;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.eclipse.gyrex.monitoring.metrics.PoolMetric;
import org.eclipse.gyrex.monitoring.metrics.StatusMetric;

public class SimplePooledJdbcRepositoryMetrics
extends MetricSet {
    private final PoolMetric poolMetric;
    private final StatusMetric poolStatusMetric = (StatusMetric)this.getMetric(0, StatusMetric.class);
    private final ErrorMetric errorMetric;

    private static String getError(SQLException sqlException) {
        String error = MessageFormat.format("[SQLException] {0}; SQLState: {1}, Vendor ErrorCode: {2}", sqlException.getMessage(), sqlException.getSQLState(), sqlException.getErrorCode());
        return error;
    }

    private static String getErrorDetails(String sql, SQLException sqlException) {
        StringWriter errorDetailsStringWriter = new StringWriter(1024);
        PrintWriter errorDetailsWriter = new PrintWriter(errorDetailsStringWriter);
        errorDetailsWriter.append("[SQL] ").append(sql);
        errorDetailsWriter.println();
        while (sqlException != null) {
            errorDetailsWriter.append("[SQLException]  ").append(sqlException.getMessage()).append("; ");
            errorDetailsWriter.append("SQLState: ").append(sqlException.getSQLState()).append(", ");
            errorDetailsWriter.append("Vendor ErrorCode: ").append(String.valueOf(sqlException.getErrorCode()));
            errorDetailsWriter.println();
            sqlException.printStackTrace(errorDetailsWriter);
            sqlException = sqlException.getNextException();
        }
        errorDetailsWriter.flush();
        return errorDetailsStringWriter.toString();
    }

    protected SimplePooledJdbcRepositoryMetrics(String id, String repositoryId, String initialStatus, String initialStatusReason, long initialChannelsCapacity, long initialChannelsMinimum) {
        super(id, String.format("Metrics for repository %s", repositoryId), new BaseMetric[]{new StatusMetric(String.valueOf(id) + ".status", initialStatus, initialStatusReason), new PoolMetric(String.valueOf(id) + ".pool", initialChannelsCapacity, initialChannelsMinimum), new ErrorMetric(String.valueOf(id) + ".errors", 5)});
        this.poolMetric = (PoolMetric)this.getMetric(1, PoolMetric.class);
        this.errorMetric = (ErrorMetric)this.getMetric(2, ErrorMetric.class);
    }

    public ErrorMetric getErrorMetric() {
        return this.errorMetric;
    }

    public PoolMetric getPoolMetric() {
        return this.poolMetric;
    }

    public StatusMetric getPoolStatusMetric() {
        return this.poolStatusMetric;
    }

    public void setClosed(String reason) {
        this.getPoolStatusMetric().setStatus("closed", reason);
    }

    public void setSQLError(String sql, SQLException sqlException) {
        String error = SimplePooledJdbcRepositoryMetrics.getError(sqlException);
        String errorDetails = SimplePooledJdbcRepositoryMetrics.getErrorDetails(sql, sqlException);
        this.getErrorMetric().setLastError(error, errorDetails);
    }
}

