/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.solr.internal;

import java.io.File;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.persistence.solr.internal.SolrRepositoryProvider;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;
import org.eclipse.gyrex.server.Platform;
import org.osgi.framework.BundleContext;

public class SolrActivator
extends BaseBundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.gyrex.persistence.solr";
    private static final AtomicReference<SolrActivator> instance = new AtomicReference();
    private final AtomicReference<CoreContainer> coreContainerRef = new AtomicReference();
    private volatile File solrBase;

    public static String getEmbeddedSolrCoreName(String repositoryId) {
        return repositoryId;
    }

    public static SolrActivator getInstance() {
        return instance.get();
    }

    public SolrActivator() {
        super(PLUGIN_ID);
    }

    public void createEmbeddedCore(String coreName) throws Exception {
        CoreContainer coreContainer = this.getEmbeddedCoreContainer();
        if (coreContainer == null) {
            throw new IllegalStateException("no coreContainer");
        }
        SolrCore core = coreContainer.getCore(coreName);
        try {
            if (core != null) {
                throw new IllegalStateException(String.format("core '%s' already exists", coreName));
            }
            EmbeddedSolrServer adminServer = new EmbeddedSolrServer(coreContainer, "admin");
            CoreAdminRequest.createCore((String)coreName, (String)coreName, (SolrServer)adminServer);
        }
        finally {
            if (core != null) {
                core.close();
            }
        }
    }

    protected void doStart(BundleContext context) throws Exception {
        instance.set(this);
        this.startEmbeddedSolrServer(context);
    }

    protected void doStop(BundleContext context) throws Exception {
        this.shutdownEmbeddedSolrServer();
        instance.set(null);
    }

    public CoreContainer getEmbeddedCoreContainer() {
        return this.coreContainerRef.get();
    }

    public File getEmbeddedSolrBase() {
        return this.solrBase;
    }

    public File getEmbeddedSolrCoreBase(String coreName) {
        if (this.solrBase == null) {
            throw new IllegalStateException("no Solr base directory");
        }
        return new File(this.solrBase, coreName);
    }

    private void shutdownEmbeddedSolrServer() {
        CoreContainer coreContainer = this.coreContainerRef.getAndSet(null);
        if (coreContainer != null) {
            coreContainer.persist();
            coreContainer.shutdown();
        }
    }

    private void startEmbeddedSolrServer(BundleContext context) throws Exception {
        CoreContainer coreContainer;
        File configFile;
        if (!Platform.inDevelopmentMode()) {
            return;
        }
        File configTemplate = new File(FileLocator.toFileURL((URL)context.getBundle().getEntry("conf-embeddedsolr")).getFile());
        IPath instanceLocation = Platform.getInstanceLocation();
        this.solrBase = instanceLocation.append("solr").toFile();
        if (!this.solrBase.isDirectory()) {
            this.solrBase.mkdirs();
        }
        if (!(configFile = new File(this.solrBase, "solr.xml")).isFile()) {
            FileUtils.copyDirectory((File)configTemplate, (File)this.solrBase);
            if (!configFile.isFile()) {
                throw new IllegalStateException("config file '" + configFile.getPath() + "' is missing");
            }
        }
        if (!this.coreContainerRef.compareAndSet(null, coreContainer = new CoreContainer())) {
            return;
        }
        coreContainer.load(this.solrBase.getAbsolutePath(), configFile);
        if (!coreContainer.getCoreNames().contains("admin")) {
            coreContainer.create(new CoreDescriptor(coreContainer, "admin", "admin"));
        }
        this.getServiceHelper().registerService(RepositoryProvider.class.getName(), (Object)new SolrRepositoryProvider(coreContainer), "Eclipse Gyrex", "Apache Solr Repository provider implementation.", null, null);
    }

    public void unloadEmbeddedCore(String coreName) throws Exception {
        CoreContainer coreContainer = this.getEmbeddedCoreContainer();
        if (coreContainer == null) {
            throw new IllegalStateException("no coreContainer");
        }
        SolrCore core = coreContainer.getCore(coreName);
        try {
            if (core != null) {
                EmbeddedSolrServer adminServer = new EmbeddedSolrServer(coreContainer, "admin");
                CoreAdminRequest.unloadCore((String)coreName, (SolrServer)adminServer);
            }
        }
        finally {
            if (core != null) {
                core.close();
            }
        }
    }
}

