/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.internal.storage;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.persistence.internal.storage.RepositoryDefinition;
import org.eclipse.gyrex.preferences.CloudScope;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepositoryDefinitionsStore {
    private static final String NODE_REPOSITORIES = "repositories";
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryDefinitionsStore.class);
    private final IEclipsePreferences storage = (IEclipsePreferences)CloudScope.INSTANCE.getNode("org.eclipse.gyrex.persistence").node("repositories");

    public RepositoryDefinition create(String repositoryId, String repositoryProviderId) {
        RepositoryDefinition repositoryDefinition = new RepositoryDefinition(repositoryId, (IEclipsePreferences)this.storage.node(repositoryId));
        repositoryDefinition.setProviderId(repositoryProviderId);
        return repositoryDefinition;
    }

    public RepositoryDefinition findById(String repositoryId) {
        if (repositoryId == null) {
            throw new IllegalArgumentException("repository id must not be null");
        }
        try {
            if (!this.storage.nodeExists(repositoryId)) {
                return null;
            }
        }
        catch (BackingStoreException e) {
            LOG.warn("Unable to access preferences store. Repositories not available. {}", new Object[]{e.getMessage(), e});
            return null;
        }
        return new RepositoryDefinition(repositoryId, (IEclipsePreferences)this.storage.node(repositoryId));
    }

    public Collection<String> findRepositoryIds() {
        if (this.storage == null) {
            throw new IllegalStateException("not loaded");
        }
        try {
            return Arrays.asList(this.storage.childrenNames());
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(NLS.bind((String)"Error reading repositories: {1}", (Object)e.getMessage()), e);
        }
    }

    public void remove(String repositoryId) {
        if (this.storage == null) {
            throw new IllegalStateException("not loaded");
        }
        try {
            if (this.storage.nodeExists(repositoryId)) {
                this.storage.node(repositoryId).removeNode();
                this.storage.flush();
            }
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(NLS.bind((String)"Error removing repository ''{0}'': {1}", (Object)repositoryId, (Object)e.getMessage()), e);
        }
    }
}

