/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.preferences.tests.internal;

import junit.framework.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.preferences.CloudScope;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CloudPreferencesBlackBoxTests {
    private static final String PATH_5 = "tests/with/some/deep/path";
    private static final String PATH_1 = "tests";
    private static final String VALUE_1 = "test";
    private static final String KEY_1 = "key_1";

    private void remove(IEclipsePreferences node) throws BackingStoreException {
        Preferences parent = node.parent();
        node.removeNode();
        parent.flush();
        Assert.assertFalse((String)"node removal failed", (boolean)node.nodeExists(""));
        Assert.assertFalse((String)"node removal failed at parent", (boolean)parent.nodeExists(PATH_1));
        try {
            node.get(KEY_1, null);
            Assert.fail((String)"node method get should have thrown exception");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void test001() throws Exception {
        IEclipsePreferences node = CloudScope.INSTANCE.getNode(PATH_1);
        node.put(KEY_1, VALUE_1);
        node.flush();
        Assert.assertEquals((String)"preference value lost on persisted", (String)VALUE_1, (String)node.get(KEY_1, null));
        node.sync();
        Assert.assertEquals((String)"preference value lost on sync", (String)VALUE_1, (String)node.get(KEY_1, null));
        this.remove(node);
    }

    @Test
    public void test002() throws Exception {
        IEclipsePreferences node = CloudScope.INSTANCE.getNode("tests/tests/with/some/deep/path");
        node.put(KEY_1, VALUE_1);
        CloudScope.INSTANCE.getNode(PATH_1).flush();
        Assert.assertEquals((String)"preference value lost on persisted", (String)VALUE_1, (String)node.get(KEY_1, null));
        CloudScope.INSTANCE.getNode(PATH_1).sync();
        Assert.assertEquals((String)"preference value lost on sync", (String)VALUE_1, (String)node.get(KEY_1, null));
        this.remove(CloudScope.INSTANCE.getNode(PATH_1));
    }
}

