/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.internal.design.example.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.ui.interactiondesign.layout.ElementBuilder;
import org.eclipse.rap.ui.interactiondesign.layout.model.LayoutSet;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class StackPresentationBuider
extends ElementBuilder {
    public static final String BOTTOM_BORDER = "bottomBorder";
    public static final String RIGHT_BORDER = "rightBorder";
    public static final String LEFT_BORDER = "leftBorder";
    public static final String TOP_BORDER = "topBorder";
    public static final String RIGHT = "right";
    public static final String LEFT = "left";
    private Image tabInactiveBgActive;
    private Composite content;
    private Image borderBottom;
    private Image borderTop;
    private Image borderLeft;
    private Image borderRight;
    private Composite tabBar;
    private Image leftCorner;
    private Image rightCorner;
    private Label leftCornerLabel;
    private Label rightCornerLabel;
    private Map labelMap = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public StackPresentationBuider(Composite parent, String layoutSetId) {
        super(parent, layoutSetId);
        this.init();
    }

    private void init() {
        this.tabInactiveBgActive = this.createImageById("stack.tab.inactive.bg.act");
        this.borderBottom = this.createImageById("stack.border.bottom");
        this.borderTop = this.createImageById("stack.border.top");
        this.borderLeft = this.createImageById("stack.border.left");
        this.borderRight = this.createImageById("stack.border.right");
        this.leftCorner = this.createImageById("stack.tabbar.left.active");
        this.rightCorner = this.createImageById("stack.tabbar.right.active");
    }

    private Image createImageById(String id) {
        LayoutSet set = this.getLayoutSet();
        return this.createImage(set.getImagePath(id));
    }

    public void addControl(Control control, Object layoutData) {
    }

    public void addControl(Control control, String positionId) {
    }

    public void addImage(Image image, Object layoutData) {
    }

    public void addImage(Image image, String positionId) {
    }

    public void build() {
        this.getParent().setLayout((Layout)new FillLayout());
        Composite stack = this.createFrame();
        stack.setLayout((Layout)new FormLayout());
        this.tabBar = new Composite(stack, 0);
        this.tabBar.setLayout((Layout)new FormLayout());
        this.tabBar.setBackgroundImage(this.tabInactiveBgActive);
        FormData fdTabBar = new FormData();
        this.tabBar.setLayoutData((Object)fdTabBar);
        fdTabBar.top = new FormAttachment(0);
        fdTabBar.left = new FormAttachment(0);
        fdTabBar.right = new FormAttachment(100);
        fdTabBar.height = this.tabInactiveBgActive.getBounds().height;
        if (this.rightCorner != null && this.leftCorner != null) {
            this.leftCornerLabel = new Label(stack.getParent(), 0);
            this.leftCornerLabel.setImage(this.leftCorner);
            FormData fdLeftCorner = new FormData();
            this.leftCornerLabel.setLayoutData((Object)fdLeftCorner);
            fdLeftCorner.left = new FormAttachment(0, 3);
            fdLeftCorner.top = new FormAttachment(0, 7);
            this.rightCornerLabel = new Label(stack.getParent(), 0);
            this.rightCornerLabel.setImage(this.rightCorner);
            FormData fdRightCorner = new FormData();
            this.rightCornerLabel.setLayoutData((Object)fdRightCorner);
            fdRightCorner.right = new FormAttachment(100, -3);
            fdRightCorner.top = new FormAttachment(0, 7);
            this.rightCornerLabel.moveAbove(null);
            this.leftCornerLabel.moveAbove(null);
            this.labelMap.put(LEFT, this.leftCornerLabel);
            this.labelMap.put(RIGHT, this.rightCornerLabel);
        }
        this.content = new Composite(stack, 0);
        FormData fdContent = new FormData();
        this.content.setLayoutData((Object)fdContent);
        fdContent.top = new FormAttachment((Control)this.tabBar);
        fdContent.left = new FormAttachment(0);
        fdContent.right = new FormAttachment(100);
        fdContent.bottom = new FormAttachment(100);
    }

    private Composite createFrame() {
        Composite frameComp = new Composite(this.getParent(), 0);
        frameComp.setData("org.eclipse.rwt.themeVariant", (Object)"compGray");
        frameComp.setLayout((Layout)new FormLayout());
        frameComp.setBackgroundMode(2);
        Label left = new Label(frameComp, 0);
        left.setData("org.eclipse.rwt.themeVariant", (Object)"stackBorder");
        left.setBackgroundImage(this.borderLeft);
        FormData fdLeft = new FormData();
        left.setLayoutData((Object)fdLeft);
        fdLeft.top = new FormAttachment(0, this.borderTop.getBounds().height);
        fdLeft.bottom = new FormAttachment(100, -this.borderBottom.getBounds().height + 1);
        fdLeft.left = new FormAttachment(0);
        fdLeft.width = this.borderLeft.getBounds().width;
        this.labelMap.put(LEFT_BORDER, left);
        Label right = new Label(frameComp, 0);
        right.setData("org.eclipse.rwt.themeVariant", (Object)"stackBorder");
        right.setBackgroundImage(this.borderRight);
        FormData fdRight = new FormData();
        right.setLayoutData((Object)fdRight);
        fdRight.top = new FormAttachment(0, this.borderTop.getBounds().height);
        fdRight.bottom = new FormAttachment(100, -this.borderBottom.getBounds().height + 1);
        fdRight.right = new FormAttachment(100);
        fdRight.width = this.borderRight.getBounds().width;
        this.labelMap.put(RIGHT_BORDER, right);
        Label top = new Label(frameComp, 0);
        top.setData("org.eclipse.rwt.themeVariant", (Object)"stackBorder");
        top.setBackgroundImage(this.borderTop);
        FormData fdTop = new FormData();
        top.setLayoutData((Object)fdTop);
        fdTop.top = new FormAttachment(0);
        fdTop.left = new FormAttachment((Control)left);
        fdTop.right = new FormAttachment((Control)right);
        fdTop.height = this.borderTop.getBounds().height;
        this.labelMap.put(TOP_BORDER, top);
        Label bottom = new Label(frameComp, 0);
        bottom.setData("org.eclipse.rwt.themeVariant", (Object)"stackBorder");
        bottom.setBackgroundImage(this.borderBottom);
        FormData fdBottom = new FormData();
        bottom.setLayoutData((Object)fdBottom);
        fdBottom.bottom = new FormAttachment(100);
        fdBottom.left = new FormAttachment((Control)left);
        fdBottom.right = new FormAttachment((Control)right);
        fdBottom.height = this.borderBottom.getBounds().height;
        this.labelMap.put(BOTTOM_BORDER, bottom);
        Composite result = new Composite(frameComp, 0);
        result.setData("org.eclipse.rwt.themeVariant", (Object)"compGray");
        FormData fdResult = new FormData();
        result.setLayoutData((Object)fdResult);
        fdResult.top = new FormAttachment((Control)top);
        fdResult.left = new FormAttachment((Control)left);
        fdResult.right = new FormAttachment((Control)right);
        fdResult.bottom = new FormAttachment((Control)bottom);
        return result;
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.content;
    }

    public Point getSize() {
        Point result = null;
        if (this.content != null) {
            result = this.content.getSize();
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        Object result = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rap.internal.design.example.stacks.ViewStackPresentation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            result = this.tabBar;
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.util.Map");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz2) {
                result = this.labelMap;
            }
        }
        return result;
    }
}

