/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.branding;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rap.ui.branding.IExitConfirmation;
import org.eclipse.rap.ui.internal.servlet.EntryPointExtension;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.branding.Header;
import org.osgi.framework.Bundle;

public final class Branding
extends AbstractBranding {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Header[] EMPTY_HEADERS = new Header[0];
    private final String contributor;
    private String servletName;
    private String defaultEntryPointId;
    private List entryPointIds;
    private String title;
    private String favIcon;
    private List headers;
    private String body;
    private IExitConfirmation exitConfirmation;
    private String themeId;
    private String brandingId;

    public Branding(String contributor) {
        this.contributor = contributor;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public void addEntryPointId(String entryPointId) {
        if (this.entryPointIds == null) {
            this.entryPointIds = new ArrayList();
        }
        this.entryPointIds.add(entryPointId);
    }

    public void setDefaultEntryPointId(String defaultEntryPointId) {
        this.defaultEntryPointId = defaultEntryPointId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setFavIcon(String favIcon) {
        this.favIcon = favIcon;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void addHeader(String tagName, Map attributes) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        Header header = new Header(tagName, attributes);
        this.headers.add(header);
    }

    public void setExitConfirmation(IExitConfirmation exitConfirmation) {
        this.exitConfirmation = exitConfirmation;
    }

    public void setThemeId(String themeId) {
        this.themeId = themeId;
    }

    void setId(String brandingId) {
        this.brandingId = brandingId;
    }

    public String getServletName() {
        return this.servletName;
    }

    public String getDefaultEntryPoint() {
        return EntryPointExtension.getById(this.defaultEntryPointId);
    }

    public String[] getEntryPoints() {
        String[] result;
        if (this.entryPointIds == null) {
            result = EMPTY_STRINGS;
        } else {
            result = new String[this.entryPointIds.size()];
            int i = 0;
            while (i < result.length) {
                String entryPointId = (String)this.entryPointIds.get(i);
                result[i] = EntryPointExtension.getById(entryPointId);
                ++i;
            }
        }
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public String getFavIcon() {
        return this.favIcon;
    }

    public Header[] getHeaders() {
        Header[] result;
        if (this.headers == null) {
            result = EMPTY_HEADERS;
        } else {
            result = new Header[this.headers.size()];
            this.headers.toArray(result);
        }
        return result;
    }

    public String getBody() {
        return this.body;
    }

    public boolean showExitConfirmation() {
        boolean result = false;
        if (this.exitConfirmation != null) {
            result = this.exitConfirmation.showExitConfirmation();
        }
        return result;
    }

    public String getExitConfirmationText() {
        String result = null;
        if (this.exitConfirmation != null) {
            result = this.exitConfirmation.getExitConfirmationText();
        }
        return result;
    }

    public String getThemeId() {
        return this.themeId;
    }

    public String getId() {
        return this.brandingId;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerResources() throws IOException {
        Path file;
        if (this.favIcon == null) return;
        if ("".equals(this.favIcon)) return;
        Bundle bundle = Platform.getBundle((String)this.contributor);
        InputStream stream = FileLocator.openStream((Bundle)bundle, (IPath)(file = new Path(this.favIcon)), (boolean)false);
        if (stream == null) return;
        try {
            RWT.getResourceManager().register(this.favIcon, stream);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            stream.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        stream.close();
    }
}

