/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields;

import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FormTextDialogField
extends DialogField {
    private String fText = "";
    private FormText fTextControl;
    private boolean fParseTags;
    private boolean fExpandURLs;

    protected static GridData gridDataForText(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    @Override
    public void adaptToForm(FormToolkit toolkit) {
        if (this.isOkToUse((Control)this.fTextControl)) {
            FormText formText = this.fTextControl;
            formText.setHyperlinkSettings((HyperlinkSettings)toolkit.getHyperlinkGroup());
            toolkit.adapt((Control)formText, false, true);
            formText.setMenu(this.fTextControl.getParent().getMenu());
            formText.setFont(this.fTextControl.getParent().getFont());
        }
    }

    protected FormText createTextControl(Composite parent) {
        return new FormText(parent, 64);
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)FormTextDialogField.gridDataForLabel(1));
        FormText text = this.getTextControl(parent);
        text.setLayoutData((Object)FormTextDialogField.gridDataForText(nColumns - 1));
        return new Control[]{label, text};
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    public String getText() {
        return this.fText;
    }

    public FormText getTextControl(Composite parent) {
        if (this.fTextControl == null) {
            this.assertCompositeNotNull(parent);
            this.fTextControl = this.createTextControl(parent);
            this.fTextControl.setText(this.fText, this.fParseTags, this.fExpandURLs);
            this.fTextControl.setFont(parent.getFont());
            this.fTextControl.setEnabled(this.isEnabled());
        }
        return this.fTextControl;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.setText(this.fText, this.fParseTags, this.fExpandURLs);
        }
    }

    public void setText(String text, boolean parseTags, boolean expandURLs) {
        this.fText = text;
        this.fParseTags = parseTags;
        this.fExpandURLs = expandURLs;
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setText(text, parseTags, expandURLs);
        }
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setEnabled(this.isEnabled());
        }
    }
}

