/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.rap.ui.internal.application.ApplicationRegistry;
import org.eclipse.rap.ui.internal.branding.BrandingExtension;
import org.eclipse.rap.ui.internal.preferences.WorkbenchFileSettingStoreFactory;
import org.eclipse.rap.ui.internal.servlet.EntryPointExtension;
import org.eclipse.rwt.AdapterFactory;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.EngineConfig;
import org.eclipse.rwt.internal.IEngineConfig;
import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.rwt.internal.lifecycle.UICallBackServiceHandler;
import org.eclipse.rwt.internal.resources.DefaultResourceManagerFactory;
import org.eclipse.rwt.internal.resources.JSLibraryServiceHandler;
import org.eclipse.rwt.internal.theme.ResourceLoader;
import org.eclipse.rwt.internal.theme.Theme;
import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.rwt.internal.theme.css.CssFileReader;
import org.eclipse.rwt.internal.theme.css.StyleSheet;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.rwt.resources.IResource;
import org.eclipse.rwt.resources.IResourceManagerFactory;
import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.rwt.service.ISettingStoreFactory;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.osgi.framework.Bundle;

public final class EngineConfigWrapper
implements IEngineConfig {
    private static final String ID_ADAPTER_FACTORY = "org.eclipse.rap.ui.adapterfactory";
    private static final String ID_ENTRY_POINT = "org.eclipse.rap.ui.entrypoint";
    private static final String ID_THEMES = "org.eclipse.rap.ui.themes";
    private static final String ELEMENT_THEME = "theme";
    private static final String ELEMENT_THEME_CONTRIBUTION = "themeContribution";
    private static final String ID_THEMEABLE_WIDGETS = "org.eclipse.rap.ui.themeableWidgets";
    private static final String ID_PHASE_LISTENER = "org.eclipse.rap.ui.phaselistener";
    private static final String ID_SERVICE_HANDLER = "org.eclipse.rap.ui.serviceHandler";
    private static final String ID_RESOURCES = "org.eclipse.rap.ui.resources";
    private static final String ID_SETTING_STORES = "org.eclipse.rap.ui.settingstores";
    private final EngineConfig engineConfig = new EngineConfig(EngineConfigWrapper.findContextPath().toString());

    public EngineConfigWrapper() {
        this.init();
    }

    public File getServerContextDir() {
        return this.engineConfig.getServerContextDir();
    }

    public File getClassDir() {
        return this.engineConfig.getClassDir();
    }

    public File getLibDir() {
        return this.engineConfig.getLibDir();
    }

    private void init() {
        RWTFactory.getConfigurationReader().setEngineConfig((IEngineConfig)this);
        EngineConfigWrapper.registerPhaseListener();
        EngineConfigWrapper.registerResourceManagerFactory();
        EngineConfigWrapper.registerSettingStoreFactory();
        EngineConfigWrapper.registerWorkbenchEntryPoint();
        EngineConfigWrapper.registerThemeableWidgets();
        EngineConfigWrapper.registerThemes();
        EngineConfigWrapper.registerThemeContributions();
        EngineConfigWrapper.registerFactories();
        EngineConfigWrapper.registerResources();
        EngineConfigWrapper.registerUICallBackServiceHandler();
        this.registerJSLibraryServiceHandler();
        this.registerCustomServiceHandlers();
        this.registerApplicationEntryPoints();
        this.registerBrandings();
    }

    private static void registerPhaseListener() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_PHASE_LISTENER);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            try {
                PhaseListener listener = (PhaseListener)elements[i].createExecutableExtension("class");
                RWTFactory.getPhaseListenerRegistry().add(listener);
            }
            catch (CoreException ce) {
                WorkbenchPlugin.getDefault().getLog().log(ce.getStatus());
            }
            ++i;
        }
    }

    private static void registerResourceManagerFactory() {
        RWTFactory.getResourceManagerProvider().registerFactory((IResourceManagerFactory)new DefaultResourceManagerFactory());
    }

    private static void registerSettingStoreFactory() {
        WorkbenchFileSettingStoreFactory result = null;
        String factoryId = System.getProperty("org.eclipse.rwt.settingStoreFactory");
        if (factoryId != null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(ID_SETTING_STORES);
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String id = elements[i].getAttribute("id");
                if (factoryId.equals(id)) {
                    try {
                        Object obj = elements[i].createExecutableExtension("class");
                        if (obj instanceof ISettingStoreFactory) {
                            result = (ISettingStoreFactory)obj;
                        }
                    }
                    catch (CoreException cex) {
                        WorkbenchPlugin.log(cex.getStatus());
                    }
                }
                ++i;
            }
            if (result == null) {
                String msg = "Warning: could not find the factory with id '" + factoryId + "' in org.eclipse.rap.ui.settingstores";
                WorkbenchPlugin.log(WorkbenchPlugin.getStatus(new Throwable(msg)));
            }
        }
        if (result == null) {
            result = new WorkbenchFileSettingStoreFactory();
        }
        RWTFactory.getSettingStoreManager().register(result);
    }

    private static void registerFactories() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_ADAPTER_FACTORY);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String contributorName = elements[i].getContributor().getName();
            String factoryName = elements[i].getAttribute("factoryClass");
            String adaptableName = elements[i].getAttribute("adaptableClass");
            try {
                Bundle bundle = Platform.getBundle((String)contributorName);
                Class factoryClass = bundle.loadClass(factoryName);
                Class adaptableClass = bundle.loadClass(adaptableName);
                AdapterFactory adapterFactory = (AdapterFactory)ClassUtil.newInstance((Class)factoryClass);
                RWTFactory.getAdapterManager().registerAdapters(adaptableClass, adapterFactory);
            }
            catch (Throwable thr) {
                String text = "Could not register adapter factory ''{0}'' for the adapter type ''{1}''.";
                Object[] param = new Object[]{factoryName, adaptableName};
                String msg = MessageFormat.format(text, param);
                Status status = new Status(4, contributorName, 0, msg, thr);
                WorkbenchPlugin.getDefault().getLog().log((IStatus)status);
            }
            ++i;
        }
    }

    private static void registerWorkbenchEntryPoint() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_ENTRY_POINT);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String contributorName = elements[i].getContributor().getName();
            String className = elements[i].getAttribute("class");
            String parameter = elements[i].getAttribute("parameter");
            String id = elements[i].getAttribute("id");
            try {
                Bundle bundle = Platform.getBundle((String)contributorName);
                Class clazz = bundle.loadClass(className);
                RWTFactory.getEntryPointManager().register(parameter, clazz);
                EntryPointExtension.bind(id, parameter);
            }
            catch (Throwable thr) {
                String text = "Could not register entry point ''{0}'' with request startup parameter ''{1}''.";
                Object[] param = new Object[]{className, parameter};
                String msg = MessageFormat.format(text, param);
                Status status = new Status(4, contributorName, 0, msg, thr);
                WorkbenchPlugin.getDefault().getLog().log((IStatus)status);
            }
            ++i;
        }
    }

    private static void registerThemeableWidgets() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(ID_THEMEABLE_WIDGETS);
        IConfigurationElement[] widgetExts = ep.getConfigurationElements();
        int i = 0;
        while (i < widgetExts.length) {
            String contributorName = widgetExts[i].getContributor().getName();
            String widgetClass = widgetExts[i].getAttribute("class");
            try {
                final Bundle bundle = Platform.getBundle((String)contributorName);
                ResourceLoader resLoader = new ResourceLoader(){

                    public InputStream getResourceAsStream(String resourceName) throws IOException {
                        InputStream result = null;
                        URL url = bundle.getResource(resourceName);
                        if (url != null) {
                            result = url.openStream();
                        }
                        return result;
                    }
                };
                Class widget = bundle.loadClass(widgetClass);
                ThemeManager.getInstance().addThemeableWidget(widget, resLoader);
            }
            catch (Throwable thr) {
                String text = "Could not register themeable widget ''{0}''.";
                Object[] param = new Object[]{widgetClass};
                String message = MessageFormat.format(text, param);
                Status status = new Status(4, contributorName, message, thr);
                WorkbenchPlugin.getDefault().getLog().log((IStatus)status);
            }
            ++i;
        }
        ThemeManager.getInstance().initializeThemeableWidgets();
    }

    private static void registerThemes() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(ID_THEMES);
        IConfigurationElement[] elements = ep.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            if (ELEMENT_THEME.equals(elements[i].getName())) {
                String contributorName = elements[i].getContributor().getName();
                String themeId = elements[i].getAttribute("id");
                String themeName = elements[i].getAttribute("name");
                String themeFile = elements[i].getAttribute("file");
                if (!"org.eclipse.rap.rwt.theme.Default".equals(themeId)) {
                    try {
                        Bundle bundle = Platform.getBundle((String)contributorName);
                        ResourceLoader loader = EngineConfigWrapper.createResourceLoader(bundle);
                        StyleSheet styleSheet = null;
                        if (themeFile != null) {
                            styleSheet = CssFileReader.readStyleSheet((String)themeFile, (ResourceLoader)loader);
                        }
                        Theme theme = new Theme(themeId, themeName, styleSheet);
                        ThemeManager.getInstance().registerTheme(theme);
                    }
                    catch (Exception e) {
                        String text = "Could not register custom theme ''{0}'' from file ''{1}''.";
                        Object[] param = new Object[]{themeId, themeFile};
                        String msg = MessageFormat.format(text, param);
                        Status status = new Status(4, contributorName, msg, (Throwable)e);
                        WorkbenchPlugin.getDefault().getLog().log((IStatus)status);
                    }
                }
            }
            ++i;
        }
    }

    private static void registerThemeContributions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(ID_THEMES);
        IConfigurationElement[] elements = ep.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            if (ELEMENT_THEME_CONTRIBUTION.equals(elements[i].getName())) {
                String contributorName = elements[i].getContributor().getName();
                String themeId = elements[i].getAttribute("themeId");
                String themeFile = elements[i].getAttribute("file");
                try {
                    Bundle bundle = Platform.getBundle((String)contributorName);
                    ResourceLoader loader = EngineConfigWrapper.createResourceLoader(bundle);
                    StyleSheet styleSheet = CssFileReader.readStyleSheet((String)themeFile, (ResourceLoader)loader);
                    Theme theme = ThemeManager.getInstance().getTheme(themeId);
                    if (theme == null) {
                        throw new IllegalArgumentException("No such theme defined: " + themeId);
                    }
                    theme.addStyleSheet(styleSheet);
                }
                catch (Exception e) {
                    String text = "Could not register theme contribution for theme ''{0}'' from file ''{1}''.";
                    Object[] param = new Object[]{themeId, themeFile};
                    String msg = MessageFormat.format(text, param);
                    Status status = new Status(4, contributorName, msg, (Throwable)e);
                    WorkbenchPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
            ++i;
        }
        ThemeManager.getInstance().initialize();
    }

    private static ResourceLoader createResourceLoader(final Bundle bundle) {
        ResourceLoader result = new ResourceLoader(){

            public InputStream getResourceAsStream(String resourceName) throws IOException {
                InputStream result = null;
                Path path = new Path(resourceName);
                URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
                if (url != null) {
                    result = url.openStream();
                }
                return result;
            }
        };
        return result;
    }

    private static IPath findContextPath() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.rap.ui");
        IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
        return stateLocation.append("context");
    }

    private static void registerResources() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_RESOURCES);
        IConfigurationElement[] elements = point.getConfigurationElements();
        DependentResource[] resources = EngineConfigWrapper.loadResources(elements);
        resources = EngineConfigWrapper.sortResources(resources);
        EngineConfigWrapper.registerResources(resources);
    }

    private static DependentResource[] loadResources(IConfigurationElement[] elements) {
        DependentResource[] result = new DependentResource[elements.length];
        int i = 0;
        while (i < elements.length) {
            try {
                IResource resource = (IResource)elements[i].createExecutableExtension("class");
                String resourceId = elements[i].getAttribute("id");
                IConfigurationElement[] dependsOn = elements[i].getChildren("dependsOn");
                ArrayList<String> resourceDependencies = new ArrayList<String>();
                int j = 0;
                while (j < dependsOn.length) {
                    String dependency = dependsOn[j].getAttribute("resourceId");
                    resourceDependencies.add(dependency);
                    ++j;
                }
                result[i] = new DependentResource(resource, resourceId, resourceDependencies);
            }
            catch (CoreException ce) {
                WorkbenchPlugin.getDefault().getLog().log(ce.getStatus());
            }
            ++i;
        }
        return result;
    }

    private static DependentResource[] sortResources(DependentResource[] resources) {
        DependentResource[] result = new DependentResource[resources.length];
        ArrayList<String> sortedResourceIds = new ArrayList<String>();
        ArrayList<DependentResource> deferredResources = new ArrayList<DependentResource>();
        int index = 0;
        int i = 0;
        while (i < resources.length) {
            DependentResource resource = resources[i];
            if (resource != null) {
                resource.dependencies.removeAll(sortedResourceIds);
                boolean checkDeferredResources = false;
                if (resource.dependencies.isEmpty()) {
                    result[index++] = resource;
                    sortedResourceIds.add(resource.id);
                    checkDeferredResources = true;
                } else {
                    deferredResources.add(resource);
                }
                while (checkDeferredResources) {
                    checkDeferredResources = false;
                    Iterator iterator = deferredResources.iterator();
                    while (iterator.hasNext()) {
                        DependentResource deferredResource = (DependentResource)iterator.next();
                        deferredResource.dependencies.removeAll(sortedResourceIds);
                        if (!deferredResource.dependencies.isEmpty()) continue;
                        result[index++] = deferredResource;
                        sortedResourceIds.add(deferredResource.id);
                        iterator.remove();
                        checkDeferredResources = true;
                    }
                }
            }
            ++i;
        }
        if (deferredResources.size() != 0) {
            String pluginId = WorkbenchPlugin.getDefault().getBundle().getSymbolicName();
            String message = "Dependencies could not be resolved for " + deferredResources;
            WorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, pluginId, message));
        }
        return result;
    }

    private static void registerResources(DependentResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] != null) {
                RWTFactory.getResourceRegistry().add(resources[i].resource);
            }
            ++i;
        }
    }

    private static void registerUICallBackServiceHandler() {
        RWT.getServiceManager().registerServiceHandler(UICallBackServiceHandler.HANDLER_ID, (IServiceHandler)new UICallBackServiceHandler());
    }

    private void registerJSLibraryServiceHandler() {
        JSLibraryServiceHandler handler = new JSLibraryServiceHandler();
        RWT.getServiceManager().registerServiceHandler(JSLibraryServiceHandler.HANDLER_ID, (IServiceHandler)handler);
        RWTFactory.getJSLibraryConcatenator().startJSConcatenation();
    }

    private void registerCustomServiceHandlers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_SERVICE_HANDLER);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            try {
                String id = elements[i].getAttribute("id");
                if (id != null) {
                    Object extObject = elements[i].createExecutableExtension("class");
                    IServiceHandler handler = (IServiceHandler)extObject;
                    RWT.getServiceManager().registerServiceHandler(id, handler);
                }
            }
            catch (CoreException ce) {
                WorkbenchPlugin.getDefault().getLog().log(ce.getStatus());
            }
            ++i;
        }
    }

    private void registerBrandings() {
        try {
            BrandingExtension.read();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to read branding extension", ioe);
        }
    }

    private void registerApplicationEntryPoints() {
        ApplicationRegistry.registerApplicationEntryPoints();
    }

    private static final class DependentResource {
        public final IResource resource;
        public final String id;
        public final List dependencies;

        public DependentResource(IResource resource, String id, List dependencies) {
            this.resource = resource;
            this.id = id;
            this.dependencies = dependencies;
        }

        public String toString() {
            return this.id != null ? this.id : this.resource.getClass().getName();
        }
    }
}

