/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.common.internal.services;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.gyrex.common.internal.services.IServiceProxyDisposalListener;
import org.eclipse.gyrex.common.internal.services.ServiceProxy;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;

public class ServiceProxyPool {
    private final ConcurrentHashMap<String, ServiceProxy<?>> trackedServices = new ConcurrentHashMap();
    private final AtomicReference<BundleContext> bundleContextRef = new AtomicReference();

    public ServiceProxyPool(BundleContext bundleContext) {
        this.bundleContextRef.set(bundleContext);
    }

    public void dispose() {
        this.bundleContextRef.set(null);
        for (ServiceProxy<?> serviceProxy : this.trackedServices.values()) {
            serviceProxy.dispose();
        }
        this.trackedServices.clear();
    }

    public BundleContext getBundleContext() {
        BundleContext context = this.bundleContextRef.get();
        if (context == null) {
            throw new IllegalStateException("disposed");
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> IServiceProxy<T> getOrCreate(Class<T> serviceInterface) {
        BundleContext bundleContext = this.bundleContextRef.get();
        if (bundleContext == null) {
            throw new IllegalStateException("inactive");
        }
        String key = serviceInterface.getName().intern();
        ServiceProxy<Object> proxy = this.trackedServices.get(key);
        if (proxy == null) {
            ConcurrentHashMap<String, ServiceProxy<?>> concurrentHashMap = this.trackedServices;
            synchronized (concurrentHashMap) {
                proxy = this.trackedServices.get(key);
                if (proxy == null) {
                    proxy = new ServiceProxy<T>(this.getBundleContext(), serviceInterface);
                    proxy.addDisposalListener(new RemoveOnDisposalListener(key));
                    this.trackedServices.put(key, proxy);
                }
            }
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> IServiceProxy<T> getOrCreate(Class<T> serviceInterface, Filter filter) {
        BundleContext bundleContext = this.bundleContextRef.get();
        if (bundleContext == null) {
            throw new IllegalStateException("inactive");
        }
        String key = serviceInterface.getName().intern().concat(filter.toString().intern());
        ServiceProxy<Object> proxy = this.trackedServices.get(key);
        if (proxy == null) {
            ConcurrentHashMap<String, ServiceProxy<?>> concurrentHashMap = this.trackedServices;
            synchronized (concurrentHashMap) {
                proxy = this.trackedServices.get(key);
                if (proxy == null) {
                    proxy = new ServiceProxy<T>(bundleContext, serviceInterface, filter);
                    proxy.addDisposalListener(new RemoveOnDisposalListener(key));
                    this.trackedServices.put(key, proxy);
                }
            }
        }
        return proxy;
    }

    private final class RemoveOnDisposalListener
    implements IServiceProxyDisposalListener {
        private final String key;

        private RemoveOnDisposalListener(String key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disposed(IServiceProxy<?> proxy) {
            ConcurrentHashMap concurrentHashMap = ServiceProxyPool.this.trackedServices;
            synchronized (concurrentHashMap) {
                ServiceProxyPool.this.trackedServices.remove(this.key);
            }
        }
    }
}

