/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.console;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.cloud.admin.ICloudManager;
import org.eclipse.gyrex.cloud.admin.INodeDescriptor;
import org.eclipse.gyrex.cloud.internal.CloudActivator;
import org.eclipse.gyrex.common.console.Command;
import org.kohsuke.args4j.Argument;

public class ListNodesCmd
extends Command {
    private static final String APPROVED = "approved";
    private static final String PENDING = "pending";
    private static final String ONLINE = "online";
    @Argument(index=0, metaVar="pending|approved|online", usage="specify the type of nodes to list")
    String what;
    @Argument(index=1, metaVar="FILTER", usage="an optional filter string")
    String filter;

    static boolean matchesFilter(String filter, INodeDescriptor node) {
        return StringUtils.isBlank((String)filter) || StringUtils.containsIgnoreCase((String)node.getId(), (String)filter) || StringUtils.containsIgnoreCase((String)node.getName(), (String)filter) || StringUtils.containsIgnoreCase((String)node.getLocation(), (String)filter);
    }

    public ListNodesCmd() {
        super("pending|approved|online - list nodes");
    }

    private void collectedNodes(Map<String, INodeDescriptor> nodes, Collection<INodeDescriptor> nodeDescriptors) {
        for (INodeDescriptor nodeDescriptor : nodeDescriptors) {
            nodes.put(nodeDescriptor.getId(), nodeDescriptor);
        }
    }

    protected void doExecute() throws Exception {
        ICloudManager cloudManager = (ICloudManager)CloudActivator.getInstance().getService(ICloudManager.class);
        Collection<String> onlineNodes = cloudManager.getOnlineNodes();
        HashMap<String, INodeDescriptor> nodes = new HashMap<String, INodeDescriptor>();
        this.collectedNodes(nodes, cloudManager.getApprovedNodes());
        this.collectedNodes(nodes, cloudManager.getPendingNodes());
        TreeSet<INodeDescriptor> result = new TreeSet<INodeDescriptor>(new Comparator<INodeDescriptor>(){

            @Override
            public int compare(INodeDescriptor o1, INodeDescriptor o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        if (StringUtils.isBlank((String)this.what)) {
            result.addAll(nodes.values());
        } else if (StringUtils.startsWithIgnoreCase((String)APPROVED, (String)this.what)) {
            for (INodeDescriptor node : nodes.values()) {
                if (!node.isApproved()) continue;
                result.add(node);
            }
        } else if (StringUtils.startsWithIgnoreCase((String)PENDING, (String)this.what)) {
            for (INodeDescriptor node : nodes.values()) {
                if (node.isApproved()) continue;
                result.add(node);
            }
        } else if (StringUtils.startsWith((String)ONLINE, (String)this.what)) {
            for (String onlineNode : onlineNodes) {
                INodeDescriptor node = (INodeDescriptor)nodes.get(onlineNode);
                if (node == null) continue;
                result.add(node);
            }
        }
        for (INodeDescriptor node : result) {
            String approved;
            if (!ListNodesCmd.matchesFilter(this.filter, node)) continue;
            String name = StringUtils.isNotBlank((String)node.getName()) ? node.getName() : "<unnamed>";
            String location = StringUtils.isNotBlank((String)node.getLocation()) ? node.getLocation() : "<unknown>";
            String tags = StringUtils.join(node.getTags(), (String)", ");
            String string = approved = node.isApproved() ? APPROVED : "not approved";
            if (onlineNodes.contains(node.getId())) {
                this.printf("%s - %s @ %s [%s, online] %s", new Object[]{node.getId(), name, location, approved, tags});
                continue;
            }
            this.printf("%s - %s @ %s [%s] %s", new Object[]{node.getId(), name, location, approved, tags});
        }
    }
}

