/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.RWTMessages;
import org.eclipse.rwt.internal.branding.BrandingUtil;
import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.rwt.internal.resources.JSLibraryServiceHandler;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.StartupPage;
import org.eclipse.rwt.internal.service.StartupPageTemplateHolder;
import org.eclipse.rwt.internal.textsize.MeasurementUtil;
import org.eclipse.rwt.internal.theme.ThemeUtil;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.resources.IResource;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.swt.internal.widgets.displaykit.DisplayLCAFacade;

public final class StartupPageConfigurer
implements StartupPage.IStartupPageConfigurer {
    private static final String PACKAGE_NAME;
    private static final String FOLDER;
    private static final String INDEX_TEMPLATE;
    private int probeCount;
    private long lastModified = System.currentTimeMillis();
    private StartupPageTemplateHolder template;
    private final List registeredBrandings = new LinkedList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.service.StartupPageConfigurer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PACKAGE_NAME = clazz.getPackage().getName();
        FOLDER = PACKAGE_NAME.replace('.', '/');
        INDEX_TEMPLATE = String.valueOf(FOLDER) + "/rwt-index.html";
    }

    public StartupPageTemplateHolder getTemplate() throws IOException {
        this.readContent();
        this.template.reset();
        DisplayLCAFacade.registerResources();
        this.template.replace(StartupPageTemplateHolder.VAR_LIBRARIES, StartupPageConfigurer.getJsLibraries());
        this.template.replace(StartupPageTemplateHolder.VAR_APPSCRIPT, StartupPageConfigurer.getAppScript());
        this.applyBranding();
        return this.template;
    }

    public synchronized boolean isModifiedSince() {
        boolean result;
        int currentProbeCount = MeasurementUtil.getProbeCount();
        if (this.probeCount != currentProbeCount) {
            this.lastModified = System.currentTimeMillis();
            this.probeCount = currentProbeCount;
        }
        HttpServletRequest request = ContextProvider.getRequest();
        HttpServletResponse response = ContextProvider.getResponse();
        response.addHeader("Cache-Control", "max-age=0, no-cache, must-revalidate, no-store");
        long dateHeader = request.getDateHeader("If-Modified-Since");
        if (dateHeader + 1000L < this.lastModified) {
            result = true;
            response.addDateHeader("Last-Modified", this.lastModified);
        } else {
            result = false;
            response.setStatus(304);
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readContent() throws IOException {
        if (this.template != null) return;
        InputStream stream = StartupPageConfigurer.loadTemplateFile();
        InputStreamReader streamReader = new InputStreamReader(stream, "UTF-8");
        BufferedReader reader = new BufferedReader(streamReader);
        try {
            String line = reader.readLine();
            StringBuffer buffer = new StringBuffer();
            while (true) {
                block4: {
                    if (line != null) break block4;
                    this.template = new StartupPageTemplateHolder(buffer.toString());
                    break;
                }
                buffer.append(line);
                buffer.append("\n");
                line = reader.readLine();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            reader.close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        reader.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InputStream loadTemplateFile() throws IOException {
        InputStream result = null;
        IResourceManager resourceManager = RWT.getResourceManager();
        ClassLoader buffer = resourceManager.getContextLoader();
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.rwt.internal.service.StartupPageConfigurer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        resourceManager.setContextLoader(clazz.getClassLoader());
        try {
            result = resourceManager.getResourceAsStream(INDEX_TEMPLATE);
            if (result == null) {
                String text = "Failed to load Browser Survey HTML Page. Resource {0} could not be found.";
                Object[] param = new Object[]{INDEX_TEMPLATE};
                String msg = MessageFormat.format(text, param);
                throw new IOException(msg);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            resourceManager.setContextLoader(buffer);
            throw throwable;
        }
        {
            Object var6_8 = null;
            resourceManager.setContextLoader(buffer);
            return result;
        }
    }

    private static String getAppScript() {
        StringBuffer code = new StringBuffer();
        code.append(StartupPageConfigurer.getTextSizeProbeCode());
        code.append(StartupPageConfigurer.getApplicationJsCode("w1"));
        return code.toString();
    }

    private static String getTextSizeProbeCode() {
        return MeasurementUtil.getStartupProbeCode();
    }

    private static String getApplicationJsCode(String id) {
        HttpServletRequest request = ContextProvider.getRequest();
        String url = request.getServletPath().substring(1);
        String encodedURL = ContextProvider.getResponse().encodeURL(url);
        return "var req = org.eclipse.swt.Request.getInstance();req.setUrl( \"" + encodedURL + "\" );" + "req.setUIRootId( \"" + id + "\" );" + "var app = new org.eclipse.swt.Application();" + "qx.core.Init.getInstance().setApplication( app );";
    }

    private void applyBranding() throws IOException {
        AbstractBranding branding = BrandingUtil.determineBranding();
        this.registerBrandingResources(branding);
        HttpServletRequest request = ContextProvider.getRequest();
        String entryPoint = request.getParameter("startup");
        if (entryPoint == null && ((entryPoint = branding.getDefaultEntryPoint()) == null || "".equals(entryPoint))) {
            entryPoint = "default";
        }
        if (branding.getThemeId() != null) {
            ThemeUtil.setCurrentThemeId(branding.getThemeId());
        }
        BrandingUtil.replacePlaceholder(this.template, StartupPageTemplateHolder.VAR_BODY, branding.getBody());
        BrandingUtil.replacePlaceholder(this.template, StartupPageTemplateHolder.VAR_TITLE, branding.getTitle());
        String headers = BrandingUtil.headerMarkup(branding);
        BrandingUtil.replacePlaceholder(this.template, StartupPageTemplateHolder.VAR_HEADERS, headers);
        String encodedEntryPoint = EncodingUtil.encodeHTMLEntities(entryPoint);
        BrandingUtil.replacePlaceholder(this.template, StartupPageTemplateHolder.VAR_STARTUP, encodedEntryPoint);
        String noScriptWarning = RWTMessages.getMessage("RWT_NoScriptWarning");
        BrandingUtil.replacePlaceholder(this.template, StartupPageTemplateHolder.VAR_NO_SCRIPT_MESSAGE, noScriptWarning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBrandingResources(AbstractBranding branding) throws IOException {
        List list = this.registeredBrandings;
        synchronized (list) {
            if (!this.registeredBrandings.contains(branding)) {
                branding.registerResources();
                this.registeredBrandings.add(branding);
            }
        }
    }

    private static String getJsLibraries() {
        StringBuffer buffer = new StringBuffer();
        IResource[] resources = RWTFactory.getResourceRegistry().get();
        int i = 0;
        while (i < resources.length) {
            if (resources[i].isExternal() && resources[i].isJSLibrary()) {
                StartupPageConfigurer.writeScriptTag(buffer, resources[i].getLocation());
            }
            ++i;
        }
        StartupPageConfigurer.writeScriptTag(buffer, JSLibraryServiceHandler.getRequestURL());
        return buffer.toString();
    }

    private static void writeScriptTag(StringBuffer buffer, String library) {
        buffer.append("<script type=\"text/javascript\" src=\"");
        buffer.append(library);
        buffer.append("\" charset=\"");
        buffer.append("UTF-8");
        buffer.append("\"></script>");
    }
}

