/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.app;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.http.internal.application.gateway.HttpGatewayBinding;
import org.eclipse.gyrex.http.internal.application.gateway.IUrlRegistry;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationRegistration;
import org.eclipse.gyrex.http.jetty.internal.JettyDebug;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationHandler;
import org.eclipse.gyrex.http.jetty.internal.app.JettyGateway;
import org.eclipse.jetty.server.Handler;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlRegistry
implements IUrlRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(UrlRegistry.class);
    private final JettyGateway jettyGateway;
    private final HttpGatewayBinding applicationManager;
    private final ConcurrentMap<String, String> applicationIdsByUrl = new ConcurrentHashMap<String, String>(30);
    private final ConcurrentMap<String, Handler> appHandlerByAppId = new ConcurrentHashMap<String, Handler>();

    public UrlRegistry(JettyGateway jettyGateway, HttpGatewayBinding applicationManager) {
        this.jettyGateway = jettyGateway;
        this.applicationManager = applicationManager;
    }

    public void applicationUnregistered(String applicationId) {
        if (JettyDebug.debug) {
            LOG.debug("application unregistered: {}", (Object)applicationId);
        }
        for (Map.Entry entry : this.applicationIdsByUrl.entrySet()) {
            if (!((String)entry.getValue()).equals(applicationId)) continue;
            this.applicationIdsByUrl.remove(entry.getKey());
            if (!JettyDebug.debug) continue;
            LOG.debug("removed url: {}", entry.getKey());
        }
        Handler handler = (Handler)this.appHandlerByAppId.remove(applicationId);
        if (handler == null) {
            return;
        }
        try {
            this.jettyGateway.removeApplicationHandler(handler, true);
        }
        catch (Exception e) {
            LOG.warn("Error while removing app '{}' from the underlying Jetty engine. There might be resources leaking. {}", (Object)applicationId, (Object)e.getMessage());
        }
        handler.destroy();
    }

    private Handler ensureHandler(String applicationId) {
        Handler applicationContextHandler = (Handler)this.appHandlerByAppId.get(applicationId);
        if (applicationContextHandler == null) {
            ApplicationRegistration applicationRegistration = this.applicationManager.getApplicationRegistration(applicationId);
            if (applicationRegistration == null) {
                throw new IllegalStateException(NLS.bind((String)"Application \"{0}\" could not be retreived from the registry!", (Object)applicationId));
            }
            this.appHandlerByAppId.putIfAbsent(applicationId, this.jettyGateway.customize(new ApplicationHandler(applicationRegistration)));
            applicationContextHandler = (Handler)this.appHandlerByAppId.get(applicationId);
        }
        return applicationContextHandler;
    }

    public String registerIfAbsent(String url, String applicationId) {
        String existingRegistration = this.applicationIdsByUrl.putIfAbsent(url, applicationId);
        if (existingRegistration != null) {
            return existingRegistration;
        }
        Handler handler = this.ensureHandler(applicationId);
        this.jettyGateway.getApplicationHandler(handler).addUrl(url);
        try {
            this.jettyGateway.addApplicationHandlerIfAbsent(handler);
        }
        catch (Exception e) {
            try {
                this.jettyGateway.removeApplicationHandler(handler, true);
            }
            catch (Exception exception) {}
            throw new IllegalStateException("Error while binding application '" + applicationId + "' to url '" + url + "' with the underlying Jetty engine. " + e.getMessage(), e);
        }
        return null;
    }

    public String unregister(String url) {
        String appId = (String)this.applicationIdsByUrl.remove(url);
        if (appId == null) {
            return null;
        }
        Handler handler = this.ensureHandler(appId);
        this.jettyGateway.getApplicationHandler(handler).removeUrl(url);
        try {
            if (this.jettyGateway.removeApplicationHandler(handler, false)) {
                handler = (Handler)this.appHandlerByAppId.remove(appId);
                handler.destroy();
            }
        }
        catch (Exception e) {
            LOG.warn("Error while unbinding url '{}' from the underlying Jetty engine. There might be resources leaking. {}", new Object[]{url, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
        return appId;
    }
}

