/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.internal;

import org.eclipse.gyrex.http.application.manager.IApplicationManager;
import org.eclipse.gyrex.http.internal.HttpActivator;
import org.eclipse.gyrex.http.internal.application.gateway.HttpGatewayBinding;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationManager;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class HttpLifecycleComponent
implements EventHandler {
    private ApplicationManager applicationManager;
    private ServiceRegistration<IApplicationManager> appManagerServiceRegistration;
    private HttpGatewayBinding gatewayBinding;

    private synchronized void activate() {
        if (this.applicationManager != null) {
            return;
        }
        this.applicationManager = new ApplicationManager();
        this.appManagerServiceRegistration = HttpActivator.getInstance().getServiceHelper().registerService(IApplicationManager.class, (Object)this.applicationManager, "Eclipse Gyrex", "Gyrex Web Application Management Service", null, null);
        this.gatewayBinding = new HttpGatewayBinding(HttpActivator.getInstance().getBundle().getBundleContext(), this.applicationManager);
        this.gatewayBinding.open();
    }

    private synchronized void deactivate() {
        if (this.gatewayBinding != null) {
            this.gatewayBinding.close();
            this.gatewayBinding = null;
        }
        if (this.appManagerServiceRegistration != null) {
            this.appManagerServiceRegistration.unregister();
            this.appManagerServiceRegistration = null;
        }
        if (this.applicationManager != null) {
            this.applicationManager = null;
        }
    }

    public void handleEvent(Event event) {
        if ("org/eclipse/gyrex/cloud/node/online".equals(event.getTopic())) {
            this.activate();
        } else if ("org/eclipse/gyrex/cloud/node/offline".equals(event.getTopic())) {
            this.deactivate();
        }
    }
}

