/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal.services;

import org.eclipse.gyrex.common.services.BundleServiceHelper;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.context.internal.GyrexContextImpl;
import org.eclipse.gyrex.context.internal.configuration.ContextConfiguration;
import org.eclipse.gyrex.context.services.IRuntimeContextServiceLocator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class GyrexContextServiceLocatorImpl
implements IRuntimeContextServiceLocator {
    private final BundleServiceHelper serviceHelper;
    private final GyrexContextImpl context;
    private final BundleContext bundleContext;

    public GyrexContextServiceLocatorImpl(GyrexContextImpl context, BundleContext bundleContext) {
        this.context = context;
        this.bundleContext = bundleContext;
        this.serviceHelper = new BundleServiceHelper(bundleContext);
    }

    public void dispose() {
        this.serviceHelper.dispose();
    }

    public <T> IServiceProxy<T> trackService(Class<T> serviceInterface) {
        try {
            return this.trackService(serviceInterface, null);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("invalid filter syntax", e);
        }
    }

    public <T> IServiceProxy<T> trackService(Class<T> serviceInterface, String additionalFilter) throws InvalidSyntaxException {
        Filter contextFilter;
        Filter filter = null;
        if (additionalFilter != null) {
            filter = this.bundleContext.createFilter(additionalFilter);
        }
        if ((contextFilter = ContextConfiguration.findFilter(this.context.getContextPath(), serviceInterface.getName())) != null) {
            filter = filter != null ? this.bundleContext.createFilter(String.format("(&(%s)(%s))", contextFilter.toString(), filter.toString())) : contextFilter;
        } else if (filter != null) {
            filter = this.bundleContext.createFilter(String.format("(&(objectClass=%s)(%s))", serviceInterface.getName(), filter.toString()));
        }
        if (filter != null) {
            return this.serviceHelper.trackService(serviceInterface, filter);
        }
        return this.serviceHelper.trackService(serviceInterface);
    }
}

