/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.preferences;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zookeeper.data.Stat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.preferences.ZooKeeperPreferencesService;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZooKeeperBasedPreferences
implements IEclipsePreferences {
    private static final long RELOAD_AGE = Long.getLong("gyrex.preferences.reloadAfter", 3000L);
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperBasedPreferences.class);
    private static final String VERSION_KEY = "gyrex.preferences.version";
    private static final String VERSION_VALUE = "1";
    private static final String[] EMPTY_NAMES_ARRAY = new String[0];
    private static final String PATH_SEPARATOR = String.valueOf('/');
    private static final String EMPTY_STRING = "";
    private static final String FALSE = Boolean.FALSE.toString();
    private static final String TRUE = Boolean.TRUE.toString();
    private final ZooKeeperPreferencesService service;
    private final IEclipsePreferences parent;
    private final String name;
    private final IPath path;
    final String zkPath;
    private final ConcurrentMap<String, ZooKeeperBasedPreferences> children = new ConcurrentHashMap<String, ZooKeeperBasedPreferences>(4);
    private final Map<String, ZooKeeperBasedPreferences> pendingChildRemovals = new HashMap<String, ZooKeeperBasedPreferences>();
    private final Properties properties = new Properties();
    final Lock childrenModifyLock = new ReentrantLock();
    final Lock propertiesModificationLock = new ReentrantLock();
    volatile boolean removed;
    volatile int propertiesVersion = -1;
    volatile int childrenVersion = -1;
    volatile long propertiesLoadTimestamp;
    volatile long childrenLoadTimestamp;
    private volatile ListenerList nodeListeners;
    private volatile ListenerList preferenceListeners;

    public ZooKeeperBasedPreferences(IEclipsePreferences parent, String name, ZooKeeperPreferencesService service) {
        if (parent == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (service == null) {
            throw new IllegalArgumentException("service must not be null");
        }
        this.service = service;
        this.parent = parent;
        this.name = name;
        this.path = parent.absolutePath().equals(PATH_SEPARATOR) ? new Path(name).makeAbsolute() : new Path(parent.absolutePath()).append(name).makeAbsolute();
        this.zkPath = IZooKeeperLayout.PATH_PREFERENCES_ROOT.append(this.path).toString();
        if (!(parent instanceof ZooKeeperBasedPreferences) && service.activeNodesByPath.putIfAbsent(this.zkPath, this) != null) {
            throw new IllegalStateException(String.format("programming/concurrency error: created a new scope root although one already existed (new=%s) (%s)", this, service));
        }
    }

    public String absolutePath() {
        return this.path.toString();
    }

    public void accept(IPreferenceNodeVisitor visitor) throws BackingStoreException {
        this.ensureLoaded();
        if (!visitor.visit((IEclipsePreferences)this)) {
            return;
        }
        Collection toVisit = this.children.values();
        for (ZooKeeperBasedPreferences child : toVisit) {
            child.accept(visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        if (this.nodeListeners == null) {
            ZooKeeperBasedPreferences zooKeeperBasedPreferences = this;
            synchronized (zooKeeperBasedPreferences) {
                if (this.nodeListeners == null) {
                    this.nodeListeners = new ListenerList();
                }
            }
        }
        this.ensureLoadedIfPossible();
        this.nodeListeners.add((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        if (this.preferenceListeners == null) {
            ZooKeeperBasedPreferences zooKeeperBasedPreferences = this;
            synchronized (zooKeeperBasedPreferences) {
                if (this.preferenceListeners == null) {
                    this.preferenceListeners = new ListenerList();
                }
            }
        }
        this.ensureLoadedIfPossible();
        this.preferenceListeners.add((Object)listener);
    }

    private IEclipsePreferences calculateRoot() {
        ZooKeeperBasedPreferences result = this;
        while (result.parent() != null) {
            result = (IEclipsePreferences)result.parent();
        }
        return result;
    }

    private void checkRemoved() {
        if (this.removed) {
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Node {} has been removed! Operation will fail.", new Object[]{this});
            }
            throw new IllegalStateException(String.format("Node '%s' has been removed.", this.name));
        }
    }

    public String[] childrenNames() throws BackingStoreException {
        try {
            this.ensureLoaded();
            Set names = this.children.keySet();
            return !names.isEmpty() ? names.toArray(EMPTY_NAMES_ARRAY) : EMPTY_NAMES_ARRAY;
        }
        catch (Exception e) {
            throw this.createBackingStoreException("reading children", e);
        }
    }

    public void clear() throws BackingStoreException {
        this.ensureLoaded();
        try {
            String[] keys = this.keys();
            int i = 0;
            while (i < keys.length) {
                this.remove(keys[i]);
                ++i;
            }
        }
        catch (Exception e) {
            throw this.createBackingStoreException("removing properties", e);
        }
    }

    protected BackingStoreException createBackingStoreException(String action, Exception cause) {
        return new BackingStoreException(String.format("Error %s (node %s). %s", action, this.absolutePath(), cause.getMessage() != null ? cause.getMessage() : ExceptionUtils.getMessage((Throwable)cause)), (Throwable)cause);
    }

    private ZooKeeperBasedPreferences createChild(String name, List<ZooKeeperBasedPreferences> added) {
        this.childrenModifyLock.lock();
        try {
            ZooKeeperBasedPreferences child = (ZooKeeperBasedPreferences)this.children.get(name);
            if (child != null) {
                ZooKeeperBasedPreferences zooKeeperBasedPreferences = child;
                return zooKeeperBasedPreferences;
            }
            child = this.newChild(name);
            ZooKeeperBasedPreferences existingChild = this.children.put(name, child);
            if (existingChild != null && existingChild != child) {
                throw new AssertionError((Object)String.format("programming/concurrency error: created a new child although one still existed (new=%s %d) (old=%s %d)", child, System.identityHashCode(child), existingChild, System.identityHashCode(existingChild)));
            }
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Node {} child created: {} ", (Object)this, (Object)name);
            }
            this.service.activateNode(child);
            this.pendingChildRemovals.remove(name);
            if (added != null) {
                added.add(child);
            }
            ZooKeeperBasedPreferences zooKeeperBasedPreferences = child;
            return zooKeeperBasedPreferences;
        }
        finally {
            this.childrenModifyLock.unlock();
        }
    }

    final void dispose() {
        this.nodeListeners = null;
        this.preferenceListeners = null;
        this.properties.clear();
        this.children.clear();
    }

    private void doRemove(String key) {
        String oldValue = this.properties.getProperty(key);
        if (oldValue == null) {
            return;
        }
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("[REMOVE] {} - {}", new Object[]{this, key});
        }
        this.propertiesModificationLock.lock();
        try {
            if (this.properties.remove(key) == null) {
                if (CloudDebug.zooKeeperPreferences) {
                    LOG.debug("[REMOVE] Aborted due to concurrent removal. {} - {}", new Object[]{this, key});
                }
                return;
            }
        }
        finally {
            this.propertiesModificationLock.unlock();
        }
        this.firePreferenceEvent(new IEclipsePreferences.PreferenceChangeEvent((Object)this, key, (Object)oldValue, null));
    }

    private void ensureLoaded() throws BackingStoreException {
        this.checkRemoved();
        if (this.propertiesLoadTimestamp > System.currentTimeMillis() - RELOAD_AGE && this.childrenLoadTimestamp > System.currentTimeMillis() - RELOAD_AGE) {
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Node had been loaded recently. Skipping load request for node {}!", (Object)this);
            }
            return;
        }
        try {
            if (this.shouldLoad()) {
                if (CloudDebug.zooKeeperPreferences) {
                    LOG.debug("Ensuring that node {} (version {}, cversion {}) is loaded!", new Object[]{this, this.propertiesVersion, this.childrenVersion});
                }
                this.service.loadNode(this.zkPath, true);
            }
            this.propertiesLoadTimestamp = this.childrenLoadTimestamp = System.currentTimeMillis();
        }
        catch (Exception e) {
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Exception while connecting node {}: {}", new Object[]{this, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
            throw this.createBackingStoreException("loading node", e);
        }
    }

    private void ensureLoadedIfPossible() throws IllegalStateException {
        this.checkRemoved();
        if (this.propertiesLoadTimestamp > System.currentTimeMillis() - RELOAD_AGE && this.childrenLoadTimestamp > System.currentTimeMillis() - RELOAD_AGE) {
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Node had been loaded recently. Skipping load request for node {}!", (Object)this);
            }
            return;
        }
        try {
            if (this.shouldLoad()) {
                if (CloudDebug.zooKeeperPreferences) {
                    LOG.debug("Ensuring (if possible) that node {} (version {}, cversion {}) is loaded!", new Object[]{this, this.propertiesVersion, this.childrenVersion});
                }
                this.service.loadNode(this.zkPath, false);
                this.propertiesLoadTimestamp = this.childrenLoadTimestamp = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Exception while loading node {}: {}", new Object[]{this, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
            throw new IllegalStateException(String.format("Error loading node '%s'. %s", this, e.getMessage()), e);
        }
    }

    private void fireNodeEvent(ZooKeeperBasedPreferences child, boolean added) {
        IEclipsePreferences.NodeChangeEvent event = new IEclipsePreferences.NodeChangeEvent((Preferences)this, (Preferences)child);
        ListenerList listeners = this.nodeListeners;
        if (listeners != null) {
            Object[] objectArray = listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    if (added) {
                        ((IEclipsePreferences.INodeChangeListener)listener).added(event);
                    } else {
                        ((IEclipsePreferences.INodeChangeListener)listener).removed(event);
                    }
                }
                catch (AssertionError e) {
                    LOG.error("Removing bogus node listener ({}) after exception.", listener, (Object)e);
                    listeners.remove(listener);
                }
                catch (LinkageError e) {
                    LOG.error("Removing bogus node listener ({}) after exception.", listener, (Object)e);
                    listeners.remove(listener);
                }
                catch (Exception e) {
                    LOG.error("Removing bogus node listener ({}) after exception.", listener, (Object)e);
                    listeners.remove(listener);
                }
                ++n2;
            }
        }
    }

    private void firePreferenceEvent(IEclipsePreferences.PreferenceChangeEvent event) {
        ListenerList listeners;
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("Sending event {}.", (Object)event);
        }
        if ((listeners = this.preferenceListeners) != null) {
            Object[] objectArray = listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    if (CloudDebug.zooKeeperPreferences) {
                        LOG.debug("Sending event to {}.", listener);
                    }
                    ((IEclipsePreferences.IPreferenceChangeListener)listener).preferenceChange(event);
                }
                catch (AssertionError e) {
                    LOG.error("Removing bogus preference listener ({}) after exception.", listener, (Object)e);
                    listeners.remove(listener);
                }
                catch (LinkageError e) {
                    LOG.error("Removing bogus preference listener ({}) after exception.", listener, (Object)e);
                    listeners.remove(listener);
                }
                catch (Exception e) {
                    LOG.warn("Removing bogus preference listener ({}) after exception. ", listener, (Object)e);
                    listeners.remove(listener);
                }
                ++n2;
            }
        }
    }

    public void flush() throws BackingStoreException {
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("Flushing node {} (version {}, cversion {})", new Object[]{this, this.propertiesVersion, this.childrenVersion});
        }
        this.ensureLoaded();
        this.childrenModifyLock.lock();
        try {
            try {
                this.checkRemoved();
                this.propertiesModificationLock.lock();
                try {
                    this.checkRemoved();
                    this.saveProperties();
                }
                finally {
                    this.propertiesModificationLock.unlock();
                }
                this.childrenVersion = Math.max(0, this.childrenVersion);
                this.saveChildren();
            }
            catch (Exception e) {
                throw this.createBackingStoreException("flushing node", e);
            }
        }
        finally {
            this.childrenModifyLock.unlock();
        }
        if (CloudDebug.zooKeeperPreferences) {
            LOG.info("Flushed node {} (version {}, cversion {})", new Object[]{this, this.propertiesVersion, this.childrenVersion});
        }
    }

    public String get(String key, String def) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (this.shouldLoad() && this.properties.isEmpty()) {
            this.ensureLoadedIfPossible();
        } else {
            this.checkRemoved();
        }
        String value = this.properties.getProperty(key);
        return value == null ? def : value;
    }

    public boolean getBoolean(String key, boolean def) {
        String value = this.get(key, null);
        return value == null ? def : TRUE.equalsIgnoreCase(value);
    }

    public byte[] getByteArray(String key, byte[] def) {
        String value = this.get(key, null);
        try {
            return value == null ? def : Base64.decodeBase64((byte[])value.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java VM does not support US_ASCII encoding? " + e.getMessage());
        }
    }

    public double getDouble(String key, double def) {
        String value = this.get(key, null);
        return value == null ? def : Double.valueOf(value);
    }

    public float getFloat(String key, float def) {
        String value = this.get(key, null);
        return value == null ? def : Float.valueOf(value).floatValue();
    }

    public int getInt(String key, int def) {
        String value = this.get(key, null);
        return value == null ? def : Integer.valueOf(value);
    }

    public long getLong(String key, long def) {
        String value = this.get(key, null);
        return value == null ? def : Long.valueOf(value);
    }

    protected ZooKeeperPreferencesService getService() {
        return this.service;
    }

    public String[] keys() throws BackingStoreException {
        this.ensureLoaded();
        if (this.properties.isEmpty()) {
            return EMPTY_NAMES_ARRAY;
        }
        Set<String> names = this.properties.stringPropertyNames();
        return names.toArray(EMPTY_NAMES_ARRAY);
    }

    final void loadChildren(Collection<String> remoteChildrenNames, int childrenVersion) throws Exception {
        if (this.removed) {
            return;
        }
        ArrayList<ZooKeeperBasedPreferences> addedNodes = new ArrayList<ZooKeeperBasedPreferences>(3);
        ArrayList removedNodes = new ArrayList(3);
        this.childrenModifyLock.lock();
        try {
            if (this.removed) {
                return;
            }
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Loading children for node {} (cversion {})", (Object)this, (Object)childrenVersion);
            }
            this.childrenVersion = childrenVersion;
            this.childrenLoadTimestamp = System.currentTimeMillis();
            for (String name : remoteChildrenNames) {
                if (this.children.containsKey(name)) continue;
                ZooKeeperBasedPreferences removedNode = this.pendingChildRemovals.get(name);
                if (removedNode != null) {
                    Stat versionInfo = this.service.getVersionInfo(removedNode.zkPath);
                    if (versionInfo == null) {
                        for (String child : this.pendingChildRemovals.keySet()) {
                            LOG.debug("Node {} child also removed remotely: {}", (Object)this, (Object)child);
                        }
                        this.pendingChildRemovals.remove(name);
                    } else {
                        if (versionInfo.getVersion() == removedNode.propertiesVersion && versionInfo.getCversion() == removedNode.childrenVersion) {
                            for (String child : this.pendingChildRemovals.keySet()) {
                                LOG.debug("Node {} keeping unflushed local removal for child: {}", (Object)this, (Object)child);
                            }
                            continue;
                        }
                        for (String child : this.pendingChildRemovals.keySet()) {
                            LOG.debug("Node {} restored local removal for child due to newer remot version: {}", (Object)this, (Object)child);
                        }
                        this.pendingChildRemovals.remove(name);
                    }
                }
                ZooKeeperBasedPreferences child = this.createChild(name, addedNodes);
                if (!CloudDebug.zooKeeperPreferences) continue;
                LOG.debug("Node {} child added: {} ", (Object)this, (Object)child);
            }
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Loaded children for node {} (now at cversion {})", (Object)this, (Object)childrenVersion);
            }
        }
        finally {
            this.childrenModifyLock.unlock();
        }
        for (ZooKeeperBasedPreferences child : addedNodes) {
            this.fireNodeEvent(child, true);
        }
        for (ZooKeeperBasedPreferences child : removedNodes) {
            this.fireNodeEvent(child, false);
        }
    }

    final void loadProperties(byte[] remotePropertyBytes, int propertiesVersion) throws IOException {
        if (this.removed) {
            return;
        }
        ArrayList<IEclipsePreferences.PreferenceChangeEvent> events = new ArrayList<IEclipsePreferences.PreferenceChangeEvent>();
        this.propertiesModificationLock.lock();
        try {
            if (this.removed) {
                return;
            }
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Loading properties for node {} (version {})", (Object)this, (Object)propertiesVersion);
            }
            Properties loadedProps = new Properties();
            if (remotePropertyBytes != null) {
                loadedProps.load(new ByteArrayInputStream(remotePropertyBytes));
                Object formatVersion = loadedProps.remove(VERSION_KEY);
                if (formatVersion == null || !VERSION_VALUE.equals(formatVersion)) {
                    LOG.warn("Properties with incompatible storage format version ({}) found for node {}.", formatVersion, (Object)this);
                    return;
                }
            }
            this.propertiesVersion = propertiesVersion;
            this.propertiesLoadTimestamp = System.currentTimeMillis();
            HashSet<String> propertyNames = new HashSet<String>();
            propertyNames.addAll(loadedProps.stringPropertyNames());
            propertyNames.addAll(this.properties.stringPropertyNames());
            for (String key : propertyNames) {
                String newValue = loadedProps.getProperty(key);
                String oldValue = this.properties.getProperty(key);
                if (newValue == null) {
                    this.properties.remove(key);
                    if (CloudDebug.zooKeeperPreferences) {
                        LOG.debug("Node {} property removed: {}", (Object)this, (Object)key);
                    }
                    events.add(new IEclipsePreferences.PreferenceChangeEvent((Object)this, key, (Object)oldValue, (Object)newValue));
                    continue;
                }
                if (oldValue != null && oldValue.equals(newValue)) continue;
                this.properties.put(key, newValue);
                if (CloudDebug.zooKeeperPreferences) {
                    if (oldValue == null) {
                        LOG.debug("Node {} property added: {}={}", new Object[]{this, key, newValue});
                    } else {
                        LOG.debug("Node {} property updated: {}={}", new Object[]{this, key, newValue});
                    }
                }
                events.add(new IEclipsePreferences.PreferenceChangeEvent((Object)this, key, (Object)oldValue, (Object)newValue));
            }
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Loaded properties for node {} (now at version {})", (Object)this, (Object)propertiesVersion);
            }
        }
        finally {
            this.propertiesModificationLock.unlock();
        }
        for (IEclipsePreferences.PreferenceChangeEvent event : events) {
            this.firePreferenceEvent(event);
        }
    }

    public String name() {
        return this.name;
    }

    protected abstract ZooKeeperBasedPreferences newChild(String var1);

    public Preferences node(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path name must not be null");
        }
        this.checkRemoved();
        if (path.length() == 0) {
            return this;
        }
        if (path.charAt(0) == '/') {
            return this.calculateRoot().node(path.substring(1));
        }
        int index = path.indexOf(47);
        String key = index == -1 ? path : path.substring(0, index);
        ZooKeeperBasedPreferences child = (ZooKeeperBasedPreferences)this.children.get(key);
        ArrayList<ZooKeeperBasedPreferences> added = new ArrayList<ZooKeeperBasedPreferences>(1);
        if (child == null) {
            if (this.shouldLoad() && this.children.isEmpty()) {
                this.ensureLoadedIfPossible();
            }
            child = this.createChild(key, added);
        }
        if (!added.isEmpty()) {
            for (ZooKeeperBasedPreferences addedChild : added) {
                this.fireNodeEvent(addedChild, true);
            }
        }
        return child.node(index == -1 ? EMPTY_STRING : path.substring(index + 1));
    }

    public boolean nodeExists(String pathName) throws BackingStoreException {
        boolean noSlash;
        if (pathName == null) {
            throw new IllegalArgumentException("path name must not be null");
        }
        if (this.removed && pathName.length() == 0) {
            return false;
        }
        this.checkRemoved();
        if (pathName.length() > 0 && pathName.charAt(0) == '/') {
            return this.calculateRoot().nodeExists(pathName.substring(1));
        }
        this.ensureLoaded();
        if (pathName.length() == 0) {
            return !this.removed;
        }
        int index = pathName.indexOf(47);
        boolean bl = noSlash = index == -1;
        if (noSlash) {
            return this.children.containsKey(pathName);
        }
        String childName = pathName.substring(0, index);
        ZooKeeperBasedPreferences child = (ZooKeeperBasedPreferences)this.children.get(childName);
        if (child == null) {
            return false;
        }
        return child.nodeExists(pathName.substring(index + 1));
    }

    public Preferences parent() {
        return this.parent;
    }

    public void put(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if (this.shouldLoad() && this.properties.isEmpty()) {
            this.ensureLoadedIfPossible();
        } else {
            this.checkRemoved();
        }
        String oldValue = this.properties.getProperty(key);
        if (value.equals(oldValue)) {
            return;
        }
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("[PUT] {} - {}: {}", new Object[]{this, key, value});
        }
        this.propertiesModificationLock.lock();
        try {
            if (value.equals(this.properties.setProperty(key, value))) {
                if (CloudDebug.zooKeeperPreferences) {
                    LOG.debug("[PUT] Aborted due to concurrent modification to the same value. {} - {}", new Object[]{this, key});
                }
                return;
            }
        }
        finally {
            this.propertiesModificationLock.unlock();
        }
        this.firePreferenceEvent(new IEclipsePreferences.PreferenceChangeEvent((Object)this, key, (Object)oldValue, (Object)value));
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, value ? TRUE : FALSE);
    }

    public void putByteArray(String key, byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        try {
            this.put(key, new String(Base64.encodeBase64((byte[])value), "US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java VM does not support US_ASCII encoding? " + e.getMessage());
        }
    }

    public void putDouble(String key, double value) {
        this.put(key, Double.toString(value));
    }

    public void putFloat(String key, float value) {
        this.put(key, Float.toString(value));
    }

    public void putInt(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    public void putLong(String key, long value) {
        this.put(key, Long.toString(value));
    }

    public void remove(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (this.shouldLoad() && this.properties.isEmpty()) {
            this.ensureLoadedIfPossible();
        } else {
            this.checkRemoved();
        }
        this.doRemove(key);
    }

    private boolean removeChild(ZooKeeperBasedPreferences child, boolean triggeredRemotely) {
        this.childrenModifyLock.lock();
        try {
            if (!this.children.remove(child.name(), child)) {
                return false;
            }
            child.removed = true;
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Node {} child removed: {} ", (Object)this, (Object)child.name());
            }
            this.service.deactivateNode(child);
            if (!triggeredRemotely) {
                this.pendingChildRemovals.put(child.name(), child);
            }
        }
        finally {
            this.childrenModifyLock.unlock();
        }
        this.fireNodeEvent(child, false);
        return true;
    }

    public void removeNode() throws BackingStoreException {
        this.removeNode(false);
    }

    /*
     * Exception decompiling
     */
    final void removeNode(boolean triggeredRemotely) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        if (this.nodeListeners != null) {
            this.nodeListeners.remove((Object)listener);
        }
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        if (this.preferenceListeners != null) {
            this.preferenceListeners.remove((Object)listener);
        }
    }

    private void saveChildren() throws Exception {
        if (this.removed) {
            return;
        }
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("Saving children of node {} (cversion {})", (Object)this, (Object)this.childrenVersion);
        }
        this.childrenModifyLock.lock();
        try {
            if (this.removed) {
                return;
            }
            for (ZooKeeperBasedPreferences child : this.children.values()) {
                child.flush();
            }
            for (ZooKeeperBasedPreferences child : this.pendingChildRemovals.values()) {
                if (CloudDebug.zooKeeperPreferences) {
                    LOG.debug("Removing child node {}", (Object)child);
                }
                this.service.removeNode(child.zkPath, child.propertiesVersion, child.childrenVersion);
            }
            this.pendingChildRemovals.clear();
        }
        finally {
            this.childrenModifyLock.unlock();
        }
    }

    private void saveProperties() throws Exception {
        if (this.removed) {
            return;
        }
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("Saving properties of node {} (version {})", (Object)this, (Object)this.propertiesVersion);
        }
        this.propertiesModificationLock.lock();
        try {
            if (this.removed) {
                return;
            }
            SortedProperties toSave = new SortedProperties();
            for (String key : this.properties.stringPropertyNames()) {
                String value = this.properties.getProperty(key);
                if (value == null) continue;
                toSave.put(key, value);
            }
            toSave.put(VERSION_KEY, VERSION_VALUE);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            toSave.store(out, null);
            this.propertiesVersion = this.service.writeProperties(this.zkPath, out.toByteArray(), this.propertiesVersion);
            this.propertiesLoadTimestamp = System.currentTimeMillis();
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Saved properties of node {} (now at version {})", (Object)this, (Object)this.propertiesVersion);
            }
        }
        finally {
            this.propertiesModificationLock.unlock();
        }
    }

    private boolean shouldLoad() {
        return this.propertiesVersion == -1 || this.childrenVersion == -1 || this.propertiesLoadTimestamp < System.currentTimeMillis() - RELOAD_AGE || this.childrenLoadTimestamp < System.currentTimeMillis() - RELOAD_AGE;
    }

    public void sync() throws BackingStoreException {
        this.syncTree();
        this.flush();
    }

    void syncTree() throws BackingStoreException {
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("Syncing node {} (version {}, cversion {})", new Object[]{this, this.propertiesVersion, this.childrenVersion});
        }
        this.ensureLoaded();
        this.childrenModifyLock.lock();
        try {
            this.checkRemoved();
            this.propertiesModificationLock.lock();
            try {
                Stat versionInfo;
                this.checkRemoved();
                if (this.propertiesVersion == -1 && (versionInfo = this.service.getVersionInfo(this.zkPath)) == null) {
                    if (CloudDebug.zooKeeperPreferences) {
                        LOG.debug("Sync aborted for node {} (version {}, cversion {}): it was never flushed and does not exists in ZooKeeper.", new Object[]{this, this.propertiesVersion, this.childrenVersion});
                    }
                    return;
                }
                try {
                    this.service.refreshProperties(this.zkPath, true);
                    this.service.refreshChildren(this.zkPath, true);
                }
                catch (Exception e) {
                    throw this.createBackingStoreException("refreshing node data", e);
                }
            }
            finally {
                this.propertiesModificationLock.unlock();
            }
            for (ZooKeeperBasedPreferences child : this.children.values()) {
                child.syncTree();
            }
        }
        finally {
            this.childrenModifyLock.unlock();
        }
        if (CloudDebug.zooKeeperPreferences) {
            LOG.debug("Synced node {} (version {}, cversion {})", new Object[]{this, this.propertiesVersion, this.childrenVersion});
        }
    }

    protected ConcurrentMap<String, ZooKeeperBasedPreferences> testableGetChildren() {
        return this.children;
    }

    protected int testableGetChildrenVersion() {
        return this.childrenVersion;
    }

    protected Properties testableGetProperties() {
        return this.properties;
    }

    protected int testableGetPropertiesVersion() {
        return this.propertiesVersion;
    }

    protected String testableGetZooKeeperPath() {
        return this.zkPath;
    }

    protected boolean testableRemoved() {
        return this.removed;
    }

    public String toString() {
        StringBuilder toString = new StringBuilder();
        toString.append(this.absolutePath());
        if (this.removed) {
            toString.append(" REMOVED");
        }
        if (!this.service.isActive(this)) {
            toString.append(" INACTIVE");
        }
        if (!this.service.isConnected()) {
            toString.append(" DISCONNECTED");
        }
        toString.append(" [").append(this.propertiesVersion).append('/').append(this.childrenVersion).append(']');
        return toString.toString();
    }

    private static final class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        private SortedProperties() {
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(this.keySet());
        }

        @Override
        public Set<Object> keySet() {
            return new TreeSet<Object>(super.keySet());
        }
    }
}

