/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.p2.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.zookeeper.KeeperException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.admin.ui.internal.databinding.TrueWhenListSelectionNotEmptyConverter;
import org.eclipse.gyrex.admin.ui.internal.forms.ViewerWithButtonsSectionPart;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.p2.internal.Node;
import org.eclipse.gyrex.admin.ui.p2.internal.P2UiLabelProvider;
import org.eclipse.gyrex.admin.ui.p2.internal.SoftwareLandingPage;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperMonitor;
import org.eclipse.gyrex.p2.internal.installer.PackageInstallerJob;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public class InstallStateSection
extends ViewerWithButtonsSectionPart {
    private static final IPath LOCKS_PATH = IZooKeeperLayout.PATH_LOCKS_DURABLE.append(PackageInstallerJob.ID_INSTALL_LOCK);
    private Button cancelButton;
    private ListViewer nodeList;
    private final DataBindingContext bindingContext;
    private IObservableValue selectedValue;
    final ZooKeeperMonitor monitor = new ZooKeeperMonitor(){

        protected void childrenChanged(String path) {
            if (!InstallStateSection.this.getSection().isDisposed()) {
                InstallStateSection.this.markStale();
            }
        }
    };

    public InstallStateSection(Composite parent, SoftwareLandingPage page) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.bindingContext = page.getBindingContext();
        Section section = this.getSection();
        section.setText("Active Installation");
        section.setDescription("Monitor the active install operations.");
        this.createContent(section);
    }

    void cancelButtonPressed() {
        Node node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        if (!MessageDialog.openQuestion((Shell)SwtUtil.getShell((Widget)this.getSection()), (String)"Cancel Installation", (String)"Do you really want to cancel the installation?")) {
            return;
        }
        if (StringUtils.isNotBlank((String)node.getLockName())) {
            try {
                ZooKeeperGate zk = ZooKeeperGate.get();
                zk.deletePath(LOCKS_PATH.append(node.getLockName()));
            }
            catch (Exception exception) {}
        }
        this.markStale();
    }

    protected void createButtons(Composite buttonsPanel) {
        this.cancelButton = this.createButton(buttonsPanel, "Cancel", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallStateSection.this.cancelButtonPressed();
            }
        });
    }

    protected void createViewer(Composite parent) {
        this.nodeList = new ListViewer(parent, this.getToolkit().getBorderStyle() | 4 | 0x100 | 0x200);
        org.eclipse.swt.widgets.List list = this.nodeList.getList();
        this.getToolkit().adapt((Control)list, true, true);
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.nodeList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.nodeList.setLabelProvider((IBaseLabelProvider)new P2UiLabelProvider());
        this.selectedValue = ViewersObservables.observeSingleSelection((Viewer)this.nodeList);
    }

    private Object[] getActiveNodesInstallingStuff() {
        try {
            ZooKeeperGate zk = ZooKeeperGate.get();
            List locks = zk.readChildrenNames(LOCKS_PATH, this.monitor, null);
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (String lock : locks) {
                String[] segments;
                String record = zk.readRecord(LOCKS_PATH.append(lock), "", null);
                if (StringUtils.isBlank((String)record) || (segments = StringUtils.splitByWholeSeparator((String)record, (String)"__")).length <= 2) continue;
                nodes.add(new Node(segments[0], segments[1], lock));
            }
            return nodes.toArray();
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return new Object[0];
        }
        catch (IllegalStateException illegalStateException) {
            return new Object[0];
        }
        catch (InterruptedException interruptedException) {
            return new Object[0];
        }
        catch (Exception e) {
            return new Object[]{new Node(e.getClass().getSimpleName(), e.getMessage(), null)};
        }
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    private Node getSelectedNode() {
        return (Node)(this.selectedValue != null ? this.selectedValue.getValue() : null);
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter((IConverter)new TrueWhenListSelectionNotEmptyConverter());
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.cancelButton), (IObservableValue)SWTObservables.observeSelection((Control)this.nodeList.getControl()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
    }

    public void refresh() {
        this.nodeList.setInput((Object)this.getActiveNodesInstallingStuff());
        super.refresh();
    }
}

