/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.registry.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.gyrex.http.registry.internal.HttpRegistryDebug;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionPointTracker {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionPointTracker.class);
    private static final Listener NULL_LISTENER = new Listener(){

        @Override
        public void added(IExtension extension) {
        }

        @Override
        public void removed(IExtension extension) {
        }
    };
    private final IExtensionRegistry registry;
    private final String extensionPointId;
    final String namespace;
    final String simpleIdentifier;
    final Listener listener;
    private final RegistryChangeListener registryChangeListener = new RegistryChangeListener();
    private final Set<IExtension> extensionCache = new HashSet<IExtension>();
    private boolean closed = true;

    static String toDebugString(IExtension extension) {
        StringBuilder string = new StringBuilder();
        string.append("extension ");
        string.append("id=").append(extension.getUniqueIdentifier());
        string.append(" (point ").append(extension.getExtensionPointUniqueIdentifier()).append(") ");
        string.append("contributed by ");
        string.append(extension.getContributor());
        return extension.getUniqueIdentifier();
    }

    public ExtensionPointTracker(IExtensionRegistry registry, String extensionPointId, Listener listener) {
        this.registry = registry;
        this.extensionPointId = extensionPointId;
        Listener listener2 = this.listener = listener != null ? listener : NULL_LISTENER;
        if (extensionPointId == null || -1 == extensionPointId.indexOf(46)) {
            throw new IllegalArgumentException("Unexpected Extension Point Identifier: " + extensionPointId);
        }
        int lastDotIndex = extensionPointId.lastIndexOf(46);
        this.namespace = extensionPointId.substring(0, lastDotIndex);
        this.simpleIdentifier = extensionPointId.substring(lastDotIndex + 1);
    }

    synchronized boolean addExtension(IExtension extension) {
        if (this.closed) {
            return false;
        }
        if (HttpRegistryDebug.extensionRegistration) {
            LOG.debug("Adding {}.", (Object)ExtensionPointTracker.toDebugString(extension));
        }
        return this.extensionCache.add(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        IExtension[] extensions = null;
        ExtensionPointTracker extensionPointTracker = this;
        synchronized (extensionPointTracker) {
            if (this.closed) {
                return;
            }
            if (HttpRegistryDebug.extensionRegistration) {
                LOG.debug("Closing tracker for extension point {} (namespace {}).", (Object)this.extensionPointId, (Object)this.namespace);
            }
            this.closed = true;
            this.registry.removeRegistryChangeListener((IRegistryChangeListener)this.registryChangeListener);
            extensions = this.getExtensions();
            this.extensionCache.clear();
        }
        int i = 0;
        while (i < extensions.length) {
            this.listener.removed(extensions[i]);
            ++i;
        }
    }

    public synchronized IExtension[] getExtensions() {
        return this.extensionCache.toArray(new IExtension[this.extensionCache.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        IExtension[] extensions = null;
        ExtensionPointTracker extensionPointTracker = this;
        synchronized (extensionPointTracker) {
            if (!this.closed) {
                return;
            }
            if (HttpRegistryDebug.extensionRegistration) {
                LOG.debug("Opening tracker for extension point {} (namespace {}).", (Object)this.extensionPointId, (Object)this.namespace);
            }
            this.registry.addRegistryChangeListener((IRegistryChangeListener)this.registryChangeListener, this.namespace);
            try {
                IExtensionPoint point = this.registry.getExtensionPoint(this.extensionPointId);
                if (point != null) {
                    extensions = point.getExtensions();
                    this.extensionCache.addAll(Arrays.asList(extensions));
                }
                this.closed = false;
            }
            catch (InvalidRegistryObjectException e) {
                this.registry.removeRegistryChangeListener((IRegistryChangeListener)this.registryChangeListener);
                throw e;
            }
        }
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                this.listener.added(extensions[i]);
                ++i;
            }
        }
    }

    synchronized boolean removeExtension(IExtension extension) {
        if (this.closed) {
            return false;
        }
        if (HttpRegistryDebug.extensionRegistration) {
            LOG.debug("Removing {}.", (Object)ExtensionPointTracker.toDebugString(extension));
        }
        return this.extensionCache.remove(extension);
    }

    public static interface Listener {
        public void added(IExtension var1);

        public void removed(IExtension var1);
    }

    class RegistryChangeListener
    implements IRegistryChangeListener {
        RegistryChangeListener() {
        }

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] deltas = event.getExtensionDeltas(ExtensionPointTracker.this.namespace, ExtensionPointTracker.this.simpleIdentifier);
            int i = 0;
            while (i < deltas.length) {
                IExtensionDelta delta = deltas[i];
                IExtension extension = delta.getExtension();
                switch (delta.getKind()) {
                    case 1: {
                        if (!ExtensionPointTracker.this.addExtension(extension)) break;
                        ExtensionPointTracker.this.listener.added(extension);
                        if (!HttpRegistryDebug.extensionRegistration) break;
                        LOG.debug("Added {}.", (Object)ExtensionPointTracker.toDebugString(extension));
                        break;
                    }
                    case 2: {
                        if (!ExtensionPointTracker.this.removeExtension(extension)) break;
                        ExtensionPointTracker.this.listener.removed(extension);
                        if (!HttpRegistryDebug.extensionRegistration) break;
                        LOG.debug("Removed {}.", (Object)ExtensionPointTracker.toDebugString(extension));
                    }
                }
                ++i;
            }
        }
    }
}

