/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.common.console;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.common.console.SubCommand;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.kohsuke.args4j.CmdLineParser;

class CommandUtil {
    private CommandUtil() {
    }

    static boolean isHelpOption(String arg) {
        return StringUtils.equals((String)"-h", (String)arg) || StringUtils.equals((String)"--help", (String)arg);
    }

    static void appendCommandDescription(StrBuilder help, String name, Command command, String ident) {
        help.append(ident).append(name);
        String description = command.getDescription();
        if (!StringUtils.contains((String)description, (String)" - ")) {
            help.append(" - ");
        } else if (!StringUtils.startsWith((String)description, (String)" ")) {
            help.append(' ');
        }
        help.appendln(description);
    }

    static void appendCommandInfo(StrBuilder help, String commandName, Map<String, Class<? extends Command>> commands, String ident) {
        help.append(ident).append(commandName).appendln(" <cmd> [args]");
        ident = String.valueOf(ident) + "\t";
        for (String name : commands.keySet()) {
            try {
                Command command = commands.get(name).newInstance();
                if (command instanceof SubCommand) {
                    CommandUtil.appendCommandInfo(help, name, ((SubCommand)command).commands, ident);
                    continue;
                }
                CommandUtil.appendCommandDescription(help, name, command, ident);
            }
            catch (Exception e) {
                help.append(ident).append(name).append(" - ").appendln(ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    static void printCommandHelp(CommandInterpreter ci, String name, String command, CmdLineParser parser) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append(String.format("%s %s", name, command));
        parser.printSingleLineUsage((Writer)stringWriter, null);
        stringWriter.append(SystemUtils.LINE_SEPARATOR);
        parser.printUsage((Writer)stringWriter, null);
        stringWriter.flush();
        ci.println((Object)stringWriter.toString());
    }
}

